package io.intino.sumus.graph;

import io.intino.konos.alexandria.activity.services.push.User;
import io.intino.tara.magritte.Graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

import static java.util.stream.Collectors.toList;
import static java.util.stream.Collectors.toSet;

public class SumusGraph extends io.intino.sumus.graph.AbstractGraph {
	public static io.intino.sumus.Settings Settings;

	public SumusGraph(Graph graph) {
		super(graph);
	}

	public SumusGraph(Graph graph, SumusGraph wrapper) {
		super(graph, wrapper);
	}

	public void init() {
		load();
	}

	private void load() {
		graph.loadStashes("filters.stash", "clusters.stash");
		this.update();
	}

	public List<AbstractAccess> accesses(User user) {
		List<String> roles = user != null ? user.roles() : Collections.emptyList();

		return abstractAccessList().stream()
				.filter(a -> a.i$(GlobalAccess.class) || (a.i$(Access.class) && roles.contains(a.a$(Access.class).name$())))
				.map(a -> a.a$(AbstractAccess.class)).collect(toList());
	}

	public List<NameSpace> nameSpaces(User user) {
		List<AbstractAccess> accesses = accesses(user);

		if (accesses.stream().anyMatch(a -> a.i$(GlobalAccess.class)))
			return nameSpaceList();

		return new ArrayList<>(accesses.stream().filter(a -> a.i$(Access.class))
				.map(a -> a.a$(Access.class).namespaces())
				.flatMap(Collection::stream).collect(toSet()));
	}

}