package io.intino.sumus.graph;

import io.intino.tara.magritte.Concept;
import io.intino.tara.magritte.Layer;

import java.util.*;

import static java.util.stream.Collectors.toList;
import static java.util.stream.Collectors.toSet;

public class Categorization extends AbstractCategorization {

	// TODO clear cache and limit size
	Map<String, List<String>> recordTags = new HashMap<>();

	public Categorization(io.intino.tara.magritte.Node node) {
		super(node);
	}

	public TagMap categorizedLayersMap(List<? extends Layer> layers) {
		return doCategorizeRecords(layers);
	}

	public RecordTagger recordTaggerOf(Layer layer) {
		return recordTaggerList.stream().filter(r -> layer.i$(r.record)).findFirst().orElse(null);
	}

	public RecordTagger recordTaggerOf(Concept concept) {
		return recordTaggerList.stream().filter(r -> r.record().equals(concept)).findFirst().orElse(null);
	}

	public DigestTagger digestTagger(Cube cube) {
		return digestTaggerList.stream().filter(d -> cube.equals(d.cube)).findFirst().orElse(null);
	}

	@Override
	public List<String> tags() {
		return savedTags.isEmpty() ? savedTags = super.tags() : savedTags;
	}

	public List<String> tags(List<AbstractAccess> accessList) {
		Set<String> availableTags = tagsOf(accessList);
		return tags().stream().filter(availableTags::contains).collect(toList());
	}

	private TagMap doCategorizeRecords(List<? extends Layer> recordList) {
		TagMap tagMap = new TagMap();
		if (recordList.isEmpty()) return tagMap;
		RecordTagger tagger = recordTaggerOf(recordList.get(0));
		if (tagger == null)
			throw new RuntimeException(String.format("no record tagger found for layer %s in %s", recordList.get(0).getClass(), this.name$()));
		for (Layer record : recordList) {
			if (!record.i$(tagger.record())) continue;
			processTags(tagMap, tagger, record);
		}
		return tagMap;
	}

	private void processTags(TagMap tagMap, RecordTagger tagger, Layer record) {
		if (!recordTags.containsKey(key(record)))
			recordTags.put(key(record), tagger.tag(record));
		recordTags.get(key(record)).forEach(tag -> tagMap.add(tag, record));
	}

	public TagMap filter(TagMap tagMap, Set<String> tags) {
		TagMap result = new TagMap();
		tags.stream().filter(tagMap::containsKey).forEach(t -> result.put(t, tagMap.get(t)));
		return result;
	}

	private Set<String> tagsOf(List<AbstractAccess> accessList) {
		long count = accessList.stream().filter(a -> a.i$(GlobalAccess.class)).count();

		if (count > 0)
			return new HashSet<>(tags.value());

		return accessList.stream()
				.filter(a -> a.i$(Access.class))
				.map(a -> a.a$(Access.class).tagsList())
				.flatMap(Collection::stream)
				.filter(c -> c.categorization.equals(this))
				.map(Access.Tags::tags)
				.flatMap(Collection::stream)
				.collect(toSet());
	}

	private String key(Layer record) {
		return this.name$() + record.core$().id();
	}
}