package io.intino.sumus.box.schemas;

public class ActivitySchemaAdapters {


	public static io.intino.sumus.box.schemas.Olap olapFromLayer(io.intino.tara.magritte.Layer layer) {
		return olapFromNode(layer.core$());
	}

	private static io.intino.sumus.box.schemas.Olap olapFromNode(io.intino.tara.magritte.Node node) {
		io.intino.sumus.box.schemas.Olap schema = new io.intino.sumus.box.schemas.Olap();
		final java.util.Map<String, java.util.List<?>> variables = node.variables();
		variables.put("name", java.util.Collections.singletonList(node.name()));
		variables.put("id", java.util.Collections.singletonList(node.id()));
		for (String variable : variables.keySet()) {
			if (variable.equals("label")) schema.label((String) variables.get(variable).get(0).toString());
			if (variable.equals("type")) schema.type((String) variables.get(variable).get(0).toString());
		}

		return schema;
	}


	public static io.intino.sumus.box.schemas.Filter filterFromLayer(io.intino.tara.magritte.Layer layer) {
		return filterFromNode(layer.core$());
	}

	private static io.intino.sumus.box.schemas.Filter filterFromNode(io.intino.tara.magritte.Node node) {
		io.intino.sumus.box.schemas.Filter schema = new io.intino.sumus.box.schemas.Filter();
		final java.util.Map<String, java.util.List<?>> variables = node.variables();
		variables.put("name", java.util.Collections.singletonList(node.name()));
		variables.put("id", java.util.Collections.singletonList(node.id()));
		for (String variable : variables.keySet()) {
			if (variable.equals("name")) schema.name((String) variables.get(variable).get(0).toString());
			if (variable.equals("label")) schema.label((String) variables.get(variable).get(0).toString());
		}
		for (io.intino.tara.magritte.Node component : node.componentList()) {
			if (component.name().equalsIgnoreCase(io.intino.sumus.box.schemas.FilterCategorization.class.getSimpleName())) schema.filterCategorizationList().add(filterCategorizationFromNode(component));
		}
		return schema;
	}


	public static io.intino.sumus.box.schemas.FilterCategorization filterCategorizationFromLayer(io.intino.tara.magritte.Layer layer) {
		return filterCategorizationFromNode(layer.core$());
	}

	private static io.intino.sumus.box.schemas.FilterCategorization filterCategorizationFromNode(io.intino.tara.magritte.Node node) {
		io.intino.sumus.box.schemas.FilterCategorization schema = new io.intino.sumus.box.schemas.FilterCategorization();
		final java.util.Map<String, java.util.List<?>> variables = node.variables();
		variables.put("name", java.util.Collections.singletonList(node.name()));
		variables.put("id", java.util.Collections.singletonList(node.id()));
		for (String variable : variables.keySet()) {
			if (variable.equals("name")) schema.name((String) variables.get(variable).get(0).toString());
			if (variable.equals("tags")) schema.tags().addAll(((java.util.List<String>) variables.get(variable)));
		}

		return schema;
	}


	public static io.intino.sumus.box.schemas.FilterDialog filterDialogFromLayer(io.intino.tara.magritte.Layer layer) {
		return filterDialogFromNode(layer.core$());
	}

	private static io.intino.sumus.box.schemas.FilterDialog filterDialogFromNode(io.intino.tara.magritte.Node node) {
		io.intino.sumus.box.schemas.FilterDialog schema = new io.intino.sumus.box.schemas.FilterDialog();
		final java.util.Map<String, java.util.List<?>> variables = node.variables();
		variables.put("name", java.util.Collections.singletonList(node.name()));
		variables.put("id", java.util.Collections.singletonList(node.id()));
		for (String variable : variables.keySet()) {
			if (variable.equals("filter")) schema.filter((String) variables.get(variable).get(0).toString());
			if (variable.equals("label")) schema.label((String) variables.get(variable).get(0).toString());
		}

		return schema;
	}


	public static io.intino.sumus.box.schemas.FilterCondition filterConditionFromLayer(io.intino.tara.magritte.Layer layer) {
		return filterConditionFromNode(layer.core$());
	}

	private static io.intino.sumus.box.schemas.FilterCondition filterConditionFromNode(io.intino.tara.magritte.Node node) {
		io.intino.sumus.box.schemas.FilterCondition schema = new io.intino.sumus.box.schemas.FilterCondition();
		final java.util.Map<String, java.util.List<?>> variables = node.variables();
		variables.put("name", java.util.Collections.singletonList(node.name()));
		variables.put("id", java.util.Collections.singletonList(node.id()));

		for (io.intino.tara.magritte.Node component : node.componentList()) {
			if (component.name().equalsIgnoreCase(io.intino.sumus.box.schemas.Categorization.class.getSimpleName())) schema.categorization((categorizationFromNode(component)));
			if (component.name().equalsIgnoreCase(io.intino.sumus.box.schemas.Tag.class.getSimpleName())) schema.tagList().add(tagFromNode(component));
		}
		return schema;
	}


	public static io.intino.sumus.box.schemas.Drill drillFromLayer(io.intino.tara.magritte.Layer layer) {
		return drillFromNode(layer.core$());
	}

	private static io.intino.sumus.box.schemas.Drill drillFromNode(io.intino.tara.magritte.Node node) {
		io.intino.sumus.box.schemas.Drill schema = new io.intino.sumus.box.schemas.Drill();
		final java.util.Map<String, java.util.List<?>> variables = node.variables();
		variables.put("name", java.util.Collections.singletonList(node.name()));
		variables.put("id", java.util.Collections.singletonList(node.id()));

		for (io.intino.tara.magritte.Node component : node.componentList()) {
			if (component.name().equalsIgnoreCase(io.intino.sumus.box.schemas.Categorization.class.getSimpleName())) schema.categorization((categorizationFromNode(component)));
			if (component.name().equalsIgnoreCase(io.intino.sumus.box.schemas.Tag.class.getSimpleName())) schema.tagList().add(tagFromNode(component));
		}
		return schema;
	}


	public static io.intino.sumus.box.schemas.Categorization categorizationFromLayer(io.intino.tara.magritte.Layer layer) {
		return categorizationFromNode(layer.core$());
	}

	private static io.intino.sumus.box.schemas.Categorization categorizationFromNode(io.intino.tara.magritte.Node node) {
		io.intino.sumus.box.schemas.Categorization schema = new io.intino.sumus.box.schemas.Categorization();
		final java.util.Map<String, java.util.List<?>> variables = node.variables();
		variables.put("name", java.util.Collections.singletonList(node.name()));
		variables.put("id", java.util.Collections.singletonList(node.id()));
		for (String variable : variables.keySet()) {
			if (variable.equals("name")) schema.name((String) variables.get(variable).get(0).toString());
			if (variable.equals("label")) schema.label((String) variables.get(variable).get(0).toString());
		}

		return schema;
	}


	public static io.intino.sumus.box.schemas.Tag tagFromLayer(io.intino.tara.magritte.Layer layer) {
		return tagFromNode(layer.core$());
	}

	private static io.intino.sumus.box.schemas.Tag tagFromNode(io.intino.tara.magritte.Node node) {
		io.intino.sumus.box.schemas.Tag schema = new io.intino.sumus.box.schemas.Tag();
		final java.util.Map<String, java.util.List<?>> variables = node.variables();
		variables.put("name", java.util.Collections.singletonList(node.name()));
		variables.put("id", java.util.Collections.singletonList(node.id()));
		for (String variable : variables.keySet()) {
			if (variable.equals("name")) schema.name((String) variables.get(variable).get(0).toString());
			if (variable.equals("label")) schema.label((String) variables.get(variable).get(0).toString());
		}

		return schema;
	}


	public static io.intino.sumus.box.schemas.CategorizationView categorizationViewFromLayer(io.intino.tara.magritte.Layer layer) {
		return categorizationViewFromNode(layer.core$());
	}

	private static io.intino.sumus.box.schemas.CategorizationView categorizationViewFromNode(io.intino.tara.magritte.Node node) {
		io.intino.sumus.box.schemas.CategorizationView schema = new io.intino.sumus.box.schemas.CategorizationView();
		final java.util.Map<String, java.util.List<?>> variables = node.variables();
		variables.put("name", java.util.Collections.singletonList(node.name()));
		variables.put("id", java.util.Collections.singletonList(node.id()));
		for (String variable : variables.keySet()) {
			if (variable.equals("name")) schema.name((String) variables.get(variable).get(0).toString());
			if (variable.equals("label")) schema.label((String) variables.get(variable).get(0).toString());
		}
		for (io.intino.tara.magritte.Node component : node.componentList()) {
			if (component.name().equalsIgnoreCase(io.intino.sumus.box.schemas.TagView.class.getSimpleName())) schema.tagViewList().add(tagViewFromNode(component));
		}
		return schema;
	}


	public static io.intino.sumus.box.schemas.TagView tagViewFromLayer(io.intino.tara.magritte.Layer layer) {
		return tagViewFromNode(layer.core$());
	}

	private static io.intino.sumus.box.schemas.TagView tagViewFromNode(io.intino.tara.magritte.Node node) {
		io.intino.sumus.box.schemas.TagView schema = new io.intino.sumus.box.schemas.TagView();
		final java.util.Map<String, java.util.List<?>> variables = node.variables();
		variables.put("name", java.util.Collections.singletonList(node.name()));
		variables.put("id", java.util.Collections.singletonList(node.id()));
		for (String variable : variables.keySet()) {
			if (variable.equals("name")) schema.name((String) variables.get(variable).get(0).toString());
			if (variable.equals("label")) schema.label((String) variables.get(variable).get(0).toString());
		}

		return schema;
	}


	public static io.intino.sumus.box.schemas.Formatter formatterFromLayer(io.intino.tara.magritte.Layer layer) {
		return formatterFromNode(layer.core$());
	}

	private static io.intino.sumus.box.schemas.Formatter formatterFromNode(io.intino.tara.magritte.Node node) {
		io.intino.sumus.box.schemas.Formatter schema = new io.intino.sumus.box.schemas.Formatter();
		final java.util.Map<String, java.util.List<?>> variables = node.variables();
		variables.put("name", java.util.Collections.singletonList(node.name()));
		variables.put("id", java.util.Collections.singletonList(node.id()));
		for (String variable : variables.keySet()) {
			if (variable.equals("name")) schema.name((String) variables.get(variable).get(0).toString());
			if (variable.equals("format")) schema.format((String) variables.get(variable).get(0).toString());
		}

		return schema;
	}


	public static io.intino.sumus.box.schemas.Event eventFromLayer(io.intino.tara.magritte.Layer layer) {
		return eventFromNode(layer.core$());
	}

	private static io.intino.sumus.box.schemas.Event eventFromNode(io.intino.tara.magritte.Node node) {
		io.intino.sumus.box.schemas.Event schema = new io.intino.sumus.box.schemas.Event();
		final java.util.Map<String, java.util.List<?>> variables = node.variables();
		variables.put("name", java.util.Collections.singletonList(node.name()));
		variables.put("id", java.util.Collections.singletonList(node.id()));
		for (String variable : variables.keySet()) {
			if (variable.equals("name")) schema.name((String) variables.get(variable).get(0).toString());
			if (variable.equals("label")) schema.label((String) variables.get(variable).get(0).toString());
			if (variable.equals("created")) schema.created((java.time.Instant) variables.get(variable).get(0));
			if (variable.equals("render")) schema.render((String) variables.get(variable).get(0).toString());
			if (variable.equals("icon")) schema.icon((String) variables.get(variable).get(0).toString());
		}

		return schema;
	}


	public static io.intino.sumus.box.schemas.Serie serieFromLayer(io.intino.tara.magritte.Layer layer) {
		return serieFromNode(layer.core$());
	}

	private static io.intino.sumus.box.schemas.Serie serieFromNode(io.intino.tara.magritte.Node node) {
		io.intino.sumus.box.schemas.Serie schema = new io.intino.sumus.box.schemas.Serie();
		final java.util.Map<String, java.util.List<?>> variables = node.variables();
		variables.put("name", java.util.Collections.singletonList(node.name()));
		variables.put("id", java.util.Collections.singletonList(node.id()));
		for (String variable : variables.keySet()) {
			if (variable.equals("label")) schema.label((String) variables.get(variable).get(0).toString());
			if (variable.equals("group")) schema.group((String) variables.get(variable).get(0).toString());
			if (variable.equals("metric")) schema.metric((String) variables.get(variable).get(0).toString());
			if (variable.equals("color")) schema.color((String) variables.get(variable).get(0).toString());
			if (variable.equals("style")) schema.style((String) variables.get(variable).get(0).toString());
			if (variable.equals("min")) schema.min((Integer) variables.get(variable).get(0));
			if (variable.equals("max")) schema.max((Integer) variables.get(variable).get(0));
		}
		for (io.intino.tara.magritte.Node component : node.componentList()) {
			if (component.name().equalsIgnoreCase(io.intino.sumus.box.schemas.Data.class.getSimpleName())) schema.dataList().add(dataFromNode(component));
			if (component.name().equalsIgnoreCase(io.intino.sumus.box.schemas.DecimalPlaces.class.getSimpleName())) schema.decimalPlaces((decimalPlacesFromNode(component)));
		}
		return schema;
	}


	public static io.intino.sumus.box.schemas.Data dataFromLayer(io.intino.tara.magritte.Layer layer) {
		return dataFromNode(layer.core$());
	}

	private static io.intino.sumus.box.schemas.Data dataFromNode(io.intino.tara.magritte.Node node) {
		io.intino.sumus.box.schemas.Data schema = new io.intino.sumus.box.schemas.Data();
		final java.util.Map<String, java.util.List<?>> variables = node.variables();
		variables.put("name", java.util.Collections.singletonList(node.name()));
		variables.put("id", java.util.Collections.singletonList(node.id()));
		for (String variable : variables.keySet()) {
			if (variable.equals("created")) schema.created((Double) variables.get(variable).get(0));
			if (variable.equals("value")) schema.value((Double) variables.get(variable).get(0));
		}

		return schema;
	}


	public static io.intino.sumus.box.schemas.DecimalPlaces decimalPlacesFromLayer(io.intino.tara.magritte.Layer layer) {
		return decimalPlacesFromNode(layer.core$());
	}

	private static io.intino.sumus.box.schemas.DecimalPlaces decimalPlacesFromNode(io.intino.tara.magritte.Node node) {
		io.intino.sumus.box.schemas.DecimalPlaces schema = new io.intino.sumus.box.schemas.DecimalPlaces();
		final java.util.Map<String, java.util.List<?>> variables = node.variables();
		variables.put("name", java.util.Collections.singletonList(node.name()));
		variables.put("id", java.util.Collections.singletonList(node.id()));
		for (String variable : variables.keySet()) {
			if (variable.equals("absolute")) schema.absolute((Integer) variables.get(variable).get(0));
			if (variable.equals("percentage")) schema.percentage((Integer) variables.get(variable).get(0));
		}

		return schema;
	}


	public static io.intino.sumus.box.schemas.Points pointsFromLayer(io.intino.tara.magritte.Layer layer) {
		return pointsFromNode(layer.core$());
	}

	private static io.intino.sumus.box.schemas.Points pointsFromNode(io.intino.tara.magritte.Node node) {
		io.intino.sumus.box.schemas.Points schema = new io.intino.sumus.box.schemas.Points();
		final java.util.Map<String, java.util.List<?>> variables = node.variables();
		variables.put("name", java.util.Collections.singletonList(node.name()));
		variables.put("id", java.util.Collections.singletonList(node.id()));

		for (io.intino.tara.magritte.Node component : node.componentList()) {
			if (component.name().equalsIgnoreCase(io.intino.sumus.box.schemas.Serie.class.getSimpleName())) schema.serieList().add(serieFromNode(component));
			if (component.name().equalsIgnoreCase(io.intino.sumus.box.schemas.Scale.class.getSimpleName())) schema.scale((scaleFromNode(component)));
		}
		return schema;
	}


	public static io.intino.sumus.box.schemas.Scale scaleFromLayer(io.intino.tara.magritte.Layer layer) {
		return scaleFromNode(layer.core$());
	}

	private static io.intino.sumus.box.schemas.Scale scaleFromNode(io.intino.tara.magritte.Node node) {
		io.intino.sumus.box.schemas.Scale schema = new io.intino.sumus.box.schemas.Scale();
		final java.util.Map<String, java.util.List<?>> variables = node.variables();
		variables.put("name", java.util.Collections.singletonList(node.name()));
		variables.put("id", java.util.Collections.singletonList(node.id()));
		for (String variable : variables.keySet()) {
			if (variable.equals("name")) schema.name((String) variables.get(variable).get(0).toString());
			if (variable.equals("label")) schema.label((String) variables.get(variable).get(0).toString());
			if (variable.equals("symbol")) schema.symbol((String) variables.get(variable).get(0).toString());
		}

		return schema;
	}


	public static io.intino.sumus.box.schemas.Histogram histogramFromLayer(io.intino.tara.magritte.Layer layer) {
		return histogramFromNode(layer.core$());
	}

	private static io.intino.sumus.box.schemas.Histogram histogramFromNode(io.intino.tara.magritte.Node node) {
		io.intino.sumus.box.schemas.Histogram schema = new io.intino.sumus.box.schemas.Histogram();
		final java.util.Map<String, java.util.List<?>> variables = node.variables();
		variables.put("name", java.util.Collections.singletonList(node.name()));
		variables.put("id", java.util.Collections.singletonList(node.id()));

		for (io.intino.tara.magritte.Node component : node.componentList()) {
			if (component.name().equalsIgnoreCase(io.intino.sumus.box.schemas.TagView.class.getSimpleName())) schema.tagViewList().add(tagViewFromNode(component));
			if (component.name().equalsIgnoreCase(io.intino.sumus.box.schemas.Ticket.class.getSimpleName())) schema.ticketList().add(ticketFromNode(component));
			if (component.name().equalsIgnoreCase(io.intino.sumus.box.schemas.HeatMap.class.getSimpleName())) schema.heatMap((heatMapFromNode(component)));
		}
		return schema;
	}


	public static io.intino.sumus.box.schemas.NameSpace nameSpaceFromLayer(io.intino.tara.magritte.Layer layer) {
		return nameSpaceFromNode(layer.core$());
	}

	private static io.intino.sumus.box.schemas.NameSpace nameSpaceFromNode(io.intino.tara.magritte.Node node) {
		io.intino.sumus.box.schemas.NameSpace schema = new io.intino.sumus.box.schemas.NameSpace();
		final java.util.Map<String, java.util.List<?>> variables = node.variables();
		variables.put("name", java.util.Collections.singletonList(node.name()));
		variables.put("id", java.util.Collections.singletonList(node.id()));
		for (String variable : variables.keySet()) {
			if (variable.equals("name")) schema.name((String) variables.get(variable).get(0).toString());
			if (variable.equals("label")) schema.label((String) variables.get(variable).get(0).toString());
		}

		return schema;
	}


	public static io.intino.sumus.box.schemas.Ticket ticketFromLayer(io.intino.tara.magritte.Layer layer) {
		return ticketFromNode(layer.core$());
	}

	private static io.intino.sumus.box.schemas.Ticket ticketFromNode(io.intino.tara.magritte.Node node) {
		io.intino.sumus.box.schemas.Ticket schema = new io.intino.sumus.box.schemas.Ticket();
		final java.util.Map<String, java.util.List<?>> variables = node.variables();
		variables.put("name", java.util.Collections.singletonList(node.name()));
		variables.put("id", java.util.Collections.singletonList(node.id()));
		for (String variable : variables.keySet()) {
			if (variable.equals("name")) schema.name((String) variables.get(variable).get(0).toString());
			if (variable.equals("label")) schema.label((String) variables.get(variable).get(0).toString());
			if (variable.equals("shortLabel")) schema.shortLabel((String) variables.get(variable).get(0).toString());
			if (variable.equals("color")) schema.color((String) variables.get(variable).get(0).toString());
			if (variable.equals("unit")) schema.unit((String) variables.get(variable).get(0).toString());
		}
		for (io.intino.tara.magritte.Node component : node.componentList()) {
			if (component.name().equalsIgnoreCase(io.intino.sumus.box.schemas.Indicator.class.getSimpleName())) schema.indicatorList().add(indicatorFromNode(component));
		}
		return schema;
	}


	public static io.intino.sumus.box.schemas.Indicator indicatorFromLayer(io.intino.tara.magritte.Layer layer) {
		return indicatorFromNode(layer.core$());
	}

	private static io.intino.sumus.box.schemas.Indicator indicatorFromNode(io.intino.tara.magritte.Node node) {
		io.intino.sumus.box.schemas.Indicator schema = new io.intino.sumus.box.schemas.Indicator();
		final java.util.Map<String, java.util.List<?>> variables = node.variables();
		variables.put("name", java.util.Collections.singletonList(node.name()));
		variables.put("id", java.util.Collections.singletonList(node.id()));
		for (String variable : variables.keySet()) {
			if (variable.equals("label")) schema.label((String) variables.get(variable).get(0).toString());
			if (variable.equals("color")) schema.color((String) variables.get(variable).get(0).toString());
			if (variable.equals("minValue")) schema.minValue((Double) variables.get(variable).get(0));
			if (variable.equals("maxValue")) schema.maxValue((Double) variables.get(variable).get(0));
		}
		for (io.intino.tara.magritte.Node component : node.componentList()) {
			if (component.name().equalsIgnoreCase(io.intino.sumus.box.schemas.DecimalPlaces.class.getSimpleName())) schema.decimalPlaces((decimalPlacesFromNode(component)));
		}
		return schema;
	}


	public static io.intino.sumus.box.schemas.CategorizationToggleDialog categorizationToggleDialogFromLayer(io.intino.tara.magritte.Layer layer) {
		return categorizationToggleDialogFromNode(layer.core$());
	}

	private static io.intino.sumus.box.schemas.CategorizationToggleDialog categorizationToggleDialogFromNode(io.intino.tara.magritte.Node node) {
		io.intino.sumus.box.schemas.CategorizationToggleDialog schema = new io.intino.sumus.box.schemas.CategorizationToggleDialog();
		final java.util.Map<String, java.util.List<?>> variables = node.variables();
		variables.put("name", java.util.Collections.singletonList(node.name()));
		variables.put("id", java.util.Collections.singletonList(node.id()));
		for (String variable : variables.keySet()) {
			if (variable.equals("categorization")) schema.categorization((String) variables.get(variable).get(0).toString());
			if (variable.equals("tags")) schema.tags().addAll(((java.util.List<String>) variables.get(variable)));
		}

		return schema;
	}


	public static io.intino.sumus.box.schemas.SortBy sortByFromLayer(io.intino.tara.magritte.Layer layer) {
		return sortByFromNode(layer.core$());
	}

	private static io.intino.sumus.box.schemas.SortBy sortByFromNode(io.intino.tara.magritte.Node node) {
		io.intino.sumus.box.schemas.SortBy schema = new io.intino.sumus.box.schemas.SortBy();
		final java.util.Map<String, java.util.List<?>> variables = node.variables();
		variables.put("name", java.util.Collections.singletonList(node.name()));
		variables.put("id", java.util.Collections.singletonList(node.id()));
		for (String variable : variables.keySet()) {
			if (variable.equals("ticket")) schema.ticket((String) variables.get(variable).get(0).toString());
			if (variable.equals("indicator")) schema.indicator((String) variables.get(variable).get(0).toString());
			if (variable.equals("mode")) schema.mode((String) variables.get(variable).get(0).toString());
		}

		return schema;
	}


	public static io.intino.sumus.box.schemas.CrossTableData crossTableDataFromLayer(io.intino.tara.magritte.Layer layer) {
		return crossTableDataFromNode(layer.core$());
	}

	private static io.intino.sumus.box.schemas.CrossTableData crossTableDataFromNode(io.intino.tara.magritte.Node node) {
		io.intino.sumus.box.schemas.CrossTableData schema = new io.intino.sumus.box.schemas.CrossTableData();
		final java.util.Map<String, java.util.List<?>> variables = node.variables();
		variables.put("name", java.util.Collections.singletonList(node.name()));
		variables.put("id", java.util.Collections.singletonList(node.id()));
		for (String variable : variables.keySet()) {
			if (variable.equals("unitLabel")) schema.unitLabel((String) variables.get(variable).get(0).toString());
		}
		for (io.intino.tara.magritte.Node component : node.componentList()) {
			if (component.name().equalsIgnoreCase(io.intino.sumus.box.schemas.Column.class.getSimpleName())) schema.columnList().add(columnFromNode(component));
			if (component.name().equalsIgnoreCase(io.intino.sumus.box.schemas.Row.class.getSimpleName())) schema.rowList().add(rowFromNode(component));
			if (component.name().equalsIgnoreCase(io.intino.sumus.box.schemas.Entry.class.getSimpleName())) schema.entryList().add(entryFromNode(component));
			if (component.name().equalsIgnoreCase(io.intino.sumus.box.schemas.DecimalPlaces.class.getSimpleName())) schema.decimalPlaces((decimalPlacesFromNode(component)));
			if (component.name().equalsIgnoreCase(io.intino.sumus.box.schemas.HeatMap.class.getSimpleName())) schema.heatMap((heatMapFromNode(component)));
		}
		return schema;
	}


	public static io.intino.sumus.box.schemas.Column columnFromLayer(io.intino.tara.magritte.Layer layer) {
		return columnFromNode(layer.core$());
	}

	private static io.intino.sumus.box.schemas.Column columnFromNode(io.intino.tara.magritte.Node node) {
		io.intino.sumus.box.schemas.Column schema = new io.intino.sumus.box.schemas.Column();
		final java.util.Map<String, java.util.List<?>> variables = node.variables();
		variables.put("name", java.util.Collections.singletonList(node.name()));
		variables.put("id", java.util.Collections.singletonList(node.id()));
		for (String variable : variables.keySet()) {
			if (variable.equals("label")) schema.label((String) variables.get(variable).get(0).toString());
			if (variable.equals("values")) schema.values().addAll(((java.util.List<String>) variables.get(variable)));
		}

		return schema;
	}


	public static io.intino.sumus.box.schemas.Row rowFromLayer(io.intino.tara.magritte.Layer layer) {
		return rowFromNode(layer.core$());
	}

	private static io.intino.sumus.box.schemas.Row rowFromNode(io.intino.tara.magritte.Node node) {
		io.intino.sumus.box.schemas.Row schema = new io.intino.sumus.box.schemas.Row();
		final java.util.Map<String, java.util.List<?>> variables = node.variables();
		variables.put("name", java.util.Collections.singletonList(node.name()));
		variables.put("id", java.util.Collections.singletonList(node.id()));
		for (String variable : variables.keySet()) {
			if (variable.equals("label")) schema.label((String) variables.get(variable).get(0).toString());
			if (variable.equals("values")) schema.values().addAll(((java.util.List<String>) variables.get(variable)));
		}

		return schema;
	}


	public static io.intino.sumus.box.schemas.Entry entryFromLayer(io.intino.tara.magritte.Layer layer) {
		return entryFromNode(layer.core$());
	}

	private static io.intino.sumus.box.schemas.Entry entryFromNode(io.intino.tara.magritte.Node node) {
		io.intino.sumus.box.schemas.Entry schema = new io.intino.sumus.box.schemas.Entry();
		final java.util.Map<String, java.util.List<?>> variables = node.variables();
		variables.put("name", java.util.Collections.singletonList(node.name()));
		variables.put("id", java.util.Collections.singletonList(node.id()));


		return schema;
	}


	public static io.intino.sumus.box.schemas.CrossTableQuery crossTableQueryFromLayer(io.intino.tara.magritte.Layer layer) {
		return crossTableQueryFromNode(layer.core$());
	}

	private static io.intino.sumus.box.schemas.CrossTableQuery crossTableQueryFromNode(io.intino.tara.magritte.Node node) {
		io.intino.sumus.box.schemas.CrossTableQuery schema = new io.intino.sumus.box.schemas.CrossTableQuery();
		final java.util.Map<String, java.util.List<?>> variables = node.variables();
		variables.put("name", java.util.Collections.singletonList(node.name()));
		variables.put("id", java.util.Collections.singletonList(node.id()));
		for (String variable : variables.keySet()) {
			if (variable.equals("cols")) schema.cols().addAll(((java.util.List<String>) variables.get(variable)));
			if (variable.equals("rows")) schema.rows().addAll(((java.util.List<String>) variables.get(variable)));
			if (variable.equals("ticket")) schema.ticket((String) variables.get(variable).get(0).toString());
		}
		for (io.intino.tara.magritte.Node component : node.componentList()) {
			if (component.name().equalsIgnoreCase(io.intino.sumus.box.schemas.HeatMap.class.getSimpleName())) schema.heatMap((heatMapFromNode(component)));
		}
		return schema;
	}


	public static io.intino.sumus.box.schemas.HeatMap heatMapFromLayer(io.intino.tara.magritte.Layer layer) {
		return heatMapFromNode(layer.core$());
	}

	private static io.intino.sumus.box.schemas.HeatMap heatMapFromNode(io.intino.tara.magritte.Node node) {
		io.intino.sumus.box.schemas.HeatMap schema = new io.intino.sumus.box.schemas.HeatMap();
		final java.util.Map<String, java.util.List<?>> variables = node.variables();
		variables.put("name", java.util.Collections.singletonList(node.name()));
		variables.put("id", java.util.Collections.singletonList(node.id()));
		for (String variable : variables.keySet()) {
			if (variable.equals("min")) schema.min((String) variables.get(variable).get(0).toString());
			if (variable.equals("max")) schema.max((String) variables.get(variable).get(0).toString());
		}

		return schema;
	}


	public static io.intino.sumus.box.schemas.Label labelFromLayer(io.intino.tara.magritte.Layer layer) {
		return labelFromNode(layer.core$());
	}

	private static io.intino.sumus.box.schemas.Label labelFromNode(io.intino.tara.magritte.Node node) {
		io.intino.sumus.box.schemas.Label schema = new io.intino.sumus.box.schemas.Label();
		final java.util.Map<String, java.util.List<?>> variables = node.variables();
		variables.put("name", java.util.Collections.singletonList(node.name()));
		variables.put("id", java.util.Collections.singletonList(node.id()));

		for (io.intino.tara.magritte.Node component : node.componentList()) {
			if (component.name().equalsIgnoreCase(io.intino.sumus.box.schemas.Translation.class.getSimpleName())) schema.translationList().add(translationFromNode(component));
		}
		return schema;
	}


	public static io.intino.sumus.box.schemas.Translation translationFromLayer(io.intino.tara.magritte.Layer layer) {
		return translationFromNode(layer.core$());
	}

	private static io.intino.sumus.box.schemas.Translation translationFromNode(io.intino.tara.magritte.Node node) {
		io.intino.sumus.box.schemas.Translation schema = new io.intino.sumus.box.schemas.Translation();
		final java.util.Map<String, java.util.List<?>> variables = node.variables();
		variables.put("name", java.util.Collections.singletonList(node.name()));
		variables.put("id", java.util.Collections.singletonList(node.id()));
		for (String variable : variables.keySet()) {
			if (variable.equals("language")) schema.language((String) variables.get(variable).get(0).toString());
			if (variable.equals("value")) schema.value((String) variables.get(variable).get(0).toString());
		}

		return schema;
	}


	public static io.intino.sumus.box.schemas.ScatterQuery scatterQueryFromLayer(io.intino.tara.magritte.Layer layer) {
		return scatterQueryFromNode(layer.core$());
	}

	private static io.intino.sumus.box.schemas.ScatterQuery scatterQueryFromNode(io.intino.tara.magritte.Node node) {
		io.intino.sumus.box.schemas.ScatterQuery schema = new io.intino.sumus.box.schemas.ScatterQuery();
		final java.util.Map<String, java.util.List<?>> variables = node.variables();
		variables.put("name", java.util.Collections.singletonList(node.name()));
		variables.put("id", java.util.Collections.singletonList(node.id()));
		for (String variable : variables.keySet()) {
			if (variable.equals("xAxis")) schema.xAxis((String) variables.get(variable).get(0).toString());
			if (variable.equals("yAxis")) schema.yAxis((String) variables.get(variable).get(0).toString());
			if (variable.equals("radius")) schema.radius((String) variables.get(variable).get(0).toString());
			if (variable.equals("color")) schema.color((String) variables.get(variable).get(0).toString());
			if (variable.equals("categorization")) schema.categorization((String) variables.get(variable).get(0).toString());
		}
		for (io.intino.tara.magritte.Node component : node.componentList()) {
			if (component.name().equalsIgnoreCase(io.intino.sumus.box.schemas.HeatMap.class.getSimpleName())) schema.heatMap((heatMapFromNode(component)));
		}
		return schema;
	}


	public static io.intino.sumus.box.schemas.Chart chartFromLayer(io.intino.tara.magritte.Layer layer) {
		return chartFromNode(layer.core$());
	}

	private static io.intino.sumus.box.schemas.Chart chartFromNode(io.intino.tara.magritte.Node node) {
		io.intino.sumus.box.schemas.Chart schema = new io.intino.sumus.box.schemas.Chart();
		final java.util.Map<String, java.util.List<?>> variables = node.variables();
		variables.put("name", java.util.Collections.singletonList(node.name()));
		variables.put("id", java.util.Collections.singletonList(node.id()));
		for (String variable : variables.keySet()) {
			if (variable.equals("name")) schema.name((String) variables.get(variable).get(0).toString());
			if (variable.equals("options")) schema.options().addAll(((java.util.List<String>) variables.get(variable)));
		}

		return schema;
	}


	public static io.intino.sumus.box.schemas.ChartOption chartOptionFromLayer(io.intino.tara.magritte.Layer layer) {
		return chartOptionFromNode(layer.core$());
	}

	private static io.intino.sumus.box.schemas.ChartOption chartOptionFromNode(io.intino.tara.magritte.Node node) {
		io.intino.sumus.box.schemas.ChartOption schema = new io.intino.sumus.box.schemas.ChartOption();
		final java.util.Map<String, java.util.List<?>> variables = node.variables();
		variables.put("name", java.util.Collections.singletonList(node.name()));
		variables.put("id", java.util.Collections.singletonList(node.id()));
		for (String variable : variables.keySet()) {
			if (variable.equals("name")) schema.name((String) variables.get(variable).get(0).toString());
			if (variable.equals("option")) schema.option((String) variables.get(variable).get(0).toString());
		}

		return schema;
	}


	public static io.intino.sumus.box.schemas.EventIcon eventIconFromLayer(io.intino.tara.magritte.Layer layer) {
		return eventIconFromNode(layer.core$());
	}

	private static io.intino.sumus.box.schemas.EventIcon eventIconFromNode(io.intino.tara.magritte.Node node) {
		io.intino.sumus.box.schemas.EventIcon schema = new io.intino.sumus.box.schemas.EventIcon();
		final java.util.Map<String, java.util.List<?>> variables = node.variables();
		variables.put("name", java.util.Collections.singletonList(node.name()));
		variables.put("id", java.util.Collections.singletonList(node.id()));
		for (String variable : variables.keySet()) {
			if (variable.equals("event")) schema.event((String) variables.get(variable).get(0).toString());
			if (variable.equals("value")) schema.value((String) variables.get(variable).get(0).toString());
		}

		return schema;
	}


	public static io.intino.sumus.box.schemas.Container containerFromLayer(io.intino.tara.magritte.Layer layer) {
		return containerFromNode(layer.core$());
	}

	private static io.intino.sumus.box.schemas.Container containerFromNode(io.intino.tara.magritte.Node node) {
		io.intino.sumus.box.schemas.Container schema = new io.intino.sumus.box.schemas.Container();
		final java.util.Map<String, java.util.List<?>> variables = node.variables();
		variables.put("name", java.util.Collections.singletonList(node.name()));
		variables.put("id", java.util.Collections.singletonList(node.id()));
		for (String variable : variables.keySet()) {
			if (variable.equals("name")) schema.name((String) variables.get(variable).get(0).toString());
			if (variable.equals("label")) schema.label((String) variables.get(variable).get(0).toString());
		}

		return schema;
	}


	public static io.intino.sumus.box.schemas.CatalogInstant catalogInstantFromLayer(io.intino.tara.magritte.Layer layer) {
		return catalogInstantFromNode(layer.core$());
	}

	private static io.intino.sumus.box.schemas.CatalogInstant catalogInstantFromNode(io.intino.tara.magritte.Node node) {
		io.intino.sumus.box.schemas.CatalogInstant schema = new io.intino.sumus.box.schemas.CatalogInstant();
		final java.util.Map<String, java.util.List<?>> variables = node.variables();
		variables.put("name", java.util.Collections.singletonList(node.name()));
		variables.put("id", java.util.Collections.singletonList(node.id()));
		for (String variable : variables.keySet()) {
			if (variable.equals("catalog")) schema.catalog((String) variables.get(variable).get(0).toString());
			if (variable.equals("value")) schema.value((java.time.Instant) variables.get(variable).get(0));
		}

		return schema;
	}


	public static io.intino.sumus.box.schemas.Range rangeFromLayer(io.intino.tara.magritte.Layer layer) {
		return rangeFromNode(layer.core$());
	}

	private static io.intino.sumus.box.schemas.Range rangeFromNode(io.intino.tara.magritte.Node node) {
		io.intino.sumus.box.schemas.Range schema = new io.intino.sumus.box.schemas.Range();
		final java.util.Map<String, java.util.List<?>> variables = node.variables();
		variables.put("name", java.util.Collections.singletonList(node.name()));
		variables.put("id", java.util.Collections.singletonList(node.id()));
		for (String variable : variables.keySet()) {
			if (variable.equals("min")) schema.min((Double) variables.get(variable).get(0));
			if (variable.equals("max")) schema.max((Double) variables.get(variable).get(0));
			if (variable.equals("scale")) schema.scale((String) variables.get(variable).get(0).toString());
		}

		return schema;
	}


	public static io.intino.sumus.box.schemas.Reference referenceFromLayer(io.intino.tara.magritte.Layer layer) {
		return referenceFromNode(layer.core$());
	}

	private static io.intino.sumus.box.schemas.Reference referenceFromNode(io.intino.tara.magritte.Node node) {
		io.intino.sumus.box.schemas.Reference schema = new io.intino.sumus.box.schemas.Reference();
		final java.util.Map<String, java.util.List<?>> variables = node.variables();
		variables.put("name", java.util.Collections.singletonList(node.name()));
		variables.put("id", java.util.Collections.singletonList(node.id()));
		for (String variable : variables.keySet()) {
			if (variable.equals("name")) schema.name((String) variables.get(variable).get(0).toString());
			if (variable.equals("label")) schema.label((String) variables.get(variable).get(0).toString());
		}
		for (io.intino.tara.magritte.Node component : node.componentList()) {
			if (component.name().equalsIgnoreCase(io.intino.sumus.box.schemas.ReferenceProperty.class.getSimpleName())) schema.referencePropertyList().add(referencePropertyFromNode(component));
		}
		return schema;
	}


	public static io.intino.sumus.box.schemas.ReferenceProperty referencePropertyFromLayer(io.intino.tara.magritte.Layer layer) {
		return referencePropertyFromNode(layer.core$());
	}

	private static io.intino.sumus.box.schemas.ReferenceProperty referencePropertyFromNode(io.intino.tara.magritte.Node node) {
		io.intino.sumus.box.schemas.ReferenceProperty schema = new io.intino.sumus.box.schemas.ReferenceProperty();
		final java.util.Map<String, java.util.List<?>> variables = node.variables();
		variables.put("name", java.util.Collections.singletonList(node.name()));
		variables.put("id", java.util.Collections.singletonList(node.id()));
		for (String variable : variables.keySet()) {
			if (variable.equals("name")) schema.name((String) variables.get(variable).get(0).toString());
			if (variable.equals("value")) schema.value((String) variables.get(variable).get(0).toString());
		}

		return schema;
	}


	public static io.intino.sumus.box.schemas.RequestRange requestRangeFromLayer(io.intino.tara.magritte.Layer layer) {
		return requestRangeFromNode(layer.core$());
	}

	private static io.intino.sumus.box.schemas.RequestRange requestRangeFromNode(io.intino.tara.magritte.Node node) {
		io.intino.sumus.box.schemas.RequestRange schema = new io.intino.sumus.box.schemas.RequestRange();
		final java.util.Map<String, java.util.List<?>> variables = node.variables();
		variables.put("name", java.util.Collections.singletonList(node.name()));
		variables.put("id", java.util.Collections.singletonList(node.id()));
		for (String variable : variables.keySet()) {
			if (variable.equals("from")) schema.from((java.time.Instant) variables.get(variable).get(0));
			if (variable.equals("to")) schema.to((java.time.Instant) variables.get(variable).get(0));
		}

		return schema;
	}

}

