package io.intino.sumus.box.displays.requesters;

import io.intino.sumus.box.displays.SumusFilter;
import io.intino.konos.alexandria.exceptions.*;
import io.intino.sumus.box.*;
import io.intino.sumus.box.schemas.*;

import io.intino.sumus.box.displays.notifiers.SumusFilterNotifier;
import io.intino.konos.alexandria.activity.displays.requesters.AlexandriaDisplayRequester;
import io.intino.konos.alexandria.exceptions.AlexandriaException;
import io.intino.konos.alexandria.activity.displays.AlexandriaDisplayNotifierProvider;
import io.intino.konos.alexandria.activity.spark.ActivitySparkManager;

public class SumusFilterRequester extends AlexandriaDisplayRequester {

	public SumusFilterRequester(ActivitySparkManager manager, AlexandriaDisplayNotifierProvider notifierProvider) {
		super(manager, notifierProvider);
	}

	@Override
	public void execute() throws AlexandriaException {
		SumusFilter display = display();
		if (display == null) return;
		String operation = operation();

		if (operation.equals("addCategorization")) display.addCategorization(manager.fromQuery("value", String.class));
		else if (operation.equals("removeCategorization")) display.removeCategorization(manager.fromQuery("value", String.class));
		else if (operation.equals("apply")) display.apply();
		else if (operation.equals("quit")) display.quit();
		super.execute();
	}
}