package io.intino.sumus.box.displays.builders;

import io.intino.sumus.box.schemas.Drill;
import io.intino.sumus.box.schemas.Tag;

import java.util.ArrayList;
import java.util.List;

import static io.intino.sumus.box.schemas.ActivitySchemaAdapters.categorizationFromLayer;

public class DrillBuilder {

    public static Drill build(io.intino.sumus.analytics.viewmodels.Drill drill) {
        if (drill == null) return null;

        return new Drill().categorization(categorizationFromLayer(drill.categorization))
                .tagList(build(drill.tags));
    }

    private static List<Tag> build(List<String> tags) {
        List<Tag> result = new ArrayList<>();
        tags.forEach(tag -> result.add(build(tag)));
        return result;
    }

    private static Tag build(String tag) {
        return new Tag().name(tag).label(tag);
    }
}
