package io.intino.sumus.box.displays;

import io.intino.konos.alexandria.activity.displays.ActivityDisplay;
import io.intino.konos.alexandria.activity.displays.AlexandriaDisplayNotifier;
import io.intino.konos.alexandria.activity.model.TimeScale;
import io.intino.sumus.QueryEngine;
import io.intino.sumus.box.SumusBox;
import io.intino.sumus.graph.AbstractAccess;
import io.intino.sumus.graph.SumusGraph;
import io.intino.sumus.graph.rules.SumusTimeScale;

import java.util.List;

import static java.util.stream.Collectors.toList;

public class SumusDisplay<N extends AlexandriaDisplayNotifier> extends ActivityDisplay<N, SumusBox> {
    private QueryEngine queryEngine;

    public SumusDisplay(SumusBox box) {
        super(box);
    }

    SumusGraph platform() {
        return box.graph();
    }

    List<AbstractAccess> accessList() {
        return box.graph().accesses(user());
    }

    public QueryEngine queryEngine() {
        if (queryEngine == null)
            queryEngine = new QueryEngine(box);
        return queryEngine;
    }

    public void queryEngine(QueryEngine engine) {
        this.queryEngine = engine;
    }

    TimeScale scaleOf(SumusTimeScale scale) {
        return TimeScale.values()[scale.ordinal()];
    }

    List<TimeScale> scalesOf(List<SumusTimeScale> scales) {
        return scales.stream().map(this::scaleOf).collect(toList());
    }

}
