package io.intino.sumus.box;

public class SumusConfiguration extends io.intino.konos.alexandria.BoxConfiguration {

	PlatformActivityConfiguration platformConfiguration;

	public SumusConfiguration(String[] args) {
		super(args);
		fillWithArgs();
	}

	private void fillWithArgs() {
		if (this.store == null && args.get("graph_store") != null)
			store = new java.io.File(args.remove("graph_store"));
		if (args.containsKey("platform_port")) {
			platformConfiguration(toInt(args.remove("platform_port")));

		}
	}

	public java.io.File store() {
		return this.store;
	}

	public SumusConfiguration platformConfiguration(int port) {
		this.platformConfiguration = new PlatformActivityConfiguration();
		this.platformConfiguration.port = port;
		this.platformConfiguration.webDirectory = "www/";

		return this;
	}

	public PlatformActivityConfiguration platformConfiguration() {
		return platformConfiguration;
	}

	public static class PlatformActivityConfiguration {
		public int port;
		public String webDirectory;
		public io.intino.konos.alexandria.activity.services.AuthService authService;



	}
}