package io.intino.sumus.box;

import io.intino.sumus.box.displays.*;
import io.intino.sumus.box.displays.notifiers.*;
import io.intino.sumus.box.displays.requesters.*;
import io.intino.sumus.box.resources.*;

import io.intino.konos.alexandria.activity.ActivityAlexandriaSpark;
import io.intino.konos.alexandria.activity.AssetResourceLoader;
import io.intino.konos.alexandria.activity.displays.AlexandriaDisplayNotifier;
import io.intino.konos.alexandria.activity.displays.AlexandriaDisplayNotifierProvider;
import io.intino.konos.alexandria.activity.services.push.PushService;
import io.intino.konos.alexandria.activity.spark.resources.AfterDisplayRequest;
import io.intino.konos.alexandria.activity.spark.resources.AssetResource;
import io.intino.konos.alexandria.activity.spark.resources.AuthenticateCallbackResource;
import io.intino.konos.alexandria.activity.spark.resources.BeforeDisplayRequest;

import java.net.MalformedURLException;
import java.net.URL;

public class PlatformActivity extends io.intino.konos.alexandria.activity.Activity {

	public static void init(ActivityAlexandriaSpark spark, SumusBox box) {
		SumusConfiguration.PlatformActivityConfiguration configuration = box.configuration().platformConfiguration;
		spark.route("/push").push(new PushService());
		spark.route("/authenticate-callback").get(manager -> new AuthenticateCallbackResource(manager, notifierProvider()).execute());
		spark.route("/asset/:name").get(manager -> new AssetResource(name -> new AssetResourceLoader(box).load(name), manager, notifierProvider()).execute());

		spark.route("/analytics").get(manager -> new AnalyticsPageResource(box, manager, notifierProvider()).execute());
		initDisplays(spark);
	}

	public static void initDisplays(ActivityAlexandriaSpark spark) {
		spark.route("/sumusdesktop/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/sumusdesktop/:displayId").post(manager -> new SumusDesktopRequester(manager, notifierProvider()).execute());

		spark.route("/sumusdesktop/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		spark.route("/sumusnamespace/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/sumusnamespace/:displayId").post(manager -> new SumusNameSpaceRequester(manager, notifierProvider()).execute());

		spark.route("/sumusnamespace/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		spark.route("/sumuserror/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/sumuserror/:displayId").post(manager -> new SumusErrorRequester(manager, notifierProvider()).execute());

		spark.route("/sumuserror/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		spark.route("/sumusolap/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/sumusolap/:displayId").post(manager -> new SumusOlapRequester(manager, notifierProvider()).execute());
		spark.route("/sumusolap/:displayId").get(manager -> new SumusOlapRequester(manager, notifierProvider()).execute());
		spark.route("/sumusolap/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		spark.route("/sumusanalyze/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/sumusanalyze/:displayId").post(manager -> new SumusAnalyzeRequester(manager, notifierProvider()).execute());

		spark.route("/sumusanalyze/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		spark.route("/sumustimeserieschart/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/sumustimeserieschart/:displayId").post(manager -> new SumusTimeSeriesChartRequester(manager, notifierProvider()).execute());

		spark.route("/sumustimeserieschart/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		spark.route("/sumustimeserieschartdialog/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/sumustimeserieschartdialog/:displayId").post(manager -> new SumusTimeSeriesChartDialogRequester(manager, notifierProvider()).execute());

		spark.route("/sumustimeserieschartdialog/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		spark.route("/sumustimecrosstable/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/sumustimecrosstable/:displayId").post(manager -> new SumusTimeCrossTableRequester(manager, notifierProvider()).execute());

		spark.route("/sumustimecrosstable/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		spark.route("/sumustimecrosstabledialog/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/sumustimecrosstabledialog/:displayId").post(manager -> new SumusTimeCrossTableDialogRequester(manager, notifierProvider()).execute());

		spark.route("/sumustimecrosstabledialog/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		spark.route("/sumustimebarchart/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/sumustimebarchart/:displayId").post(manager -> new SumusTimeBarChartRequester(manager, notifierProvider()).execute());

		spark.route("/sumustimebarchart/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		spark.route("/sumustimebarchartdialog/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/sumustimebarchartdialog/:displayId").post(manager -> new SumusTimeBarChartDialogRequester(manager, notifierProvider()).execute());

		spark.route("/sumustimebarchartdialog/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		spark.route("/sumustimescatterchart/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/sumustimescatterchart/:displayId").post(manager -> new SumusTimeScatterChartRequester(manager, notifierProvider()).execute());

		spark.route("/sumustimescatterchart/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		spark.route("/sumustimescatterchartdialog/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/sumustimescatterchartdialog/:displayId").post(manager -> new SumusTimeScatterChartDialogRequester(manager, notifierProvider()).execute());

		spark.route("/sumustimescatterchartdialog/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		spark.route("/sumustimechartdesign/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/sumustimechartdesign/:displayId").post(manager -> new SumusTimeChartDesignRequester(manager, notifierProvider()).execute());

		spark.route("/sumustimechartdesign/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		spark.route("/sumusfilterlist/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/sumusfilterlist/:displayId").post(manager -> new SumusFilterListRequester(manager, notifierProvider()).execute());

		spark.route("/sumusfilterlist/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		spark.route("/sumusfilter/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/sumusfilter/:displayId").post(manager -> new SumusFilterRequester(manager, notifierProvider()).execute());

		spark.route("/sumusfilter/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		spark.route("/sumuscategorizationcomparator/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/sumuscategorizationcomparator/:displayId").post(manager -> new SumusCategorizationComparatorRequester(manager, notifierProvider()).execute());

		spark.route("/sumuscategorizationcomparator/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		spark.route("/sumuscategorization/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/sumuscategorization/:displayId").post(manager -> new SumusCategorizationRequester(manager, notifierProvider()).execute());

		spark.route("/sumuscategorization/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());

		registerNotifiers();
	}

	private static void registerNotifiers() {
		register(SumusDesktopNotifier.class).forDisplay(io.intino.sumus.box.displays.SumusDesktop.class);
		register(SumusNameSpaceNotifier.class).forDisplay(io.intino.sumus.box.displays.SumusNameSpace.class);
		register(SumusErrorNotifier.class).forDisplay(io.intino.sumus.box.displays.SumusError.class);
		register(SumusOlapNotifier.class).forDisplay(io.intino.sumus.box.displays.SumusOlap.class);
		register(SumusAnalyzeNotifier.class).forDisplay(io.intino.sumus.box.displays.SumusAnalyze.class);
		register(SumusTimeSeriesChartNotifier.class).forDisplay(io.intino.sumus.box.displays.SumusTimeSeriesChart.class);
		register(SumusTimeSeriesChartDialogNotifier.class).forDisplay(io.intino.sumus.box.displays.SumusTimeSeriesChartDialog.class);
		register(SumusTimeCrossTableNotifier.class).forDisplay(io.intino.sumus.box.displays.SumusTimeCrossTable.class);
		register(SumusTimeCrossTableDialogNotifier.class).forDisplay(io.intino.sumus.box.displays.SumusTimeCrossTableDialog.class);
		register(SumusTimeBarChartNotifier.class).forDisplay(io.intino.sumus.box.displays.SumusTimeBarChart.class);
		register(SumusTimeBarChartDialogNotifier.class).forDisplay(io.intino.sumus.box.displays.SumusTimeBarChartDialog.class);
		register(SumusTimeScatterChartNotifier.class).forDisplay(io.intino.sumus.box.displays.SumusTimeScatterChart.class);
		register(SumusTimeScatterChartDialogNotifier.class).forDisplay(io.intino.sumus.box.displays.SumusTimeScatterChartDialog.class);
		register(SumusTimeChartDesignNotifier.class).forDisplay(io.intino.sumus.box.displays.SumusTimeChartDesign.class);
		register(SumusFilterListNotifier.class).forDisplay(io.intino.sumus.box.displays.SumusFilterList.class);
		register(SumusFilterNotifier.class).forDisplay(io.intino.sumus.box.displays.SumusFilter.class);
		register(SumusCategorizationComparatorNotifier.class).forDisplay(io.intino.sumus.box.displays.SumusCategorizationComparator.class);
		register(SumusCategorizationNotifier.class).forDisplay(io.intino.sumus.box.displays.SumusCategorization.class);

	}
}