package io.intino.sumus.analytics.viewmodels;

import java.util.List;

import static java.util.Collections.emptyList;

public class TagView {

	private final String name;
	private final List<TagView> subTags;

	public TagView(String tag) {
		this(tag, emptyList());
	}

	public TagView(String tag, List<TagView> subTags) {
		this.name = tag;
		this.subTags = subTags;
	}

	public String name() {
		return name;
	}

	public List<TagView> subTags() {
		return subTags;
	}

	@Override
	public boolean equals(Object obj) {
		if (!(obj instanceof TagView)) return false;
		return ((TagView) obj).name.equals(name) && ((TagView) obj).subTags.equals(subTags);
	}
}
