package io.intino.sumus.graph;

import io.intino.sumus.graph.*;
import io.intino.konos.alexandria.activity.model.TimeScale;
import io.intino.sumus.graph.NameSpace;
import java.time.Instant;
import io.intino.sumus.datawarehouse.store.Bucket;
import io.intino.sumus.datawarehouse.store.Digest;


public class Cube extends io.intino.tara.magritte.Layer implements io.intino.tara.magritte.tags.Terminal {
	protected io.intino.sumus.graph.functions.GetBucket getBucket;
	protected io.intino.sumus.graph.functions.GetBucket getOrCreateBucket;
	protected io.intino.sumus.graph.functions.GetDigest getDigest;
	protected java.util.List<io.intino.sumus.graph.Cube.Dimension> dimensionList = new java.util.ArrayList<>();
	protected java.util.List<io.intino.sumus.graph.Cube.Property> propertyList = new java.util.ArrayList<>();

	public Cube(io.intino.tara.magritte.Node node) {
		super(node);
	}

	public Bucket getBucket(NameSpace nameSpace, TimeScale scale, Instant instant) {
		return getBucket.get(nameSpace, scale, instant);
	}

	public Bucket getOrCreateBucket(NameSpace nameSpace, TimeScale scale, Instant instant) {
		return getOrCreateBucket.get(nameSpace, scale, instant);
	}

	public Digest getDigest(String ref) {
		return getDigest.digest(ref);
	}

	public Cube getBucket(io.intino.sumus.graph.functions.GetBucket value) {
		this.getBucket = io.intino.tara.magritte.loaders.FunctionLoader.load(getBucket, this, io.intino.sumus.graph.functions.GetBucket.class);
		return (Cube) this;
	}

	public Cube getOrCreateBucket(io.intino.sumus.graph.functions.GetBucket value) {
		this.getOrCreateBucket = io.intino.tara.magritte.loaders.FunctionLoader.load(getOrCreateBucket, this, io.intino.sumus.graph.functions.GetBucket.class);
		return (Cube) this;
	}

	public Cube getDigest(io.intino.sumus.graph.functions.GetDigest value) {
		this.getDigest = io.intino.tara.magritte.loaders.FunctionLoader.load(getDigest, this, io.intino.sumus.graph.functions.GetDigest.class);
		return (Cube) this;
	}

	public java.util.List<io.intino.sumus.graph.Cube.Dimension> dimensionList() {
		return java.util.Collections.unmodifiableList(dimensionList);
	}

	public io.intino.sumus.graph.Cube.Dimension dimension(int index) {
		return dimensionList.get(index);
	}

	public java.util.List<io.intino.sumus.graph.Cube.Dimension> dimensionList(java.util.function.Predicate<io.intino.sumus.graph.Cube.Dimension> predicate) {
		return dimensionList().stream().filter(predicate).collect(java.util.stream.Collectors.toList());
	}

	public java.util.List<io.intino.sumus.graph.Cube.Property> propertyList() {
		return java.util.Collections.unmodifiableList(propertyList);
	}

	public io.intino.sumus.graph.Cube.Property property(int index) {
		return propertyList.get(index);
	}

	public java.util.List<io.intino.sumus.graph.Cube.Property> propertyList(java.util.function.Predicate<io.intino.sumus.graph.Cube.Property> predicate) {
		return propertyList().stream().filter(predicate).collect(java.util.stream.Collectors.toList());
	}





	protected java.util.List<io.intino.tara.magritte.Node> componentList$() {
		java.util.Set<io.intino.tara.magritte.Node> components = new java.util.LinkedHashSet<>(super.componentList$());
		new java.util.ArrayList<>(dimensionList).forEach(c -> components.add(c.core$()));
		new java.util.ArrayList<>(propertyList).forEach(c -> components.add(c.core$()));
		return new java.util.ArrayList<>(components);
	}

	@Override
	protected java.util.Map<java.lang.String, java.util.List<?>> variables$() {
		java.util.Map<String, java.util.List<?>> map = new java.util.LinkedHashMap<>();
		map.put("getBucket", this.getBucket != null ? new java.util.ArrayList(java.util.Collections.singletonList(this.getBucket)) : java.util.Collections.emptyList());
		map.put("getOrCreateBucket", this.getOrCreateBucket != null ? new java.util.ArrayList(java.util.Collections.singletonList(this.getOrCreateBucket)) : java.util.Collections.emptyList());
		map.put("getDigest", this.getDigest != null ? new java.util.ArrayList(java.util.Collections.singletonList(this.getDigest)) : java.util.Collections.emptyList());
		return map;
	}

	@Override
	protected void addNode$(io.intino.tara.magritte.Node node) {
		super.addNode$(node);
		if (node.is("Cube$Dimension")) this.dimensionList.add(node.as(io.intino.sumus.graph.Cube.Dimension.class));
		if (node.is("Cube$Property")) this.propertyList.add(node.as(io.intino.sumus.graph.Cube.Property.class));
	}

	@Override
    protected void removeNode$(io.intino.tara.magritte.Node node) {
        super.removeNode$(node);
        if (node.is("Cube$Dimension")) this.dimensionList.remove(node.as(io.intino.sumus.graph.Cube.Dimension.class));
        if (node.is("Cube$Property")) this.propertyList.remove(node.as(io.intino.sumus.graph.Cube.Property.class));
    }

	@Override
	protected void load$(java.lang.String name, java.util.List<?> values) {
		super.load$(name, values);
		if (name.equalsIgnoreCase("getBucket")) this.getBucket = io.intino.tara.magritte.loaders.FunctionLoader.load(values, this, io.intino.sumus.graph.functions.GetBucket.class).get(0);
		else if (name.equalsIgnoreCase("getOrCreateBucket")) this.getOrCreateBucket = io.intino.tara.magritte.loaders.FunctionLoader.load(values, this, io.intino.sumus.graph.functions.GetBucket.class).get(0);
		else if (name.equalsIgnoreCase("getDigest")) this.getDigest = io.intino.tara.magritte.loaders.FunctionLoader.load(values, this, io.intino.sumus.graph.functions.GetDigest.class).get(0);
	}

	@Override
	protected void set$(java.lang.String name, java.util.List<?> values) {
		super.set$(name, values);
		if (name.equalsIgnoreCase("getBucket")) this.getBucket = io.intino.tara.magritte.loaders.FunctionLoader.load(values.get(0), this, io.intino.sumus.graph.functions.GetBucket.class);
		else if (name.equalsIgnoreCase("getOrCreateBucket")) this.getOrCreateBucket = io.intino.tara.magritte.loaders.FunctionLoader.load(values.get(0), this, io.intino.sumus.graph.functions.GetBucket.class);
		else if (name.equalsIgnoreCase("getDigest")) this.getDigest = io.intino.tara.magritte.loaders.FunctionLoader.load(values.get(0), this, io.intino.sumus.graph.functions.GetDigest.class);
	}

	public Create create() {
		return new Create(null);
	}

	public Create create(java.lang.String name) {
		return new Create(name);
	}

	public class Create  {
		protected final java.lang.String name;

		public Create(java.lang.String name) {
			this.name = name;
		}

		public io.intino.sumus.graph.Cube.Dimension dimension(io.intino.tara.magritte.Concept entity) {
		    io.intino.sumus.graph.Cube.Dimension newElement = core$().graph().concept(io.intino.sumus.graph.Cube.Dimension.class).createNode(name, core$()).as(io.intino.sumus.graph.Cube.Dimension.class);
			newElement.core$().set(newElement, "entity", java.util.Collections.singletonList(entity));
		    return newElement;
		}

		public io.intino.sumus.graph.Cube.Property property(java.lang.String label, io.intino.sumus.graph.Cube.Property.Type type) {
		    io.intino.sumus.graph.Cube.Property newElement = core$().graph().concept(io.intino.sumus.graph.Cube.Property.class).createNode(name, core$()).as(io.intino.sumus.graph.Cube.Property.class);
			newElement.core$().set(newElement, "label", java.util.Collections.singletonList(label));
			newElement.core$().set(newElement, "type", java.util.Collections.singletonList(type));
		    return newElement;
		}

	}

	public Clear clear() {
		return new Clear();
	}

	public class Clear  {
		public void dimension(java.util.function.Predicate<io.intino.sumus.graph.Cube.Dimension> filter) {
			new java.util.ArrayList<>(dimensionList()).stream().filter(filter).forEach(io.intino.tara.magritte.Layer::delete$);
		}

		public void property(java.util.function.Predicate<io.intino.sumus.graph.Cube.Property> filter) {
			new java.util.ArrayList<>(propertyList()).stream().filter(filter).forEach(io.intino.tara.magritte.Layer::delete$);
		}
	}

	public static class Dimension extends io.intino.tara.magritte.Layer implements io.intino.tara.magritte.tags.Terminal {
		protected io.intino.tara.magritte.Concept entity;

		public Dimension(io.intino.tara.magritte.Node node) {
			super(node);
		}

		public io.intino.tara.magritte.Concept entity() {
			return this.entity;
		}

		public Dimension entity(io.intino.tara.magritte.Concept value) {
			this.entity = value;
			return (Dimension) this;
		}

		@Override
		protected java.util.Map<java.lang.String, java.util.List<?>> variables$() {
			java.util.Map<String, java.util.List<?>> map = new java.util.LinkedHashMap<>();
			map.put("entity", this.entity != null ? new java.util.ArrayList(java.util.Collections.singletonList(this.entity)) : java.util.Collections.emptyList());
			return map;
		}

		@Override
		protected void load$(java.lang.String name, java.util.List<?> values) {
			super.load$(name, values);
			if (name.equalsIgnoreCase("entity")) this.entity = io.intino.tara.magritte.loaders.ConceptLoader.load(values, this).get(0);
		}

		@Override
		protected void set$(java.lang.String name, java.util.List<?> values) {
			super.set$(name, values);
			if (name.equalsIgnoreCase("entity")) this.entity = (io.intino.tara.magritte.Concept) values.get(0);
		}


		public io.intino.sumus.graph.SumusGraph graph() {
			return (io.intino.sumus.graph.SumusGraph) core$().graph().as(io.intino.sumus.graph.SumusGraph.class);
		}
	}

	public static class Property extends io.intino.tara.magritte.Layer implements io.intino.tara.magritte.tags.Terminal {
		protected java.lang.String label;
		protected Type type;

		public enum Type {
			Integer, Float;
		}
		protected boolean extended;

		public Property(io.intino.tara.magritte.Node node) {
			super(node);
		}

		public java.lang.String label() {
			return label;
		}

		public Type type() {
			return type;
		}

		public boolean extended() {
			return extended;
		}

		public Property label(java.lang.String value) {
			this.label = value;
			return (Property) this;
		}

		public Property type(io.intino.sumus.graph.Cube.Property.Type value) {
			this.type = value;
			return (Property) this;
		}

		public Property extended(boolean value) {
			this.extended = value;
			return (Property) this;
		}

		@Override
		protected java.util.Map<java.lang.String, java.util.List<?>> variables$() {
			java.util.Map<String, java.util.List<?>> map = new java.util.LinkedHashMap<>();
			map.put("label", new java.util.ArrayList(java.util.Collections.singletonList(this.label)));
			map.put("type", new java.util.ArrayList(java.util.Collections.singletonList(this.type)));
			map.put("extended", new java.util.ArrayList(java.util.Collections.singletonList(this.extended)));
			return map;
		}

		@Override
		protected void load$(java.lang.String name, java.util.List<?> values) {
			super.load$(name, values);
			if (name.equalsIgnoreCase("label")) this.label = io.intino.tara.magritte.loaders.StringLoader.load(values, this).get(0);
			else if (name.equalsIgnoreCase("type")) this.type = io.intino.tara.magritte.loaders.WordLoader.load(values, Type.class, this).get(0);
			else if (name.equalsIgnoreCase("extended")) this.extended = io.intino.tara.magritte.loaders.BooleanLoader.load(values, this).get(0);
		}

		@Override
		protected void set$(java.lang.String name, java.util.List<?> values) {
			super.set$(name, values);
			if (name.equalsIgnoreCase("label")) this.label = (java.lang.String) values.get(0);
			else if (name.equalsIgnoreCase("type")) this.type = (Type) values.get(0);
			else if (name.equalsIgnoreCase("extended")) this.extended = (java.lang.Boolean) values.get(0);
		}


		public io.intino.sumus.graph.SumusGraph graph() {
			return (io.intino.sumus.graph.SumusGraph) core$().graph().as(io.intino.sumus.graph.SumusGraph.class);
		}
	}


	public io.intino.sumus.graph.SumusGraph graph() {
		return (io.intino.sumus.graph.SumusGraph) core$().graph().as(io.intino.sumus.graph.SumusGraph.class);
	}
}
