package io.intino.sumus.box.displays.requesters;

import io.intino.sumus.box.displays.SumusTimeSeriesChart;
import io.intino.konos.alexandria.exceptions.*;
import io.intino.sumus.box.*;
import io.intino.sumus.box.schemas.*;

import io.intino.sumus.box.displays.notifiers.SumusTimeSeriesChartNotifier;
import io.intino.konos.alexandria.activity.displays.requesters.AlexandriaDisplayRequester;
import io.intino.konos.alexandria.exceptions.AlexandriaException;
import io.intino.konos.alexandria.activity.displays.AlexandriaDisplayNotifierProvider;
import io.intino.konos.alexandria.activity.spark.ActivitySparkManager;

public class SumusTimeSeriesChartRequester extends AlexandriaDisplayRequester {

	public SumusTimeSeriesChartRequester(ActivitySparkManager manager, AlexandriaDisplayNotifierProvider notifierProvider) {
		super(manager, notifierProvider);
	}

	@Override
	public void execute() throws AlexandriaException {
		SumusTimeSeriesChart display = display();
		if (display == null) return;
		String operation = operation();

		if (operation.equals("updateRangeAndScale")) display.updateRangeAndScale(manager.fromQuery("value", io.intino.sumus.box.schemas.RequestRange.class));
		else if (operation.equals("moveLeft")) display.moveLeft(manager.fromQuery("value", Long.class));
		else if (operation.equals("moveRight")) display.moveRight(manager.fromQuery("value", Long.class));
		else if (operation.equals("showDialog")) display.showDialog();
		else if (operation.equals("selectCatalogInstant")) display.selectCatalogInstant(manager.fromQuery("value", io.intino.sumus.box.schemas.CatalogInstant.class));
		super.execute();
	}
}