package io.intino.sumus.box.displays.requesters;

import io.intino.sumus.box.displays.SumusTimeCrossTableDialog;
import io.intino.konos.alexandria.exceptions.*;
import io.intino.sumus.box.*;
import io.intino.sumus.box.schemas.*;

import io.intino.sumus.box.displays.notifiers.SumusTimeCrossTableDialogNotifier;
import io.intino.konos.alexandria.activity.displays.requesters.AlexandriaDisplayRequester;
import io.intino.konos.alexandria.exceptions.AlexandriaException;
import io.intino.konos.alexandria.activity.displays.AlexandriaDisplayNotifierProvider;
import io.intino.konos.alexandria.activity.spark.ActivitySparkManager;

public class SumusTimeCrossTableDialogRequester extends AlexandriaDisplayRequester {

	public SumusTimeCrossTableDialogRequester(ActivitySparkManager manager, AlexandriaDisplayNotifierProvider notifierProvider) {
		super(manager, notifierProvider);
	}

	@Override
	public void execute() throws AlexandriaException {
		SumusTimeCrossTableDialog display = display();
		if (display == null) return;
		String operation = operation();

		if (operation.equals("query")) display.query(manager.fromQuery("value", io.intino.sumus.box.schemas.CrossTableQuery.class));
		super.execute();
	}
}