package io.intino.sumus.box.displays.requesters;

import io.intino.sumus.box.displays.SumusFilterList;
import io.intino.konos.alexandria.exceptions.*;
import io.intino.sumus.box.*;
import io.intino.sumus.box.schemas.*;

import io.intino.sumus.box.displays.notifiers.SumusFilterListNotifier;
import io.intino.konos.alexandria.activity.displays.requesters.AlexandriaDisplayRequester;
import io.intino.konos.alexandria.exceptions.AlexandriaException;
import io.intino.konos.alexandria.activity.displays.AlexandriaDisplayNotifierProvider;
import io.intino.konos.alexandria.activity.spark.ActivitySparkManager;

public class SumusFilterListRequester extends AlexandriaDisplayRequester {

	public SumusFilterListRequester(ActivitySparkManager manager, AlexandriaDisplayNotifierProvider notifierProvider) {
		super(manager, notifierProvider);
	}

	@Override
	public void execute() throws AlexandriaException {
		SumusFilterList display = display();
		if (display == null) return;
		String operation = operation();

		if (operation.equals("addFilter")) display.addFilter();
		else if (operation.equals("saveFilter")) display.saveFilter(manager.fromQuery("value", io.intino.sumus.box.schemas.FilterDialog.class));
		else if (operation.equals("removeFilter")) display.removeFilter(manager.fromQuery("value", String.class));
		else if (operation.equals("selectFilter")) display.selectFilter(manager.fromQuery("value", String.class));
		else if (operation.equals("applyFilter")) display.applyFilter(manager.fromQuery("value", String.class));
		else if (operation.equals("quitFilter")) display.quitFilter(manager.fromQuery("value", String.class));
		super.execute();
	}
}