package io.intino.sumus.box.displays.requesters;

import io.intino.sumus.box.displays.SumusCategorization;
import io.intino.konos.alexandria.exceptions.*;
import io.intino.sumus.box.*;
import io.intino.sumus.box.schemas.*;

import io.intino.sumus.box.displays.notifiers.SumusCategorizationNotifier;
import io.intino.konos.alexandria.activity.displays.requesters.AlexandriaDisplayRequester;
import io.intino.konos.alexandria.exceptions.AlexandriaException;
import io.intino.konos.alexandria.activity.displays.AlexandriaDisplayNotifierProvider;
import io.intino.konos.alexandria.activity.spark.ActivitySparkManager;

public class SumusCategorizationRequester extends AlexandriaDisplayRequester {

	public SumusCategorizationRequester(ActivitySparkManager manager, AlexandriaDisplayNotifierProvider notifierProvider) {
		super(manager, notifierProvider);
	}

	@Override
	public void execute() throws AlexandriaException {
		SumusCategorization display = display();
		if (display == null) return;
		String operation = operation();

		if (operation.equals("toggle")) display.toggle(manager.fromQuery("value", io.intino.sumus.box.schemas.CategorizationToggleDialog.class));
		else if (operation.equals("select")) display.select(manager.fromQuery("value", String[].class));
		else if (operation.equals("selectAll")) display.selectAll();
		else if (operation.equals("selectNone")) display.selectNone();
		super.execute();
	}
}