package io.intino.sumus.box.displays.requesters;

import io.intino.sumus.box.displays.SumusCategorizationComparator;
import io.intino.konos.alexandria.exceptions.*;
import io.intino.sumus.box.*;
import io.intino.sumus.box.schemas.*;

import io.intino.sumus.box.displays.notifiers.SumusCategorizationComparatorNotifier;
import io.intino.konos.alexandria.activity.displays.requesters.AlexandriaDisplayRequester;
import io.intino.konos.alexandria.exceptions.AlexandriaException;
import io.intino.konos.alexandria.activity.displays.AlexandriaDisplayNotifierProvider;
import io.intino.konos.alexandria.activity.spark.ActivitySparkManager;

public class SumusCategorizationComparatorRequester extends AlexandriaDisplayRequester {

	public SumusCategorizationComparatorRequester(ActivitySparkManager manager, AlexandriaDisplayNotifierProvider notifierProvider) {
		super(manager, notifierProvider);
	}

	@Override
	public void execute() throws AlexandriaException {
		SumusCategorizationComparator display = display();
		if (display == null) return;
		String operation = operation();

		if (operation.equals("includeGlobalSerie")) display.includeGlobalSerie(manager.fromQuery("value", Boolean.class));
		else if (operation.equals("apply")) display.apply();
		else if (operation.equals("quit")) display.quit();
		super.execute();
	}
}