/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.queries.digest;

import io.intino.sumus.TimeStamp;
import io.intino.sumus.datawarehouse.store.Bucket;
import io.intino.sumus.datawarehouse.store.Digest;
import io.intino.sumus.graph.Cube;
import io.intino.sumus.graph.NameSpace;
import io.intino.sumus.queries.Drill;
import io.intino.sumus.queries.digest.Query;
import io.intino.sumus.queries.digest.QueryResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class QueryExecutor {
    private final Query query;
    private final QueryResult result;
    private final Map<String, List<Drill>> drillMap = new ConcurrentHashMap<String, List<Drill>>();

    private QueryExecutor(Query query) {
        this.query = query.commit();
        this.result = new QueryResult(query);
    }

    public static QueryResult execute(Query query) {
        QueryExecutor executor = new QueryExecutor(query);
        executor.execute();
        return executor.result;
    }

    private void execute() {
        for (NameSpace nameSpace : this.query.nameSpaces()) {
            this.processNamespaces(nameSpace);
        }
    }

    private void processNamespaces(NameSpace nameSpace) {
        List<Query.SubQuery> queries = this.query.subQueries().stream().filter((? super T s) -> ((Object)((Object)s.nameSpace)).equals((Object)nameSpace)).collect(Collectors.toList());
        this.queryTimeStamps(queries).parallelStream().forEach(i -> this.processNamespace((TimeStamp)i, (Collection<Query.SubQuery>)queries));
    }

    private void processNamespace(TimeStamp stamp, Collection<Query.SubQuery> queries) {
        Collection<Query.SubQuery> availableQueries = this.availableQueries(stamp, queries);
        Map<Cube, BucketWithDrills> bucketMap = this.bucketByCubeType(stamp, availableQueries);
        for (Query.SubQuery query : availableQueries) {
            BucketWithDrills bucket = bucketMap.get((Object)query.cube());
            if (bucket == null) continue;
            if (bucket.drilledDigests.isEmpty()) {
                this.result.register(query, stamp, query.formula.calculate(bucket.filteredDigests));
                continue;
            }
            bucket.drilledDigests.forEach((drill, value) -> this.result.register(query, (Drill)drill, stamp, query.formula.calculate((List<Digest>)value)));
        }
    }

    private Collection<Query.SubQuery> availableQueries(TimeStamp stamp, Collection<Query.SubQuery> queries) {
        if (this.query.timeStamps().contains(stamp)) {
            return queries;
        }
        ArrayList<Query.SubQuery> subQueries = new ArrayList<Query.SubQuery>();
        for (Query.SubQuery subQuery : queries) {
            if (!subQuery.ts.contains(stamp)) continue;
            subQueries.add(subQuery);
        }
        return subQueries;
    }

    private Map<Drill, List<Digest>> groupDigestsByDrill(List<Digest> digests, List<Drill> temporalDrills) {
        HashMap<Drill, List<Digest>> digestsByDrill = new HashMap<Drill, List<Digest>>();
        if (!this.query.drills().isEmpty()) {
            this.groupDigestsByDrill(digests, digestsByDrill);
        }
        if (temporalDrills != null) {
            this.groupDigestsByDrill(digests, digestsByDrill, temporalDrills);
        }
        return digestsByDrill;
    }

    private synchronized void groupDigestsByDrill(List<Digest> digests, Map<Drill, List<Digest>> digestsByDrill) {
        this.query.drills().forEach(d -> {
            List cfr_ignored_0 = digestsByDrill.put((Drill)d, new ArrayList());
        });
        for (Digest digest : digests) {
            if (!this.drillMap.containsKey(digest.entityIds())) {
                this.indexDigest(digest);
            }
            for (Drill drill : this.drillMap.get(digest.entityIds())) {
                digestsByDrill.get(drill).add(digest);
            }
        }
    }

    private void groupDigestsByDrill(List<Digest> digests, Map<Drill, List<Digest>> digestsByDrill, List<Drill> temporalDrills) {
        temporalDrills.forEach(d -> {
            List cfr_ignored_0 = digestsByDrill.put((Drill)d, new ArrayList());
        });
        for (Digest digest : digests) {
            for (Drill temporalDrill : temporalDrills) {
                if (!temporalDrill.contains(digest.entityIds())) continue;
                digestsByDrill.get(temporalDrill).add(digest);
            }
        }
    }

    private void indexDigest(Digest digest) {
        this.drillMap.put(digest.entityIds(), new ArrayList());
        for (Drill drill : this.query.drills()) {
            if (!drill.contains(digest.entityIdsSplit())) continue;
            this.drillMap.get(digest.entityIds()).add(drill);
        }
    }

    private Collection<TimeStamp> queryTimeStamps(List<Query.SubQuery> queries) {
        LinkedHashSet<TimeStamp> stamps = new LinkedHashSet<TimeStamp>();
        queries.forEach(q -> stamps.addAll(q.ts));
        return stamps;
    }

    private List<Digest> filter(List<Digest> digests) {
        if (this.query.filter() == null) {
            return digests;
        }
        ArrayList<Digest> result = new ArrayList<Digest>();
        for (Digest digest : digests) {
            if (!this.query.filter().contains(digest.entityIdsSplit())) continue;
            result.add(digest);
        }
        return result;
    }

    private Map<Cube, BucketWithDrills> bucketByCubeType(TimeStamp stamp, Collection<Query.SubQuery> queries) {
        HashMap<Cube, BucketWithDrills> cubes = new HashMap<Cube, BucketWithDrills>();
        for (Cube cube : this.cubes(queries)) {
            Bucket bucket = new Bucket(cube, queries.iterator().next().nameSpace, stamp);
            if (!bucket.exists()) continue;
            cubes.put(cube, new BucketWithDrills(bucket));
        }
        return cubes;
    }

    private Set<Cube> cubes(Collection<Query.SubQuery> queries) {
        HashSet<Cube> concepts = new HashSet<Cube>();
        for (Query.SubQuery query : queries) {
            concepts.add(query.cube());
        }
        return concepts;
    }

    class BucketWithDrills {
        List<Digest> filteredDigests;
        Map<Drill, List<Digest>> drilledDigests;

        BucketWithDrills(Bucket bucket) {
            this.filteredDigests = QueryExecutor.this.filter(bucket.digests());
            QueryExecutor.this.result.register(this.filteredDigests);
            this.drilledDigests = QueryExecutor.this.groupDigestsByDrill((List<Digest>)this.filteredDigests, QueryExecutor.this.query.drills(bucket.timeStamp()));
        }
    }
}

