/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.queries;

import io.intino.sumus.Category;
import io.intino.sumus.TimeStamp;
import io.intino.sumus.analytics.FormulaLoader;
import io.intino.sumus.analytics.TimeRange;
import io.intino.sumus.graph.Categorization;
import io.intino.sumus.graph.MeasureIndicator;
import io.intino.sumus.graph.NameSpace;
import io.intino.sumus.graph.Ticket;
import io.intino.sumus.graph.rules.TimeScale;
import io.intino.sumus.queries.AbstractQuery;
import io.intino.sumus.queries.digest.Query;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TimeSeriesQuery
extends AbstractQuery {
    private final List<Ticket> tickets = new ArrayList<Ticket>();
    private final Map<Categorization, Set<Category>> drills = new HashMap<Categorization, Set<Category>>();
    private final Map<Categorization, List<Category>> filters = new HashMap<Categorization, List<Category>>();
    private NameSpace nameSpace;
    private TimeRange timeRange;
    private TimeStamp timeStamp;
    private boolean includeGlobalSerie;

    private TimeSeriesQuery() {
    }

    public NameSpace nameSpace() {
        return this.nameSpace;
    }

    public TimeRange timeRange() {
        return this.timeRange;
    }

    public List<Ticket> tickets() {
        return this.tickets;
    }

    public Map<Categorization, List<Category>> filters() {
        return this.filters;
    }

    public Map<Categorization, Set<Category>> drills() {
        return this.drills;
    }

    public boolean includeGlobalSerie() {
        return this.includeGlobalSerie;
    }

    public Query toRawQuery(FormulaLoader loader) {
        Query result = new Query();
        this.addScope(result);
        loader.formulas(this.tickets).forEach(formula -> result.add(this.nameSpace, (MeasureIndicator.Formula)((Object)formula)));
        if (this.timeRange != null) {
            result.add(this.timeRange);
        }
        if (this.timeStamp != null) {
            result.add(this.timeStamp);
        }
        if (!this.filters.values().isEmpty()) {
            result.filter((Category[])this.filters.values().stream().flatMap(Collection::stream).toArray(Category[]::new));
        }
        this.drills.values().forEach(categories -> categories.forEach(xva$0 -> result.drill((Category)xva$0)));
        return result;
    }

    public TimeScale scale() {
        return this.timeRange != null ? this.timeRange.scale() : this.timeStamp.scale();
    }

    public static class SortBy {
        private final Ticket ticket;
        private final MeasureIndicator indicator;
        private final Mode mode;

        public SortBy(Ticket ticket, MeasureIndicator indicator, Mode mode) {
            this.ticket = ticket;
            this.indicator = indicator;
            this.mode = mode;
        }

        public Ticket ticket() {
            return this.ticket;
        }

        public MeasureIndicator indicator() {
            return this.indicator;
        }

        public Mode mode() {
            return this.mode;
        }

        public static enum Mode {
            Ascendant,
            Descendant;

        }
    }

    public static class Builder {
        private final TimeSeriesQuery query = new TimeSeriesQuery();

        public TimeSeriesQuery build(NameSpace nameSpace, TimeRange timeRange) {
            this.nameSpace(nameSpace);
            this.timeRange(timeRange);
            return this.query;
        }

        public TimeSeriesQuery build(NameSpace nameSpace, TimeStamp timeStamp) {
            this.nameSpace(nameSpace);
            this.timeStamp(timeStamp);
            return this.query;
        }

        public Builder addTicket(Ticket ticket) {
            this.query.tickets.add(ticket);
            return this;
        }

        public Builder addTickets(List<Ticket> tickets) {
            this.query.tickets.addAll(tickets);
            return this;
        }

        public Builder filter(Categorization categorization, List<Category> category) {
            this.query.filters.put(categorization, category);
            return this;
        }

        public Builder drill(Categorization categorization, Category category) {
            this.query.drills.putIfAbsent(categorization, new HashSet());
            Set categories = (Set)this.query.drills.get((Object)categorization);
            categories.remove(category);
            categories.add(category);
            return this;
        }

        public Builder drill(Categorization categorization, List<Category> categories) {
            categories.forEach(c -> this.drill(categorization, (Category)c));
            return this;
        }

        public Builder drillWithKeys(Categorization categorization, List<String> keys) {
            categorization.calculate(keys).forEach(c -> this.drill(categorization, (Category)c));
            return this;
        }

        private Builder timeRange(TimeRange timeRange) {
            this.query.timeRange = timeRange;
            return this;
        }

        private Builder timeStamp(TimeStamp timeStamp) {
            this.query.timeStamp = timeStamp;
            return this;
        }

        public void includeGlobalSerie(boolean value) {
            this.query.includeGlobalSerie = value;
        }

        public void nameSpace(NameSpace nameSpace) {
            this.query.nameSpace = nameSpace;
        }
    }
}

