/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.queries;

import io.intino.sumus.Category;
import io.intino.sumus.analytics.TimeRange;
import io.intino.sumus.analytics.viewmodels.FilterCondition;
import io.intino.sumus.graph.Categorization;
import io.intino.sumus.graph.NameSpace;
import io.intino.sumus.graph.rules.TimeScale;
import io.intino.sumus.queries.AbstractQuery;
import io.intino.sumus.queries.temporalrecord.Query;
import io.intino.tara.magritte.Concept;
import io.intino.tara.magritte.Layer;
import java.time.Instant;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TemporalRecordQuery
extends AbstractQuery {
    private Concept record;
    private Map<Categorization, List<Category>> filters = new HashMap<Categorization, List<Category>>();
    private String condition;
    private TimeRange range = null;
    private TimeScale scale = null;
    private Instant instant = null;
    private NameSpace nameSpace;
    private String username;

    private TemporalRecordQuery() {
    }

    public Class<? extends Layer> event() {
        return this.record.layerClass();
    }

    public String condition() {
        return this.condition;
    }

    public TimeRange timeRange() {
        return this.range;
    }

    public Map<Categorization, List<Category>> filters() {
        return this.filters;
    }

    public NameSpace nameSpace() {
        return this.nameSpace;
    }

    public String username() {
        return this.username;
    }

    public Query toRawQuery() {
        Query result = this.range != null ? new Query(this.nameSpace, this.record, this.range) : new Query(this.nameSpace, this.record, this.scale, this.instant);
        this.addScope(result);
        if (this.condition != null) {
            result.condition(this.condition);
        }
        if (!this.filters.values().isEmpty()) {
            result.filter((Category[])this.filters.values().stream().flatMap(Collection::stream).toArray(Category[]::new));
        }
        return result;
    }

    public static class Builder {
        private final TemporalRecordQuery query = new TemporalRecordQuery();

        public TemporalRecordQuery build(Concept record, String username) {
            this.query.record = record;
            this.query.username = username;
            return this.query;
        }

        public Builder nameSpace(NameSpace nameSpace) {
            this.query.nameSpace = nameSpace;
            return this;
        }

        public Builder timeRange(TimeRange range) {
            this.query.range = range;
            return this;
        }

        public Builder instant(Instant instant, TimeScale scale) {
            this.query.instant = instant;
            this.query.scale = scale;
            return this;
        }

        public Builder filter(List<FilterCondition> filters) {
            this.query.filters = this.query.toMap(filters);
            return this;
        }

        public Builder condition(String condition) {
            this.query.condition = condition;
            return this;
        }
    }
}

