/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.queries;

import io.intino.sumus.Category;
import io.intino.sumus.TimeStamp;
import io.intino.sumus.analytics.categorization.TemporalCategorization;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Filter {
    private final List<Set<String>> recordIds = new ArrayList<Set<String>>();
    private final Map<TimeStamp, TemporalCategorization.TemporalCategory> temporalCategories = new HashMap<TimeStamp, TemporalCategorization.TemporalCategory>();

    public void add(Category ... categories) {
        ArrayList<Category> recordCategories = new ArrayList<Category>();
        for (Category category : categories) {
            if (category instanceof TemporalCategorization.TemporalCategory) {
                this.add((TemporalCategorization.TemporalCategory)category);
                continue;
            }
            recordCategories.add(category);
        }
        this.add(recordCategories);
    }

    private void add(List<Category> recordCategories) {
        HashSet<String> records = new HashSet<String>();
        for (Category category : recordCategories) {
            records.addAll(category.recordIds());
        }
        this.recordIds.add(records);
    }

    private void add(TemporalCategorization.TemporalCategory category) {
        this.temporalCategories.put(category.timeStamp(), category);
    }

    public boolean contains(List<String> ids) {
        for (Set<String> record : this.recordIds) {
            if (this.containsAnyOf(ids, record)) continue;
            return false;
        }
        return true;
    }

    public boolean contains(String id) {
        return this.contains(Collections.singletonList(id));
    }

    private boolean containsAnyOf(List<String> ids, Set<String> records) {
        for (String id : ids) {
            if (!records.contains(id)) continue;
            return true;
        }
        return false;
    }

    public boolean isTemporal() {
        return !this.temporalCategories.isEmpty();
    }

    public boolean contains(TimeStamp timeStamp) {
        if (this.temporalCategories.isEmpty()) {
            return true;
        }
        for (TimeStamp stamp : this.temporalCategories.keySet()) {
            if (!stamp.contains(timeStamp)) continue;
            return true;
        }
        return false;
    }
}

