/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.queries;

import io.intino.sumus.Category;
import io.intino.sumus.analytics.FormulaLoader;
import io.intino.sumus.analytics.TimeRange;
import io.intino.sumus.analytics.viewmodels.FilterCondition;
import io.intino.sumus.graph.Categorization;
import io.intino.sumus.graph.MeasureIndicator;
import io.intino.sumus.graph.NameSpace;
import io.intino.sumus.graph.Ticket;
import io.intino.sumus.helpers.MathHelper;
import io.intino.sumus.queries.AbstractQuery;
import io.intino.sumus.queries.digest.Query;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CrossTableQuery
extends AbstractQuery {
    private Ticket ticket = null;
    private final Map<Categorization, List<Category>> columns = new HashMap<Categorization, List<Category>>();
    private final Map<Categorization, List<Category>> rows = new HashMap<Categorization, List<Category>>();
    private final Map<Categorization, List<Category>> filters = new HashMap<Categorization, List<Category>>();
    private NameSpace nameSpace;
    private TimeRange timeRange;

    private CrossTableQuery() {
    }

    public Ticket ticket() {
        return this.ticket;
    }

    public Map<Categorization, List<Category>> columns() {
        return this.columns;
    }

    public Map<Categorization, List<Category>> rows() {
        return this.rows;
    }

    public Map<Categorization, List<Category>> filters() {
        return this.filters;
    }

    public NameSpace nameSpace() {
        return this.nameSpace;
    }

    public TimeRange timeRange() {
        return this.timeRange;
    }

    public Query toRawQuery(FormulaLoader loader) {
        Query result = new Query();
        this.addScope(result);
        loader.formulas(Collections.singletonList(this.ticket)).forEach(formula -> result.add(this.nameSpace, (MeasureIndicator.Formula)((Object)formula)));
        result.add(this.timeRange);
        this.filters.values().forEach(categories -> result.filter(categories.toArray(new Category[categories.size()])));
        Set<Set<Category>> cartesianColumns = this.cartesianProduct(new ArrayList<List<Category>>(this.columns.values()));
        Set<Set<Category>> cartesianRows = this.cartesianProduct(new ArrayList<List<Category>>(this.rows.values()));
        cartesianColumns.forEach(cartesianColumn -> cartesianRows.forEach(cartesianRow -> {
            List<Category> categories = this.mergeSets((Set<Category>)cartesianColumn, (Set<Category>)cartesianRow);
            result.drill(categories);
        }));
        return result;
    }

    private Set<Set<Category>> cartesianProduct(final List<List<Category>> values) {
        Set[] set = new Set[values.size()];
        for (int i = 0; i < values.size(); ++i) {
            set[i] = new LinkedHashSet(values.get(i));
        }
        if (set.length == 1) {
            return new LinkedHashSet<Set<Category>>(){
                {
                    ((List)values.get(0)).forEach(value -> this.add(new LinkedHashSet<Category>(){
                        {
                            this.add(value);
                        }
                    }));
                }
            };
        }
        return MathHelper.cartesianProduct(set);
    }

    private List<Category> mergeSets(Set<Category> column, Set<Category> row) {
        ArrayList<Category> categories = new ArrayList<Category>(column);
        categories.addAll(row);
        return categories;
    }

    public static class Builder {
        private final CrossTableQuery query = new CrossTableQuery();

        public CrossTableQuery build(NameSpace nameSpace, Ticket ticket, TimeRange timeRange) {
            this.nameSpace(nameSpace);
            this.ticket(ticket);
            this.timeRange(timeRange);
            return this.query;
        }

        private Builder ticket(Ticket ticket) {
            this.query.ticket = ticket;
            return this;
        }

        private Builder nameSpace(NameSpace nameSpace) {
            this.query.nameSpace = nameSpace;
            return this;
        }

        private Builder timeRange(TimeRange timeRange) {
            this.query.timeRange = timeRange;
            return this;
        }

        public Builder addColumn(Categorization categorization, List<Category> categories) {
            this.query.columns.put(categorization, categories);
            return this;
        }

        public Builder addRow(Categorization categorization, List<Category> categories) {
            this.query.rows.put(categorization, categories);
            return this;
        }

        public Builder filter(List<FilterCondition> filterConditions) {
            filterConditions.forEach(filter -> this.query.filters.put(filter.categorization, filter.categories));
            return this;
        }
    }
}

