/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.queries;

import io.intino.sumus.Category;
import io.intino.sumus.CategoryMap;
import io.intino.sumus.graph.Categorization;
import io.intino.sumus.graph.Record;
import io.intino.sumus.queries.Filter;
import io.intino.tara.magritte.Layer;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class CatalogManager {
    private final List<Record> records;
    private final Map<String, Categorization> categorizations;
    private final Map<Categorization, CategoryMap> categories;
    private final List<String> keys;
    private Filter filter = null;
    private Map<String, List<String>> filteredCategorizations = new HashMap<String, List<String>>();

    public CatalogManager(List<Record> records, List<Categorization> categorizations, List<String> keys) {
        this.records = records;
        this.keys = keys;
        this.categorizations = categorizations.stream().collect(Collectors.toMap(Layer::name$, c -> c));
        this.categories = this.calculateCategorizations(records);
    }

    private Map<Categorization, CategoryMap> calculateCategorizations(List<Record> records) {
        return this.categorizations.values().stream().collect(Collectors.toMap(c -> c, c -> this.filteredCategorizations.keySet().contains(c.name$()) ? c.calculateMap(this.records, this.keys) : c.calculateMap(records, this.keys)));
    }

    public void filter(String categorizationName, List<String> categories) {
        Categorization categorization = this.categorizations.get(categorizationName);
        this.filter = this.filter == null ? new Filter() : this.filter;
        this.filter.add(this.collect(categories, categorization));
        this.filteredCategorizations.put(categorizationName, categories);
    }

    public void clearFilter() {
        this.filter = null;
        this.filteredCategorizations.clear();
    }

    public List<Record> records() {
        if (this.filter == null) {
            return this.records;
        }
        return this.records.stream().filter(record -> this.filter.contains(record.core$().id())).collect(Collectors.toList());
    }

    public Map<Categorization, CategoryMap> categories() {
        if (this.filter == null) {
            return this.categories;
        }
        return this.calculateCategorizations(this.records());
    }

    public List<String> filteredCategories(Categorization categorization) {
        String key = categorization.name$();
        return this.filteredCategorizations.containsKey(key) ? this.filteredCategorizations.get(key) : Collections.emptyList();
    }

    public CategoryMap categories(Categorization categorization) {
        return this.categories(categorization.name$());
    }

    public CategoryMap categories(String categorization) {
        return this.categories().entrySet().stream().filter(e -> ((Categorization)((Object)((Object)e.getKey()))).name$().equals(categorization) || ((Categorization)((Object)((Object)e.getKey()))).label().equals(categorization)).map(Map.Entry::getValue).findFirst().orElse(null);
    }

    private Category[] collect(List<String> categories, Categorization categorization) {
        return (Category[])categories.stream().map(c -> (Category)this.categories.get((Object)categorization).get(c)).toArray(Category[]::new);
    }
}

