/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.helpers;

import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.Month;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.temporal.TemporalField;

public class UtcDateTime {
    private LocalDateTime dateTime;

    public UtcDateTime(long epochMilli) {
        this.dateTime = UtcDateTime.dateTimeOf(epochMilli);
    }

    public UtcDateTime(Instant instant) {
        this.dateTime = UtcDateTime.dateTimeOf(instant);
    }

    public UtcDateTime(int year, int month, int day, int hour, int minute) {
        this.dateTime = LocalDateTime.of(year, month, day, hour, minute);
    }

    public UtcDateTime(int year, int month, int day, int hour, int minute, int second) {
        this.dateTime = LocalDateTime.of(year, month, day, hour, minute, second);
    }

    public int year() {
        return this.dateTime.getYear();
    }

    public static int yearOf(Instant instant) {
        return UtcDateTime.dateTimeOf(instant).getYear();
    }

    public Month month() {
        return this.dateTime.getMonth();
    }

    public static Month monthOf(Instant instant) {
        return UtcDateTime.dateTimeOf(instant).getMonth();
    }

    public int monthNumber() {
        return this.dateTime.getMonthValue();
    }

    public static int monthNumberOf(Instant instant) {
        return UtcDateTime.dateTimeOf(instant).getMonthValue();
    }

    public int dayOfYear() {
        return this.dateTime.getDayOfYear();
    }

    public static int dayOfYearOf(Instant instant) {
        return UtcDateTime.dateTimeOf(instant).getDayOfYear();
    }

    public int dayOfMonth() {
        return this.dateTime.getDayOfMonth();
    }

    public DayOfWeek dayOfWeek() {
        return this.dateTime.getDayOfWeek();
    }

    public static int dayOfMonthOf(Instant instant) {
        return UtcDateTime.dateTimeOf(instant).getDayOfMonth();
    }

    public static DayOfWeek dayOfWeek(Instant instant) {
        return UtcDateTime.dateTimeOf(instant).getDayOfWeek();
    }

    public int hour() {
        return this.dateTime.getHour();
    }

    public static int hourOf(Instant instant) {
        return UtcDateTime.dateTimeOf(instant).getHour();
    }

    public int minute() {
        return this.dateTime.getMinute();
    }

    public static int minuteOf(Instant instant) {
        return UtcDateTime.dateTimeOf(instant).getMinute();
    }

    public int second() {
        return this.dateTime.getSecond();
    }

    public static int secondOf(Instant instant) {
        return UtcDateTime.dateTimeOf(instant).getSecond();
    }

    public boolean isBefore(UtcDateTime other) {
        return this.dateTime.isBefore(other.dateTime);
    }

    public boolean isEqual(UtcDateTime other) {
        return this.dateTime.isEqual(other.dateTime);
    }

    public UtcDateTime plusWeeks(int week) {
        this.dateTime = this.dateTime.plusWeeks(week);
        return this;
    }

    public UtcDateTime plusDays(int day) {
        this.dateTime = this.dateTime.plusDays(day);
        return this;
    }

    public UtcDateTime plusHours(int hours) {
        this.dateTime = this.dateTime.plusHours(hours);
        return this;
    }

    public UtcDateTime plusMinutes(int minutes) {
        this.dateTime = this.dateTime.plusMinutes(minutes);
        return this;
    }

    public UtcDateTime minusDays(int day) {
        this.dateTime = this.dateTime.minusDays(day);
        return this;
    }

    public UtcDateTime with(TemporalField temporalField, int newValue) {
        this.dateTime = this.dateTime.with(temporalField, newValue);
        return this;
    }

    public int get(TemporalField temporalField) {
        return this.dateTime.get(temporalField);
    }

    public Instant toInstant() {
        return UtcDateTime.instantOf(this.dateTime);
    }

    public static UtcDateTime of(Instant initialInstant) {
        return new UtcDateTime(initialInstant);
    }

    public static UtcDateTime of(long epochMilli) {
        return new UtcDateTime(epochMilli);
    }

    public static UtcDateTime of(int year, int month, int day, int hour, int minute) {
        return new UtcDateTime(year, month, day, hour, minute);
    }

    public static UtcDateTime of(int year, int month, int day, int hour, int minute, int second) {
        return new UtcDateTime(year, month, day, hour, minute, second);
    }

    private static LocalDateTime dateTimeOf(long epochMilli) {
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(epochMilli), UtcDateTime.utc());
    }

    private static LocalDateTime dateTimeOf(Instant instant) {
        return UtcDateTime.dateTimeOf(instant.toEpochMilli());
    }

    private static ZoneId utc() {
        return ZoneId.of("UTC");
    }

    private static ZoneOffset utcOffset() {
        return ZoneOffset.UTC;
    }

    private static Instant instantOf(LocalDateTime dateTime) {
        return dateTime.toInstant(UtcDateTime.utcOffset());
    }
}

