/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.helpers;

import io.intino.sumus.RecordList;
import io.intino.sumus.analytics.TimeRange;
import io.intino.sumus.box.SumusBox;
import io.intino.sumus.datawarehouse.store.PathBuilder;
import io.intino.sumus.graph.NameSpace;
import io.intino.sumus.graph.TemporalRecord;
import io.intino.sumus.helpers.Helper;
import io.intino.sumus.queries.TemporalRecordQuery;
import io.intino.sumus.queries.temporalrecord.QueryExecutor;
import io.intino.tara.magritte.Node;
import java.util.List;
import java.util.stream.Collectors;

public class TemporalRecordHelper
extends Helper {
    private final SumusBox box;

    public TemporalRecordHelper(SumusBox box) {
        this.box = box;
    }

    public TimeRange recordRange(List<NameSpace> nameSpaces) {
        return PathBuilder.range(nameSpaces);
    }

    public RecordList<TemporalRecord> records(TemporalRecordQuery query) {
        return new RecordList<TemporalRecord>(this.load(query));
    }

    public TemporalRecord record(String id, String username) {
        Node node = this.box.graph().core$().clone().load(id, false);
        if (node == null) {
            return null;
        }
        TemporalRecord record = (TemporalRecord)node.as(TemporalRecord.class);
        return this.checkPermissions(record, username) ? record : null;
    }

    private List<TemporalRecord> load(TemporalRecordQuery query) {
        return QueryExecutor.execute(query.toRawQuery()).values().stream().filter(tr -> this.checkPermissions((TemporalRecord)((Object)tr), query.username())).collect(Collectors.toList());
    }

    private boolean checkPermissions(TemporalRecord record, String username) {
        return this.box.graph().checkPermissions(record, username);
    }
}

