/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.helpers;

import io.intino.sumus.helpers.Helper;
import java.util.LinkedHashSet;
import java.util.Set;

public class MathHelper
extends Helper {
    public static double round(double value, int places) {
        if (places < 0) {
            throw new IllegalArgumentException();
        }
        long factor = (long)Math.pow(10.0, places);
        long tmp = Math.round(value *= (double)factor);
        return (double)tmp / (double)factor;
    }

    public static <T> Set<Set<T>> cartesianProduct(Set<T> ... sets) {
        if (sets.length < 2) {
            throw new IllegalArgumentException("Can't have a product of fewer than two sets (got " + sets.length + ")");
        }
        return MathHelper._cartesianProduct(0, sets);
    }

    private static <T> Set<Set<T>> _cartesianProduct(int index, Set<T> ... sets) {
        LinkedHashSet<Set<T>> ret = new LinkedHashSet<Set<T>>();
        if (index == sets.length) {
            ret.add(new LinkedHashSet());
        } else {
            for (T obj : sets[index]) {
                for (Set<T> set : MathHelper._cartesianProduct(index + 1, sets)) {
                    set.add(obj);
                    ret.add(set);
                }
            }
        }
        return ret;
    }
}

