/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.helpers;

import io.intino.sumus.Category;
import io.intino.sumus.analytics.viewmodels.Histogram;
import io.intino.sumus.graph.Categorization;
import io.intino.sumus.graph.MeasureIndicator;
import io.intino.sumus.graph.NameSpace;
import io.intino.sumus.graph.Ticket;
import io.intino.sumus.helpers.QueryHelper;
import io.intino.sumus.queries.Drill;
import io.intino.sumus.queries.HistogramQuery;
import io.intino.sumus.queries.digest.Query;
import io.intino.sumus.queries.digest.QueryExecutor;
import io.intino.sumus.queries.digest.QueryResult;
import java.util.List;
import java.util.stream.Collectors;

public class HistogramHelper
extends QueryHelper {
    public Histogram execute(HistogramQuery histogramQuery) {
        Query query = this.queryOf(histogramQuery);
        QueryResult rawData = QueryExecutor.execute(query);
        Histogram histogram = new Histogram(this.categories(histogramQuery), histogramQuery.sortBy());
        query.nameSpaces().forEach(nameSpace -> query.formulas().forEach(formula -> {
            List<Double> values = query.drills().stream().map(d -> rawData.values((NameSpace)((Object)nameSpace), (MeasureIndicator.Formula)((Object)((Object)formula)), (Drill)d).values().iterator().next()).collect(Collectors.toList());
            Histogram.HistogramTicket ticket = histogram.histogramTicket(this.ticketOf((MeasureIndicator.Formula)((Object)((Object)formula))));
            ticket.register(this.createIndicator((MeasureIndicator.Formula)((Object)((Object)formula)), query, values));
        }));
        return histogram;
    }

    private Histogram.HistogramIndicator createIndicator(MeasureIndicator.Formula formula, Query query, List<Double> values) {
        MeasureIndicator indicator = this.indicatorOf(formula);
        Ticket.DecimalPlaces decimalPlaces = this.ticketOf(formula).decimalPlaces();
        Histogram.HistogramIndicator result = new Histogram.HistogramIndicator(indicator, this.labelOf(formula), this.colorOf(indicator), decimalPlaces);
        result.register(values);
        return result;
    }

    private Query queryOf(HistogramQuery query) {
        return query.toRawQuery(tickets -> this.formulas(this.measureIndicators(query.tickets(), query.scale())), this.categories(query));
    }

    private List<Category> categories(HistogramQuery query) {
        Categorization categorization = query.categorization();
        if (query.filters().containsKey((Object)categorization)) {
            return query.filters().get((Object)categorization);
        }
        return categorization.calculate(query.keys());
    }
}

