/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.helpers;

import io.intino.konos.server.activity.services.push.User;
import io.intino.sumus.analytics.TimeRange;
import io.intino.sumus.analytics.viewmodels.ElementView;
import io.intino.sumus.box.displays.ElementDisplay;
import io.intino.sumus.box.displays.ElementViewDisplay;
import io.intino.sumus.box.displays.StampDisplay;
import io.intino.sumus.box.displays.builders.RecordItemBuilder;
import io.intino.sumus.box.displays.providers.ElementViewDisplayProvider;
import io.intino.sumus.box.displays.providers.RecordDisplayProvider;
import io.intino.sumus.box.schemas.ElementOperationParameters;
import io.intino.sumus.box.schemas.RecordItem;
import io.intino.sumus.box.schemas.SaveItemParameters;
import io.intino.sumus.graph.Mold;
import io.intino.sumus.graph.NameSpace;
import io.intino.sumus.graph.Record;
import io.intino.sumus.graph.functions.Resource;
import io.intino.sumus.graph.rules.TimeScale;
import io.intino.sumus.helpers.NameSpaceHandler;
import java.net.URL;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;

public class ElementHelper {
    public static RecordItem[] recordItems(Record[] records, RecordItemBuilder.RecordItemBuilderProvider provider, URL baseAssetUrl) {
        return (RecordItem[])Stream.of(records).map(r -> ElementHelper.recordItem(r, provider, baseAssetUrl)).toArray(RecordItem[]::new);
    }

    public static RecordItem recordItem(Record record, RecordItemBuilder.RecordItemBuilderProvider provider, URL baseAssetUrl) {
        return RecordItemBuilder.build(record, provider, baseAssetUrl);
    }

    public static RecordDisplayProvider recordDisplayProvider(final ElementViewDisplayProvider provider, final ElementView view) {
        return new RecordDisplayProvider(){

            @Override
            public Mold mold() {
                return view.mold();
            }

            @Override
            public Record record(String id) {
                return provider.record(id);
            }

            @Override
            public NameSpaceHandler nameSpaceHandler() {
                return provider.nameSpaceHandler();
            }

            @Override
            public NameSpace nameSpace() {
                Optional<User> user = provider.user();
                return provider.nameSpaceHandler().selectedNameSpace(user.isPresent() ? user.get().username() : null);
            }

            @Override
            public TimeRange range() {
                return provider.range();
            }

            @Override
            public List<Mold.Block> blocks(Mold mold) {
                return provider.blocks(mold);
            }

            @Override
            public List<Mold.Block.Stamp> stamps(Mold mold) {
                return provider.stamps(mold);
            }

            @Override
            public Mold.Block.Stamp stamp(Mold mold, String stampName) {
                return provider.stamp(mold, stampName);
            }

            @Override
            public StampDisplay display(String name) {
                return provider.display(name);
            }

            @Override
            public ElementDisplay openElement(String label) {
                return provider.openElement(label);
            }

            @Override
            public void executeOperation(ElementOperationParameters params, List<Record> records) {
                provider.executeOperation(params, records);
            }

            @Override
            public Resource downloadOperation(ElementOperationParameters params, List<Record> records) {
                return provider.downloadOperation(params, records);
            }

            @Override
            public void saveItem(SaveItemParameters params, Record record) {
                provider.saveItem(params, record);
            }
        };
    }

    public static RecordItemBuilder.RecordItemBuilderProvider recordItemDisplayProvider(final ElementViewDisplayProvider provider, final ElementView view) {
        return new RecordItemBuilder.RecordItemBuilderProvider(){

            @Override
            public List<Mold.Block> blocks() {
                return provider.blocks(view.mold());
            }

            @Override
            public List<Mold.Block.Stamp> stamps() {
                return provider.stamps(view.mold());
            }

            @Override
            public String username() {
                return provider.user().isPresent() ? provider.user().get().username() : null;
            }

            @Override
            public TimeScale scale() {
                return provider.range() != null ? provider.range().scale() : null;
            }
        };
    }

    public static ElementViewDisplay.OpenItemDialogEvent openItemDialogEvent(final String item, final Mold.Block.Stamp stamp) {
        return new ElementViewDisplay.OpenItemDialogEvent(){

            @Override
            public String item() {
                return item;
            }

            @Override
            public String path() {
                return ((Mold.Block.OpenDialogOperation)stamp.a$(Mold.Block.OpenDialogOperation.class)).path(item);
            }

            @Override
            public int width() {
                return ((Mold.Block.OpenDialogOperation)stamp.a$(Mold.Block.OpenDialogOperation.class)).width();
            }

            @Override
            public int height() {
                return ((Mold.Block.OpenDialogOperation)stamp.a$(Mold.Block.OpenDialogOperation.class)).height();
            }
        };
    }

    public static ElementViewDisplay.ExecuteItemTaskEvent executeItemTaskEvent(final String item, final Mold.Block.Stamp stamp) {
        return new ElementViewDisplay.ExecuteItemTaskEvent(){

            @Override
            public String item() {
                return item;
            }

            @Override
            public Mold.Block.Stamp stamp() {
                return stamp;
            }
        };
    }
}

