/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.graph;

import io.intino.sumus.graph.Element;
import io.intino.sumus.graph.Record;
import io.intino.sumus.graph.SumusGraph;
import io.intino.sumus.graph.functions.OperationDownload;
import io.intino.sumus.graph.functions.OperationDownloadSelection;
import io.intino.sumus.graph.functions.OperationExport;
import io.intino.sumus.graph.functions.OperationExportSelection;
import io.intino.sumus.graph.functions.OperationTask;
import io.intino.sumus.graph.functions.OperationTaskSelection;
import io.intino.sumus.graph.functions.Resource;
import io.intino.tara.magritte.Layer;
import io.intino.tara.magritte.Node;
import io.intino.tara.magritte.loaders.BooleanLoader;
import io.intino.tara.magritte.loaders.FunctionLoader;
import io.intino.tara.magritte.loaders.InstantLoader;
import io.intino.tara.magritte.loaders.IntegerLoader;
import io.intino.tara.magritte.loaders.StringLoader;
import io.intino.tara.magritte.loaders.WordLoader;
import io.intino.tara.magritte.tags.Component;
import io.intino.tara.magritte.tags.Terminal;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class Toolbar
extends Layer
implements Component,
Terminal {
    protected boolean canSearch;
    protected List<Operation> operationList = new ArrayList<Operation>();
    protected List<Task> taskList = new ArrayList<Task>();
    protected List<TaskSelection> taskSelectionList = new ArrayList<TaskSelection>();
    protected List<Download> downloadList = new ArrayList<Download>();
    protected List<DownloadSelection> downloadSelectionList = new ArrayList<DownloadSelection>();
    protected List<Export> exportList = new ArrayList<Export>();
    protected List<ExportSelection> exportSelectionList = new ArrayList<ExportSelection>();
    protected List<OpenDialog> openDialogList = new ArrayList<OpenDialog>();
    protected List<GroupingSelection> groupingSelectionList = new ArrayList<GroupingSelection>();

    public Toolbar(Node node) {
        super(node);
    }

    public boolean canSearch() {
        return this.canSearch;
    }

    public Toolbar canSearch(boolean value) {
        this.canSearch = value;
        return this;
    }

    public List<Operation> operationList() {
        return Collections.unmodifiableList(this.operationList);
    }

    public Operation operation(int index) {
        return this.operationList.get(index);
    }

    public List<Operation> operationList(Predicate<Operation> predicate) {
        return this.operationList().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<Task> taskList() {
        return Collections.unmodifiableList(this.taskList);
    }

    public Task task(int index) {
        return this.taskList.get(index);
    }

    public List<Task> taskList(Predicate<Task> predicate) {
        return this.taskList().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<TaskSelection> taskSelectionList() {
        return Collections.unmodifiableList(this.taskSelectionList);
    }

    public TaskSelection taskSelection(int index) {
        return this.taskSelectionList.get(index);
    }

    public List<TaskSelection> taskSelectionList(Predicate<TaskSelection> predicate) {
        return this.taskSelectionList().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<Download> downloadList() {
        return Collections.unmodifiableList(this.downloadList);
    }

    public Download download(int index) {
        return this.downloadList.get(index);
    }

    public List<Download> downloadList(Predicate<Download> predicate) {
        return this.downloadList().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<DownloadSelection> downloadSelectionList() {
        return Collections.unmodifiableList(this.downloadSelectionList);
    }

    public DownloadSelection downloadSelection(int index) {
        return this.downloadSelectionList.get(index);
    }

    public List<DownloadSelection> downloadSelectionList(Predicate<DownloadSelection> predicate) {
        return this.downloadSelectionList().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<Export> exportList() {
        return Collections.unmodifiableList(this.exportList);
    }

    public Export export(int index) {
        return this.exportList.get(index);
    }

    public List<Export> exportList(Predicate<Export> predicate) {
        return this.exportList().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<ExportSelection> exportSelectionList() {
        return Collections.unmodifiableList(this.exportSelectionList);
    }

    public ExportSelection exportSelection(int index) {
        return this.exportSelectionList.get(index);
    }

    public List<ExportSelection> exportSelectionList(Predicate<ExportSelection> predicate) {
        return this.exportSelectionList().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<OpenDialog> openDialogList() {
        return Collections.unmodifiableList(this.openDialogList);
    }

    public OpenDialog openDialog(int index) {
        return this.openDialogList.get(index);
    }

    public List<OpenDialog> openDialogList(Predicate<OpenDialog> predicate) {
        return this.openDialogList().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<GroupingSelection> groupingSelectionList() {
        return Collections.unmodifiableList(this.groupingSelectionList);
    }

    public GroupingSelection groupingSelection(int index) {
        return this.groupingSelectionList.get(index);
    }

    public List<GroupingSelection> groupingSelectionList(Predicate<GroupingSelection> predicate) {
        return this.groupingSelectionList().stream().filter(predicate).collect(Collectors.toList());
    }

    protected List<Node> componentList$() {
        LinkedHashSet components = new LinkedHashSet(super.componentList$());
        new ArrayList<Operation>(this.operationList).forEach(c -> components.add(c.core$()));
        new ArrayList<Task>(this.taskList).forEach(c -> components.add(c.core$()));
        new ArrayList<TaskSelection>(this.taskSelectionList).forEach(c -> components.add(c.core$()));
        new ArrayList<Download>(this.downloadList).forEach(c -> components.add(c.core$()));
        new ArrayList<DownloadSelection>(this.downloadSelectionList).forEach(c -> components.add(c.core$()));
        new ArrayList<Export>(this.exportList).forEach(c -> components.add(c.core$()));
        new ArrayList<ExportSelection>(this.exportSelectionList).forEach(c -> components.add(c.core$()));
        new ArrayList<OpenDialog>(this.openDialogList).forEach(c -> components.add(c.core$()));
        new ArrayList<GroupingSelection>(this.groupingSelectionList).forEach(c -> components.add(c.core$()));
        return new ArrayList<Node>(components);
    }

    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap();
        map.put("canSearch", new ArrayList<Boolean>(Collections.singletonList(this.canSearch)));
        return map;
    }

    protected void addNode$(Node node) {
        super.addNode$(node);
        if (node.is("Toolbar$Operation")) {
            this.operationList.add((Operation)node.as(Operation.class));
        }
        if (node.is("Toolbar$Task")) {
            this.taskList.add((Task)node.as(Task.class));
        }
        if (node.is("Toolbar$TaskSelection")) {
            this.taskSelectionList.add((TaskSelection)node.as(TaskSelection.class));
        }
        if (node.is("Toolbar$Download")) {
            this.downloadList.add((Download)node.as(Download.class));
        }
        if (node.is("Toolbar$DownloadSelection")) {
            this.downloadSelectionList.add((DownloadSelection)node.as(DownloadSelection.class));
        }
        if (node.is("Toolbar$Export")) {
            this.exportList.add((Export)node.as(Export.class));
        }
        if (node.is("Toolbar$ExportSelection")) {
            this.exportSelectionList.add((ExportSelection)node.as(ExportSelection.class));
        }
        if (node.is("Toolbar$OpenDialog")) {
            this.openDialogList.add((OpenDialog)node.as(OpenDialog.class));
        }
        if (node.is("Toolbar$GroupingSelection")) {
            this.groupingSelectionList.add((GroupingSelection)node.as(GroupingSelection.class));
        }
    }

    protected void removeNode$(Node node) {
        super.removeNode$(node);
        if (node.is("Toolbar$Operation")) {
            this.operationList.remove(node.as(Operation.class));
        }
        if (node.is("Toolbar$Task")) {
            this.taskList.remove(node.as(Task.class));
        }
        if (node.is("Toolbar$TaskSelection")) {
            this.taskSelectionList.remove(node.as(TaskSelection.class));
        }
        if (node.is("Toolbar$Download")) {
            this.downloadList.remove(node.as(Download.class));
        }
        if (node.is("Toolbar$DownloadSelection")) {
            this.downloadSelectionList.remove(node.as(DownloadSelection.class));
        }
        if (node.is("Toolbar$Export")) {
            this.exportList.remove(node.as(Export.class));
        }
        if (node.is("Toolbar$ExportSelection")) {
            this.exportSelectionList.remove(node.as(ExportSelection.class));
        }
        if (node.is("Toolbar$OpenDialog")) {
            this.openDialogList.remove(node.as(OpenDialog.class));
        }
        if (node.is("Toolbar$GroupingSelection")) {
            this.groupingSelectionList.remove(node.as(GroupingSelection.class));
        }
    }

    protected void load$(String name, List<?> values) {
        super.load$(name, values);
        if (name.equalsIgnoreCase("canSearch")) {
            this.canSearch = (Boolean)BooleanLoader.load(values, (Layer)this).get(0);
        }
    }

    protected void set$(String name, List<?> values) {
        super.set$(name, values);
        if (name.equalsIgnoreCase("canSearch")) {
            this.canSearch = (Boolean)values.get(0);
        }
    }

    public Create create() {
        return new Create(null);
    }

    public Create create(String name) {
        return new Create(name);
    }

    public Clear clear() {
        return new Clear();
    }

    public SumusGraph graph() {
        return (SumusGraph)this.core$().graph().as(SumusGraph.class);
    }

    public static class GroupingSelection
    extends Operation
    implements Terminal {
        public GroupingSelection(Node node) {
            super(node);
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap(super.variables$());
            return map;
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
        }

        @Override
        public SumusGraph graph() {
            return (SumusGraph)this.core$().graph().as(SumusGraph.class);
        }
    }

    public static class OpenDialog
    extends Operation
    implements Terminal {
        protected int width;
        protected int height;
        protected String path;

        public OpenDialog(Node node) {
            super(node);
        }

        public int width() {
            return this.width;
        }

        public int height() {
            return this.height;
        }

        public String path() {
            return this.path;
        }

        public OpenDialog width(int value) {
            this.width = value;
            return this;
        }

        public OpenDialog height(int value) {
            this.height = value;
            return this;
        }

        public OpenDialog path(String value) {
            this.path = value;
            return this;
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap(super.variables$());
            map.put("width", new ArrayList<Integer>(Collections.singletonList(this.width)));
            map.put("height", new ArrayList<Integer>(Collections.singletonList(this.height)));
            map.put("path", new ArrayList<String>(Collections.singletonList(this.path)));
            return map;
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("width")) {
                this.width = (Integer)IntegerLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("height")) {
                this.height = (Integer)IntegerLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("path")) {
                this.path = (String)StringLoader.load(values, (Layer)this).get(0);
            }
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("width")) {
                this.width = (Integer)values.get(0);
            } else if (name.equalsIgnoreCase("height")) {
                this.height = (Integer)values.get(0);
            } else if (name.equalsIgnoreCase("path")) {
                this.path = (String)values.get(0);
            }
        }

        @Override
        public SumusGraph graph() {
            return (SumusGraph)this.core$().graph().as(SumusGraph.class);
        }
    }

    public static class ExportSelection
    extends Operation
    implements Terminal {
        protected Instant from;
        protected Instant to;
        protected OperationExportSelection execute;

        public ExportSelection(Node node) {
            super(node);
        }

        public Instant from() {
            return this.from;
        }

        public Instant to() {
            return this.to;
        }

        public Resource execute(Element element, Instant from, Instant to, List<Record> selection) {
            return this.execute.export(element, from, to, selection);
        }

        public ExportSelection from(Instant value) {
            this.from = value;
            return this;
        }

        public ExportSelection to(Instant value) {
            this.to = value;
            return this;
        }

        public ExportSelection execute(OperationExportSelection value) {
            this.execute = (OperationExportSelection)FunctionLoader.load((Object)this.execute, (Layer)this, OperationExportSelection.class);
            return this;
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap(super.variables$());
            map.put("from", new ArrayList<Instant>(Collections.singletonList(this.from)));
            map.put("to", new ArrayList<Instant>(Collections.singletonList(this.to)));
            map.put("execute", this.execute != null ? new ArrayList<OperationExportSelection>(Collections.singletonList(this.execute)) : Collections.emptyList());
            return map;
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("from")) {
                this.from = (Instant)InstantLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("to")) {
                this.to = (Instant)InstantLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("execute")) {
                this.execute = (OperationExportSelection)FunctionLoader.load(values, (Layer)this, OperationExportSelection.class).get(0);
            }
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("from")) {
                this.from = (Instant)values.get(0);
            } else if (name.equalsIgnoreCase("to")) {
                this.to = (Instant)values.get(0);
            } else if (name.equalsIgnoreCase("execute")) {
                this.execute = (OperationExportSelection)FunctionLoader.load(values.get(0), (Layer)this, OperationExportSelection.class);
            }
        }

        @Override
        public SumusGraph graph() {
            return (SumusGraph)this.core$().graph().as(SumusGraph.class);
        }
    }

    public static class Export
    extends Operation
    implements Terminal {
        protected Instant from;
        protected Instant to;
        protected OperationExport execute;

        public Export(Node node) {
            super(node);
        }

        public Instant from() {
            return this.from;
        }

        public Instant to() {
            return this.to;
        }

        public Resource execute(Element element, Instant from, Instant to) {
            return this.execute.export(element, from, to);
        }

        public Export from(Instant value) {
            this.from = value;
            return this;
        }

        public Export to(Instant value) {
            this.to = value;
            return this;
        }

        public Export execute(OperationExport value) {
            this.execute = (OperationExport)FunctionLoader.load((Object)this.execute, (Layer)this, OperationExport.class);
            return this;
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap(super.variables$());
            map.put("from", new ArrayList<Instant>(Collections.singletonList(this.from)));
            map.put("to", new ArrayList<Instant>(Collections.singletonList(this.to)));
            map.put("execute", this.execute != null ? new ArrayList<OperationExport>(Collections.singletonList(this.execute)) : Collections.emptyList());
            return map;
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("from")) {
                this.from = (Instant)InstantLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("to")) {
                this.to = (Instant)InstantLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("execute")) {
                this.execute = (OperationExport)FunctionLoader.load(values, (Layer)this, OperationExport.class).get(0);
            }
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("from")) {
                this.from = (Instant)values.get(0);
            } else if (name.equalsIgnoreCase("to")) {
                this.to = (Instant)values.get(0);
            } else if (name.equalsIgnoreCase("execute")) {
                this.execute = (OperationExport)FunctionLoader.load(values.get(0), (Layer)this, OperationExport.class);
            }
        }

        @Override
        public SumusGraph graph() {
            return (SumusGraph)this.core$().graph().as(SumusGraph.class);
        }
    }

    public static class DownloadSelection
    extends Operation
    implements Terminal {
        protected List<String> options = new ArrayList<String>();
        protected OperationDownloadSelection execute;

        public DownloadSelection(Node node) {
            super(node);
        }

        public List<String> options() {
            return this.options;
        }

        public String options(int index) {
            return this.options.get(index);
        }

        public List<String> options(Predicate<String> predicate) {
            return this.options().stream().filter(predicate).collect(Collectors.toList());
        }

        public Resource execute(Element element, String option, List<Record> selection) {
            return this.execute.download(element, option, selection);
        }

        public DownloadSelection execute(OperationDownloadSelection value) {
            this.execute = (OperationDownloadSelection)FunctionLoader.load((Object)this.execute, (Layer)this, OperationDownloadSelection.class);
            return this;
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap(super.variables$());
            map.put("options", this.options);
            map.put("execute", this.execute != null ? new ArrayList<OperationDownloadSelection>(Collections.singletonList(this.execute)) : Collections.emptyList());
            return map;
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("options")) {
                this.options = StringLoader.load(values, (Layer)this);
            } else if (name.equalsIgnoreCase("execute")) {
                this.execute = (OperationDownloadSelection)FunctionLoader.load(values, (Layer)this, OperationDownloadSelection.class).get(0);
            }
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("options")) {
                this.options = new ArrayList(values);
            } else if (name.equalsIgnoreCase("execute")) {
                this.execute = (OperationDownloadSelection)FunctionLoader.load(values.get(0), (Layer)this, OperationDownloadSelection.class);
            }
        }

        @Override
        public SumusGraph graph() {
            return (SumusGraph)this.core$().graph().as(SumusGraph.class);
        }
    }

    public static class Download
    extends Operation
    implements Terminal {
        protected List<String> options = new ArrayList<String>();
        protected OperationDownload execute;

        public Download(Node node) {
            super(node);
        }

        public List<String> options() {
            return this.options;
        }

        public String options(int index) {
            return this.options.get(index);
        }

        public List<String> options(Predicate<String> predicate) {
            return this.options().stream().filter(predicate).collect(Collectors.toList());
        }

        public Resource execute(Element element, String option) {
            return this.execute.download(element, option);
        }

        public Download execute(OperationDownload value) {
            this.execute = (OperationDownload)FunctionLoader.load((Object)this.execute, (Layer)this, OperationDownload.class);
            return this;
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap(super.variables$());
            map.put("options", this.options);
            map.put("execute", this.execute != null ? new ArrayList<OperationDownload>(Collections.singletonList(this.execute)) : Collections.emptyList());
            return map;
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("options")) {
                this.options = StringLoader.load(values, (Layer)this);
            } else if (name.equalsIgnoreCase("execute")) {
                this.execute = (OperationDownload)FunctionLoader.load(values, (Layer)this, OperationDownload.class).get(0);
            }
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("options")) {
                this.options = new ArrayList(values);
            } else if (name.equalsIgnoreCase("execute")) {
                this.execute = (OperationDownload)FunctionLoader.load(values.get(0), (Layer)this, OperationDownload.class);
            }
        }

        @Override
        public SumusGraph graph() {
            return (SumusGraph)this.core$().graph().as(SumusGraph.class);
        }
    }

    public static class TaskSelection
    extends Operation
    implements Terminal {
        protected Refresh refresh;
        protected OperationTaskSelection execute;

        public TaskSelection(Node node) {
            super(node);
        }

        public Refresh refresh() {
            return this.refresh;
        }

        public void execute(Element element, String option, List<Record> selection, String username) {
            this.execute.execute(element, option, selection, username);
        }

        public TaskSelection refresh(Refresh value) {
            this.refresh = value;
            return this;
        }

        public TaskSelection execute(OperationTaskSelection value) {
            this.execute = (OperationTaskSelection)FunctionLoader.load((Object)this.execute, (Layer)this, OperationTaskSelection.class);
            return this;
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap(super.variables$());
            map.put("refresh", new ArrayList<Refresh>(Collections.singletonList(this.refresh)));
            map.put("execute", this.execute != null ? new ArrayList<OperationTaskSelection>(Collections.singletonList(this.execute)) : Collections.emptyList());
            return map;
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("refresh")) {
                this.refresh = (Refresh)((Object)WordLoader.load(values, Refresh.class, (Layer)this).get(0));
            } else if (name.equalsIgnoreCase("execute")) {
                this.execute = (OperationTaskSelection)FunctionLoader.load(values, (Layer)this, OperationTaskSelection.class).get(0);
            }
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("refresh")) {
                this.refresh = (Refresh)((Object)values.get(0));
            } else if (name.equalsIgnoreCase("execute")) {
                this.execute = (OperationTaskSelection)FunctionLoader.load(values.get(0), (Layer)this, OperationTaskSelection.class);
            }
        }

        @Override
        public SumusGraph graph() {
            return (SumusGraph)this.core$().graph().as(SumusGraph.class);
        }

        public static enum Refresh {
            None,
            Catalog,
            Selection;

        }
    }

    public static class Task
    extends Operation
    implements Terminal {
        protected Refresh refresh;
        protected OperationTask execute;

        public Task(Node node) {
            super(node);
        }

        public Refresh refresh() {
            return this.refresh;
        }

        public void execute(Element element, String option, String username) {
            this.execute.execute(element, option, username);
        }

        public Task refresh(Refresh value) {
            this.refresh = value;
            return this;
        }

        public Task execute(OperationTask value) {
            this.execute = (OperationTask)FunctionLoader.load((Object)this.execute, (Layer)this, OperationTask.class);
            return this;
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap(super.variables$());
            map.put("refresh", new ArrayList<Refresh>(Collections.singletonList(this.refresh)));
            map.put("execute", this.execute != null ? new ArrayList<OperationTask>(Collections.singletonList(this.execute)) : Collections.emptyList());
            return map;
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("refresh")) {
                this.refresh = (Refresh)((Object)WordLoader.load(values, Refresh.class, (Layer)this).get(0));
            } else if (name.equalsIgnoreCase("execute")) {
                this.execute = (OperationTask)FunctionLoader.load(values, (Layer)this, OperationTask.class).get(0);
            }
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("refresh")) {
                this.refresh = (Refresh)((Object)values.get(0));
            } else if (name.equalsIgnoreCase("execute")) {
                this.execute = (OperationTask)FunctionLoader.load(values.get(0), (Layer)this, OperationTask.class);
            }
        }

        @Override
        public SumusGraph graph() {
            return (SumusGraph)this.core$().graph().as(SumusGraph.class);
        }

        public static enum Refresh {
            None,
            Catalog;

        }
    }

    public static abstract class Operation
    extends Layer
    implements Terminal {
        protected String title;
        protected String sumusIcon;

        public Operation(Node node) {
            super(node);
        }

        public String title() {
            return this.title;
        }

        public String sumusIcon() {
            return this.sumusIcon;
        }

        public Operation title(String value) {
            this.title = value;
            return this;
        }

        public Operation sumusIcon(String value) {
            this.sumusIcon = value;
            return this;
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("title", new ArrayList<String>(Collections.singletonList(this.title)));
            map.put("sumusIcon", new ArrayList<String>(Collections.singletonList(this.sumusIcon)));
            return map;
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("title")) {
                this.title = (String)StringLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("sumusIcon")) {
                this.sumusIcon = (String)StringLoader.load(values, (Layer)this).get(0);
            }
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("title")) {
                this.title = (String)values.get(0);
            } else if (name.equalsIgnoreCase("sumusIcon")) {
                this.sumusIcon = (String)values.get(0);
            }
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public SumusGraph graph() {
            return (SumusGraph)this.core$().graph().as(SumusGraph.class);
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }
        }
    }

    public class Clear {
        public void task(Predicate<Task> filter) {
            new ArrayList<Task>(Toolbar.this.taskList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void taskSelection(Predicate<TaskSelection> filter) {
            new ArrayList<TaskSelection>(Toolbar.this.taskSelectionList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void download(Predicate<Download> filter) {
            new ArrayList<Download>(Toolbar.this.downloadList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void downloadSelection(Predicate<DownloadSelection> filter) {
            new ArrayList<DownloadSelection>(Toolbar.this.downloadSelectionList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void export(Predicate<Export> filter) {
            new ArrayList<Export>(Toolbar.this.exportList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void exportSelection(Predicate<ExportSelection> filter) {
            new ArrayList<ExportSelection>(Toolbar.this.exportSelectionList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void openDialog(Predicate<OpenDialog> filter) {
            new ArrayList<OpenDialog>(Toolbar.this.openDialogList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void groupingSelection(Predicate<GroupingSelection> filter) {
            new ArrayList<GroupingSelection>(Toolbar.this.groupingSelectionList()).stream().filter(filter).forEach(Layer::delete$);
        }
    }

    public class Create {
        protected final String name;

        public Create(String name) {
            this.name = name;
        }

        public Task task(String title, String sumusIcon, OperationTask execute) {
            Task newElement = (Task)Toolbar.this.core$().graph().concept(Task.class).createNode(this.name, Toolbar.this.core$()).as(Task.class);
            newElement.core$().set((Layer)newElement, "title", Collections.singletonList(title));
            newElement.core$().set((Layer)newElement, "sumusIcon", Collections.singletonList(sumusIcon));
            newElement.core$().set((Layer)newElement, "execute", Collections.singletonList(execute));
            return newElement;
        }

        public TaskSelection taskSelection(String title, String sumusIcon, OperationTaskSelection execute) {
            TaskSelection newElement = (TaskSelection)Toolbar.this.core$().graph().concept(TaskSelection.class).createNode(this.name, Toolbar.this.core$()).as(TaskSelection.class);
            newElement.core$().set((Layer)newElement, "title", Collections.singletonList(title));
            newElement.core$().set((Layer)newElement, "sumusIcon", Collections.singletonList(sumusIcon));
            newElement.core$().set((Layer)newElement, "execute", Collections.singletonList(execute));
            return newElement;
        }

        public Download download(String title, OperationDownload execute) {
            Download newElement = (Download)Toolbar.this.core$().graph().concept(Download.class).createNode(this.name, Toolbar.this.core$()).as(Download.class);
            newElement.core$().set((Layer)newElement, "title", Collections.singletonList(title));
            newElement.core$().set((Layer)newElement, "execute", Collections.singletonList(execute));
            return newElement;
        }

        public DownloadSelection downloadSelection(String title, OperationDownloadSelection execute) {
            DownloadSelection newElement = (DownloadSelection)Toolbar.this.core$().graph().concept(DownloadSelection.class).createNode(this.name, Toolbar.this.core$()).as(DownloadSelection.class);
            newElement.core$().set((Layer)newElement, "title", Collections.singletonList(title));
            newElement.core$().set((Layer)newElement, "execute", Collections.singletonList(execute));
            return newElement;
        }

        public Export export(String title, OperationExport execute) {
            Export newElement = (Export)Toolbar.this.core$().graph().concept(Export.class).createNode(this.name, Toolbar.this.core$()).as(Export.class);
            newElement.core$().set((Layer)newElement, "title", Collections.singletonList(title));
            newElement.core$().set((Layer)newElement, "execute", Collections.singletonList(execute));
            return newElement;
        }

        public ExportSelection exportSelection(String title, OperationExportSelection execute) {
            ExportSelection newElement = (ExportSelection)Toolbar.this.core$().graph().concept(ExportSelection.class).createNode(this.name, Toolbar.this.core$()).as(ExportSelection.class);
            newElement.core$().set((Layer)newElement, "title", Collections.singletonList(title));
            newElement.core$().set((Layer)newElement, "execute", Collections.singletonList(execute));
            return newElement;
        }

        public OpenDialog openDialog(String title, String sumusIcon, String path) {
            OpenDialog newElement = (OpenDialog)Toolbar.this.core$().graph().concept(OpenDialog.class).createNode(this.name, Toolbar.this.core$()).as(OpenDialog.class);
            newElement.core$().set((Layer)newElement, "title", Collections.singletonList(title));
            newElement.core$().set((Layer)newElement, "sumusIcon", Collections.singletonList(sumusIcon));
            newElement.core$().set((Layer)newElement, "path", Collections.singletonList(path));
            return newElement;
        }

        public GroupingSelection groupingSelection(String title) {
            GroupingSelection newElement = (GroupingSelection)Toolbar.this.core$().graph().concept(GroupingSelection.class).createNode(this.name, Toolbar.this.core$()).as(GroupingSelection.class);
            newElement.core$().set((Layer)newElement, "title", Collections.singletonList(title));
            return newElement;
        }
    }
}

