/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.graph;

import io.intino.sumus.graph.AbstractMetric;
import io.intino.sumus.graph.SumusGraph;
import io.intino.tara.magritte.Layer;
import io.intino.tara.magritte.Node;
import io.intino.tara.magritte.loaders.DoubleLoader;
import io.intino.tara.magritte.tags.Terminal;
import io.intino.tara.magritte.utils.ProxyList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class TemporalMetric
extends AbstractMetric
implements Terminal {
    public TemporalMetric(Node node) {
        super(node);
    }

    public List<Unit> temporalMetricUnitList() {
        return new ProxyList(this.unitList, Unit.class);
    }

    public Unit temporalMetricUnit(int index) {
        return this.temporalMetricUnitList().get(index);
    }

    public List<Unit> temporalMetricUnitList(Predicate<Unit> predicate) {
        return this.temporalMetricUnitList().stream().filter(predicate).collect(Collectors.toList());
    }

    @Override
    protected List<Node> componentList$() {
        LinkedHashSet<Node> components = new LinkedHashSet<Node>(super.componentList$());
        return new ArrayList<Node>(components);
    }

    @Override
    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap(super.variables$());
        return map;
    }

    @Override
    protected void addNode$(Node node) {
        super.addNode$(node);
    }

    @Override
    protected void removeNode$(Node node) {
        super.removeNode$(node);
    }

    @Override
    protected void load$(String name, List<?> values) {
        super.load$(name, values);
    }

    @Override
    protected void set$(String name, List<?> values) {
        super.set$(name, values);
    }

    @Override
    public Create create() {
        return new Create(null);
    }

    @Override
    public Create create(String name) {
        return new Create(name);
    }

    @Override
    public Clear clear() {
        return new Clear();
    }

    @Override
    public SumusGraph graph() {
        return (SumusGraph)this.core$().graph().as(SumusGraph.class);
    }

    public static class Unit
    extends AbstractMetric.Unit
    implements Terminal {
        protected double limit;
        protected double conversionFactor;

        public Unit(Node node) {
            super(node);
        }

        public double limit() {
            return this.limit;
        }

        public double conversionFactor() {
            return this.conversionFactor;
        }

        public Unit limit(double value) {
            this.limit = value;
            return this;
        }

        public Unit conversionFactor(double value) {
            this.conversionFactor = value;
            return this;
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap(super.variables$());
            map.put("limit", new ArrayList<Double>(Collections.singletonList(this.limit)));
            map.put("conversionFactor", new ArrayList<Double>(Collections.singletonList(this.conversionFactor)));
            return map;
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("limit")) {
                this.limit = (Double)DoubleLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("conversionFactor")) {
                this.conversionFactor = (Double)DoubleLoader.load(values, (Layer)this).get(0);
            }
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("limit")) {
                this.limit = (Double)values.get(0);
            } else if (name.equalsIgnoreCase("conversionFactor")) {
                this.conversionFactor = (Double)values.get(0);
            }
        }

        @Override
        public SumusGraph graph() {
            return (SumusGraph)this.core$().graph().as(SumusGraph.class);
        }
    }

    public class Clear
    extends AbstractMetric.Clear {
    }

    public class Create
    extends AbstractMetric.Create {
        public Create(String name) {
            super(name);
        }

        @Override
        public Unit unit(double limit, double conversionFactor) {
            Unit newElement = (Unit)TemporalMetric.this.core$().graph().concept(Unit.class).createNode(this.name, TemporalMetric.this.core$()).as(Unit.class);
            newElement.core$().set((Layer)newElement, "limit", Collections.singletonList(limit));
            newElement.core$().set((Layer)newElement, "conversionFactor", Collections.singletonList(conversionFactor));
            return newElement;
        }
    }
}

