/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.graph;

import io.intino.sumus.graph.AbstractView;
import io.intino.sumus.graph.Catalog;
import io.intino.sumus.graph.Element;
import io.intino.sumus.graph.ElementRender;
import io.intino.sumus.graph.Mold;
import io.intino.sumus.graph.Olap;
import io.intino.sumus.graph.RenderCatalog;
import io.intino.sumus.graph.RenderCatalogs;
import io.intino.sumus.graph.RenderMold;
import io.intino.sumus.graph.RenderOlap;
import io.intino.sumus.graph.RenderPanel;
import io.intino.sumus.graph.RenderPanels;
import io.intino.sumus.graph.RenderRecord;
import io.intino.sumus.graph.RenderRecords;
import io.intino.sumus.graph.SumusGraph;
import io.intino.sumus.graph.Toolbar;
import io.intino.sumus.graph.functions.PanelSource;
import io.intino.sumus.graph.functions.RecordSource;
import io.intino.tara.magritte.Layer;
import io.intino.tara.magritte.Node;
import io.intino.tara.magritte.loaders.IntegerLoader;
import io.intino.tara.magritte.loaders.StringLoader;
import io.intino.tara.magritte.tags.Terminal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class Panel
extends Element
implements Terminal {
    protected Toolbar toolbar;
    protected View view;
    protected Views views;

    public Panel(Node node) {
        super(node);
    }

    public Toolbar toolbar() {
        return this.toolbar;
    }

    public View view() {
        return this.view;
    }

    public Views views() {
        return this.views;
    }

    public Panel toolbar(Toolbar value) {
        this.toolbar = value;
        return this;
    }

    public Panel view(View value) {
        this.view = value;
        return this;
    }

    public Panel views(Views value) {
        this.views = value;
        return this;
    }

    protected List<Node> componentList$() {
        LinkedHashSet<Node> components = new LinkedHashSet<Node>(super.componentList$());
        if (this.toolbar != null) {
            components.add(this.toolbar.core$());
        }
        if (this.view != null) {
            components.add(this.view.core$());
        }
        if (this.views != null) {
            components.add(this.views.core$());
        }
        return new ArrayList<Node>(components);
    }

    @Override
    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap(super.variables$());
        return map;
    }

    protected void addNode$(Node node) {
        super.addNode$(node);
        if (node.is("Toolbar")) {
            this.toolbar = (Toolbar)node.as(Toolbar.class);
        }
        if (node.is("Panel$View")) {
            this.view = (View)node.as(View.class);
        }
        if (node.is("Panel$Views")) {
            this.views = (Views)node.as(Views.class);
        }
    }

    protected void removeNode$(Node node) {
        super.removeNode$(node);
        if (node.is("Toolbar")) {
            this.toolbar = null;
        }
        if (node.is("Panel$View")) {
            this.view = null;
        }
        if (node.is("Panel$Views")) {
            this.views = null;
        }
    }

    @Override
    protected void load$(String name, List<?> values) {
        super.load$(name, values);
    }

    @Override
    protected void set$(String name, List<?> values) {
        super.set$(name, values);
    }

    @Override
    public Create create() {
        return new Create(null);
    }

    @Override
    public Create create(String name) {
        return new Create(name);
    }

    public Clear clear() {
        return new Clear();
    }

    @Override
    public SumusGraph graph() {
        return (SumusGraph)this.core$().graph().as(SumusGraph.class);
    }

    public static class Views
    extends Layer
    implements Terminal {
        protected List<View> viewList = new ArrayList<View>();

        public Views(Node node) {
            super(node);
        }

        public List<View> viewList() {
            return Collections.unmodifiableList(this.viewList);
        }

        public View view(int index) {
            return this.viewList.get(index);
        }

        public List<View> viewList(Predicate<View> predicate) {
            return this.viewList().stream().filter(predicate).collect(Collectors.toList());
        }

        protected List<Node> componentList$() {
            LinkedHashSet components = new LinkedHashSet(super.componentList$());
            new ArrayList<View>(this.viewList).forEach(c -> components.add(c.core$()));
            return new ArrayList<Node>(components);
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            return map;
        }

        protected void addNode$(Node node) {
            super.addNode$(node);
            if (node.is("Panel$View")) {
                this.viewList.add((View)node.as(View.class));
            }
        }

        protected void removeNode$(Node node) {
            super.removeNode$(node);
            if (node.is("Panel$View")) {
                this.viewList.remove(node.as(View.class));
            }
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public Clear clear() {
            return new Clear();
        }

        public SumusGraph graph() {
            return (SumusGraph)this.core$().graph().as(SumusGraph.class);
        }

        public class Clear {
            public void view(Predicate<View> filter) {
                new ArrayList<View>(Views.this.viewList()).stream().filter(filter).forEach(Layer::delete$);
            }
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }

            public View view() {
                View newElement = (View)Views.this.core$().graph().concept(View.class).createNode(this.name, Views.this.core$()).as(View.class);
                return newElement;
            }
        }
    }

    public static class View
    extends AbstractView
    implements Terminal {
        protected String icon;
        protected int bubble;
        protected ElementRender elementRender;

        public View(Node node) {
            super(node);
        }

        public String icon() {
            return this.icon;
        }

        public int bubble() {
            return this.bubble;
        }

        public View icon(String value) {
            this.icon = value;
            return this;
        }

        public View bubble(int value) {
            this.bubble = value;
            return this;
        }

        public ElementRender elementRender() {
            return this.elementRender;
        }

        public View elementRender(ElementRender value) {
            this.elementRender = value;
            return this;
        }

        protected List<Node> componentList$() {
            LinkedHashSet<Node> components = new LinkedHashSet<Node>(super.componentList$());
            if (this.elementRender != null) {
                components.add(this.elementRender.core$());
            }
            return new ArrayList<Node>(components);
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap(super.variables$());
            map.put("icon", new ArrayList<String>(Collections.singletonList(this.icon)));
            map.put("bubble", new ArrayList<Integer>(Collections.singletonList(this.bubble)));
            return map;
        }

        protected void addNode$(Node node) {
            super.addNode$(node);
            if (node.is("ElementRender")) {
                this.elementRender = (ElementRender)node.as(ElementRender.class);
            }
        }

        protected void removeNode$(Node node) {
            super.removeNode$(node);
            if (node.is("ElementRender")) {
                this.elementRender = null;
            }
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("icon")) {
                this.icon = (String)StringLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("bubble")) {
                this.bubble = (Integer)IntegerLoader.load(values, (Layer)this).get(0);
            }
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("icon")) {
                this.icon = (String)values.get(0);
            } else if (name.equalsIgnoreCase("bubble")) {
                this.bubble = (Integer)values.get(0);
            }
        }

        @Override
        public Create create() {
            return new Create(null);
        }

        @Override
        public Create create(String name) {
            return new Create(name);
        }

        public Clear clear() {
            return new Clear();
        }

        @Override
        public SumusGraph graph() {
            return (SumusGraph)this.core$().graph().as(SumusGraph.class);
        }

        public class Clear {
        }

        public class Create
        extends AbstractView.Create {
            public Create(String name) {
                super(View.this, name);
            }

            public RenderRecord renderRecord(Panel container) {
                RenderRecord newElement = (RenderRecord)View.this.core$().graph().concept(RenderRecord.class).createNode(this.name, View.this.core$()).as(RenderRecord.class);
                newElement.core$().set((Layer)newElement, "container", Collections.singletonList(container));
                return newElement;
            }

            public RenderMold renderMold(Mold mold) {
                RenderMold newElement = (RenderMold)View.this.core$().graph().concept(RenderMold.class).createNode(this.name, View.this.core$()).as(RenderMold.class);
                newElement.core$().set((Layer)newElement, "mold", Collections.singletonList(mold));
                return newElement;
            }

            public RenderCatalog renderCatalog(Catalog catalog) {
                RenderCatalog newElement = (RenderCatalog)View.this.core$().graph().concept(RenderCatalog.class).createNode(this.name, View.this.core$()).as(RenderCatalog.class);
                newElement.core$().set((Layer)newElement, "catalog", Collections.singletonList(catalog));
                return newElement;
            }

            public RenderRecords renderRecords(RecordSource source, Panel panel) {
                RenderRecords newElement = (RenderRecords)View.this.core$().graph().concept(RenderRecords.class).createNode(this.name, View.this.core$()).as(RenderRecords.class);
                newElement.core$().set((Layer)newElement, "source", Collections.singletonList(source));
                newElement.core$().set((Layer)newElement, "panel", Collections.singletonList(panel));
                return newElement;
            }

            public RenderOlap renderOlap(Olap olap) {
                RenderOlap newElement = (RenderOlap)View.this.core$().graph().concept(RenderOlap.class).createNode(this.name, View.this.core$()).as(RenderOlap.class);
                newElement.core$().set((Layer)newElement, "olap", Collections.singletonList(olap));
                return newElement;
            }

            public RenderPanels renderPanels(PanelSource source) {
                RenderPanels newElement = (RenderPanels)View.this.core$().graph().concept(RenderPanels.class).createNode(this.name, View.this.core$()).as(RenderPanels.class);
                newElement.core$().set((Layer)newElement, "source", Collections.singletonList(source));
                return newElement;
            }

            public RenderCatalogs renderCatalogs() {
                RenderCatalogs newElement = (RenderCatalogs)View.this.core$().graph().concept(RenderCatalogs.class).createNode(this.name, View.this.core$()).as(RenderCatalogs.class);
                return newElement;
            }

            public RenderPanel renderPanel(Panel panel) {
                RenderPanel newElement = (RenderPanel)View.this.core$().graph().concept(RenderPanel.class).createNode(this.name, View.this.core$()).as(RenderPanel.class);
                newElement.core$().set((Layer)newElement, "panel", Collections.singletonList(panel));
                return newElement;
            }
        }
    }

    public class Clear {
    }

    public class Create
    extends Element.Create {
        public Create(String name) {
            super(Panel.this, name);
        }

        public Toolbar toolbar() {
            Toolbar newElement = (Toolbar)Panel.this.core$().graph().concept(Toolbar.class).createNode(this.name, Panel.this.core$()).as(Toolbar.class);
            return newElement;
        }

        public View view() {
            View newElement = (View)Panel.this.core$().graph().concept(View.class).createNode(this.name, Panel.this.core$()).as(View.class);
            return newElement;
        }

        public Views views() {
            Views newElement = (Views)Panel.this.core$().graph().concept(Views.class).createNode(this.name, Panel.this.core$()).as(Views.class);
            return newElement;
        }
    }
}

