/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.graph;

import io.intino.sumus.graph.Catalog;
import io.intino.sumus.graph.Element;
import io.intino.sumus.graph.ElementOption;
import io.intino.sumus.graph.ElementRender;
import io.intino.sumus.graph.Mold;
import io.intino.sumus.graph.Olap;
import io.intino.sumus.graph.Panel;
import io.intino.sumus.graph.Record;
import io.intino.sumus.graph.RenderCatalog;
import io.intino.sumus.graph.RenderCatalogs;
import io.intino.sumus.graph.RenderMold;
import io.intino.sumus.graph.RenderOlap;
import io.intino.sumus.graph.RenderPanel;
import io.intino.sumus.graph.RenderPanels;
import io.intino.sumus.graph.RenderRecord;
import io.intino.sumus.graph.RenderRecords;
import io.intino.sumus.graph.SumusGraph;
import io.intino.sumus.graph.functions.OptionsBubble;
import io.intino.sumus.graph.functions.OptionsIcon;
import io.intino.sumus.graph.functions.OptionsLabel;
import io.intino.sumus.graph.functions.PanelSource;
import io.intino.sumus.graph.functions.RecordSource;
import io.intino.tara.magritte.Layer;
import io.intino.tara.magritte.Node;
import io.intino.tara.magritte.loaders.FunctionLoader;
import io.intino.tara.magritte.tags.Terminal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class Options
extends ElementOption
implements Terminal {
    protected OptionsLabel label;
    protected OptionsIcon icon;
    protected OptionsBubble bubble;
    protected ElementRender elementRender;
    protected List<Source> sourceList = new ArrayList<Source>();
    protected List<Catalogs> catalogsList = new ArrayList<Catalogs>();
    protected List<Records> recordsList = new ArrayList<Records>();

    public Options(Node node) {
        super(node);
    }

    public String label(Element element, Record record) {
        return this.label.label(element, record);
    }

    public String icon(Element element, Record record) {
        return this.icon.icon(element, record);
    }

    public int bubble(Element element, Record record) {
        return this.bubble.bubble(element, record);
    }

    public Options label(OptionsLabel value) {
        this.label = (OptionsLabel)FunctionLoader.load((Object)this.label, (Layer)this, OptionsLabel.class);
        return this;
    }

    public Options icon(OptionsIcon value) {
        this.icon = (OptionsIcon)FunctionLoader.load((Object)this.icon, (Layer)this, OptionsIcon.class);
        return this;
    }

    public Options bubble(OptionsBubble value) {
        this.bubble = (OptionsBubble)FunctionLoader.load((Object)this.bubble, (Layer)this, OptionsBubble.class);
        return this;
    }

    public ElementRender elementRender() {
        return this.elementRender;
    }

    public List<Source> sourceList() {
        return Collections.unmodifiableList(this.sourceList);
    }

    public Source source(int index) {
        return this.sourceList.get(index);
    }

    public List<Source> sourceList(Predicate<Source> predicate) {
        return this.sourceList().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<Catalogs> catalogsList() {
        return Collections.unmodifiableList(this.catalogsList);
    }

    public Catalogs catalogs(int index) {
        return this.catalogsList.get(index);
    }

    public List<Catalogs> catalogsList(Predicate<Catalogs> predicate) {
        return this.catalogsList().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<Records> recordsList() {
        return Collections.unmodifiableList(this.recordsList);
    }

    public Records records(int index) {
        return this.recordsList.get(index);
    }

    public List<Records> recordsList(Predicate<Records> predicate) {
        return this.recordsList().stream().filter(predicate).collect(Collectors.toList());
    }

    public Options elementRender(ElementRender value) {
        this.elementRender = value;
        return this;
    }

    protected List<Node> componentList$() {
        LinkedHashSet<Node> components = new LinkedHashSet<Node>(super.componentList$());
        if (this.elementRender != null) {
            components.add(this.elementRender.core$());
        }
        new ArrayList<Source>(this.sourceList).forEach(c -> components.add(c.core$()));
        new ArrayList<Catalogs>(this.catalogsList).forEach(c -> components.add(c.core$()));
        new ArrayList<Records>(this.recordsList).forEach(c -> components.add(c.core$()));
        return new ArrayList<Node>(components);
    }

    @Override
    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap(super.variables$());
        map.put("label", this.label != null ? new ArrayList<OptionsLabel>(Collections.singletonList(this.label)) : Collections.emptyList());
        map.put("icon", this.icon != null ? new ArrayList<OptionsIcon>(Collections.singletonList(this.icon)) : Collections.emptyList());
        map.put("bubble", this.bubble != null ? new ArrayList<OptionsBubble>(Collections.singletonList(this.bubble)) : Collections.emptyList());
        return map;
    }

    protected void addNode$(Node node) {
        super.addNode$(node);
        if (node.is("ElementRender")) {
            this.elementRender = (ElementRender)node.as(ElementRender.class);
        }
        if (node.is("Options$Source")) {
            this.sourceList.add((Source)node.as(Source.class));
        }
        if (node.is("Options$Catalogs")) {
            this.catalogsList.add((Catalogs)node.as(Catalogs.class));
        }
        if (node.is("Options$Records")) {
            this.recordsList.add((Records)node.as(Records.class));
        }
    }

    protected void removeNode$(Node node) {
        super.removeNode$(node);
        if (node.is("ElementRender")) {
            this.elementRender = null;
        }
        if (node.is("Options$Source")) {
            this.sourceList.remove(node.as(Source.class));
        }
        if (node.is("Options$Catalogs")) {
            this.catalogsList.remove(node.as(Catalogs.class));
        }
        if (node.is("Options$Records")) {
            this.recordsList.remove(node.as(Records.class));
        }
    }

    @Override
    protected void load$(String name, List<?> values) {
        super.load$(name, values);
        if (name.equalsIgnoreCase("label")) {
            this.label = (OptionsLabel)FunctionLoader.load(values, (Layer)this, OptionsLabel.class).get(0);
        } else if (name.equalsIgnoreCase("icon")) {
            this.icon = (OptionsIcon)FunctionLoader.load(values, (Layer)this, OptionsIcon.class).get(0);
        } else if (name.equalsIgnoreCase("bubble")) {
            this.bubble = (OptionsBubble)FunctionLoader.load(values, (Layer)this, OptionsBubble.class).get(0);
        }
    }

    @Override
    protected void set$(String name, List<?> values) {
        super.set$(name, values);
        if (name.equalsIgnoreCase("label")) {
            this.label = (OptionsLabel)FunctionLoader.load(values.get(0), (Layer)this, OptionsLabel.class);
        } else if (name.equalsIgnoreCase("icon")) {
            this.icon = (OptionsIcon)FunctionLoader.load(values.get(0), (Layer)this, OptionsIcon.class);
        } else if (name.equalsIgnoreCase("bubble")) {
            this.bubble = (OptionsBubble)FunctionLoader.load(values.get(0), (Layer)this, OptionsBubble.class);
        }
    }

    @Override
    public Create create() {
        return new Create(null);
    }

    @Override
    public Create create(String name) {
        return new Create(name);
    }

    public Clear clear() {
        return new Clear();
    }

    @Override
    public SumusGraph graph() {
        return (SumusGraph)this.core$().graph().as(SumusGraph.class);
    }

    public static class Records
    extends Source
    implements Terminal {
        public Records(Node node) {
            super(node);
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap(super.variables$());
            return map;
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
        }

        @Override
        public SumusGraph graph() {
            return (SumusGraph)this.core$().graph().as(SumusGraph.class);
        }
    }

    public static class Catalogs
    extends Source
    implements Terminal {
        public Catalogs(Node node) {
            super(node);
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap(super.variables$());
            return map;
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
        }

        @Override
        public SumusGraph graph() {
            return (SumusGraph)this.core$().graph().as(SumusGraph.class);
        }
    }

    public static abstract class Source
    extends Layer
    implements Terminal {
        public Source(Node node) {
            super(node);
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            return map;
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public SumusGraph graph() {
            return (SumusGraph)this.core$().graph().as(SumusGraph.class);
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }
        }
    }

    public class Clear {
        public void catalogs(Predicate<Catalogs> filter) {
            new ArrayList<Catalogs>(Options.this.catalogsList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void records(Predicate<Records> filter) {
            new ArrayList<Records>(Options.this.recordsList()).stream().filter(filter).forEach(Layer::delete$);
        }
    }

    public class Create
    extends ElementOption.Create {
        public Create(String name) {
            super(Options.this, name);
        }

        public Catalogs catalogs() {
            Catalogs newElement = (Catalogs)Options.this.core$().graph().concept(Catalogs.class).createNode(this.name, Options.this.core$()).as(Catalogs.class);
            return newElement;
        }

        public Records records() {
            Records newElement = (Records)Options.this.core$().graph().concept(Records.class).createNode(this.name, Options.this.core$()).as(Records.class);
            return newElement;
        }

        public RenderRecord renderRecord(Panel container) {
            RenderRecord newElement = (RenderRecord)Options.this.core$().graph().concept(RenderRecord.class).createNode(this.name, Options.this.core$()).as(RenderRecord.class);
            newElement.core$().set((Layer)newElement, "container", Collections.singletonList(container));
            return newElement;
        }

        public RenderMold renderMold(Mold mold) {
            RenderMold newElement = (RenderMold)Options.this.core$().graph().concept(RenderMold.class).createNode(this.name, Options.this.core$()).as(RenderMold.class);
            newElement.core$().set((Layer)newElement, "mold", Collections.singletonList(mold));
            return newElement;
        }

        public RenderCatalog renderCatalog(Catalog catalog) {
            RenderCatalog newElement = (RenderCatalog)Options.this.core$().graph().concept(RenderCatalog.class).createNode(this.name, Options.this.core$()).as(RenderCatalog.class);
            newElement.core$().set((Layer)newElement, "catalog", Collections.singletonList(catalog));
            return newElement;
        }

        public RenderRecords renderRecords(RecordSource source, Panel panel) {
            RenderRecords newElement = (RenderRecords)Options.this.core$().graph().concept(RenderRecords.class).createNode(this.name, Options.this.core$()).as(RenderRecords.class);
            newElement.core$().set((Layer)newElement, "source", Collections.singletonList(source));
            newElement.core$().set((Layer)newElement, "panel", Collections.singletonList(panel));
            return newElement;
        }

        public RenderOlap renderOlap(Olap olap) {
            RenderOlap newElement = (RenderOlap)Options.this.core$().graph().concept(RenderOlap.class).createNode(this.name, Options.this.core$()).as(RenderOlap.class);
            newElement.core$().set((Layer)newElement, "olap", Collections.singletonList(olap));
            return newElement;
        }

        public RenderPanels renderPanels(PanelSource source) {
            RenderPanels newElement = (RenderPanels)Options.this.core$().graph().concept(RenderPanels.class).createNode(this.name, Options.this.core$()).as(RenderPanels.class);
            newElement.core$().set((Layer)newElement, "source", Collections.singletonList(source));
            return newElement;
        }

        public RenderCatalogs renderCatalogs() {
            RenderCatalogs newElement = (RenderCatalogs)Options.this.core$().graph().concept(RenderCatalogs.class).createNode(this.name, Options.this.core$()).as(RenderCatalogs.class);
            return newElement;
        }

        public RenderPanel renderPanel(Panel panel) {
            RenderPanel newElement = (RenderPanel)Options.this.core$().graph().concept(RenderPanel.class).createNode(this.name, Options.this.core$()).as(RenderPanel.class);
            newElement.core$().set((Layer)newElement, "panel", Collections.singletonList(panel));
            return newElement;
        }
    }
}

