/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.graph;

import io.intino.sumus.graph.Catalog;
import io.intino.sumus.graph.Element;
import io.intino.sumus.graph.NameSpace;
import io.intino.sumus.graph.OnClickInstant;
import io.intino.sumus.graph.SumusGraph;
import io.intino.sumus.graph.Ticket;
import io.intino.sumus.graph.functions.Command;
import io.intino.sumus.graph.functions.InstantLoader;
import io.intino.sumus.graph.functions.NameSpacesLoader;
import io.intino.sumus.graph.functions.RefreshListener;
import io.intino.sumus.graph.rules.Chart;
import io.intino.sumus.graph.rules.Mode;
import io.intino.sumus.graph.rules.TimeScale;
import io.intino.tara.magritte.Expression;
import io.intino.tara.magritte.Layer;
import io.intino.tara.magritte.Node;
import io.intino.tara.magritte.loaders.FunctionLoader;
import io.intino.tara.magritte.loaders.IntegerLoader;
import io.intino.tara.magritte.loaders.NodeLoader;
import io.intino.tara.magritte.loaders.ObjectLoader;
import io.intino.tara.magritte.loaders.StringLoader;
import io.intino.tara.magritte.loaders.WordLoader;
import io.intino.tara.magritte.tags.Terminal;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class Olap
extends Element
implements Terminal {
    protected NameSpacesLoader nameSpaces;
    protected List<Ticket> tickets = new ArrayList<Ticket>();
    protected List listeners;
    protected RefreshListener onRefresh;
    protected Command refresh;
    protected List<Chart> charts = new ArrayList<Chart>();
    protected Events events;
    protected Range range;
    protected InstantFormatter instantFormatter;
    protected Select select;
    protected ZoomGroup zoomGroup;

    public Olap(Node node) {
        super(node);
    }

    public List<NameSpace> nameSpaces(String username) {
        return this.nameSpaces.nameSpaces(username);
    }

    public List<Ticket> tickets() {
        return this.tickets;
    }

    public Ticket tickets(int index) {
        return this.tickets.get(index);
    }

    public List<Ticket> tickets(Predicate<Ticket> predicate) {
        return this.tickets().stream().filter(predicate).collect(Collectors.toList());
    }

    public List listeners() {
        return this.listeners;
    }

    public void onRefresh(Command command) {
        this.onRefresh.onRefresh(command);
    }

    public void refresh() {
        this.refresh.execute();
    }

    public List<Chart> charts() {
        return this.charts;
    }

    public Olap nameSpaces(NameSpacesLoader value) {
        this.nameSpaces = (NameSpacesLoader)FunctionLoader.load((Object)this.nameSpaces, (Layer)this, NameSpacesLoader.class);
        return this;
    }

    public Olap listeners(List value) {
        this.listeners = value;
        return this;
    }

    public Olap onRefresh(RefreshListener value) {
        this.onRefresh = (RefreshListener)FunctionLoader.load((Object)this.onRefresh, (Layer)this, RefreshListener.class);
        return this;
    }

    public Olap refresh(Command value) {
        this.refresh = (Command)FunctionLoader.load((Object)this.refresh, (Layer)this, Command.class);
        return this;
    }

    public Events events() {
        return this.events;
    }

    public Range range() {
        return this.range;
    }

    public InstantFormatter instantFormatter() {
        return this.instantFormatter;
    }

    public Select select() {
        return this.select;
    }

    public ZoomGroup zoomGroup() {
        return this.zoomGroup;
    }

    public Olap events(Events value) {
        this.events = value;
        return this;
    }

    public Olap range(Range value) {
        this.range = value;
        return this;
    }

    public Olap instantFormatter(InstantFormatter value) {
        this.instantFormatter = value;
        return this;
    }

    public Olap select(Select value) {
        this.select = value;
        return this;
    }

    public Olap zoomGroup(ZoomGroup value) {
        this.zoomGroup = value;
        return this;
    }

    protected List<Node> componentList$() {
        LinkedHashSet<Node> components = new LinkedHashSet<Node>(super.componentList$());
        if (this.events != null) {
            components.add(this.events.core$());
        }
        if (this.range != null) {
            components.add(this.range.core$());
        }
        if (this.instantFormatter != null) {
            components.add(this.instantFormatter.core$());
        }
        if (this.select != null) {
            components.add(this.select.core$());
        }
        if (this.zoomGroup != null) {
            components.add(this.zoomGroup.core$());
        }
        return new ArrayList<Node>(components);
    }

    @Override
    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap(super.variables$());
        map.put("nameSpaces", this.nameSpaces != null ? new ArrayList<NameSpacesLoader>(Collections.singletonList(this.nameSpaces)) : Collections.emptyList());
        map.put("tickets", this.tickets);
        map.put("listeners", new ArrayList<List>(Collections.singletonList(this.listeners)));
        map.put("onRefresh", this.onRefresh != null ? new ArrayList<RefreshListener>(Collections.singletonList(this.onRefresh)) : Collections.emptyList());
        map.put("refresh", this.refresh != null ? new ArrayList<Command>(Collections.singletonList(this.refresh)) : Collections.emptyList());
        map.put("charts", this.charts);
        return map;
    }

    protected void addNode$(Node node) {
        super.addNode$(node);
        if (node.is("Olap$Events")) {
            this.events = (Events)node.as(Events.class);
        }
        if (node.is("Olap$Range")) {
            this.range = (Range)node.as(Range.class);
        }
        if (node.is("Olap$InstantFormatter")) {
            this.instantFormatter = (InstantFormatter)node.as(InstantFormatter.class);
        }
        if (node.is("Olap$Select")) {
            this.select = (Select)node.as(Select.class);
        }
        if (node.is("Olap$ZoomGroup")) {
            this.zoomGroup = (ZoomGroup)node.as(ZoomGroup.class);
        }
    }

    protected void removeNode$(Node node) {
        super.removeNode$(node);
        if (node.is("Olap$Events")) {
            this.events = null;
        }
        if (node.is("Olap$Range")) {
            this.range = null;
        }
        if (node.is("Olap$InstantFormatter")) {
            this.instantFormatter = null;
        }
        if (node.is("Olap$Select")) {
            this.select = null;
        }
        if (node.is("Olap$ZoomGroup")) {
            this.zoomGroup = null;
        }
    }

    @Override
    protected void load$(String name, List<?> values) {
        super.load$(name, values);
        if (name.equalsIgnoreCase("nameSpaces")) {
            this.nameSpaces = (NameSpacesLoader)FunctionLoader.load(values, (Layer)this, NameSpacesLoader.class).get(0);
        } else if (name.equalsIgnoreCase("tickets")) {
            this.tickets = NodeLoader.load(values, Ticket.class, (Layer)this);
        } else if (name.equalsIgnoreCase("listeners")) {
            this.listeners = (List)ObjectLoader.load(values, List.class, (Layer)this).get(0);
        } else if (name.equalsIgnoreCase("onRefresh")) {
            this.onRefresh = (RefreshListener)FunctionLoader.load(values, (Layer)this, RefreshListener.class).get(0);
        } else if (name.equalsIgnoreCase("refresh")) {
            this.refresh = (Command)FunctionLoader.load(values, (Layer)this, Command.class).get(0);
        } else if (name.equalsIgnoreCase("charts")) {
            this.charts = WordLoader.load(values, Chart.class, (Layer)this);
        }
    }

    @Override
    protected void set$(String name, List<?> values) {
        super.set$(name, values);
        if (name.equalsIgnoreCase("nameSpaces")) {
            this.nameSpaces = (NameSpacesLoader)FunctionLoader.load(values.get(0), (Layer)this, NameSpacesLoader.class);
        } else if (name.equalsIgnoreCase("tickets")) {
            this.tickets = values.stream().map(s -> (Ticket)this.graph().core$().load(((Layer)s).core$().id()).as(Ticket.class)).collect(Collectors.toList());
        } else if (name.equalsIgnoreCase("listeners")) {
            this.listeners = (List)values.get(0);
        } else if (name.equalsIgnoreCase("onRefresh")) {
            this.onRefresh = (RefreshListener)FunctionLoader.load(values.get(0), (Layer)this, RefreshListener.class);
        } else if (name.equalsIgnoreCase("refresh")) {
            this.refresh = (Command)FunctionLoader.load(values.get(0), (Layer)this, Command.class);
        } else if (name.equalsIgnoreCase("charts")) {
            this.charts = new ArrayList(values);
        }
    }

    @Override
    public Create create() {
        return new Create(null);
    }

    @Override
    public Create create(String name) {
        return new Create(name);
    }

    public Clear clear() {
        return new Clear();
    }

    @Override
    public SumusGraph graph() {
        return (SumusGraph)this.core$().graph().as(SumusGraph.class);
    }

    public static class ZoomGroup
    extends Layer
    implements Terminal {
        protected List<Zoom> zoomList = new ArrayList<Zoom>();

        public ZoomGroup(Node node) {
            super(node);
        }

        public List<Zoom> zoomList() {
            return Collections.unmodifiableList(this.zoomList);
        }

        public Zoom zoom(int index) {
            return this.zoomList.get(index);
        }

        public List<Zoom> zoomList(Predicate<Zoom> predicate) {
            return this.zoomList().stream().filter(predicate).collect(Collectors.toList());
        }

        protected List<Node> componentList$() {
            LinkedHashSet components = new LinkedHashSet(super.componentList$());
            new ArrayList<Zoom>(this.zoomList).forEach(c -> components.add(c.core$()));
            return new ArrayList<Node>(components);
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            return map;
        }

        protected void addNode$(Node node) {
            super.addNode$(node);
            if (node.is("Olap$ZoomGroup$Zoom")) {
                this.zoomList.add((Zoom)node.as(Zoom.class));
            }
        }

        protected void removeNode$(Node node) {
            super.removeNode$(node);
            if (node.is("Olap$ZoomGroup$Zoom")) {
                this.zoomList.remove(node.as(Zoom.class));
            }
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public Clear clear() {
            return new Clear();
        }

        public SumusGraph graph() {
            return (SumusGraph)this.core$().graph().as(SumusGraph.class);
        }

        public static class Zoom
        extends Layer
        implements Terminal {
            protected TimeScale scale;
            protected InstantRange instantRange;

            public Zoom(Node node) {
                super(node);
            }

            public TimeScale scale() {
                return this.scale;
            }

            public InstantRange instantRange() {
                return this.instantRange;
            }

            public Zoom instantRange(InstantRange value) {
                this.instantRange = value;
                return this;
            }

            protected List<Node> componentList$() {
                LinkedHashSet<Node> components = new LinkedHashSet<Node>(super.componentList$());
                if (this.instantRange != null) {
                    components.add(this.instantRange.core$());
                }
                return new ArrayList<Node>(components);
            }

            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap();
                map.put("scale", new ArrayList<TimeScale>(Collections.singletonList(this.scale)));
                return map;
            }

            protected void addNode$(Node node) {
                super.addNode$(node);
                if (node.is("Olap$ZoomGroup$Zoom$InstantRange")) {
                    this.instantRange = (InstantRange)node.as(InstantRange.class);
                }
            }

            protected void removeNode$(Node node) {
                super.removeNode$(node);
                if (node.is("Olap$ZoomGroup$Zoom$InstantRange")) {
                    this.instantRange = null;
                }
            }

            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("scale")) {
                    this.scale = (TimeScale)((Object)WordLoader.load(values, TimeScale.class, (Layer)this).get(0));
                }
            }

            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("scale")) {
                    this.scale = (TimeScale)((Object)values.get(0));
                }
            }

            public Create create() {
                return new Create(null);
            }

            public Create create(String name) {
                return new Create(name);
            }

            public Clear clear() {
                return new Clear();
            }

            public SumusGraph graph() {
                return (SumusGraph)this.core$().graph().as(SumusGraph.class);
            }

            public static class InstantRange
            extends Layer
            implements Terminal {
                protected int min;
                protected int max;

                public InstantRange(Node node) {
                    super(node);
                }

                public int min() {
                    return this.min;
                }

                public int max() {
                    return this.max;
                }

                protected Map<String, List<?>> variables$() {
                    LinkedHashMap map = new LinkedHashMap();
                    map.put("min", new ArrayList<Integer>(Collections.singletonList(this.min)));
                    map.put("max", new ArrayList<Integer>(Collections.singletonList(this.max)));
                    return map;
                }

                protected void load$(String name, List<?> values) {
                    super.load$(name, values);
                    if (name.equalsIgnoreCase("min")) {
                        this.min = (Integer)IntegerLoader.load(values, (Layer)this).get(0);
                    } else if (name.equalsIgnoreCase("max")) {
                        this.max = (Integer)IntegerLoader.load(values, (Layer)this).get(0);
                    }
                }

                protected void set$(String name, List<?> values) {
                    super.set$(name, values);
                    if (name.equalsIgnoreCase("min")) {
                        this.min = (Integer)values.get(0);
                    } else if (name.equalsIgnoreCase("max")) {
                        this.max = (Integer)values.get(0);
                    }
                }

                public SumusGraph graph() {
                    return (SumusGraph)this.core$().graph().as(SumusGraph.class);
                }
            }

            public class Clear {
            }

            public class Create {
                protected final String name;

                public Create(String name) {
                    this.name = name;
                }

                public InstantRange instantRange(int min, int max) {
                    InstantRange newElement = (InstantRange)Zoom.this.core$().graph().concept(InstantRange.class).createNode(this.name, Zoom.this.core$()).as(InstantRange.class);
                    newElement.core$().set((Layer)newElement, "min", Collections.singletonList(min));
                    newElement.core$().set((Layer)newElement, "max", Collections.singletonList(max));
                    return newElement;
                }
            }
        }

        public class Clear {
            public void zoom(Predicate<Zoom> filter) {
                new ArrayList<Zoom>(ZoomGroup.this.zoomList()).stream().filter(filter).forEach(Layer::delete$);
            }
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }

            public Zoom zoom(TimeScale scale) {
                Zoom newElement = (Zoom)ZoomGroup.this.core$().graph().concept(Zoom.class).createNode(this.name, ZoomGroup.this.core$()).as(Zoom.class);
                newElement.core$().set((Layer)newElement, "scale", Collections.singletonList(scale));
                return newElement;
            }
        }
    }

    public static class Select
    extends Layer
    implements Terminal {
        protected Ticket ticket;
        protected TimeScale scale;
        protected Mode range;

        public Select(Node node) {
            super(node);
        }

        public Ticket ticket() {
            return this.ticket;
        }

        public TimeScale scale() {
            return this.scale;
        }

        public Mode range() {
            return this.range;
        }

        public Select ticket(Ticket value) {
            this.ticket = value;
            return this;
        }

        public Select scale(TimeScale value) {
            this.scale = value;
            return this;
        }

        public Select range(Mode value) {
            this.range = value;
            return this;
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("ticket", this.ticket != null ? new ArrayList<Ticket>(Collections.singletonList(this.ticket)) : Collections.emptyList());
            map.put("scale", new ArrayList<TimeScale>(Collections.singletonList(this.scale)));
            map.put("range", new ArrayList<Mode>(Collections.singletonList(this.range)));
            return map;
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("ticket")) {
                this.ticket = (Ticket)((Object)NodeLoader.load(values, Ticket.class, (Layer)this).get(0));
            } else if (name.equalsIgnoreCase("scale")) {
                this.scale = (TimeScale)((Object)WordLoader.load(values, TimeScale.class, (Layer)this).get(0));
            } else if (name.equalsIgnoreCase("range")) {
                this.range = (Mode)((Object)WordLoader.load(values, Mode.class, (Layer)this).get(0));
            }
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("ticket")) {
                this.ticket = values.get(0) != null ? (Ticket)this.core$().graph().load(((Layer)values.get(0)).core$().id()).as(Ticket.class) : null;
            } else if (name.equalsIgnoreCase("scale")) {
                this.scale = (TimeScale)((Object)values.get(0));
            } else if (name.equalsIgnoreCase("range")) {
                this.range = (Mode)((Object)values.get(0));
            }
        }

        public SumusGraph graph() {
            return (SumusGraph)this.core$().graph().as(SumusGraph.class);
        }
    }

    public static class InstantFormatter
    extends Layer
    implements Terminal {
        protected List<Formatter> formatterList = new ArrayList<Formatter>();

        public InstantFormatter(Node node) {
            super(node);
        }

        public List<Formatter> formatterList() {
            return Collections.unmodifiableList(this.formatterList);
        }

        public Formatter formatter(int index) {
            return this.formatterList.get(index);
        }

        public List<Formatter> formatterList(Predicate<Formatter> predicate) {
            return this.formatterList().stream().filter(predicate).collect(Collectors.toList());
        }

        protected List<Node> componentList$() {
            LinkedHashSet components = new LinkedHashSet(super.componentList$());
            new ArrayList<Formatter>(this.formatterList).forEach(c -> components.add(c.core$()));
            return new ArrayList<Node>(components);
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            return map;
        }

        protected void addNode$(Node node) {
            super.addNode$(node);
            if (node.is("Olap$InstantFormatter$Formatter")) {
                this.formatterList.add((Formatter)node.as(Formatter.class));
            }
        }

        protected void removeNode$(Node node) {
            super.removeNode$(node);
            if (node.is("Olap$InstantFormatter$Formatter")) {
                this.formatterList.remove(node.as(Formatter.class));
            }
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public Clear clear() {
            return new Clear();
        }

        public SumusGraph graph() {
            return (SumusGraph)this.core$().graph().as(SumusGraph.class);
        }

        public static class Formatter
        extends Layer
        implements Terminal {
            protected TimeScale scale;
            protected String format;

            public Formatter(Node node) {
                super(node);
            }

            public TimeScale scale() {
                return this.scale;
            }

            public String format() {
                return this.format;
            }

            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap();
                map.put("scale", new ArrayList<TimeScale>(Collections.singletonList(this.scale)));
                map.put("format", new ArrayList<String>(Collections.singletonList(this.format)));
                return map;
            }

            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("scale")) {
                    this.scale = (TimeScale)((Object)WordLoader.load(values, TimeScale.class, (Layer)this).get(0));
                } else if (name.equalsIgnoreCase("format")) {
                    this.format = (String)StringLoader.load(values, (Layer)this).get(0);
                }
            }

            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("scale")) {
                    this.scale = (TimeScale)((Object)values.get(0));
                } else if (name.equalsIgnoreCase("format")) {
                    this.format = (String)values.get(0);
                }
            }

            public SumusGraph graph() {
                return (SumusGraph)this.core$().graph().as(SumusGraph.class);
            }
        }

        public class Clear {
            public void formatter(Predicate<Formatter> filter) {
                new ArrayList<Formatter>(InstantFormatter.this.formatterList()).stream().filter(filter).forEach(Layer::delete$);
            }
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }

            public Formatter formatter(TimeScale scale, String format) {
                Formatter newElement = (Formatter)InstantFormatter.this.core$().graph().concept(Formatter.class).createNode(this.name, InstantFormatter.this.core$()).as(Formatter.class);
                newElement.core$().set((Layer)newElement, "scale", Collections.singletonList(scale));
                newElement.core$().set((Layer)newElement, "format", Collections.singletonList(format));
                return newElement;
            }
        }
    }

    public static class Range
    extends Layer
    implements Terminal {
        protected Instant calculatedFrom;
        protected Instant calculatedTo;
        protected InstantLoader from;
        protected InstantLoader to;
        protected Expression<Boolean> reset;

        public Range(Node node) {
            super(node);
        }

        public Instant calculatedFrom() {
            return this.calculatedFrom;
        }

        public Instant calculatedTo() {
            return this.calculatedTo;
        }

        public Instant from(String username) {
            return this.from.load(username);
        }

        public Instant to(String username) {
            return this.to.load(username);
        }

        public boolean reset() {
            return (Boolean)this.reset.value();
        }

        public Range calculatedFrom(Instant value) {
            this.calculatedFrom = value;
            return this;
        }

        public Range calculatedTo(Instant value) {
            this.calculatedTo = value;
            return this;
        }

        public Range from(InstantLoader value) {
            this.from = (InstantLoader)FunctionLoader.load((Object)this.from, (Layer)this, InstantLoader.class);
            return this;
        }

        public Range to(InstantLoader value) {
            this.to = (InstantLoader)FunctionLoader.load((Object)this.to, (Layer)this, InstantLoader.class);
            return this;
        }

        public Range reset(Expression<Boolean> value) {
            this.reset = (Expression)FunctionLoader.load(value, (Layer)this, Expression.class);
            return this;
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("calculatedFrom", new ArrayList<Instant>(Collections.singletonList(this.calculatedFrom)));
            map.put("calculatedTo", new ArrayList<Instant>(Collections.singletonList(this.calculatedTo)));
            map.put("from", this.from != null ? new ArrayList<InstantLoader>(Collections.singletonList(this.from)) : Collections.emptyList());
            map.put("to", this.to != null ? new ArrayList<InstantLoader>(Collections.singletonList(this.to)) : Collections.emptyList());
            map.put("reset", new ArrayList<Expression<Boolean>>(Collections.singletonList(this.reset)));
            return map;
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("calculatedFrom")) {
                this.calculatedFrom = (Instant)io.intino.tara.magritte.loaders.InstantLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("calculatedTo")) {
                this.calculatedTo = (Instant)io.intino.tara.magritte.loaders.InstantLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("from")) {
                this.from = (InstantLoader)FunctionLoader.load(values, (Layer)this, InstantLoader.class).get(0);
            } else if (name.equalsIgnoreCase("to")) {
                this.to = (InstantLoader)FunctionLoader.load(values, (Layer)this, InstantLoader.class).get(0);
            } else if (name.equalsIgnoreCase("reset")) {
                this.reset = (Expression)FunctionLoader.load(values, (Layer)this, Expression.class).get(0);
            }
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("calculatedFrom")) {
                this.calculatedFrom = (Instant)values.get(0);
            } else if (name.equalsIgnoreCase("calculatedTo")) {
                this.calculatedTo = (Instant)values.get(0);
            } else if (name.equalsIgnoreCase("from")) {
                this.from = (InstantLoader)FunctionLoader.load(values.get(0), (Layer)this, InstantLoader.class);
            } else if (name.equalsIgnoreCase("to")) {
                this.to = (InstantLoader)FunctionLoader.load(values.get(0), (Layer)this, InstantLoader.class);
            } else if (name.equalsIgnoreCase("reset")) {
                this.reset = (Expression)FunctionLoader.load(values.get(0), (Layer)this, Expression.class);
            }
        }

        public SumusGraph graph() {
            return (SumusGraph)this.core$().graph().as(SumusGraph.class);
        }
    }

    public static class Events
    extends Layer
    implements Terminal {
        protected OnClickInstant onClickInstant;

        public Events(Node node) {
            super(node);
        }

        public OnClickInstant onClickInstant() {
            return this.onClickInstant;
        }

        public Events onClickInstant(OnClickInstant value) {
            this.onClickInstant = value;
            return this;
        }

        protected List<Node> componentList$() {
            LinkedHashSet<Node> components = new LinkedHashSet<Node>(super.componentList$());
            if (this.onClickInstant != null) {
                components.add(this.onClickInstant.core$());
            }
            return new ArrayList<Node>(components);
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            return map;
        }

        protected void addNode$(Node node) {
            super.addNode$(node);
            if (node.is("OnClickInstant")) {
                this.onClickInstant = (OnClickInstant)node.as(OnClickInstant.class);
            }
        }

        protected void removeNode$(Node node) {
            super.removeNode$(node);
            if (node.is("OnClickInstant")) {
                this.onClickInstant = null;
            }
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public Clear clear() {
            return new Clear();
        }

        public SumusGraph graph() {
            return (SumusGraph)this.core$().graph().as(SumusGraph.class);
        }

        public class Clear {
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }

            public OnClickInstant onClickInstant(List<Catalog> catalogs) {
                OnClickInstant newElement = (OnClickInstant)Events.this.core$().graph().concept(OnClickInstant.class).createNode(this.name, Events.this.core$()).as(OnClickInstant.class);
                newElement.core$().set((Layer)newElement, "catalogs", catalogs);
                return newElement;
            }
        }
    }

    public class Clear {
    }

    public class Create
    extends Element.Create {
        public Create(String name) {
            super(name);
        }

        public Events events() {
            Events newElement = (Events)Olap.this.core$().graph().concept(Events.class).createNode(this.name, Olap.this.core$()).as(Events.class);
            return newElement;
        }

        public Range range() {
            Range newElement = (Range)Olap.this.core$().graph().concept(Range.class).createNode(this.name, Olap.this.core$()).as(Range.class);
            return newElement;
        }

        public InstantFormatter instantFormatter() {
            InstantFormatter newElement = (InstantFormatter)Olap.this.core$().graph().concept(InstantFormatter.class).createNode(this.name, Olap.this.core$()).as(InstantFormatter.class);
            return newElement;
        }

        public Select select(Ticket ticket, TimeScale scale, Mode range) {
            Select newElement = (Select)Olap.this.core$().graph().concept(Select.class).createNode(this.name, Olap.this.core$()).as(Select.class);
            newElement.core$().set((Layer)newElement, "ticket", Collections.singletonList(ticket));
            newElement.core$().set((Layer)newElement, "scale", Collections.singletonList(scale));
            newElement.core$().set((Layer)newElement, "range", Collections.singletonList(range));
            return newElement;
        }

        public ZoomGroup zoomGroup() {
            ZoomGroup newElement = (ZoomGroup)Olap.this.core$().graph().concept(ZoomGroup.class).createNode(this.name, Olap.this.core$()).as(ZoomGroup.class);
            return newElement;
        }
    }
}

