/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.graph;

import io.intino.sumus.graph.Catalog;
import io.intino.sumus.graph.Element;
import io.intino.sumus.graph.Record;
import io.intino.sumus.graph.SumusGraph;
import io.intino.sumus.graph.editable.mold.block.EditableStamp;
import io.intino.sumus.graph.expanded.mold.ExpandedBlock;
import io.intino.sumus.graph.functions.BreadcrumbsTree;
import io.intino.sumus.graph.functions.CatalogFilter;
import io.intino.sumus.graph.functions.CatalogLinkFilter;
import io.intino.sumus.graph.functions.CatalogStampColor;
import io.intino.sumus.graph.functions.CatalogStampDoubleValue;
import io.intino.sumus.graph.functions.CatalogStampDownload;
import io.intino.sumus.graph.functions.CatalogStampExport;
import io.intino.sumus.graph.functions.CatalogStampPageUrl;
import io.intino.sumus.graph.functions.CatalogStampPictureValue;
import io.intino.sumus.graph.functions.CatalogStampRecordLinks;
import io.intino.sumus.graph.functions.CatalogStampResourceValue;
import io.intino.sumus.graph.functions.CatalogStampTask;
import io.intino.sumus.graph.functions.CatalogStampTextValue;
import io.intino.sumus.graph.functions.CatalogStampValue;
import io.intino.sumus.graph.functions.ItemExternalPath;
import io.intino.sumus.graph.functions.MoldBlockHidden;
import io.intino.sumus.graph.functions.Resource;
import io.intino.sumus.graph.functions.StampSaveEvent;
import io.intino.sumus.graph.functions.Tree;
import io.intino.tara.magritte.Layer;
import io.intino.tara.magritte.Node;
import io.intino.tara.magritte.loaders.BooleanLoader;
import io.intino.tara.magritte.loaders.FunctionLoader;
import io.intino.tara.magritte.loaders.InstantLoader;
import io.intino.tara.magritte.loaders.IntegerLoader;
import io.intino.tara.magritte.loaders.NodeLoader;
import io.intino.tara.magritte.loaders.ResourceLoader;
import io.intino.tara.magritte.loaders.StringLoader;
import io.intino.tara.magritte.loaders.WordLoader;
import io.intino.tara.magritte.tags.Terminal;
import java.io.InputStream;
import java.net.URL;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class Mold
extends Element
implements Terminal {
    protected List<Block> blockList = new ArrayList<Block>();

    public Mold(Node node) {
        super(node);
    }

    public List<Block> blockList() {
        return Collections.unmodifiableList(this.blockList);
    }

    public Block block(int index) {
        return this.blockList.get(index);
    }

    public List<Block> blockList(Predicate<Block> predicate) {
        return this.blockList().stream().filter(predicate).collect(Collectors.toList());
    }

    protected List<Node> componentList$() {
        LinkedHashSet components = new LinkedHashSet(super.componentList$());
        new ArrayList<Block>(this.blockList).forEach(c -> components.add(c.core$()));
        return new ArrayList<Node>(components);
    }

    @Override
    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap(super.variables$());
        return map;
    }

    protected void addNode$(Node node) {
        super.addNode$(node);
        if (node.is("Mold$Block")) {
            this.blockList.add((Block)node.as(Block.class));
        }
    }

    protected void removeNode$(Node node) {
        super.removeNode$(node);
        if (node.is("Mold$Block")) {
            this.blockList.remove(node.as(Block.class));
        }
    }

    @Override
    protected void load$(String name, List<?> values) {
        super.load$(name, values);
    }

    @Override
    protected void set$(String name, List<?> values) {
        super.set$(name, values);
    }

    @Override
    public Create create() {
        return new Create(null);
    }

    @Override
    public Create create(String name) {
        return new Create(name);
    }

    public Clear clear() {
        return new Clear();
    }

    @Override
    public SumusGraph graph() {
        return (SumusGraph)this.core$().graph().as(SumusGraph.class);
    }

    public static class Block
    extends Layer
    implements Terminal {
        protected List<Layout> layout = new ArrayList<Layout>();
        protected int width;
        protected int height;
        protected MoldBlockHidden hidden;
        protected boolean hiddenIfMobile;
        protected String style;
        protected List<Block> blockList = new ArrayList<Block>();
        protected List<Stamp> stampList = new ArrayList<Stamp>();
        protected List<Picture> pictureList = new ArrayList<Picture>();
        protected List<Icon> iconList = new ArrayList<Icon>();
        protected List<SumusIcon> sumusIconList = new ArrayList<SumusIcon>();
        protected List<Base64Icon> base64IconList = new ArrayList<Base64Icon>();
        protected List<ResourceIcon> resourceIconList = new ArrayList<ResourceIcon>();
        protected List<Highlight> highlightList = new ArrayList<Highlight>();
        protected List<Title> titleList = new ArrayList<Title>();
        protected List<Description> descriptionList = new ArrayList<Description>();
        protected List<Rating> ratingList = new ArrayList<Rating>();
        protected List<Operation> operationList = new ArrayList<Operation>();
        protected List<OpenDialogOperation> openDialogOperationList = new ArrayList<OpenDialogOperation>();
        protected List<DownloadOperation> downloadOperationList = new ArrayList<DownloadOperation>();
        protected List<ExportOperation> exportOperationList = new ArrayList<ExportOperation>();
        protected List<TaskOperation> taskOperationList = new ArrayList<TaskOperation>();
        protected List<Location> locationList = new ArrayList<Location>();
        protected List<Breadcrumbs> breadcrumbsList = new ArrayList<Breadcrumbs>();
        protected List<RecordLinks> recordLinksList = new ArrayList<RecordLinks>();
        protected List<CatalogLink> catalogLinkList = new ArrayList<CatalogLink>();
        protected List<Display> displayList = new ArrayList<Display>();
        protected List<Page> pageList = new ArrayList<Page>();
        protected List<InternalPage> internalPageList = new ArrayList<InternalPage>();
        protected List<ExternalPage> externalPageList = new ArrayList<ExternalPage>();
        protected List<Snippet> snippetList = new ArrayList<Snippet>();
        protected List<EmbeddedCatalog> embeddedCatalogList = new ArrayList<EmbeddedCatalog>();

        public Block(Node node) {
            super(node);
        }

        public List<Layout> layout() {
            return this.layout;
        }

        public int width() {
            return this.width;
        }

        public int height() {
            return this.height;
        }

        public boolean hidden(Record record) {
            return this.hidden.hidden(record);
        }

        public boolean hiddenIfMobile() {
            return this.hiddenIfMobile;
        }

        public String style() {
            return this.style;
        }

        public Block width(int value) {
            this.width = value;
            return this;
        }

        public Block height(int value) {
            this.height = value;
            return this;
        }

        public Block hidden(MoldBlockHidden value) {
            this.hidden = (MoldBlockHidden)FunctionLoader.load((Object)this.hidden, (Layer)this, MoldBlockHidden.class);
            return this;
        }

        public Block hiddenIfMobile(boolean value) {
            this.hiddenIfMobile = value;
            return this;
        }

        public Block style(String value) {
            this.style = value;
            return this;
        }

        public List<Block> blockList() {
            return Collections.unmodifiableList(this.blockList);
        }

        public Block block(int index) {
            return this.blockList.get(index);
        }

        public List<Block> blockList(Predicate<Block> predicate) {
            return this.blockList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<Stamp> stampList() {
            return Collections.unmodifiableList(this.stampList);
        }

        public Stamp stamp(int index) {
            return this.stampList.get(index);
        }

        public List<Stamp> stampList(Predicate<Stamp> predicate) {
            return this.stampList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<Picture> pictureList() {
            return Collections.unmodifiableList(this.pictureList);
        }

        public Picture picture(int index) {
            return this.pictureList.get(index);
        }

        public List<Picture> pictureList(Predicate<Picture> predicate) {
            return this.pictureList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<Icon> iconList() {
            return Collections.unmodifiableList(this.iconList);
        }

        public Icon icon(int index) {
            return this.iconList.get(index);
        }

        public List<Icon> iconList(Predicate<Icon> predicate) {
            return this.iconList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<SumusIcon> sumusIconList() {
            return Collections.unmodifiableList(this.sumusIconList);
        }

        public SumusIcon sumusIcon(int index) {
            return this.sumusIconList.get(index);
        }

        public List<SumusIcon> sumusIconList(Predicate<SumusIcon> predicate) {
            return this.sumusIconList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<Base64Icon> base64IconList() {
            return Collections.unmodifiableList(this.base64IconList);
        }

        public Base64Icon base64Icon(int index) {
            return this.base64IconList.get(index);
        }

        public List<Base64Icon> base64IconList(Predicate<Base64Icon> predicate) {
            return this.base64IconList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<ResourceIcon> resourceIconList() {
            return Collections.unmodifiableList(this.resourceIconList);
        }

        public ResourceIcon resourceIcon(int index) {
            return this.resourceIconList.get(index);
        }

        public List<ResourceIcon> resourceIconList(Predicate<ResourceIcon> predicate) {
            return this.resourceIconList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<Highlight> highlightList() {
            return Collections.unmodifiableList(this.highlightList);
        }

        public Highlight highlight(int index) {
            return this.highlightList.get(index);
        }

        public List<Highlight> highlightList(Predicate<Highlight> predicate) {
            return this.highlightList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<Title> titleList() {
            return Collections.unmodifiableList(this.titleList);
        }

        public Title title(int index) {
            return this.titleList.get(index);
        }

        public List<Title> titleList(Predicate<Title> predicate) {
            return this.titleList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<Description> descriptionList() {
            return Collections.unmodifiableList(this.descriptionList);
        }

        public Description description(int index) {
            return this.descriptionList.get(index);
        }

        public List<Description> descriptionList(Predicate<Description> predicate) {
            return this.descriptionList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<Rating> ratingList() {
            return Collections.unmodifiableList(this.ratingList);
        }

        public Rating rating(int index) {
            return this.ratingList.get(index);
        }

        public List<Rating> ratingList(Predicate<Rating> predicate) {
            return this.ratingList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<Operation> operationList() {
            return Collections.unmodifiableList(this.operationList);
        }

        public Operation operation(int index) {
            return this.operationList.get(index);
        }

        public List<Operation> operationList(Predicate<Operation> predicate) {
            return this.operationList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<OpenDialogOperation> openDialogOperationList() {
            return Collections.unmodifiableList(this.openDialogOperationList);
        }

        public OpenDialogOperation openDialogOperation(int index) {
            return this.openDialogOperationList.get(index);
        }

        public List<OpenDialogOperation> openDialogOperationList(Predicate<OpenDialogOperation> predicate) {
            return this.openDialogOperationList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<DownloadOperation> downloadOperationList() {
            return Collections.unmodifiableList(this.downloadOperationList);
        }

        public DownloadOperation downloadOperation(int index) {
            return this.downloadOperationList.get(index);
        }

        public List<DownloadOperation> downloadOperationList(Predicate<DownloadOperation> predicate) {
            return this.downloadOperationList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<ExportOperation> exportOperationList() {
            return Collections.unmodifiableList(this.exportOperationList);
        }

        public ExportOperation exportOperation(int index) {
            return this.exportOperationList.get(index);
        }

        public List<ExportOperation> exportOperationList(Predicate<ExportOperation> predicate) {
            return this.exportOperationList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<TaskOperation> taskOperationList() {
            return Collections.unmodifiableList(this.taskOperationList);
        }

        public TaskOperation taskOperation(int index) {
            return this.taskOperationList.get(index);
        }

        public List<TaskOperation> taskOperationList(Predicate<TaskOperation> predicate) {
            return this.taskOperationList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<Location> locationList() {
            return Collections.unmodifiableList(this.locationList);
        }

        public Location location(int index) {
            return this.locationList.get(index);
        }

        public List<Location> locationList(Predicate<Location> predicate) {
            return this.locationList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<Breadcrumbs> breadcrumbsList() {
            return Collections.unmodifiableList(this.breadcrumbsList);
        }

        public Breadcrumbs breadcrumbs(int index) {
            return this.breadcrumbsList.get(index);
        }

        public List<Breadcrumbs> breadcrumbsList(Predicate<Breadcrumbs> predicate) {
            return this.breadcrumbsList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<RecordLinks> recordLinksList() {
            return Collections.unmodifiableList(this.recordLinksList);
        }

        public RecordLinks recordLinks(int index) {
            return this.recordLinksList.get(index);
        }

        public List<RecordLinks> recordLinksList(Predicate<RecordLinks> predicate) {
            return this.recordLinksList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<CatalogLink> catalogLinkList() {
            return Collections.unmodifiableList(this.catalogLinkList);
        }

        public CatalogLink catalogLink(int index) {
            return this.catalogLinkList.get(index);
        }

        public List<CatalogLink> catalogLinkList(Predicate<CatalogLink> predicate) {
            return this.catalogLinkList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<Display> displayList() {
            return Collections.unmodifiableList(this.displayList);
        }

        public Display display(int index) {
            return this.displayList.get(index);
        }

        public List<Display> displayList(Predicate<Display> predicate) {
            return this.displayList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<Page> pageList() {
            return Collections.unmodifiableList(this.pageList);
        }

        public Page page(int index) {
            return this.pageList.get(index);
        }

        public List<Page> pageList(Predicate<Page> predicate) {
            return this.pageList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<InternalPage> internalPageList() {
            return Collections.unmodifiableList(this.internalPageList);
        }

        public InternalPage internalPage(int index) {
            return this.internalPageList.get(index);
        }

        public List<InternalPage> internalPageList(Predicate<InternalPage> predicate) {
            return this.internalPageList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<ExternalPage> externalPageList() {
            return Collections.unmodifiableList(this.externalPageList);
        }

        public ExternalPage externalPage(int index) {
            return this.externalPageList.get(index);
        }

        public List<ExternalPage> externalPageList(Predicate<ExternalPage> predicate) {
            return this.externalPageList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<Snippet> snippetList() {
            return Collections.unmodifiableList(this.snippetList);
        }

        public Snippet snippet(int index) {
            return this.snippetList.get(index);
        }

        public List<Snippet> snippetList(Predicate<Snippet> predicate) {
            return this.snippetList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<EmbeddedCatalog> embeddedCatalogList() {
            return Collections.unmodifiableList(this.embeddedCatalogList);
        }

        public EmbeddedCatalog embeddedCatalog(int index) {
            return this.embeddedCatalogList.get(index);
        }

        public List<EmbeddedCatalog> embeddedCatalogList(Predicate<EmbeddedCatalog> predicate) {
            return this.embeddedCatalogList().stream().filter(predicate).collect(Collectors.toList());
        }

        public ExpandedBlock asExpanded() {
            Layer as = this.a$(ExpandedBlock.class);
            return as != null ? (ExpandedBlock)as : (ExpandedBlock)this.core$().addFacet(ExpandedBlock.class);
        }

        public boolean isExpanded() {
            return this.core$().is(ExpandedBlock.class);
        }

        protected List<Node> componentList$() {
            LinkedHashSet components = new LinkedHashSet(super.componentList$());
            new ArrayList<Block>(this.blockList).forEach(c -> components.add(c.core$()));
            new ArrayList<Stamp>(this.stampList).forEach(c -> components.add(c.core$()));
            new ArrayList<Picture>(this.pictureList).forEach(c -> components.add(c.core$()));
            new ArrayList<Icon>(this.iconList).forEach(c -> components.add(c.core$()));
            new ArrayList<SumusIcon>(this.sumusIconList).forEach(c -> components.add(c.core$()));
            new ArrayList<Base64Icon>(this.base64IconList).forEach(c -> components.add(c.core$()));
            new ArrayList<ResourceIcon>(this.resourceIconList).forEach(c -> components.add(c.core$()));
            new ArrayList<Highlight>(this.highlightList).forEach(c -> components.add(c.core$()));
            new ArrayList<Title>(this.titleList).forEach(c -> components.add(c.core$()));
            new ArrayList<Description>(this.descriptionList).forEach(c -> components.add(c.core$()));
            new ArrayList<Rating>(this.ratingList).forEach(c -> components.add(c.core$()));
            new ArrayList<Operation>(this.operationList).forEach(c -> components.add(c.core$()));
            new ArrayList<OpenDialogOperation>(this.openDialogOperationList).forEach(c -> components.add(c.core$()));
            new ArrayList<DownloadOperation>(this.downloadOperationList).forEach(c -> components.add(c.core$()));
            new ArrayList<ExportOperation>(this.exportOperationList).forEach(c -> components.add(c.core$()));
            new ArrayList<TaskOperation>(this.taskOperationList).forEach(c -> components.add(c.core$()));
            new ArrayList<Location>(this.locationList).forEach(c -> components.add(c.core$()));
            new ArrayList<Breadcrumbs>(this.breadcrumbsList).forEach(c -> components.add(c.core$()));
            new ArrayList<RecordLinks>(this.recordLinksList).forEach(c -> components.add(c.core$()));
            new ArrayList<CatalogLink>(this.catalogLinkList).forEach(c -> components.add(c.core$()));
            new ArrayList<Display>(this.displayList).forEach(c -> components.add(c.core$()));
            new ArrayList<Page>(this.pageList).forEach(c -> components.add(c.core$()));
            new ArrayList<InternalPage>(this.internalPageList).forEach(c -> components.add(c.core$()));
            new ArrayList<ExternalPage>(this.externalPageList).forEach(c -> components.add(c.core$()));
            new ArrayList<Snippet>(this.snippetList).forEach(c -> components.add(c.core$()));
            new ArrayList<EmbeddedCatalog>(this.embeddedCatalogList).forEach(c -> components.add(c.core$()));
            return new ArrayList<Node>(components);
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("layout", this.layout);
            map.put("width", new ArrayList<Integer>(Collections.singletonList(this.width)));
            map.put("height", new ArrayList<Integer>(Collections.singletonList(this.height)));
            map.put("hidden", this.hidden != null ? new ArrayList<MoldBlockHidden>(Collections.singletonList(this.hidden)) : Collections.emptyList());
            map.put("hiddenIfMobile", new ArrayList<Boolean>(Collections.singletonList(this.hiddenIfMobile)));
            map.put("style", new ArrayList<String>(Collections.singletonList(this.style)));
            return map;
        }

        protected void addNode$(Node node) {
            super.addNode$(node);
            if (node.is("Mold$Block")) {
                this.blockList.add((Block)node.as(Block.class));
            }
            if (node.is("Mold$Block$Stamp")) {
                this.stampList.add((Stamp)node.as(Stamp.class));
            }
            if (node.is("Mold$Block$Picture")) {
                this.pictureList.add((Picture)node.as(Picture.class));
            }
            if (node.is("Mold$Block$Icon")) {
                this.iconList.add((Icon)node.as(Icon.class));
            }
            if (node.is("Mold$Block$SumusIcon")) {
                this.sumusIconList.add((SumusIcon)node.as(SumusIcon.class));
            }
            if (node.is("Mold$Block$Base64Icon")) {
                this.base64IconList.add((Base64Icon)node.as(Base64Icon.class));
            }
            if (node.is("Mold$Block$ResourceIcon")) {
                this.resourceIconList.add((ResourceIcon)node.as(ResourceIcon.class));
            }
            if (node.is("Mold$Block$Highlight")) {
                this.highlightList.add((Highlight)node.as(Highlight.class));
            }
            if (node.is("Mold$Block$Title")) {
                this.titleList.add((Title)node.as(Title.class));
            }
            if (node.is("Mold$Block$Description")) {
                this.descriptionList.add((Description)node.as(Description.class));
            }
            if (node.is("Mold$Block$Rating")) {
                this.ratingList.add((Rating)node.as(Rating.class));
            }
            if (node.is("Mold$Block$Operation")) {
                this.operationList.add((Operation)node.as(Operation.class));
            }
            if (node.is("Mold$Block$OpenDialogOperation")) {
                this.openDialogOperationList.add((OpenDialogOperation)node.as(OpenDialogOperation.class));
            }
            if (node.is("Mold$Block$DownloadOperation")) {
                this.downloadOperationList.add((DownloadOperation)node.as(DownloadOperation.class));
            }
            if (node.is("Mold$Block$ExportOperation")) {
                this.exportOperationList.add((ExportOperation)node.as(ExportOperation.class));
            }
            if (node.is("Mold$Block$TaskOperation")) {
                this.taskOperationList.add((TaskOperation)node.as(TaskOperation.class));
            }
            if (node.is("Mold$Block$Location")) {
                this.locationList.add((Location)node.as(Location.class));
            }
            if (node.is("Mold$Block$Breadcrumbs")) {
                this.breadcrumbsList.add((Breadcrumbs)node.as(Breadcrumbs.class));
            }
            if (node.is("Mold$Block$RecordLinks")) {
                this.recordLinksList.add((RecordLinks)node.as(RecordLinks.class));
            }
            if (node.is("Mold$Block$CatalogLink")) {
                this.catalogLinkList.add((CatalogLink)node.as(CatalogLink.class));
            }
            if (node.is("Mold$Block$Display")) {
                this.displayList.add((Display)node.as(Display.class));
            }
            if (node.is("Mold$Block$Page")) {
                this.pageList.add((Page)node.as(Page.class));
            }
            if (node.is("Mold$Block$InternalPage")) {
                this.internalPageList.add((InternalPage)node.as(InternalPage.class));
            }
            if (node.is("Mold$Block$ExternalPage")) {
                this.externalPageList.add((ExternalPage)node.as(ExternalPage.class));
            }
            if (node.is("Mold$Block$Snippet")) {
                this.snippetList.add((Snippet)node.as(Snippet.class));
            }
            if (node.is("Mold$Block$EmbeddedCatalog")) {
                this.embeddedCatalogList.add((EmbeddedCatalog)node.as(EmbeddedCatalog.class));
            }
        }

        protected void removeNode$(Node node) {
            super.removeNode$(node);
            if (node.is("Mold$Block")) {
                this.blockList.remove(node.as(Block.class));
            }
            if (node.is("Mold$Block$Stamp")) {
                this.stampList.remove(node.as(Stamp.class));
            }
            if (node.is("Mold$Block$Picture")) {
                this.pictureList.remove(node.as(Picture.class));
            }
            if (node.is("Mold$Block$Icon")) {
                this.iconList.remove(node.as(Icon.class));
            }
            if (node.is("Mold$Block$SumusIcon")) {
                this.sumusIconList.remove(node.as(SumusIcon.class));
            }
            if (node.is("Mold$Block$Base64Icon")) {
                this.base64IconList.remove(node.as(Base64Icon.class));
            }
            if (node.is("Mold$Block$ResourceIcon")) {
                this.resourceIconList.remove(node.as(ResourceIcon.class));
            }
            if (node.is("Mold$Block$Highlight")) {
                this.highlightList.remove(node.as(Highlight.class));
            }
            if (node.is("Mold$Block$Title")) {
                this.titleList.remove(node.as(Title.class));
            }
            if (node.is("Mold$Block$Description")) {
                this.descriptionList.remove(node.as(Description.class));
            }
            if (node.is("Mold$Block$Rating")) {
                this.ratingList.remove(node.as(Rating.class));
            }
            if (node.is("Mold$Block$Operation")) {
                this.operationList.remove(node.as(Operation.class));
            }
            if (node.is("Mold$Block$OpenDialogOperation")) {
                this.openDialogOperationList.remove(node.as(OpenDialogOperation.class));
            }
            if (node.is("Mold$Block$DownloadOperation")) {
                this.downloadOperationList.remove(node.as(DownloadOperation.class));
            }
            if (node.is("Mold$Block$ExportOperation")) {
                this.exportOperationList.remove(node.as(ExportOperation.class));
            }
            if (node.is("Mold$Block$TaskOperation")) {
                this.taskOperationList.remove(node.as(TaskOperation.class));
            }
            if (node.is("Mold$Block$Location")) {
                this.locationList.remove(node.as(Location.class));
            }
            if (node.is("Mold$Block$Breadcrumbs")) {
                this.breadcrumbsList.remove(node.as(Breadcrumbs.class));
            }
            if (node.is("Mold$Block$RecordLinks")) {
                this.recordLinksList.remove(node.as(RecordLinks.class));
            }
            if (node.is("Mold$Block$CatalogLink")) {
                this.catalogLinkList.remove(node.as(CatalogLink.class));
            }
            if (node.is("Mold$Block$Display")) {
                this.displayList.remove(node.as(Display.class));
            }
            if (node.is("Mold$Block$Page")) {
                this.pageList.remove(node.as(Page.class));
            }
            if (node.is("Mold$Block$InternalPage")) {
                this.internalPageList.remove(node.as(InternalPage.class));
            }
            if (node.is("Mold$Block$ExternalPage")) {
                this.externalPageList.remove(node.as(ExternalPage.class));
            }
            if (node.is("Mold$Block$Snippet")) {
                this.snippetList.remove(node.as(Snippet.class));
            }
            if (node.is("Mold$Block$EmbeddedCatalog")) {
                this.embeddedCatalogList.remove(node.as(EmbeddedCatalog.class));
            }
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("layout")) {
                this.layout = WordLoader.load(values, Layout.class, (Layer)this);
            } else if (name.equalsIgnoreCase("width")) {
                this.width = (Integer)IntegerLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("height")) {
                this.height = (Integer)IntegerLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("hidden")) {
                this.hidden = (MoldBlockHidden)FunctionLoader.load(values, (Layer)this, MoldBlockHidden.class).get(0);
            } else if (name.equalsIgnoreCase("hiddenIfMobile")) {
                this.hiddenIfMobile = (Boolean)BooleanLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("style")) {
                this.style = (String)StringLoader.load(values, (Layer)this).get(0);
            }
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("layout")) {
                this.layout = new ArrayList(values);
            } else if (name.equalsIgnoreCase("width")) {
                this.width = (Integer)values.get(0);
            } else if (name.equalsIgnoreCase("height")) {
                this.height = (Integer)values.get(0);
            } else if (name.equalsIgnoreCase("hidden")) {
                this.hidden = (MoldBlockHidden)FunctionLoader.load(values.get(0), (Layer)this, MoldBlockHidden.class);
            } else if (name.equalsIgnoreCase("hiddenIfMobile")) {
                this.hiddenIfMobile = (Boolean)values.get(0);
            } else if (name.equalsIgnoreCase("style")) {
                this.style = (String)values.get(0);
            }
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public Clear clear() {
            return new Clear();
        }

        public SumusGraph graph() {
            return (SumusGraph)this.core$().graph().as(SumusGraph.class);
        }

        public static class EmbeddedCatalog
        extends Stamp
        implements Terminal {
            protected Catalog catalog;
            protected CatalogFilter filter;

            public EmbeddedCatalog(Node node) {
                super(node);
            }

            public Catalog catalog() {
                return this.catalog;
            }

            public boolean filter(Element context, Record target, Record record) {
                return this.filter.filter(context, target, record);
            }

            public EmbeddedCatalog catalog(Catalog value) {
                this.catalog = value;
                return this;
            }

            public EmbeddedCatalog filter(CatalogFilter value) {
                this.filter = (CatalogFilter)FunctionLoader.load((Object)this.filter, (Layer)this, CatalogFilter.class);
                return this;
            }

            @Override
            public EditableStamp asEditable() {
                return (EditableStamp)this.a$(EditableStamp.class);
            }

            @Override
            public EditableStamp asEditable(StampSaveEvent onSave) {
                EditableStamp newElement = (EditableStamp)this.core$().addFacet(EditableStamp.class);
                newElement.core$().set((Layer)newElement, "onSave", Collections.singletonList(onSave));
                return newElement;
            }

            @Override
            public boolean isEditable() {
                return this.core$().is(EditableStamp.class);
            }

            @Override
            public void removeEditable() {
                this.core$().removeFacet(EditableStamp.class);
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                map.put("catalog", this.catalog != null ? new ArrayList<Catalog>(Collections.singletonList(this.catalog)) : Collections.emptyList());
                map.put("filter", this.filter != null ? new ArrayList<CatalogFilter>(Collections.singletonList(this.filter)) : Collections.emptyList());
                return map;
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("catalog")) {
                    this.catalog = (Catalog)((Object)NodeLoader.load(values, Catalog.class, (Layer)this).get(0));
                } else if (name.equalsIgnoreCase("filter")) {
                    this.filter = (CatalogFilter)FunctionLoader.load(values, (Layer)this, CatalogFilter.class).get(0);
                }
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("catalog")) {
                    this.catalog = values.get(0) != null ? (Catalog)this.core$().graph().load(((Layer)values.get(0)).core$().id()).as(Catalog.class) : null;
                } else if (name.equalsIgnoreCase("filter")) {
                    this.filter = (CatalogFilter)FunctionLoader.load(values.get(0), (Layer)this, CatalogFilter.class);
                }
            }

            @Override
            public SumusGraph graph() {
                return (SumusGraph)this.core$().graph().as(SumusGraph.class);
            }
        }

        public static class Snippet
        extends Stamp
        implements Terminal {
            protected CatalogStampTextValue code;

            public Snippet(Node node) {
                super(node);
            }

            public String code(Record record) {
                return this.code.value(record);
            }

            public Snippet code(CatalogStampTextValue value) {
                this.code = (CatalogStampTextValue)FunctionLoader.load((Object)this.code, (Layer)this, CatalogStampTextValue.class);
                return this;
            }

            @Override
            public EditableStamp asEditable() {
                return (EditableStamp)this.a$(EditableStamp.class);
            }

            @Override
            public EditableStamp asEditable(StampSaveEvent onSave) {
                EditableStamp newElement = (EditableStamp)this.core$().addFacet(EditableStamp.class);
                newElement.core$().set((Layer)newElement, "onSave", Collections.singletonList(onSave));
                return newElement;
            }

            @Override
            public boolean isEditable() {
                return this.core$().is(EditableStamp.class);
            }

            @Override
            public void removeEditable() {
                this.core$().removeFacet(EditableStamp.class);
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                map.put("code", this.code != null ? new ArrayList<CatalogStampTextValue>(Collections.singletonList(this.code)) : Collections.emptyList());
                return map;
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("code")) {
                    this.code = (CatalogStampTextValue)FunctionLoader.load(values, (Layer)this, CatalogStampTextValue.class).get(0);
                }
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("code")) {
                    this.code = (CatalogStampTextValue)FunctionLoader.load(values.get(0), (Layer)this, CatalogStampTextValue.class);
                }
            }

            @Override
            public SumusGraph graph() {
                return (SumusGraph)this.core$().graph().as(SumusGraph.class);
            }
        }

        public static class ExternalPage
        extends Page
        implements Terminal {
            protected CatalogStampPageUrl url;

            public ExternalPage(Node node) {
                super(node);
            }

            public URL url(String item) {
                return this.url.url(item);
            }

            public ExternalPage url(CatalogStampPageUrl value) {
                this.url = (CatalogStampPageUrl)FunctionLoader.load((Object)this.url, (Layer)this, CatalogStampPageUrl.class);
                return this;
            }

            @Override
            public EditableStamp asEditable() {
                return (EditableStamp)this.a$(EditableStamp.class);
            }

            @Override
            public EditableStamp asEditable(StampSaveEvent onSave) {
                EditableStamp newElement = (EditableStamp)this.core$().addFacet(EditableStamp.class);
                newElement.core$().set((Layer)newElement, "onSave", Collections.singletonList(onSave));
                return newElement;
            }

            @Override
            public boolean isEditable() {
                return this.core$().is(EditableStamp.class);
            }

            @Override
            public void removeEditable() {
                this.core$().removeFacet(EditableStamp.class);
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                map.put("url", this.url != null ? new ArrayList<CatalogStampPageUrl>(Collections.singletonList(this.url)) : Collections.emptyList());
                return map;
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("url")) {
                    this.url = (CatalogStampPageUrl)FunctionLoader.load(values, (Layer)this, CatalogStampPageUrl.class).get(0);
                }
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("url")) {
                    this.url = (CatalogStampPageUrl)FunctionLoader.load(values.get(0), (Layer)this, CatalogStampPageUrl.class);
                }
            }

            @Override
            public SumusGraph graph() {
                return (SumusGraph)this.core$().graph().as(SumusGraph.class);
            }
        }

        public static class InternalPage
        extends Page
        implements Terminal {
            protected ItemExternalPath path;

            public InternalPage(Node node) {
                super(node);
            }

            public String path(String item) {
                return this.path.path(item);
            }

            public InternalPage path(ItemExternalPath value) {
                this.path = (ItemExternalPath)FunctionLoader.load((Object)this.path, (Layer)this, ItemExternalPath.class);
                return this;
            }

            @Override
            public EditableStamp asEditable() {
                return (EditableStamp)this.a$(EditableStamp.class);
            }

            @Override
            public EditableStamp asEditable(StampSaveEvent onSave) {
                EditableStamp newElement = (EditableStamp)this.core$().addFacet(EditableStamp.class);
                newElement.core$().set((Layer)newElement, "onSave", Collections.singletonList(onSave));
                return newElement;
            }

            @Override
            public boolean isEditable() {
                return this.core$().is(EditableStamp.class);
            }

            @Override
            public void removeEditable() {
                this.core$().removeFacet(EditableStamp.class);
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                map.put("path", this.path != null ? new ArrayList<ItemExternalPath>(Collections.singletonList(this.path)) : Collections.emptyList());
                return map;
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("path")) {
                    this.path = (ItemExternalPath)FunctionLoader.load(values, (Layer)this, ItemExternalPath.class).get(0);
                }
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("path")) {
                    this.path = (ItemExternalPath)FunctionLoader.load(values.get(0), (Layer)this, ItemExternalPath.class);
                }
            }

            @Override
            public SumusGraph graph() {
                return (SumusGraph)this.core$().graph().as(SumusGraph.class);
            }
        }

        public static abstract class Page
        extends Stamp
        implements Terminal {
            public Page(Node node) {
                super(node);
            }

            @Override
            public EditableStamp asEditable() {
                return (EditableStamp)this.a$(EditableStamp.class);
            }

            @Override
            public EditableStamp asEditable(StampSaveEvent onSave) {
                EditableStamp newElement = (EditableStamp)this.core$().addFacet(EditableStamp.class);
                newElement.core$().set((Layer)newElement, "onSave", Collections.singletonList(onSave));
                return newElement;
            }

            @Override
            public boolean isEditable() {
                return this.core$().is(EditableStamp.class);
            }

            @Override
            public void removeEditable() {
                this.core$().removeFacet(EditableStamp.class);
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                return map;
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
            }

            @Override
            public Create create() {
                return new Create(null);
            }

            @Override
            public Create create(String name) {
                return new Create(name);
            }

            @Override
            public SumusGraph graph() {
                return (SumusGraph)this.core$().graph().as(SumusGraph.class);
            }

            public class Create
            extends Stamp.Create {
                public Create(String name) {
                    super(name);
                }
            }
        }

        public static class Display
        extends Stamp
        implements Terminal {
            public Display(Node node) {
                super(node);
            }

            @Override
            public EditableStamp asEditable() {
                return (EditableStamp)this.a$(EditableStamp.class);
            }

            @Override
            public EditableStamp asEditable(StampSaveEvent onSave) {
                EditableStamp newElement = (EditableStamp)this.core$().addFacet(EditableStamp.class);
                newElement.core$().set((Layer)newElement, "onSave", Collections.singletonList(onSave));
                return newElement;
            }

            @Override
            public boolean isEditable() {
                return this.core$().is(EditableStamp.class);
            }

            @Override
            public void removeEditable() {
                this.core$().removeFacet(EditableStamp.class);
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                return map;
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
            }

            @Override
            public SumusGraph graph() {
                return (SumusGraph)this.core$().graph().as(SumusGraph.class);
            }
        }

        public static class CatalogLink
        extends Stamp
        implements Terminal {
            protected CatalogStampTextValue title;
            protected Catalog catalog;
            protected CatalogLinkFilter filter;

            public CatalogLink(Node node) {
                super(node);
            }

            public String title(Record record) {
                return this.title.value(record);
            }

            public Catalog catalog() {
                return this.catalog;
            }

            public boolean filter(Record source, Record target) {
                return this.filter.filter(source, target);
            }

            public CatalogLink title(CatalogStampTextValue value) {
                this.title = (CatalogStampTextValue)FunctionLoader.load((Object)this.title, (Layer)this, CatalogStampTextValue.class);
                return this;
            }

            public CatalogLink catalog(Catalog value) {
                this.catalog = value;
                return this;
            }

            public CatalogLink filter(CatalogLinkFilter value) {
                this.filter = (CatalogLinkFilter)FunctionLoader.load((Object)this.filter, (Layer)this, CatalogLinkFilter.class);
                return this;
            }

            @Override
            public EditableStamp asEditable() {
                return (EditableStamp)this.a$(EditableStamp.class);
            }

            @Override
            public EditableStamp asEditable(StampSaveEvent onSave) {
                EditableStamp newElement = (EditableStamp)this.core$().addFacet(EditableStamp.class);
                newElement.core$().set((Layer)newElement, "onSave", Collections.singletonList(onSave));
                return newElement;
            }

            @Override
            public boolean isEditable() {
                return this.core$().is(EditableStamp.class);
            }

            @Override
            public void removeEditable() {
                this.core$().removeFacet(EditableStamp.class);
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                map.put("title", this.title != null ? new ArrayList<CatalogStampTextValue>(Collections.singletonList(this.title)) : Collections.emptyList());
                map.put("catalog", this.catalog != null ? new ArrayList<Catalog>(Collections.singletonList(this.catalog)) : Collections.emptyList());
                map.put("filter", this.filter != null ? new ArrayList<CatalogLinkFilter>(Collections.singletonList(this.filter)) : Collections.emptyList());
                return map;
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("title")) {
                    this.title = (CatalogStampTextValue)FunctionLoader.load(values, (Layer)this, CatalogStampTextValue.class).get(0);
                } else if (name.equalsIgnoreCase("catalog")) {
                    this.catalog = (Catalog)((Object)NodeLoader.load(values, Catalog.class, (Layer)this).get(0));
                } else if (name.equalsIgnoreCase("filter")) {
                    this.filter = (CatalogLinkFilter)FunctionLoader.load(values, (Layer)this, CatalogLinkFilter.class).get(0);
                }
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("title")) {
                    this.title = (CatalogStampTextValue)FunctionLoader.load(values.get(0), (Layer)this, CatalogStampTextValue.class);
                } else if (name.equalsIgnoreCase("catalog")) {
                    this.catalog = values.get(0) != null ? (Catalog)this.core$().graph().load(((Layer)values.get(0)).core$().id()).as(Catalog.class) : null;
                } else if (name.equalsIgnoreCase("filter")) {
                    this.filter = (CatalogLinkFilter)FunctionLoader.load(values.get(0), (Layer)this, CatalogLinkFilter.class);
                }
            }

            @Override
            public SumusGraph graph() {
                return (SumusGraph)this.core$().graph().as(SumusGraph.class);
            }
        }

        public static class RecordLinks
        extends Stamp
        implements Terminal {
            protected CatalogStampTextValue title;
            protected CatalogStampRecordLinks links;

            public RecordLinks(Node node) {
                super(node);
            }

            public String title(Record record) {
                return this.title.value(record);
            }

            public CatalogStampRecordLinks.RecordLinks links(Record record) {
                return this.links.value(record);
            }

            public RecordLinks title(CatalogStampTextValue value) {
                this.title = (CatalogStampTextValue)FunctionLoader.load((Object)this.title, (Layer)this, CatalogStampTextValue.class);
                return this;
            }

            public RecordLinks links(CatalogStampRecordLinks value) {
                this.links = (CatalogStampRecordLinks)FunctionLoader.load((Object)this.links, (Layer)this, CatalogStampRecordLinks.class);
                return this;
            }

            @Override
            public EditableStamp asEditable() {
                return (EditableStamp)this.a$(EditableStamp.class);
            }

            @Override
            public EditableStamp asEditable(StampSaveEvent onSave) {
                EditableStamp newElement = (EditableStamp)this.core$().addFacet(EditableStamp.class);
                newElement.core$().set((Layer)newElement, "onSave", Collections.singletonList(onSave));
                return newElement;
            }

            @Override
            public boolean isEditable() {
                return this.core$().is(EditableStamp.class);
            }

            @Override
            public void removeEditable() {
                this.core$().removeFacet(EditableStamp.class);
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                map.put("title", this.title != null ? new ArrayList<CatalogStampTextValue>(Collections.singletonList(this.title)) : Collections.emptyList());
                map.put("links", this.links != null ? new ArrayList<CatalogStampRecordLinks>(Collections.singletonList(this.links)) : Collections.emptyList());
                return map;
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("title")) {
                    this.title = (CatalogStampTextValue)FunctionLoader.load(values, (Layer)this, CatalogStampTextValue.class).get(0);
                } else if (name.equalsIgnoreCase("links")) {
                    this.links = (CatalogStampRecordLinks)FunctionLoader.load(values, (Layer)this, CatalogStampRecordLinks.class).get(0);
                }
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("title")) {
                    this.title = (CatalogStampTextValue)FunctionLoader.load(values.get(0), (Layer)this, CatalogStampTextValue.class);
                } else if (name.equalsIgnoreCase("links")) {
                    this.links = (CatalogStampRecordLinks)FunctionLoader.load(values.get(0), (Layer)this, CatalogStampRecordLinks.class);
                }
            }

            @Override
            public SumusGraph graph() {
                return (SumusGraph)this.core$().graph().as(SumusGraph.class);
            }
        }

        public static class Breadcrumbs
        extends Stamp
        implements Terminal {
            protected BreadcrumbsTree tree;

            public Breadcrumbs(Node node) {
                super(node);
            }

            public Tree tree(Record record, String username) {
                return this.tree.value(record, username);
            }

            public Breadcrumbs tree(BreadcrumbsTree value) {
                this.tree = (BreadcrumbsTree)FunctionLoader.load((Object)this.tree, (Layer)this, BreadcrumbsTree.class);
                return this;
            }

            @Override
            public EditableStamp asEditable() {
                return (EditableStamp)this.a$(EditableStamp.class);
            }

            @Override
            public EditableStamp asEditable(StampSaveEvent onSave) {
                EditableStamp newElement = (EditableStamp)this.core$().addFacet(EditableStamp.class);
                newElement.core$().set((Layer)newElement, "onSave", Collections.singletonList(onSave));
                return newElement;
            }

            @Override
            public boolean isEditable() {
                return this.core$().is(EditableStamp.class);
            }

            @Override
            public void removeEditable() {
                this.core$().removeFacet(EditableStamp.class);
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                map.put("tree", this.tree != null ? new ArrayList<BreadcrumbsTree>(Collections.singletonList(this.tree)) : Collections.emptyList());
                return map;
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("tree")) {
                    this.tree = (BreadcrumbsTree)FunctionLoader.load(values, (Layer)this, BreadcrumbsTree.class).get(0);
                }
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("tree")) {
                    this.tree = (BreadcrumbsTree)FunctionLoader.load(values.get(0), (Layer)this, BreadcrumbsTree.class);
                }
            }

            @Override
            public SumusGraph graph() {
                return (SumusGraph)this.core$().graph().as(SumusGraph.class);
            }
        }

        public static class Location
        extends Stamp
        implements Terminal {
            protected CatalogStampTextValue wkt;
            protected CatalogStampResourceValue icon;

            public Location(Node node) {
                super(node);
            }

            public String wkt(Record record) {
                return this.wkt.value(record);
            }

            public URL icon(Record record) {
                return this.icon.value(record);
            }

            public Location wkt(CatalogStampTextValue value) {
                this.wkt = (CatalogStampTextValue)FunctionLoader.load((Object)this.wkt, (Layer)this, CatalogStampTextValue.class);
                return this;
            }

            public Location icon(CatalogStampResourceValue value) {
                this.icon = (CatalogStampResourceValue)FunctionLoader.load((Object)this.icon, (Layer)this, CatalogStampResourceValue.class);
                return this;
            }

            @Override
            public EditableStamp asEditable() {
                return (EditableStamp)this.a$(EditableStamp.class);
            }

            @Override
            public EditableStamp asEditable(StampSaveEvent onSave) {
                EditableStamp newElement = (EditableStamp)this.core$().addFacet(EditableStamp.class);
                newElement.core$().set((Layer)newElement, "onSave", Collections.singletonList(onSave));
                return newElement;
            }

            @Override
            public boolean isEditable() {
                return this.core$().is(EditableStamp.class);
            }

            @Override
            public void removeEditable() {
                this.core$().removeFacet(EditableStamp.class);
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                map.put("wkt", this.wkt != null ? new ArrayList<CatalogStampTextValue>(Collections.singletonList(this.wkt)) : Collections.emptyList());
                map.put("icon", this.icon != null ? new ArrayList<CatalogStampResourceValue>(Collections.singletonList(this.icon)) : Collections.emptyList());
                return map;
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("wkt")) {
                    this.wkt = (CatalogStampTextValue)FunctionLoader.load(values, (Layer)this, CatalogStampTextValue.class).get(0);
                } else if (name.equalsIgnoreCase("icon")) {
                    this.icon = (CatalogStampResourceValue)FunctionLoader.load(values, (Layer)this, CatalogStampResourceValue.class).get(0);
                }
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("wkt")) {
                    this.wkt = (CatalogStampTextValue)FunctionLoader.load(values.get(0), (Layer)this, CatalogStampTextValue.class);
                } else if (name.equalsIgnoreCase("icon")) {
                    this.icon = (CatalogStampResourceValue)FunctionLoader.load(values.get(0), (Layer)this, CatalogStampResourceValue.class);
                }
            }

            @Override
            public SumusGraph graph() {
                return (SumusGraph)this.core$().graph().as(SumusGraph.class);
            }
        }

        public static class TaskOperation
        extends Operation
        implements Terminal {
            protected CatalogStampTask task;

            public TaskOperation(Node node) {
                super(node);
            }

            public void task(Record record, String username) {
                this.task.task(record, username);
            }

            public TaskOperation task(CatalogStampTask value) {
                this.task = (CatalogStampTask)FunctionLoader.load((Object)this.task, (Layer)this, CatalogStampTask.class);
                return this;
            }

            @Override
            public EditableStamp asEditable() {
                return (EditableStamp)this.a$(EditableStamp.class);
            }

            @Override
            public EditableStamp asEditable(StampSaveEvent onSave) {
                EditableStamp newElement = (EditableStamp)this.core$().addFacet(EditableStamp.class);
                newElement.core$().set((Layer)newElement, "onSave", Collections.singletonList(onSave));
                return newElement;
            }

            @Override
            public boolean isEditable() {
                return this.core$().is(EditableStamp.class);
            }

            @Override
            public void removeEditable() {
                this.core$().removeFacet(EditableStamp.class);
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                map.put("task", this.task != null ? new ArrayList<CatalogStampTask>(Collections.singletonList(this.task)) : Collections.emptyList());
                return map;
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("task")) {
                    this.task = (CatalogStampTask)FunctionLoader.load(values, (Layer)this, CatalogStampTask.class).get(0);
                }
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("task")) {
                    this.task = (CatalogStampTask)FunctionLoader.load(values.get(0), (Layer)this, CatalogStampTask.class);
                }
            }

            @Override
            public SumusGraph graph() {
                return (SumusGraph)this.core$().graph().as(SumusGraph.class);
            }
        }

        public static class ExportOperation
        extends Operation
        implements Terminal {
            protected String title;
            protected List<String> options = new ArrayList<String>();
            protected Instant from;
            protected Instant to;
            protected CatalogStampExport execute;

            public ExportOperation(Node node) {
                super(node);
            }

            public String title() {
                return this.title;
            }

            public List<String> options() {
                return this.options;
            }

            public String options(int index) {
                return this.options.get(index);
            }

            public List<String> options(Predicate<String> predicate) {
                return this.options().stream().filter(predicate).collect(Collectors.toList());
            }

            public Instant from() {
                return this.from;
            }

            public Instant to() {
                return this.to;
            }

            public Resource execute(Record record, Instant from, Instant to, String option, String username) {
                return this.execute.export(record, from, to, option, username);
            }

            public ExportOperation title(String value) {
                this.title = value;
                return this;
            }

            public ExportOperation from(Instant value) {
                this.from = value;
                return this;
            }

            public ExportOperation to(Instant value) {
                this.to = value;
                return this;
            }

            public ExportOperation execute(CatalogStampExport value) {
                this.execute = (CatalogStampExport)FunctionLoader.load((Object)this.execute, (Layer)this, CatalogStampExport.class);
                return this;
            }

            @Override
            public EditableStamp asEditable() {
                return (EditableStamp)this.a$(EditableStamp.class);
            }

            @Override
            public EditableStamp asEditable(StampSaveEvent onSave) {
                EditableStamp newElement = (EditableStamp)this.core$().addFacet(EditableStamp.class);
                newElement.core$().set((Layer)newElement, "onSave", Collections.singletonList(onSave));
                return newElement;
            }

            @Override
            public boolean isEditable() {
                return this.core$().is(EditableStamp.class);
            }

            @Override
            public void removeEditable() {
                this.core$().removeFacet(EditableStamp.class);
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                map.put("title", new ArrayList<String>(Collections.singletonList(this.title)));
                map.put("options", this.options);
                map.put("from", new ArrayList<Instant>(Collections.singletonList(this.from)));
                map.put("to", new ArrayList<Instant>(Collections.singletonList(this.to)));
                map.put("execute", this.execute != null ? new ArrayList<CatalogStampExport>(Collections.singletonList(this.execute)) : Collections.emptyList());
                return map;
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("title")) {
                    this.title = (String)StringLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("options")) {
                    this.options = StringLoader.load(values, (Layer)this);
                } else if (name.equalsIgnoreCase("from")) {
                    this.from = (Instant)InstantLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("to")) {
                    this.to = (Instant)InstantLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("execute")) {
                    this.execute = (CatalogStampExport)FunctionLoader.load(values, (Layer)this, CatalogStampExport.class).get(0);
                }
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("title")) {
                    this.title = (String)values.get(0);
                } else if (name.equalsIgnoreCase("options")) {
                    this.options = new ArrayList(values);
                } else if (name.equalsIgnoreCase("from")) {
                    this.from = (Instant)values.get(0);
                } else if (name.equalsIgnoreCase("to")) {
                    this.to = (Instant)values.get(0);
                } else if (name.equalsIgnoreCase("execute")) {
                    this.execute = (CatalogStampExport)FunctionLoader.load(values.get(0), (Layer)this, CatalogStampExport.class);
                }
            }

            @Override
            public SumusGraph graph() {
                return (SumusGraph)this.core$().graph().as(SumusGraph.class);
            }
        }

        public static class DownloadOperation
        extends Operation
        implements Terminal {
            protected String title;
            protected List<String> options = new ArrayList<String>();
            protected CatalogStampDownload execute;

            public DownloadOperation(Node node) {
                super(node);
            }

            public String title() {
                return this.title;
            }

            public List<String> options() {
                return this.options;
            }

            public String options(int index) {
                return this.options.get(index);
            }

            public List<String> options(Predicate<String> predicate) {
                return this.options().stream().filter(predicate).collect(Collectors.toList());
            }

            public Resource execute(Record record, String option) {
                return this.execute.download(record, option);
            }

            public DownloadOperation title(String value) {
                this.title = value;
                return this;
            }

            public DownloadOperation execute(CatalogStampDownload value) {
                this.execute = (CatalogStampDownload)FunctionLoader.load((Object)this.execute, (Layer)this, CatalogStampDownload.class);
                return this;
            }

            @Override
            public EditableStamp asEditable() {
                return (EditableStamp)this.a$(EditableStamp.class);
            }

            @Override
            public EditableStamp asEditable(StampSaveEvent onSave) {
                EditableStamp newElement = (EditableStamp)this.core$().addFacet(EditableStamp.class);
                newElement.core$().set((Layer)newElement, "onSave", Collections.singletonList(onSave));
                return newElement;
            }

            @Override
            public boolean isEditable() {
                return this.core$().is(EditableStamp.class);
            }

            @Override
            public void removeEditable() {
                this.core$().removeFacet(EditableStamp.class);
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                map.put("title", new ArrayList<String>(Collections.singletonList(this.title)));
                map.put("options", this.options);
                map.put("execute", this.execute != null ? new ArrayList<CatalogStampDownload>(Collections.singletonList(this.execute)) : Collections.emptyList());
                return map;
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("title")) {
                    this.title = (String)StringLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("options")) {
                    this.options = StringLoader.load(values, (Layer)this);
                } else if (name.equalsIgnoreCase("execute")) {
                    this.execute = (CatalogStampDownload)FunctionLoader.load(values, (Layer)this, CatalogStampDownload.class).get(0);
                }
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("title")) {
                    this.title = (String)values.get(0);
                } else if (name.equalsIgnoreCase("options")) {
                    this.options = new ArrayList(values);
                } else if (name.equalsIgnoreCase("execute")) {
                    this.execute = (CatalogStampDownload)FunctionLoader.load(values.get(0), (Layer)this, CatalogStampDownload.class);
                }
            }

            @Override
            public SumusGraph graph() {
                return (SumusGraph)this.core$().graph().as(SumusGraph.class);
            }
        }

        public static class OpenDialogOperation
        extends Operation
        implements Terminal {
            protected int width;
            protected ItemExternalPath path;

            public OpenDialogOperation(Node node) {
                super(node);
            }

            public int width() {
                return this.width;
            }

            public String path(String item) {
                return this.path.path(item);
            }

            public OpenDialogOperation width(int value) {
                this.width = value;
                return this;
            }

            public OpenDialogOperation path(ItemExternalPath value) {
                this.path = (ItemExternalPath)FunctionLoader.load((Object)this.path, (Layer)this, ItemExternalPath.class);
                return this;
            }

            @Override
            public EditableStamp asEditable() {
                return (EditableStamp)this.a$(EditableStamp.class);
            }

            @Override
            public EditableStamp asEditable(StampSaveEvent onSave) {
                EditableStamp newElement = (EditableStamp)this.core$().addFacet(EditableStamp.class);
                newElement.core$().set((Layer)newElement, "onSave", Collections.singletonList(onSave));
                return newElement;
            }

            @Override
            public boolean isEditable() {
                return this.core$().is(EditableStamp.class);
            }

            @Override
            public void removeEditable() {
                this.core$().removeFacet(EditableStamp.class);
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                map.put("width", new ArrayList<Integer>(Collections.singletonList(this.width)));
                map.put("path", this.path != null ? new ArrayList<ItemExternalPath>(Collections.singletonList(this.path)) : Collections.emptyList());
                return map;
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("width")) {
                    this.width = (Integer)IntegerLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("path")) {
                    this.path = (ItemExternalPath)FunctionLoader.load(values, (Layer)this, ItemExternalPath.class).get(0);
                }
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("width")) {
                    this.width = (Integer)values.get(0);
                } else if (name.equalsIgnoreCase("path")) {
                    this.path = (ItemExternalPath)FunctionLoader.load(values.get(0), (Layer)this, ItemExternalPath.class);
                }
            }

            @Override
            public SumusGraph graph() {
                return (SumusGraph)this.core$().graph().as(SumusGraph.class);
            }
        }

        public static abstract class Operation
        extends Stamp
        implements Terminal {
            public Operation(Node node) {
                super(node);
            }

            @Override
            public EditableStamp asEditable() {
                return (EditableStamp)this.a$(EditableStamp.class);
            }

            @Override
            public EditableStamp asEditable(StampSaveEvent onSave) {
                EditableStamp newElement = (EditableStamp)this.core$().addFacet(EditableStamp.class);
                newElement.core$().set((Layer)newElement, "onSave", Collections.singletonList(onSave));
                return newElement;
            }

            @Override
            public boolean isEditable() {
                return this.core$().is(EditableStamp.class);
            }

            @Override
            public void removeEditable() {
                this.core$().removeFacet(EditableStamp.class);
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                return map;
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
            }

            @Override
            public Create create() {
                return new Create(null);
            }

            @Override
            public Create create(String name) {
                return new Create(name);
            }

            @Override
            public SumusGraph graph() {
                return (SumusGraph)this.core$().graph().as(SumusGraph.class);
            }

            public class Create
            extends Stamp.Create {
                public Create(String name) {
                    super(name);
                }
            }
        }

        public static class Rating
        extends Stamp
        implements Terminal {
            protected CatalogStampDoubleValue rating;
            protected String ratingIcon;

            public Rating(Node node) {
                super(node);
            }

            public double rating(Record record) {
                return this.rating.rating(record);
            }

            public String ratingIcon() {
                return this.ratingIcon;
            }

            public Rating rating(CatalogStampDoubleValue value) {
                this.rating = (CatalogStampDoubleValue)FunctionLoader.load((Object)this.rating, (Layer)this, CatalogStampDoubleValue.class);
                return this;
            }

            public Rating ratingIcon(String value) {
                this.ratingIcon = value;
                return this;
            }

            @Override
            public EditableStamp asEditable() {
                return (EditableStamp)this.a$(EditableStamp.class);
            }

            @Override
            public EditableStamp asEditable(StampSaveEvent onSave) {
                EditableStamp newElement = (EditableStamp)this.core$().addFacet(EditableStamp.class);
                newElement.core$().set((Layer)newElement, "onSave", Collections.singletonList(onSave));
                return newElement;
            }

            @Override
            public boolean isEditable() {
                return this.core$().is(EditableStamp.class);
            }

            @Override
            public void removeEditable() {
                this.core$().removeFacet(EditableStamp.class);
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                map.put("rating", this.rating != null ? new ArrayList<CatalogStampDoubleValue>(Collections.singletonList(this.rating)) : Collections.emptyList());
                map.put("ratingIcon", new ArrayList<String>(Collections.singletonList(this.ratingIcon)));
                return map;
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("rating")) {
                    this.rating = (CatalogStampDoubleValue)FunctionLoader.load(values, (Layer)this, CatalogStampDoubleValue.class).get(0);
                } else if (name.equalsIgnoreCase("ratingIcon")) {
                    this.ratingIcon = (String)StringLoader.load(values, (Layer)this).get(0);
                }
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("rating")) {
                    this.rating = (CatalogStampDoubleValue)FunctionLoader.load(values.get(0), (Layer)this, CatalogStampDoubleValue.class);
                } else if (name.equalsIgnoreCase("ratingIcon")) {
                    this.ratingIcon = (String)values.get(0);
                }
            }

            @Override
            public SumusGraph graph() {
                return (SumusGraph)this.core$().graph().as(SumusGraph.class);
            }
        }

        public static class Description
        extends Stamp
        implements Terminal {
            protected CatalogStampTextValue description;

            public Description(Node node) {
                super(node);
            }

            public String description(Record record) {
                return this.description.value(record);
            }

            public Description description(CatalogStampTextValue value) {
                this.description = (CatalogStampTextValue)FunctionLoader.load((Object)this.description, (Layer)this, CatalogStampTextValue.class);
                return this;
            }

            @Override
            public EditableStamp asEditable() {
                return (EditableStamp)this.a$(EditableStamp.class);
            }

            @Override
            public EditableStamp asEditable(StampSaveEvent onSave) {
                EditableStamp newElement = (EditableStamp)this.core$().addFacet(EditableStamp.class);
                newElement.core$().set((Layer)newElement, "onSave", Collections.singletonList(onSave));
                return newElement;
            }

            @Override
            public boolean isEditable() {
                return this.core$().is(EditableStamp.class);
            }

            @Override
            public void removeEditable() {
                this.core$().removeFacet(EditableStamp.class);
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                map.put("description", this.description != null ? new ArrayList<CatalogStampTextValue>(Collections.singletonList(this.description)) : Collections.emptyList());
                return map;
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("description")) {
                    this.description = (CatalogStampTextValue)FunctionLoader.load(values, (Layer)this, CatalogStampTextValue.class).get(0);
                }
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("description")) {
                    this.description = (CatalogStampTextValue)FunctionLoader.load(values.get(0), (Layer)this, CatalogStampTextValue.class);
                }
            }

            @Override
            public SumusGraph graph() {
                return (SumusGraph)this.core$().graph().as(SumusGraph.class);
            }
        }

        public static class Title
        extends Stamp
        implements Terminal {
            protected CatalogStampTextValue title;

            public Title(Node node) {
                super(node);
            }

            public String title(Record record) {
                return this.title.value(record);
            }

            public Title title(CatalogStampTextValue value) {
                this.title = (CatalogStampTextValue)FunctionLoader.load((Object)this.title, (Layer)this, CatalogStampTextValue.class);
                return this;
            }

            @Override
            public EditableStamp asEditable() {
                return (EditableStamp)this.a$(EditableStamp.class);
            }

            @Override
            public EditableStamp asEditable(StampSaveEvent onSave) {
                EditableStamp newElement = (EditableStamp)this.core$().addFacet(EditableStamp.class);
                newElement.core$().set((Layer)newElement, "onSave", Collections.singletonList(onSave));
                return newElement;
            }

            @Override
            public boolean isEditable() {
                return this.core$().is(EditableStamp.class);
            }

            @Override
            public void removeEditable() {
                this.core$().removeFacet(EditableStamp.class);
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                map.put("title", this.title != null ? new ArrayList<CatalogStampTextValue>(Collections.singletonList(this.title)) : Collections.emptyList());
                return map;
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("title")) {
                    this.title = (CatalogStampTextValue)FunctionLoader.load(values, (Layer)this, CatalogStampTextValue.class).get(0);
                }
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("title")) {
                    this.title = (CatalogStampTextValue)FunctionLoader.load(values.get(0), (Layer)this, CatalogStampTextValue.class);
                }
            }

            @Override
            public SumusGraph graph() {
                return (SumusGraph)this.core$().graph().as(SumusGraph.class);
            }
        }

        public static class Highlight
        extends Stamp
        implements Terminal {
            protected CatalogStampTextValue value;
            protected CatalogStampColor color;

            public Highlight(Node node) {
                super(node);
            }

            public String value(Record record) {
                return this.value.value(record);
            }

            public String color(Record record) {
                return this.color.color(record);
            }

            public Highlight value(CatalogStampTextValue value) {
                this.value = (CatalogStampTextValue)FunctionLoader.load((Object)value, (Layer)this, CatalogStampTextValue.class);
                return this;
            }

            public Highlight color(CatalogStampColor value) {
                this.color = (CatalogStampColor)FunctionLoader.load((Object)this.color, (Layer)this, CatalogStampColor.class);
                return this;
            }

            @Override
            public EditableStamp asEditable() {
                return (EditableStamp)this.a$(EditableStamp.class);
            }

            @Override
            public EditableStamp asEditable(StampSaveEvent onSave) {
                EditableStamp newElement = (EditableStamp)this.core$().addFacet(EditableStamp.class);
                newElement.core$().set((Layer)newElement, "onSave", Collections.singletonList(onSave));
                return newElement;
            }

            @Override
            public boolean isEditable() {
                return this.core$().is(EditableStamp.class);
            }

            @Override
            public void removeEditable() {
                this.core$().removeFacet(EditableStamp.class);
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                map.put("value", this.value != null ? new ArrayList<CatalogStampTextValue>(Collections.singletonList(this.value)) : Collections.emptyList());
                map.put("color", this.color != null ? new ArrayList<CatalogStampColor>(Collections.singletonList(this.color)) : Collections.emptyList());
                return map;
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("value")) {
                    this.value = (CatalogStampTextValue)FunctionLoader.load(values, (Layer)this, CatalogStampTextValue.class).get(0);
                } else if (name.equalsIgnoreCase("color")) {
                    this.color = (CatalogStampColor)FunctionLoader.load(values, (Layer)this, CatalogStampColor.class).get(0);
                }
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("value")) {
                    this.value = (CatalogStampTextValue)FunctionLoader.load(values.get(0), (Layer)this, CatalogStampTextValue.class);
                } else if (name.equalsIgnoreCase("color")) {
                    this.color = (CatalogStampColor)FunctionLoader.load(values.get(0), (Layer)this, CatalogStampColor.class);
                }
            }

            @Override
            public SumusGraph graph() {
                return (SumusGraph)this.core$().graph().as(SumusGraph.class);
            }
        }

        public static class ResourceIcon
        extends Icon
        implements Terminal {
            protected CatalogStampResourceValue icon;

            public ResourceIcon(Node node) {
                super(node);
            }

            public URL icon(Record record) {
                return this.icon.value(record);
            }

            public ResourceIcon icon(CatalogStampResourceValue value) {
                this.icon = (CatalogStampResourceValue)FunctionLoader.load((Object)this.icon, (Layer)this, CatalogStampResourceValue.class);
                return this;
            }

            @Override
            public EditableStamp asEditable() {
                return (EditableStamp)this.a$(EditableStamp.class);
            }

            @Override
            public EditableStamp asEditable(StampSaveEvent onSave) {
                EditableStamp newElement = (EditableStamp)this.core$().addFacet(EditableStamp.class);
                newElement.core$().set((Layer)newElement, "onSave", Collections.singletonList(onSave));
                return newElement;
            }

            @Override
            public boolean isEditable() {
                return this.core$().is(EditableStamp.class);
            }

            @Override
            public void removeEditable() {
                this.core$().removeFacet(EditableStamp.class);
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                map.put("icon", this.icon != null ? new ArrayList<CatalogStampResourceValue>(Collections.singletonList(this.icon)) : Collections.emptyList());
                return map;
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("icon")) {
                    this.icon = (CatalogStampResourceValue)FunctionLoader.load(values, (Layer)this, CatalogStampResourceValue.class).get(0);
                }
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("icon")) {
                    this.icon = (CatalogStampResourceValue)FunctionLoader.load(values.get(0), (Layer)this, CatalogStampResourceValue.class);
                }
            }

            @Override
            public SumusGraph graph() {
                return (SumusGraph)this.core$().graph().as(SumusGraph.class);
            }
        }

        public static class Base64Icon
        extends Icon
        implements Terminal {
            protected CatalogStampTextValue icon;

            public Base64Icon(Node node) {
                super(node);
            }

            public String icon(Record record) {
                return this.icon.value(record);
            }

            public Base64Icon icon(CatalogStampTextValue value) {
                this.icon = (CatalogStampTextValue)FunctionLoader.load((Object)this.icon, (Layer)this, CatalogStampTextValue.class);
                return this;
            }

            @Override
            public EditableStamp asEditable() {
                return (EditableStamp)this.a$(EditableStamp.class);
            }

            @Override
            public EditableStamp asEditable(StampSaveEvent onSave) {
                EditableStamp newElement = (EditableStamp)this.core$().addFacet(EditableStamp.class);
                newElement.core$().set((Layer)newElement, "onSave", Collections.singletonList(onSave));
                return newElement;
            }

            @Override
            public boolean isEditable() {
                return this.core$().is(EditableStamp.class);
            }

            @Override
            public void removeEditable() {
                this.core$().removeFacet(EditableStamp.class);
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                map.put("icon", this.icon != null ? new ArrayList<CatalogStampTextValue>(Collections.singletonList(this.icon)) : Collections.emptyList());
                return map;
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("icon")) {
                    this.icon = (CatalogStampTextValue)FunctionLoader.load(values, (Layer)this, CatalogStampTextValue.class).get(0);
                }
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("icon")) {
                    this.icon = (CatalogStampTextValue)FunctionLoader.load(values.get(0), (Layer)this, CatalogStampTextValue.class);
                }
            }

            @Override
            public SumusGraph graph() {
                return (SumusGraph)this.core$().graph().as(SumusGraph.class);
            }
        }

        public static class SumusIcon
        extends Icon
        implements Terminal {
            protected CatalogStampTextValue icon;

            public SumusIcon(Node node) {
                super(node);
            }

            public String icon(Record record) {
                return this.icon.value(record);
            }

            public SumusIcon icon(CatalogStampTextValue value) {
                this.icon = (CatalogStampTextValue)FunctionLoader.load((Object)this.icon, (Layer)this, CatalogStampTextValue.class);
                return this;
            }

            @Override
            public EditableStamp asEditable() {
                return (EditableStamp)this.a$(EditableStamp.class);
            }

            @Override
            public EditableStamp asEditable(StampSaveEvent onSave) {
                EditableStamp newElement = (EditableStamp)this.core$().addFacet(EditableStamp.class);
                newElement.core$().set((Layer)newElement, "onSave", Collections.singletonList(onSave));
                return newElement;
            }

            @Override
            public boolean isEditable() {
                return this.core$().is(EditableStamp.class);
            }

            @Override
            public void removeEditable() {
                this.core$().removeFacet(EditableStamp.class);
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                map.put("icon", this.icon != null ? new ArrayList<CatalogStampTextValue>(Collections.singletonList(this.icon)) : Collections.emptyList());
                return map;
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("icon")) {
                    this.icon = (CatalogStampTextValue)FunctionLoader.load(values, (Layer)this, CatalogStampTextValue.class).get(0);
                }
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("icon")) {
                    this.icon = (CatalogStampTextValue)FunctionLoader.load(values.get(0), (Layer)this, CatalogStampTextValue.class);
                }
            }

            @Override
            public SumusGraph graph() {
                return (SumusGraph)this.core$().graph().as(SumusGraph.class);
            }
        }

        public static abstract class Icon
        extends Stamp
        implements Terminal {
            protected CatalogStampTextValue title;

            public Icon(Node node) {
                super(node);
            }

            public String title(Record record) {
                return this.title.value(record);
            }

            public Icon title(CatalogStampTextValue value) {
                this.title = (CatalogStampTextValue)FunctionLoader.load((Object)this.title, (Layer)this, CatalogStampTextValue.class);
                return this;
            }

            @Override
            public EditableStamp asEditable() {
                return (EditableStamp)this.a$(EditableStamp.class);
            }

            @Override
            public EditableStamp asEditable(StampSaveEvent onSave) {
                EditableStamp newElement = (EditableStamp)this.core$().addFacet(EditableStamp.class);
                newElement.core$().set((Layer)newElement, "onSave", Collections.singletonList(onSave));
                return newElement;
            }

            @Override
            public boolean isEditable() {
                return this.core$().is(EditableStamp.class);
            }

            @Override
            public void removeEditable() {
                this.core$().removeFacet(EditableStamp.class);
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                map.put("title", this.title != null ? new ArrayList<CatalogStampTextValue>(Collections.singletonList(this.title)) : Collections.emptyList());
                return map;
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("title")) {
                    this.title = (CatalogStampTextValue)FunctionLoader.load(values, (Layer)this, CatalogStampTextValue.class).get(0);
                }
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("title")) {
                    this.title = (CatalogStampTextValue)FunctionLoader.load(values.get(0), (Layer)this, CatalogStampTextValue.class);
                }
            }

            @Override
            public Create create() {
                return new Create(null);
            }

            @Override
            public Create create(String name) {
                return new Create(name);
            }

            @Override
            public SumusGraph graph() {
                return (SumusGraph)this.core$().graph().as(SumusGraph.class);
            }

            public class Create
            extends Stamp.Create {
                public Create(String name) {
                    super(name);
                }
            }
        }

        public static class Picture
        extends Stamp
        implements Terminal {
            protected CatalogStampPictureValue picture;
            protected URL defaultPicture;

            public Picture(Node node) {
                super(node);
            }

            public List<URL> picture(Record record) {
                return this.picture.pictures(record);
            }

            public URL defaultPicture() {
                return this.defaultPicture;
            }

            public Picture picture(CatalogStampPictureValue value) {
                this.picture = (CatalogStampPictureValue)FunctionLoader.load((Object)this.picture, (Layer)this, CatalogStampPictureValue.class);
                return this;
            }

            public Picture defaultPicture(URL url, String destiny) {
                this.defaultPicture = this.graph().core$().save(url, destiny, this.defaultPicture, this.core$());
                return this;
            }

            public Picture defaultPicture(InputStream stream, String destiny) {
                this.defaultPicture = this.graph().core$().save(stream, destiny, this.defaultPicture, this.core$());
                return this;
            }

            @Override
            public EditableStamp asEditable() {
                return (EditableStamp)this.a$(EditableStamp.class);
            }

            @Override
            public EditableStamp asEditable(StampSaveEvent onSave) {
                EditableStamp newElement = (EditableStamp)this.core$().addFacet(EditableStamp.class);
                newElement.core$().set((Layer)newElement, "onSave", Collections.singletonList(onSave));
                return newElement;
            }

            @Override
            public boolean isEditable() {
                return this.core$().is(EditableStamp.class);
            }

            @Override
            public void removeEditable() {
                this.core$().removeFacet(EditableStamp.class);
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                map.put("picture", this.picture != null ? new ArrayList<CatalogStampPictureValue>(Collections.singletonList(this.picture)) : Collections.emptyList());
                map.put("defaultPicture", new ArrayList<URL>(Collections.singletonList(this.defaultPicture)));
                return map;
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("picture")) {
                    this.picture = (CatalogStampPictureValue)FunctionLoader.load(values, (Layer)this, CatalogStampPictureValue.class).get(0);
                } else if (name.equalsIgnoreCase("defaultPicture")) {
                    this.defaultPicture = (URL)ResourceLoader.load(values, (Layer)this).get(0);
                }
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("picture")) {
                    this.picture = (CatalogStampPictureValue)FunctionLoader.load(values.get(0), (Layer)this, CatalogStampPictureValue.class);
                } else if (name.equalsIgnoreCase("defaultPicture")) {
                    this.defaultPicture = (URL)values.get(0);
                }
            }

            @Override
            public SumusGraph graph() {
                return (SumusGraph)this.core$().graph().as(SumusGraph.class);
            }
        }

        public static abstract class Stamp
        extends Layer
        implements Terminal {
            protected String label;
            protected CatalogStampValue internalValue;
            protected Layout layout;
            protected int height;
            protected String suffix;
            protected String defaultStyle;
            protected CatalogStampTextValue style;

            public Stamp(Node node) {
                super(node);
            }

            public String label() {
                return this.label;
            }

            public Object internalValue(Record record, String username) {
                return this.internalValue.value(record, username);
            }

            public Layout layout() {
                return this.layout;
            }

            public int height() {
                return this.height;
            }

            public String suffix() {
                return this.suffix;
            }

            public String defaultStyle() {
                return this.defaultStyle;
            }

            public String style(Record record) {
                return this.style.value(record);
            }

            public Stamp label(String value) {
                this.label = value;
                return this;
            }

            public Stamp internalValue(CatalogStampValue value) {
                this.internalValue = (CatalogStampValue)FunctionLoader.load((Object)this.internalValue, (Layer)this, CatalogStampValue.class);
                return this;
            }

            public Stamp layout(Layout value) {
                this.layout = value;
                return this;
            }

            public Stamp height(int value) {
                this.height = value;
                return this;
            }

            public Stamp suffix(String value) {
                this.suffix = value;
                return this;
            }

            public Stamp defaultStyle(String value) {
                this.defaultStyle = value;
                return this;
            }

            public Stamp style(CatalogStampTextValue value) {
                this.style = (CatalogStampTextValue)FunctionLoader.load((Object)this.style, (Layer)this, CatalogStampTextValue.class);
                return this;
            }

            public EditableStamp asEditable() {
                return (EditableStamp)this.a$(EditableStamp.class);
            }

            public EditableStamp asEditable(StampSaveEvent onSave) {
                EditableStamp newElement = (EditableStamp)this.core$().addFacet(EditableStamp.class);
                newElement.core$().set((Layer)newElement, "onSave", Collections.singletonList(onSave));
                return newElement;
            }

            public boolean isEditable() {
                return this.core$().is(EditableStamp.class);
            }

            public void removeEditable() {
                this.core$().removeFacet(EditableStamp.class);
            }

            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap();
                map.put("label", new ArrayList<String>(Collections.singletonList(this.label)));
                map.put("internalValue", this.internalValue != null ? new ArrayList<CatalogStampValue>(Collections.singletonList(this.internalValue)) : Collections.emptyList());
                map.put("layout", new ArrayList<Layout>(Collections.singletonList(this.layout)));
                map.put("height", new ArrayList<Integer>(Collections.singletonList(this.height)));
                map.put("suffix", new ArrayList<String>(Collections.singletonList(this.suffix)));
                map.put("defaultStyle", new ArrayList<String>(Collections.singletonList(this.defaultStyle)));
                map.put("style", this.style != null ? new ArrayList<CatalogStampTextValue>(Collections.singletonList(this.style)) : Collections.emptyList());
                return map;
            }

            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("label")) {
                    this.label = (String)StringLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("internalValue")) {
                    this.internalValue = (CatalogStampValue)FunctionLoader.load(values, (Layer)this, CatalogStampValue.class).get(0);
                } else if (name.equalsIgnoreCase("layout")) {
                    this.layout = (Layout)((Object)WordLoader.load(values, Layout.class, (Layer)this).get(0));
                } else if (name.equalsIgnoreCase("height")) {
                    this.height = (Integer)IntegerLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("suffix")) {
                    this.suffix = (String)StringLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("defaultStyle")) {
                    this.defaultStyle = (String)StringLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("style")) {
                    this.style = (CatalogStampTextValue)FunctionLoader.load(values, (Layer)this, CatalogStampTextValue.class).get(0);
                }
            }

            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("label")) {
                    this.label = (String)values.get(0);
                } else if (name.equalsIgnoreCase("internalValue")) {
                    this.internalValue = (CatalogStampValue)FunctionLoader.load(values.get(0), (Layer)this, CatalogStampValue.class);
                } else if (name.equalsIgnoreCase("layout")) {
                    this.layout = (Layout)((Object)values.get(0));
                } else if (name.equalsIgnoreCase("height")) {
                    this.height = (Integer)values.get(0);
                } else if (name.equalsIgnoreCase("suffix")) {
                    this.suffix = (String)values.get(0);
                } else if (name.equalsIgnoreCase("defaultStyle")) {
                    this.defaultStyle = (String)values.get(0);
                } else if (name.equalsIgnoreCase("style")) {
                    this.style = (CatalogStampTextValue)FunctionLoader.load(values.get(0), (Layer)this, CatalogStampTextValue.class);
                }
            }

            public Create create() {
                return new Create(null);
            }

            public Create create(String name) {
                return new Create(name);
            }

            public SumusGraph graph() {
                return (SumusGraph)this.core$().graph().as(SumusGraph.class);
            }

            public class Create {
                protected final String name;

                public Create(String name) {
                    this.name = name;
                }
            }

            public static enum Layout {
                Fixed,
                Flexible;

            }
        }

        public class Clear {
            public void block(Predicate<Block> filter) {
                new ArrayList<Block>(Block.this.blockList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void picture(Predicate<Picture> filter) {
                new ArrayList<Picture>(Block.this.pictureList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void sumusIcon(Predicate<SumusIcon> filter) {
                new ArrayList<SumusIcon>(Block.this.sumusIconList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void base64Icon(Predicate<Base64Icon> filter) {
                new ArrayList<Base64Icon>(Block.this.base64IconList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void resourceIcon(Predicate<ResourceIcon> filter) {
                new ArrayList<ResourceIcon>(Block.this.resourceIconList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void highlight(Predicate<Highlight> filter) {
                new ArrayList<Highlight>(Block.this.highlightList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void title(Predicate<Title> filter) {
                new ArrayList<Title>(Block.this.titleList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void description(Predicate<Description> filter) {
                new ArrayList<Description>(Block.this.descriptionList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void rating(Predicate<Rating> filter) {
                new ArrayList<Rating>(Block.this.ratingList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void openDialogOperation(Predicate<OpenDialogOperation> filter) {
                new ArrayList<OpenDialogOperation>(Block.this.openDialogOperationList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void downloadOperation(Predicate<DownloadOperation> filter) {
                new ArrayList<DownloadOperation>(Block.this.downloadOperationList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void exportOperation(Predicate<ExportOperation> filter) {
                new ArrayList<ExportOperation>(Block.this.exportOperationList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void taskOperation(Predicate<TaskOperation> filter) {
                new ArrayList<TaskOperation>(Block.this.taskOperationList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void location(Predicate<Location> filter) {
                new ArrayList<Location>(Block.this.locationList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void breadcrumbs(Predicate<Breadcrumbs> filter) {
                new ArrayList<Breadcrumbs>(Block.this.breadcrumbsList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void recordLinks(Predicate<RecordLinks> filter) {
                new ArrayList<RecordLinks>(Block.this.recordLinksList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void catalogLink(Predicate<CatalogLink> filter) {
                new ArrayList<CatalogLink>(Block.this.catalogLinkList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void display(Predicate<Display> filter) {
                new ArrayList<Display>(Block.this.displayList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void internalPage(Predicate<InternalPage> filter) {
                new ArrayList<InternalPage>(Block.this.internalPageList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void externalPage(Predicate<ExternalPage> filter) {
                new ArrayList<ExternalPage>(Block.this.externalPageList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void snippet(Predicate<Snippet> filter) {
                new ArrayList<Snippet>(Block.this.snippetList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void embeddedCatalog(Predicate<EmbeddedCatalog> filter) {
                new ArrayList<EmbeddedCatalog>(Block.this.embeddedCatalogList()).stream().filter(filter).forEach(Layer::delete$);
            }
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }

            public Block block() {
                Block newElement = (Block)Block.this.core$().graph().concept(Block.class).createNode(this.name, Block.this.core$()).as(Block.class);
                return newElement;
            }

            public Picture picture(URL defaultPicture) {
                Picture newElement = (Picture)Block.this.core$().graph().concept(Picture.class).createNode(this.name, Block.this.core$()).as(Picture.class);
                newElement.core$().set((Layer)newElement, "defaultPicture", Collections.singletonList(defaultPicture));
                return newElement;
            }

            public SumusIcon sumusIcon(CatalogStampTextValue icon) {
                SumusIcon newElement = (SumusIcon)Block.this.core$().graph().concept(SumusIcon.class).createNode(this.name, Block.this.core$()).as(SumusIcon.class);
                newElement.core$().set((Layer)newElement, "icon", Collections.singletonList(icon));
                return newElement;
            }

            public Base64Icon base64Icon(CatalogStampTextValue icon) {
                Base64Icon newElement = (Base64Icon)Block.this.core$().graph().concept(Base64Icon.class).createNode(this.name, Block.this.core$()).as(Base64Icon.class);
                newElement.core$().set((Layer)newElement, "icon", Collections.singletonList(icon));
                return newElement;
            }

            public ResourceIcon resourceIcon(CatalogStampResourceValue icon) {
                ResourceIcon newElement = (ResourceIcon)Block.this.core$().graph().concept(ResourceIcon.class).createNode(this.name, Block.this.core$()).as(ResourceIcon.class);
                newElement.core$().set((Layer)newElement, "icon", Collections.singletonList(icon));
                return newElement;
            }

            public Highlight highlight(CatalogStampTextValue value, CatalogStampColor color) {
                Highlight newElement = (Highlight)Block.this.core$().graph().concept(Highlight.class).createNode(this.name, Block.this.core$()).as(Highlight.class);
                newElement.core$().set((Layer)newElement, "value", Collections.singletonList(value));
                newElement.core$().set((Layer)newElement, "color", Collections.singletonList(color));
                return newElement;
            }

            public Title title(CatalogStampTextValue title) {
                Title newElement = (Title)Block.this.core$().graph().concept(Title.class).createNode(this.name, Block.this.core$()).as(Title.class);
                newElement.core$().set((Layer)newElement, "title", Collections.singletonList(title));
                return newElement;
            }

            public Description description(CatalogStampTextValue description) {
                Description newElement = (Description)Block.this.core$().graph().concept(Description.class).createNode(this.name, Block.this.core$()).as(Description.class);
                newElement.core$().set((Layer)newElement, "description", Collections.singletonList(description));
                return newElement;
            }

            public Rating rating(CatalogStampDoubleValue rating) {
                Rating newElement = (Rating)Block.this.core$().graph().concept(Rating.class).createNode(this.name, Block.this.core$()).as(Rating.class);
                newElement.core$().set((Layer)newElement, "rating", Collections.singletonList(rating));
                return newElement;
            }

            public OpenDialogOperation openDialogOperation(ItemExternalPath path) {
                OpenDialogOperation newElement = (OpenDialogOperation)Block.this.core$().graph().concept(OpenDialogOperation.class).createNode(this.name, Block.this.core$()).as(OpenDialogOperation.class);
                newElement.core$().set((Layer)newElement, "path", Collections.singletonList(path));
                return newElement;
            }

            public DownloadOperation downloadOperation(CatalogStampDownload execute) {
                DownloadOperation newElement = (DownloadOperation)Block.this.core$().graph().concept(DownloadOperation.class).createNode(this.name, Block.this.core$()).as(DownloadOperation.class);
                newElement.core$().set((Layer)newElement, "execute", Collections.singletonList(execute));
                return newElement;
            }

            public ExportOperation exportOperation(CatalogStampExport execute) {
                ExportOperation newElement = (ExportOperation)Block.this.core$().graph().concept(ExportOperation.class).createNode(this.name, Block.this.core$()).as(ExportOperation.class);
                newElement.core$().set((Layer)newElement, "execute", Collections.singletonList(execute));
                return newElement;
            }

            public TaskOperation taskOperation(CatalogStampTask task) {
                TaskOperation newElement = (TaskOperation)Block.this.core$().graph().concept(TaskOperation.class).createNode(this.name, Block.this.core$()).as(TaskOperation.class);
                newElement.core$().set((Layer)newElement, "task", Collections.singletonList(task));
                return newElement;
            }

            public Location location(CatalogStampTextValue wkt) {
                Location newElement = (Location)Block.this.core$().graph().concept(Location.class).createNode(this.name, Block.this.core$()).as(Location.class);
                newElement.core$().set((Layer)newElement, "wkt", Collections.singletonList(wkt));
                return newElement;
            }

            public Breadcrumbs breadcrumbs(BreadcrumbsTree tree) {
                Breadcrumbs newElement = (Breadcrumbs)Block.this.core$().graph().concept(Breadcrumbs.class).createNode(this.name, Block.this.core$()).as(Breadcrumbs.class);
                newElement.core$().set((Layer)newElement, "tree", Collections.singletonList(tree));
                return newElement;
            }

            public RecordLinks recordLinks(CatalogStampRecordLinks links) {
                RecordLinks newElement = (RecordLinks)Block.this.core$().graph().concept(RecordLinks.class).createNode(this.name, Block.this.core$()).as(RecordLinks.class);
                newElement.core$().set((Layer)newElement, "links", Collections.singletonList(links));
                return newElement;
            }

            public CatalogLink catalogLink(Catalog catalog) {
                CatalogLink newElement = (CatalogLink)Block.this.core$().graph().concept(CatalogLink.class).createNode(this.name, Block.this.core$()).as(CatalogLink.class);
                newElement.core$().set((Layer)newElement, "catalog", Collections.singletonList(catalog));
                return newElement;
            }

            public Display display() {
                Display newElement = (Display)Block.this.core$().graph().concept(Display.class).createNode(this.name, Block.this.core$()).as(Display.class);
                return newElement;
            }

            public InternalPage internalPage(ItemExternalPath path) {
                InternalPage newElement = (InternalPage)Block.this.core$().graph().concept(InternalPage.class).createNode(this.name, Block.this.core$()).as(InternalPage.class);
                newElement.core$().set((Layer)newElement, "path", Collections.singletonList(path));
                return newElement;
            }

            public ExternalPage externalPage(CatalogStampPageUrl url) {
                ExternalPage newElement = (ExternalPage)Block.this.core$().graph().concept(ExternalPage.class).createNode(this.name, Block.this.core$()).as(ExternalPage.class);
                newElement.core$().set((Layer)newElement, "url", Collections.singletonList(url));
                return newElement;
            }

            public Snippet snippet(CatalogStampTextValue code) {
                Snippet newElement = (Snippet)Block.this.core$().graph().concept(Snippet.class).createNode(this.name, Block.this.core$()).as(Snippet.class);
                newElement.core$().set((Layer)newElement, "code", Collections.singletonList(code));
                return newElement;
            }

            public EmbeddedCatalog embeddedCatalog(Catalog catalog) {
                EmbeddedCatalog newElement = (EmbeddedCatalog)Block.this.core$().graph().concept(EmbeddedCatalog.class).createNode(this.name, Block.this.core$()).as(EmbeddedCatalog.class);
                newElement.core$().set((Layer)newElement, "catalog", Collections.singletonList(catalog));
                return newElement;
            }
        }

        public static enum Layout {
            Vertical,
            Horizontal,
            Fixed,
            Flexible,
            Wrap,
            Center,
            Justified,
            StartJustified,
            CenterJustified,
            EndJustified;

        }
    }

    public class Clear {
        public void block(Predicate<Block> filter) {
            new ArrayList<Block>(Mold.this.blockList()).stream().filter(filter).forEach(Layer::delete$);
        }
    }

    public class Create
    extends Element.Create {
        public Create(String name) {
            super(Mold.this, name);
        }

        public Block block() {
            Block newElement = (Block)Mold.this.core$().graph().concept(Block.class).createNode(this.name, Mold.this.core$()).as(Block.class);
            return newElement;
        }
    }
}

