/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.graph;

import io.intino.sumus.graph.ElementOption;
import io.intino.sumus.graph.Option;
import io.intino.sumus.graph.Options;
import io.intino.sumus.graph.SumusGraph;
import io.intino.tara.magritte.Layer;
import io.intino.tara.magritte.Node;
import io.intino.tara.magritte.loaders.StringLoader;
import io.intino.tara.magritte.loaders.WordLoader;
import io.intino.tara.magritte.tags.Terminal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class Group
extends ElementOption
implements Terminal {
    protected String label;
    protected Mode mode;
    protected List<ElementOption> elementOptionList = new ArrayList<ElementOption>();

    public Group(Node node) {
        super(node);
    }

    public String label() {
        return this.label;
    }

    public Mode mode() {
        return this.mode;
    }

    public Group label(String value) {
        this.label = value;
        return this;
    }

    public Group mode(Mode value) {
        this.mode = value;
        return this;
    }

    public List<ElementOption> elementOptionList() {
        return Collections.unmodifiableList(this.elementOptionList);
    }

    public ElementOption elementOption(int index) {
        return this.elementOptionList.get(index);
    }

    public List<ElementOption> elementOptionList(Predicate<ElementOption> predicate) {
        return this.elementOptionList().stream().filter(predicate).collect(Collectors.toList());
    }

    protected List<Node> componentList$() {
        LinkedHashSet components = new LinkedHashSet(super.componentList$());
        new ArrayList<ElementOption>(this.elementOptionList).forEach(c -> components.add(c.core$()));
        return new ArrayList<Node>(components);
    }

    @Override
    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap(super.variables$());
        map.put("label", new ArrayList<String>(Collections.singletonList(this.label)));
        map.put("mode", new ArrayList<Mode>(Collections.singletonList(this.mode)));
        return map;
    }

    protected void addNode$(Node node) {
        super.addNode$(node);
        if (node.is("ElementOption")) {
            this.elementOptionList.add((ElementOption)node.as(ElementOption.class));
        }
    }

    protected void removeNode$(Node node) {
        super.removeNode$(node);
        if (node.is("ElementOption")) {
            this.elementOptionList.remove(node.as(ElementOption.class));
        }
    }

    @Override
    protected void load$(String name, List<?> values) {
        super.load$(name, values);
        if (name.equalsIgnoreCase("label")) {
            this.label = (String)StringLoader.load(values, (Layer)this).get(0);
        } else if (name.equalsIgnoreCase("mode")) {
            this.mode = (Mode)((Object)WordLoader.load(values, Mode.class, (Layer)this).get(0));
        }
    }

    @Override
    protected void set$(String name, List<?> values) {
        super.set$(name, values);
        if (name.equalsIgnoreCase("label")) {
            this.label = (String)values.get(0);
        } else if (name.equalsIgnoreCase("mode")) {
            this.mode = (Mode)((Object)values.get(0));
        }
    }

    @Override
    public Create create() {
        return new Create(null);
    }

    @Override
    public Create create(String name) {
        return new Create(name);
    }

    public Clear clear() {
        return new Clear();
    }

    @Override
    public SumusGraph graph() {
        return (SumusGraph)this.core$().graph().as(SumusGraph.class);
    }

    public class Clear {
    }

    public class Create
    extends ElementOption.Create {
        public Create(String name) {
            super(name);
        }

        public Option option(String label) {
            Option newElement = (Option)Group.this.core$().graph().concept(Option.class).createNode(this.name, Group.this.core$()).as(Option.class);
            newElement.core$().set((Layer)newElement, "label", Collections.singletonList(label));
            return newElement;
        }

        public Group group(String label) {
            Group newElement = (Group)Group.this.core$().graph().concept(Group.class).createNode(this.name, Group.this.core$()).as(Group.class);
            newElement.core$().set((Layer)newElement, "label", Collections.singletonList(label));
            return newElement;
        }

        public Options options() {
            Options newElement = (Options)Group.this.core$().graph().concept(Options.class).createNode(this.name, Group.this.core$()).as(Options.class);
            return newElement;
        }
    }

    public static enum Mode {
        Expanded,
        Collapsed;

    }
}

