/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.graph;

import io.intino.sumus.graph.Catalog;
import io.intino.sumus.graph.Entity;
import io.intino.sumus.graph.SumusGraph;
import io.intino.tara.magritte.Layer;
import io.intino.tara.magritte.Node;
import io.intino.tara.magritte.loaders.NodeLoader;
import io.intino.tara.magritte.loaders.StringLoader;
import io.intino.tara.magritte.tags.Terminal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class Cluster
extends Layer
implements Terminal {
    protected Catalog catalog;
    protected String label;
    protected String username;
    protected List<Group> groupList = new ArrayList<Group>();

    public Cluster(Node node) {
        super(node);
    }

    public Catalog catalog() {
        return this.catalog;
    }

    public String label() {
        return this.label;
    }

    public String username() {
        return this.username;
    }

    public Cluster catalog(Catalog value) {
        this.catalog = value;
        return this;
    }

    public Cluster label(String value) {
        this.label = value;
        return this;
    }

    public Cluster username(String value) {
        this.username = value;
        return this;
    }

    public List<Group> groupList() {
        return Collections.unmodifiableList(this.groupList);
    }

    public Group group(int index) {
        return this.groupList.get(index);
    }

    public List<Group> groupList(Predicate<Group> predicate) {
        return this.groupList().stream().filter(predicate).collect(Collectors.toList());
    }

    protected List<Node> componentList$() {
        LinkedHashSet components = new LinkedHashSet(super.componentList$());
        new ArrayList<Group>(this.groupList).forEach(c -> components.add(c.core$()));
        return new ArrayList<Node>(components);
    }

    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap();
        map.put("catalog", this.catalog != null ? new ArrayList<Catalog>(Collections.singletonList(this.catalog)) : Collections.emptyList());
        map.put("label", new ArrayList<String>(Collections.singletonList(this.label)));
        map.put("username", new ArrayList<String>(Collections.singletonList(this.username)));
        return map;
    }

    protected void addNode$(Node node) {
        super.addNode$(node);
        if (node.is("Cluster$Group")) {
            this.groupList.add((Group)node.as(Group.class));
        }
    }

    protected void removeNode$(Node node) {
        super.removeNode$(node);
        if (node.is("Cluster$Group")) {
            this.groupList.remove(node.as(Group.class));
        }
    }

    protected void load$(String name, List<?> values) {
        super.load$(name, values);
        if (name.equalsIgnoreCase("catalog")) {
            this.catalog = (Catalog)((Object)NodeLoader.load(values, Catalog.class, (Layer)this).get(0));
        } else if (name.equalsIgnoreCase("label")) {
            this.label = (String)StringLoader.load(values, (Layer)this).get(0);
        } else if (name.equalsIgnoreCase("username")) {
            this.username = (String)StringLoader.load(values, (Layer)this).get(0);
        }
    }

    protected void set$(String name, List<?> values) {
        super.set$(name, values);
        if (name.equalsIgnoreCase("catalog")) {
            this.catalog = values.get(0) != null ? (Catalog)this.core$().graph().load(((Layer)values.get(0)).core$().id()).as(Catalog.class) : null;
        } else if (name.equalsIgnoreCase("label")) {
            this.label = (String)values.get(0);
        } else if (name.equalsIgnoreCase("username")) {
            this.username = (String)values.get(0);
        }
    }

    public Create create() {
        return new Create(null);
    }

    public Create create(String name) {
        return new Create(name);
    }

    public Clear clear() {
        return new Clear();
    }

    public SumusGraph graph() {
        return (SumusGraph)this.core$().graph().as(SumusGraph.class);
    }

    public static class Group
    extends Layer
    implements Terminal {
        protected String label;
        protected List<Entity> entities = new ArrayList<Entity>();

        public Group(Node node) {
            super(node);
        }

        public String label() {
            return this.label;
        }

        public List<Entity> entities() {
            return this.entities;
        }

        public Entity entities(int index) {
            return this.entities.get(index);
        }

        public List<Entity> entities(Predicate<Entity> predicate) {
            return this.entities().stream().filter(predicate).collect(Collectors.toList());
        }

        public Group label(String value) {
            this.label = value;
            return this;
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("label", new ArrayList<String>(Collections.singletonList(this.label)));
            map.put("entities", this.entities);
            return map;
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("label")) {
                this.label = (String)StringLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("entities")) {
                this.entities = NodeLoader.load(values, Entity.class, (Layer)this);
            }
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("label")) {
                this.label = (String)values.get(0);
            } else if (name.equalsIgnoreCase("entities")) {
                this.entities = values.stream().map(s -> (Entity)this.graph().core$().load(((Layer)s).core$().id()).as(Entity.class)).collect(Collectors.toList());
            }
        }

        public SumusGraph graph() {
            return (SumusGraph)this.core$().graph().as(SumusGraph.class);
        }
    }

    public class Clear {
        public void group(Predicate<Group> filter) {
            new ArrayList<Group>(Cluster.this.groupList()).stream().filter(filter).forEach(Layer::delete$);
        }
    }

    public class Create {
        protected final String name;

        public Create(String name) {
            this.name = name;
        }

        public Group group(String label) {
            Group newElement = (Group)Cluster.this.core$().graph().concept(Group.class).createNode(this.name, Cluster.this.core$()).as(Group.class);
            newElement.core$().set((Layer)newElement, "label", Collections.singletonList(label));
            return newElement;
        }
    }
}

