/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.graph;

import io.intino.sumus.graph.AbstractView;
import io.intino.sumus.graph.Categorization;
import io.intino.sumus.graph.Cluster;
import io.intino.sumus.graph.Element;
import io.intino.sumus.graph.Mold;
import io.intino.sumus.graph.Olap;
import io.intino.sumus.graph.OnClickRecord;
import io.intino.sumus.graph.Record;
import io.intino.sumus.graph.SumusGraph;
import io.intino.sumus.graph.Toolbar;
import io.intino.sumus.graph.entityholder.EntityHolderCatalog;
import io.intino.sumus.graph.eventholder.EventHolderCatalog;
import io.intino.sumus.graph.functions.CatalogSortingComparator;
import io.intino.sumus.graph.functions.NameSpacesLoader;
import io.intino.sumus.graph.holder.HolderCatalog;
import io.intino.sumus.graph.reportholder.ReportHolderCatalog;
import io.intino.sumus.graph.rules.TimeScale;
import io.intino.sumus.graph.temporalholder.TemporalHolderCatalog;
import io.intino.tara.magritte.Concept;
import io.intino.tara.magritte.Expression;
import io.intino.tara.magritte.Layer;
import io.intino.tara.magritte.Node;
import io.intino.tara.magritte.loaders.DoubleLoader;
import io.intino.tara.magritte.loaders.FunctionLoader;
import io.intino.tara.magritte.loaders.IntegerLoader;
import io.intino.tara.magritte.loaders.NodeLoader;
import io.intino.tara.magritte.loaders.StringLoader;
import io.intino.tara.magritte.loaders.WordLoader;
import io.intino.tara.magritte.tags.Terminal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class Catalog
extends Element
implements Terminal {
    protected Toolbar toolbar;
    protected Events events;
    protected View view;
    protected MoldView moldView;
    protected MagazineView magazineView;
    protected ListView listView;
    protected GridView gridView;
    protected MapView mapView;
    protected OlapView olapView;
    protected Views views;
    protected Analysis analysis;

    public Catalog(Node node) {
        super(node);
    }

    public Toolbar toolbar() {
        return this.toolbar;
    }

    public Events events() {
        return this.events;
    }

    public View view() {
        return this.view;
    }

    public MoldView moldView() {
        return this.moldView;
    }

    public MagazineView magazineView() {
        return this.magazineView;
    }

    public ListView listView() {
        return this.listView;
    }

    public GridView gridView() {
        return this.gridView;
    }

    public MapView mapView() {
        return this.mapView;
    }

    public OlapView olapView() {
        return this.olapView;
    }

    public Views views() {
        return this.views;
    }

    public Analysis analysis() {
        return this.analysis;
    }

    public Catalog toolbar(Toolbar value) {
        this.toolbar = value;
        return this;
    }

    public Catalog events(Events value) {
        this.events = value;
        return this;
    }

    public Catalog view(View value) {
        this.view = value;
        return this;
    }

    public Catalog moldView(MoldView value) {
        this.moldView = value;
        return this;
    }

    public Catalog magazineView(MagazineView value) {
        this.magazineView = value;
        return this;
    }

    public Catalog listView(ListView value) {
        this.listView = value;
        return this;
    }

    public Catalog gridView(GridView value) {
        this.gridView = value;
        return this;
    }

    public Catalog mapView(MapView value) {
        this.mapView = value;
        return this;
    }

    public Catalog olapView(OlapView value) {
        this.olapView = value;
        return this;
    }

    public Catalog views(Views value) {
        this.views = value;
        return this;
    }

    public Catalog analysis(Analysis value) {
        this.analysis = value;
        return this;
    }

    public ReportHolderCatalog asReportHolder() {
        return (ReportHolderCatalog)this.a$(ReportHolderCatalog.class);
    }

    public ReportHolderCatalog asReportHolder(List<TimeScale> scales, NameSpacesLoader nameSpaces, Concept report) {
        ReportHolderCatalog newElement = (ReportHolderCatalog)this.core$().addFacet(ReportHolderCatalog.class);
        newElement.core$().set((Layer)newElement, "scales", scales);
        newElement.core$().set((Layer)newElement, "nameSpaces", Collections.singletonList(nameSpaces));
        newElement.core$().set((Layer)newElement, "report", Collections.singletonList(report));
        return newElement;
    }

    public boolean isReportHolder() {
        return this.core$().is(ReportHolderCatalog.class);
    }

    public void removeReportHolder() {
        this.core$().removeFacet(ReportHolderCatalog.class);
    }

    public HolderCatalog asHolder() {
        Layer as = this.a$(HolderCatalog.class);
        return as != null ? (HolderCatalog)as : null;
    }

    public boolean isHolder() {
        return this.core$().is(HolderCatalog.class);
    }

    public TemporalHolderCatalog asTemporalHolder() {
        return (TemporalHolderCatalog)this.a$(TemporalHolderCatalog.class);
    }

    public TemporalHolderCatalog asTemporalHolder(List<TimeScale> scales, NameSpacesLoader nameSpaces) {
        TemporalHolderCatalog newElement = (TemporalHolderCatalog)this.core$().addFacet(TemporalHolderCatalog.class);
        newElement.core$().set((Layer)newElement, "scales", scales);
        newElement.core$().set((Layer)newElement, "nameSpaces", Collections.singletonList(nameSpaces));
        return newElement;
    }

    public boolean isTemporalHolder() {
        return this.core$().is(TemporalHolderCatalog.class);
    }

    public void removeTemporalHolder() {
        this.core$().removeFacet(TemporalHolderCatalog.class);
    }

    public EntityHolderCatalog asEntityHolder() {
        return (EntityHolderCatalog)this.a$(EntityHolderCatalog.class);
    }

    public EntityHolderCatalog asEntityHolder(Concept entity) {
        EntityHolderCatalog newElement = (EntityHolderCatalog)this.core$().addFacet(EntityHolderCatalog.class);
        newElement.core$().set((Layer)newElement, "entity", Collections.singletonList(entity));
        return newElement;
    }

    public boolean isEntityHolder() {
        return this.core$().is(EntityHolderCatalog.class);
    }

    public void removeEntityHolder() {
        this.core$().removeFacet(EntityHolderCatalog.class);
    }

    public EventHolderCatalog asEventHolder() {
        return (EventHolderCatalog)this.a$(EventHolderCatalog.class);
    }

    public EventHolderCatalog asEventHolder(List<TimeScale> scales, NameSpacesLoader nameSpaces, Concept event) {
        EventHolderCatalog newElement = (EventHolderCatalog)this.core$().addFacet(EventHolderCatalog.class);
        newElement.core$().set((Layer)newElement, "scales", scales);
        newElement.core$().set((Layer)newElement, "nameSpaces", Collections.singletonList(nameSpaces));
        newElement.core$().set((Layer)newElement, "event", Collections.singletonList(event));
        return newElement;
    }

    public boolean isEventHolder() {
        return this.core$().is(EventHolderCatalog.class);
    }

    public void removeEventHolder() {
        this.core$().removeFacet(EventHolderCatalog.class);
    }

    protected List<Node> componentList$() {
        LinkedHashSet<Node> components = new LinkedHashSet<Node>(super.componentList$());
        if (this.toolbar != null) {
            components.add(this.toolbar.core$());
        }
        if (this.events != null) {
            components.add(this.events.core$());
        }
        if (this.view != null) {
            components.add(this.view.core$());
        }
        if (this.moldView != null) {
            components.add(this.moldView.core$());
        }
        if (this.magazineView != null) {
            components.add(this.magazineView.core$());
        }
        if (this.listView != null) {
            components.add(this.listView.core$());
        }
        if (this.gridView != null) {
            components.add(this.gridView.core$());
        }
        if (this.mapView != null) {
            components.add(this.mapView.core$());
        }
        if (this.olapView != null) {
            components.add(this.olapView.core$());
        }
        if (this.views != null) {
            components.add(this.views.core$());
        }
        if (this.analysis != null) {
            components.add(this.analysis.core$());
        }
        return new ArrayList<Node>(components);
    }

    @Override
    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap(super.variables$());
        return map;
    }

    protected void addNode$(Node node) {
        super.addNode$(node);
        if (node.is("Toolbar")) {
            this.toolbar = (Toolbar)node.as(Toolbar.class);
        }
        if (node.is("Catalog$Events")) {
            this.events = (Events)node.as(Events.class);
        }
        if (node.is("Catalog$View")) {
            this.view = (View)node.as(View.class);
        }
        if (node.is("Catalog$MoldView")) {
            this.moldView = (MoldView)node.as(MoldView.class);
        }
        if (node.is("Catalog$MagazineView")) {
            this.magazineView = (MagazineView)node.as(MagazineView.class);
        }
        if (node.is("Catalog$ListView")) {
            this.listView = (ListView)node.as(ListView.class);
        }
        if (node.is("Catalog$GridView")) {
            this.gridView = (GridView)node.as(GridView.class);
        }
        if (node.is("Catalog$MapView")) {
            this.mapView = (MapView)node.as(MapView.class);
        }
        if (node.is("Catalog$OlapView")) {
            this.olapView = (OlapView)node.as(OlapView.class);
        }
        if (node.is("Catalog$Views")) {
            this.views = (Views)node.as(Views.class);
        }
        if (node.is("Catalog$Analysis")) {
            this.analysis = (Analysis)node.as(Analysis.class);
        }
    }

    protected void removeNode$(Node node) {
        super.removeNode$(node);
        if (node.is("Toolbar")) {
            this.toolbar = null;
        }
        if (node.is("Catalog$Events")) {
            this.events = null;
        }
        if (node.is("Catalog$View")) {
            this.view = null;
        }
        if (node.is("Catalog$MoldView")) {
            this.moldView = null;
        }
        if (node.is("Catalog$MagazineView")) {
            this.magazineView = null;
        }
        if (node.is("Catalog$ListView")) {
            this.listView = null;
        }
        if (node.is("Catalog$GridView")) {
            this.gridView = null;
        }
        if (node.is("Catalog$MapView")) {
            this.mapView = null;
        }
        if (node.is("Catalog$OlapView")) {
            this.olapView = null;
        }
        if (node.is("Catalog$Views")) {
            this.views = null;
        }
        if (node.is("Catalog$Analysis")) {
            this.analysis = null;
        }
    }

    @Override
    protected void load$(String name, List<?> values) {
        super.load$(name, values);
    }

    @Override
    protected void set$(String name, List<?> values) {
        super.set$(name, values);
    }

    @Override
    public Create create() {
        return new Create(null);
    }

    @Override
    public Create create(String name) {
        return new Create(name);
    }

    public Clear clear() {
        return new Clear();
    }

    @Override
    public SumusGraph graph() {
        return (SumusGraph)this.core$().graph().as(SumusGraph.class);
    }

    public static class Analysis
    extends Layer
    implements Terminal {
        protected List<Sorting> sortingList = new ArrayList<Sorting>();
        protected List<AbstractGrouping> abstractGroupingList = new ArrayList<AbstractGrouping>();
        protected List<Grouping> groupingList = new ArrayList<Grouping>();
        protected List<ClusterGrouping> clusterGroupingList = new ArrayList<ClusterGrouping>();

        public Analysis(Node node) {
            super(node);
        }

        public List<Sorting> sortingList() {
            return Collections.unmodifiableList(this.sortingList);
        }

        public Sorting sorting(int index) {
            return this.sortingList.get(index);
        }

        public List<Sorting> sortingList(Predicate<Sorting> predicate) {
            return this.sortingList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<AbstractGrouping> abstractGroupingList() {
            return Collections.unmodifiableList(this.abstractGroupingList);
        }

        public AbstractGrouping abstractGrouping(int index) {
            return this.abstractGroupingList.get(index);
        }

        public List<AbstractGrouping> abstractGroupingList(Predicate<AbstractGrouping> predicate) {
            return this.abstractGroupingList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<Grouping> groupingList() {
            return Collections.unmodifiableList(this.groupingList);
        }

        public Grouping grouping(int index) {
            return this.groupingList.get(index);
        }

        public List<Grouping> groupingList(Predicate<Grouping> predicate) {
            return this.groupingList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<ClusterGrouping> clusterGroupingList() {
            return Collections.unmodifiableList(this.clusterGroupingList);
        }

        public ClusterGrouping clusterGrouping(int index) {
            return this.clusterGroupingList.get(index);
        }

        public List<ClusterGrouping> clusterGroupingList(Predicate<ClusterGrouping> predicate) {
            return this.clusterGroupingList().stream().filter(predicate).collect(Collectors.toList());
        }

        protected List<Node> componentList$() {
            LinkedHashSet components = new LinkedHashSet(super.componentList$());
            new ArrayList<Sorting>(this.sortingList).forEach(c -> components.add(c.core$()));
            new ArrayList<AbstractGrouping>(this.abstractGroupingList).forEach(c -> components.add(c.core$()));
            new ArrayList<Grouping>(this.groupingList).forEach(c -> components.add(c.core$()));
            new ArrayList<ClusterGrouping>(this.clusterGroupingList).forEach(c -> components.add(c.core$()));
            return new ArrayList<Node>(components);
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            return map;
        }

        protected void addNode$(Node node) {
            super.addNode$(node);
            if (node.is("Catalog$Analysis$Sorting")) {
                this.sortingList.add((Sorting)node.as(Sorting.class));
            }
            if (node.is("Catalog$Analysis$AbstractGrouping")) {
                this.abstractGroupingList.add((AbstractGrouping)node.as(AbstractGrouping.class));
            }
            if (node.is("Catalog$Analysis$Grouping")) {
                this.groupingList.add((Grouping)node.as(Grouping.class));
            }
            if (node.is("Catalog$Analysis$ClusterGrouping")) {
                this.clusterGroupingList.add((ClusterGrouping)node.as(ClusterGrouping.class));
            }
        }

        protected void removeNode$(Node node) {
            super.removeNode$(node);
            if (node.is("Catalog$Analysis$Sorting")) {
                this.sortingList.remove(node.as(Sorting.class));
            }
            if (node.is("Catalog$Analysis$AbstractGrouping")) {
                this.abstractGroupingList.remove(node.as(AbstractGrouping.class));
            }
            if (node.is("Catalog$Analysis$Grouping")) {
                this.groupingList.remove(node.as(Grouping.class));
            }
            if (node.is("Catalog$Analysis$ClusterGrouping")) {
                this.clusterGroupingList.remove(node.as(ClusterGrouping.class));
            }
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public Clear clear() {
            return new Clear();
        }

        public SumusGraph graph() {
            return (SumusGraph)this.core$().graph().as(SumusGraph.class);
        }

        public static class ClusterGrouping
        extends AbstractGrouping
        implements Terminal {
            protected Cluster cluster;

            public ClusterGrouping(Node node) {
                super(node);
            }

            public Cluster cluster() {
                return this.cluster;
            }

            public ClusterGrouping cluster(Cluster value) {
                this.cluster = value;
                return this;
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                map.put("cluster", this.cluster != null ? new ArrayList<Cluster>(Collections.singletonList(this.cluster)) : Collections.emptyList());
                return map;
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("cluster")) {
                    this.cluster = (Cluster)((Object)NodeLoader.load(values, Cluster.class, (Layer)this).get(0));
                }
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("cluster")) {
                    this.cluster = values.get(0) != null ? (Cluster)this.core$().graph().load(((Layer)values.get(0)).core$().id()).as(Cluster.class) : null;
                }
            }

            @Override
            public SumusGraph graph() {
                return (SumusGraph)this.core$().graph().as(SumusGraph.class);
            }
        }

        public static class Grouping
        extends AbstractGrouping
        implements Terminal {
            protected Categorization categorization;

            public Grouping(Node node) {
                super(node);
            }

            public Categorization categorization() {
                return this.categorization;
            }

            public Grouping categorization(Categorization value) {
                this.categorization = value;
                return this;
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                map.put("categorization", this.categorization != null ? new ArrayList<Categorization>(Collections.singletonList(this.categorization)) : Collections.emptyList());
                return map;
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("categorization")) {
                    this.categorization = (Categorization)((Object)NodeLoader.load(values, Categorization.class, (Layer)this).get(0));
                }
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("categorization")) {
                    this.categorization = values.get(0) != null ? (Categorization)this.core$().graph().load(((Layer)values.get(0)).core$().id()).as(Categorization.class) : null;
                }
            }

            @Override
            public SumusGraph graph() {
                return (SumusGraph)this.core$().graph().as(SumusGraph.class);
            }
        }

        public static abstract class AbstractGrouping
        extends Layer
        implements Terminal {
            protected Expression<String> label;
            protected Histogram histogram;

            public AbstractGrouping(Node node) {
                super(node);
            }

            public String label() {
                return (String)this.label.value();
            }

            public Histogram histogram() {
                return this.histogram;
            }

            public AbstractGrouping label(Expression<String> value) {
                this.label = (Expression)FunctionLoader.load(value, (Layer)this, Expression.class);
                return this;
            }

            public AbstractGrouping histogram(Histogram value) {
                this.histogram = value;
                return this;
            }

            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap();
                map.put("label", new ArrayList<Expression<String>>(Collections.singletonList(this.label)));
                map.put("histogram", new ArrayList<Histogram>(Collections.singletonList(this.histogram)));
                return map;
            }

            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("label")) {
                    this.label = (Expression)FunctionLoader.load(values, (Layer)this, Expression.class).get(0);
                } else if (name.equalsIgnoreCase("histogram")) {
                    this.histogram = (Histogram)((Object)WordLoader.load(values, Histogram.class, (Layer)this).get(0));
                }
            }

            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("label")) {
                    this.label = (Expression)FunctionLoader.load(values.get(0), (Layer)this, Expression.class);
                } else if (name.equalsIgnoreCase("histogram")) {
                    this.histogram = (Histogram)((Object)values.get(0));
                }
            }

            public Create create() {
                return new Create(null);
            }

            public Create create(String name) {
                return new Create(name);
            }

            public SumusGraph graph() {
                return (SumusGraph)this.core$().graph().as(SumusGraph.class);
            }

            public class Create {
                protected final String name;

                public Create(String name) {
                    this.name = name;
                }
            }

            public static enum Histogram {
                Percentage,
                Absolute;

            }
        }

        public static class Sorting
        extends Layer
        implements Terminal {
            protected String label;
            protected CatalogSortingComparator comparator;

            public Sorting(Node node) {
                super(node);
            }

            public String label() {
                return this.label;
            }

            public int comparator(Record record1, Record record2) {
                return this.comparator.compare(record1, record2);
            }

            public Sorting label(String value) {
                this.label = value;
                return this;
            }

            public Sorting comparator(CatalogSortingComparator value) {
                this.comparator = (CatalogSortingComparator)FunctionLoader.load((Object)this.comparator, (Layer)this, CatalogSortingComparator.class);
                return this;
            }

            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap();
                map.put("label", new ArrayList<String>(Collections.singletonList(this.label)));
                map.put("comparator", this.comparator != null ? new ArrayList<CatalogSortingComparator>(Collections.singletonList(this.comparator)) : Collections.emptyList());
                return map;
            }

            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("label")) {
                    this.label = (String)StringLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("comparator")) {
                    this.comparator = (CatalogSortingComparator)FunctionLoader.load(values, (Layer)this, CatalogSortingComparator.class).get(0);
                }
            }

            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("label")) {
                    this.label = (String)values.get(0);
                } else if (name.equalsIgnoreCase("comparator")) {
                    this.comparator = (CatalogSortingComparator)FunctionLoader.load(values.get(0), (Layer)this, CatalogSortingComparator.class);
                }
            }

            public SumusGraph graph() {
                return (SumusGraph)this.core$().graph().as(SumusGraph.class);
            }
        }

        public class Clear {
            public void sorting(Predicate<Sorting> filter) {
                new ArrayList<Sorting>(Analysis.this.sortingList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void grouping(Predicate<Grouping> filter) {
                new ArrayList<Grouping>(Analysis.this.groupingList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void clusterGrouping(Predicate<ClusterGrouping> filter) {
                new ArrayList<ClusterGrouping>(Analysis.this.clusterGroupingList()).stream().filter(filter).forEach(Layer::delete$);
            }
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }

            public Sorting sorting(String label, CatalogSortingComparator comparator) {
                Sorting newElement = (Sorting)Analysis.this.core$().graph().concept(Sorting.class).createNode(this.name, Analysis.this.core$()).as(Sorting.class);
                newElement.core$().set((Layer)newElement, "label", Collections.singletonList(label));
                newElement.core$().set((Layer)newElement, "comparator", Collections.singletonList(comparator));
                return newElement;
            }

            public Grouping grouping(Categorization categorization) {
                Grouping newElement = (Grouping)Analysis.this.core$().graph().concept(Grouping.class).createNode(this.name, Analysis.this.core$()).as(Grouping.class);
                newElement.core$().set((Layer)newElement, "categorization", Collections.singletonList(categorization));
                return newElement;
            }

            public ClusterGrouping clusterGrouping(Cluster cluster) {
                ClusterGrouping newElement = (ClusterGrouping)Analysis.this.core$().graph().concept(ClusterGrouping.class).createNode(this.name, Analysis.this.core$()).as(ClusterGrouping.class);
                newElement.core$().set((Layer)newElement, "cluster", Collections.singletonList(cluster));
                return newElement;
            }
        }
    }

    public static class Views
    extends Layer
    implements Terminal {
        protected List<View> viewList = new ArrayList<View>();

        public Views(Node node) {
            super(node);
        }

        public List<View> viewList() {
            return Collections.unmodifiableList(this.viewList);
        }

        public View view(int index) {
            return this.viewList.get(index);
        }

        public List<View> viewList(Predicate<View> predicate) {
            return this.viewList().stream().filter(predicate).collect(Collectors.toList());
        }

        protected List<Node> componentList$() {
            LinkedHashSet components = new LinkedHashSet(super.componentList$());
            new ArrayList<View>(this.viewList).forEach(c -> components.add(c.core$()));
            return new ArrayList<Node>(components);
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            return map;
        }

        protected void addNode$(Node node) {
            super.addNode$(node);
            if (node.is("Catalog$View")) {
                this.viewList.add((View)node.as(View.class));
            }
        }

        protected void removeNode$(Node node) {
            super.removeNode$(node);
            if (node.is("Catalog$View")) {
                this.viewList.remove(node.as(View.class));
            }
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public Clear clear() {
            return new Clear();
        }

        public SumusGraph graph() {
            return (SumusGraph)this.core$().graph().as(SumusGraph.class);
        }

        public class Clear {
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }

            public MapView mapView(Mold mold) {
                MapView newElement = (MapView)Views.this.core$().graph().concept(MapView.class).createNode(this.name, Views.this.core$()).as(MapView.class);
                newElement.core$().set((Layer)newElement, "mold", Collections.singletonList(mold));
                return newElement;
            }

            public GridView gridView(Mold mold) {
                GridView newElement = (GridView)Views.this.core$().graph().concept(GridView.class).createNode(this.name, Views.this.core$()).as(GridView.class);
                newElement.core$().set((Layer)newElement, "mold", Collections.singletonList(mold));
                return newElement;
            }

            public OlapView olapView(Olap olap) {
                OlapView newElement = (OlapView)Views.this.core$().graph().concept(OlapView.class).createNode(this.name, Views.this.core$()).as(OlapView.class);
                newElement.core$().set((Layer)newElement, "olap", Collections.singletonList(olap));
                return newElement;
            }

            public ListView listView(Mold mold) {
                ListView newElement = (ListView)Views.this.core$().graph().concept(ListView.class).createNode(this.name, Views.this.core$()).as(ListView.class);
                newElement.core$().set((Layer)newElement, "mold", Collections.singletonList(mold));
                return newElement;
            }

            public MagazineView magazineView(Mold mold) {
                MagazineView newElement = (MagazineView)Views.this.core$().graph().concept(MagazineView.class).createNode(this.name, Views.this.core$()).as(MagazineView.class);
                newElement.core$().set((Layer)newElement, "mold", Collections.singletonList(mold));
                return newElement;
            }
        }
    }

    public static class OlapView
    extends View
    implements Terminal {
        protected Olap olap;

        public OlapView(Node node) {
            super(node);
        }

        public Olap olap() {
            return this.olap;
        }

        public OlapView olap(Olap value) {
            this.olap = value;
            return this;
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap(super.variables$());
            map.put("olap", this.olap != null ? new ArrayList<Olap>(Collections.singletonList(this.olap)) : Collections.emptyList());
            return map;
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("olap")) {
                this.olap = (Olap)((Object)NodeLoader.load(values, Olap.class, (Layer)this).get(0));
            }
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("olap")) {
                this.olap = values.get(0) != null ? (Olap)this.core$().graph().load(((Layer)values.get(0)).core$().id()).as(Olap.class) : null;
            }
        }

        @Override
        public SumusGraph graph() {
            return (SumusGraph)this.core$().graph().as(SumusGraph.class);
        }
    }

    public static class MapView
    extends MoldView
    implements Terminal {
        protected Center center;
        protected Zoom zoom;

        public MapView(Node node) {
            super(node);
        }

        public Center center() {
            return this.center;
        }

        public Zoom zoom() {
            return this.zoom;
        }

        public MapView center(Center value) {
            this.center = value;
            return this;
        }

        public MapView zoom(Zoom value) {
            this.zoom = value;
            return this;
        }

        protected List<Node> componentList$() {
            LinkedHashSet<Node> components = new LinkedHashSet<Node>(super.componentList$());
            if (this.center != null) {
                components.add(this.center.core$());
            }
            if (this.zoom != null) {
                components.add(this.zoom.core$());
            }
            return new ArrayList<Node>(components);
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap(super.variables$());
            return map;
        }

        protected void addNode$(Node node) {
            super.addNode$(node);
            if (node.is("Catalog$MapView$Center")) {
                this.center = (Center)node.as(Center.class);
            }
            if (node.is("Catalog$MapView$Zoom")) {
                this.zoom = (Zoom)node.as(Zoom.class);
            }
        }

        protected void removeNode$(Node node) {
            super.removeNode$(node);
            if (node.is("Catalog$MapView$Center")) {
                this.center = null;
            }
            if (node.is("Catalog$MapView$Zoom")) {
                this.zoom = null;
            }
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
        }

        @Override
        public Create create() {
            return new Create(null);
        }

        @Override
        public Create create(String name) {
            return new Create(name);
        }

        public Clear clear() {
            return new Clear();
        }

        @Override
        public SumusGraph graph() {
            return (SumusGraph)this.core$().graph().as(SumusGraph.class);
        }

        public static class Zoom
        extends Layer
        implements Terminal {
            protected int default$;
            protected int min;
            protected int max;

            public Zoom(Node node) {
                super(node);
            }

            public int default$() {
                return this.default$;
            }

            public int min() {
                return this.min;
            }

            public int max() {
                return this.max;
            }

            public Zoom default$(int value) {
                this.default$ = value;
                return this;
            }

            public Zoom min(int value) {
                this.min = value;
                return this;
            }

            public Zoom max(int value) {
                this.max = value;
                return this;
            }

            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap();
                map.put("default", new ArrayList<Integer>(Collections.singletonList(this.default$)));
                map.put("min", new ArrayList<Integer>(Collections.singletonList(this.min)));
                map.put("max", new ArrayList<Integer>(Collections.singletonList(this.max)));
                return map;
            }

            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("default")) {
                    this.default$ = (Integer)IntegerLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("min")) {
                    this.min = (Integer)IntegerLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("max")) {
                    this.max = (Integer)IntegerLoader.load(values, (Layer)this).get(0);
                }
            }

            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("default")) {
                    this.default$ = (Integer)values.get(0);
                } else if (name.equalsIgnoreCase("min")) {
                    this.min = (Integer)values.get(0);
                } else if (name.equalsIgnoreCase("max")) {
                    this.max = (Integer)values.get(0);
                }
            }

            public SumusGraph graph() {
                return (SumusGraph)this.core$().graph().as(SumusGraph.class);
            }
        }

        public static class Center
        extends Layer
        implements Terminal {
            protected double latitude;
            protected double longitude;

            public Center(Node node) {
                super(node);
            }

            public double latitude() {
                return this.latitude;
            }

            public double longitude() {
                return this.longitude;
            }

            public Center latitude(double value) {
                this.latitude = value;
                return this;
            }

            public Center longitude(double value) {
                this.longitude = value;
                return this;
            }

            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap();
                map.put("latitude", new ArrayList<Double>(Collections.singletonList(this.latitude)));
                map.put("longitude", new ArrayList<Double>(Collections.singletonList(this.longitude)));
                return map;
            }

            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("latitude")) {
                    this.latitude = (Double)DoubleLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("longitude")) {
                    this.longitude = (Double)DoubleLoader.load(values, (Layer)this).get(0);
                }
            }

            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("latitude")) {
                    this.latitude = (Double)values.get(0);
                } else if (name.equalsIgnoreCase("longitude")) {
                    this.longitude = (Double)values.get(0);
                }
            }

            public SumusGraph graph() {
                return (SumusGraph)this.core$().graph().as(SumusGraph.class);
            }
        }

        public class Clear {
        }

        public class Create
        extends MoldView.Create {
            public Create(String name) {
                super(name);
            }

            public Center center(double latitude, double longitude) {
                Center newElement = (Center)MapView.this.core$().graph().concept(Center.class).createNode(this.name, MapView.this.core$()).as(Center.class);
                newElement.core$().set((Layer)newElement, "latitude", Collections.singletonList(latitude));
                newElement.core$().set((Layer)newElement, "longitude", Collections.singletonList(longitude));
                return newElement;
            }

            public Zoom zoom(int default$) {
                Zoom newElement = (Zoom)MapView.this.core$().graph().concept(Zoom.class).createNode(this.name, MapView.this.core$()).as(Zoom.class);
                newElement.core$().set((Layer)newElement, "default", Collections.singletonList(default$));
                return newElement;
            }
        }
    }

    public static class GridView
    extends MoldView
    implements Terminal {
        protected String noRecordsMessage;
        protected int width;

        public GridView(Node node) {
            super(node);
        }

        public String noRecordsMessage() {
            return this.noRecordsMessage;
        }

        public int width() {
            return this.width;
        }

        public GridView noRecordsMessage(String value) {
            this.noRecordsMessage = value;
            return this;
        }

        public GridView width(int value) {
            this.width = value;
            return this;
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap(super.variables$());
            map.put("noRecordsMessage", new ArrayList<String>(Collections.singletonList(this.noRecordsMessage)));
            map.put("width", new ArrayList<Integer>(Collections.singletonList(this.width)));
            return map;
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("noRecordsMessage")) {
                this.noRecordsMessage = (String)StringLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("width")) {
                this.width = (Integer)IntegerLoader.load(values, (Layer)this).get(0);
            }
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("noRecordsMessage")) {
                this.noRecordsMessage = (String)values.get(0);
            } else if (name.equalsIgnoreCase("width")) {
                this.width = (Integer)values.get(0);
            }
        }

        @Override
        public SumusGraph graph() {
            return (SumusGraph)this.core$().graph().as(SumusGraph.class);
        }
    }

    public static class ListView
    extends MoldView
    implements Terminal {
        protected String noRecordsMessage;
        protected int width;

        public ListView(Node node) {
            super(node);
        }

        public String noRecordsMessage() {
            return this.noRecordsMessage;
        }

        public int width() {
            return this.width;
        }

        public ListView noRecordsMessage(String value) {
            this.noRecordsMessage = value;
            return this;
        }

        public ListView width(int value) {
            this.width = value;
            return this;
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap(super.variables$());
            map.put("noRecordsMessage", new ArrayList<String>(Collections.singletonList(this.noRecordsMessage)));
            map.put("width", new ArrayList<Integer>(Collections.singletonList(this.width)));
            return map;
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("noRecordsMessage")) {
                this.noRecordsMessage = (String)StringLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("width")) {
                this.width = (Integer)IntegerLoader.load(values, (Layer)this).get(0);
            }
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("noRecordsMessage")) {
                this.noRecordsMessage = (String)values.get(0);
            } else if (name.equalsIgnoreCase("width")) {
                this.width = (Integer)values.get(0);
            }
        }

        @Override
        public SumusGraph graph() {
            return (SumusGraph)this.core$().graph().as(SumusGraph.class);
        }
    }

    public static class MagazineView
    extends MoldView
    implements Terminal {
        protected String noRecordMessage;
        protected int width;

        public MagazineView(Node node) {
            super(node);
        }

        public String noRecordMessage() {
            return this.noRecordMessage;
        }

        public int width() {
            return this.width;
        }

        public MagazineView noRecordMessage(String value) {
            this.noRecordMessage = value;
            return this;
        }

        public MagazineView width(int value) {
            this.width = value;
            return this;
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap(super.variables$());
            map.put("noRecordMessage", new ArrayList<String>(Collections.singletonList(this.noRecordMessage)));
            map.put("width", new ArrayList<Integer>(Collections.singletonList(this.width)));
            return map;
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("noRecordMessage")) {
                this.noRecordMessage = (String)StringLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("width")) {
                this.width = (Integer)IntegerLoader.load(values, (Layer)this).get(0);
            }
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("noRecordMessage")) {
                this.noRecordMessage = (String)values.get(0);
            } else if (name.equalsIgnoreCase("width")) {
                this.width = (Integer)values.get(0);
            }
        }

        @Override
        public SumusGraph graph() {
            return (SumusGraph)this.core$().graph().as(SumusGraph.class);
        }
    }

    public static abstract class MoldView
    extends View
    implements Terminal {
        protected Mold mold;

        public MoldView(Node node) {
            super(node);
        }

        public Mold mold() {
            return this.mold;
        }

        public MoldView mold(Mold value) {
            this.mold = value;
            return this;
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap(super.variables$());
            map.put("mold", this.mold != null ? new ArrayList<Mold>(Collections.singletonList(this.mold)) : Collections.emptyList());
            return map;
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("mold")) {
                this.mold = (Mold)((Object)NodeLoader.load(values, Mold.class, (Layer)this).get(0));
            }
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("mold")) {
                this.mold = values.get(0) != null ? (Mold)this.core$().graph().load(((Layer)values.get(0)).core$().id()).as(Mold.class) : null;
            }
        }

        @Override
        public Create create() {
            return new Create(null);
        }

        @Override
        public Create create(String name) {
            return new Create(name);
        }

        @Override
        public SumusGraph graph() {
            return (SumusGraph)this.core$().graph().as(SumusGraph.class);
        }

        public class Create
        extends View.Create {
            public Create(String name) {
                super(name);
            }
        }
    }

    public static abstract class View
    extends AbstractView
    implements Terminal {
        public View(Node node) {
            super(node);
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap(super.variables$());
            return map;
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
        }

        @Override
        public Create create() {
            return new Create(null);
        }

        @Override
        public Create create(String name) {
            return new Create(name);
        }

        @Override
        public SumusGraph graph() {
            return (SumusGraph)this.core$().graph().as(SumusGraph.class);
        }

        public class Create
        extends AbstractView.Create {
            public Create(String name) {
                super(View.this, name);
            }
        }
    }

    public static class Events
    extends Layer
    implements Terminal {
        protected OnClickRecord onClickRecord;

        public Events(Node node) {
            super(node);
        }

        public OnClickRecord onClickRecord() {
            return this.onClickRecord;
        }

        public Events onClickRecord(OnClickRecord value) {
            this.onClickRecord = value;
            return this;
        }

        protected List<Node> componentList$() {
            LinkedHashSet<Node> components = new LinkedHashSet<Node>(super.componentList$());
            if (this.onClickRecord != null) {
                components.add(this.onClickRecord.core$());
            }
            return new ArrayList<Node>(components);
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            return map;
        }

        protected void addNode$(Node node) {
            super.addNode$(node);
            if (node.is("OnClickRecord")) {
                this.onClickRecord = (OnClickRecord)node.as(OnClickRecord.class);
            }
        }

        protected void removeNode$(Node node) {
            super.removeNode$(node);
            if (node.is("OnClickRecord")) {
                this.onClickRecord = null;
            }
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public Clear clear() {
            return new Clear();
        }

        public SumusGraph graph() {
            return (SumusGraph)this.core$().graph().as(SumusGraph.class);
        }

        public class Clear {
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }

            public OnClickRecord onClickRecord() {
                OnClickRecord newElement = (OnClickRecord)Events.this.core$().graph().concept(OnClickRecord.class).createNode(this.name, Events.this.core$()).as(OnClickRecord.class);
                return newElement;
            }
        }
    }

    public class Clear {
    }

    public class Create
    extends Element.Create {
        public Create(String name) {
            super(name);
        }

        public Toolbar toolbar() {
            Toolbar newElement = (Toolbar)Catalog.this.core$().graph().concept(Toolbar.class).createNode(this.name, Catalog.this.core$()).as(Toolbar.class);
            return newElement;
        }

        public Events events() {
            Events newElement = (Events)Catalog.this.core$().graph().concept(Events.class).createNode(this.name, Catalog.this.core$()).as(Events.class);
            return newElement;
        }

        public MagazineView magazineView(Mold mold) {
            MagazineView newElement = (MagazineView)Catalog.this.core$().graph().concept(MagazineView.class).createNode(this.name, Catalog.this.core$()).as(MagazineView.class);
            newElement.core$().set((Layer)newElement, "mold", Collections.singletonList(mold));
            return newElement;
        }

        public ListView listView(Mold mold) {
            ListView newElement = (ListView)Catalog.this.core$().graph().concept(ListView.class).createNode(this.name, Catalog.this.core$()).as(ListView.class);
            newElement.core$().set((Layer)newElement, "mold", Collections.singletonList(mold));
            return newElement;
        }

        public GridView gridView(Mold mold) {
            GridView newElement = (GridView)Catalog.this.core$().graph().concept(GridView.class).createNode(this.name, Catalog.this.core$()).as(GridView.class);
            newElement.core$().set((Layer)newElement, "mold", Collections.singletonList(mold));
            return newElement;
        }

        public MapView mapView(Mold mold) {
            MapView newElement = (MapView)Catalog.this.core$().graph().concept(MapView.class).createNode(this.name, Catalog.this.core$()).as(MapView.class);
            newElement.core$().set((Layer)newElement, "mold", Collections.singletonList(mold));
            return newElement;
        }

        public OlapView olapView(Olap olap) {
            OlapView newElement = (OlapView)Catalog.this.core$().graph().concept(OlapView.class).createNode(this.name, Catalog.this.core$()).as(OlapView.class);
            newElement.core$().set((Layer)newElement, "olap", Collections.singletonList(olap));
            return newElement;
        }

        public Views views() {
            Views newElement = (Views)Catalog.this.core$().graph().concept(Views.class).createNode(this.name, Catalog.this.core$()).as(Views.class);
            return newElement;
        }

        public Analysis analysis() {
            Analysis newElement = (Analysis)Catalog.this.core$().graph().concept(Analysis.class).createNode(this.name, Catalog.this.core$()).as(Analysis.class);
            return newElement;
        }
    }
}

