/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.graph;

import io.intino.sumus.graph.AbstractMetric;
import io.intino.sumus.graph.AbstractView;
import io.intino.sumus.graph.Catalog;
import io.intino.sumus.graph.Categorization;
import io.intino.sumus.graph.Checker;
import io.intino.sumus.graph.Cluster;
import io.intino.sumus.graph.Cube;
import io.intino.sumus.graph.Element;
import io.intino.sumus.graph.ElementOption;
import io.intino.sumus.graph.ElementRender;
import io.intino.sumus.graph.Entity;
import io.intino.sumus.graph.Episode;
import io.intino.sumus.graph.Event;
import io.intino.sumus.graph.Filter;
import io.intino.sumus.graph.Group;
import io.intino.sumus.graph.KeyStore;
import io.intino.sumus.graph.Layout;
import io.intino.sumus.graph.Metric;
import io.intino.sumus.graph.Mold;
import io.intino.sumus.graph.NameSpace;
import io.intino.sumus.graph.Olap;
import io.intino.sumus.graph.OnClickInstant;
import io.intino.sumus.graph.OnClickRecord;
import io.intino.sumus.graph.Option;
import io.intino.sumus.graph.Options;
import io.intino.sumus.graph.Palette;
import io.intino.sumus.graph.Panel;
import io.intino.sumus.graph.ProfileManager;
import io.intino.sumus.graph.Record;
import io.intino.sumus.graph.RenderCatalog;
import io.intino.sumus.graph.RenderCatalogs;
import io.intino.sumus.graph.RenderMold;
import io.intino.sumus.graph.RenderOlap;
import io.intino.sumus.graph.RenderPanel;
import io.intino.sumus.graph.RenderPanels;
import io.intino.sumus.graph.RenderRecord;
import io.intino.sumus.graph.RenderRecords;
import io.intino.sumus.graph.Report;
import io.intino.sumus.graph.TemporalMetric;
import io.intino.sumus.graph.TemporalRecord;
import io.intino.sumus.graph.Ticket;
import io.intino.sumus.graph.aspect.AspectEntity;
import io.intino.sumus.graph.dynamic.DynamicEntity;
import io.intino.sumus.graph.editable.mold.block.EditableStamp;
import io.intino.sumus.graph.entityholder.EntityHolderCatalog;
import io.intino.sumus.graph.eventholder.EventHolderCatalog;
import io.intino.sumus.graph.expanded.mold.ExpandedBlock;
import io.intino.sumus.graph.functions.Attribute;
import io.intino.sumus.graph.functions.NameSpacesLoader;
import io.intino.sumus.graph.functions.PanelSource;
import io.intino.sumus.graph.functions.RecordSource;
import io.intino.sumus.graph.functions.StampSaveEvent;
import io.intino.sumus.graph.geolocated.GeolocatedEntity;
import io.intino.sumus.graph.holder.HolderCatalog;
import io.intino.sumus.graph.lock.LockEntity;
import io.intino.sumus.graph.menu.MenuLayout;
import io.intino.sumus.graph.reportholder.ReportHolderCatalog;
import io.intino.sumus.graph.rules.TimeScale;
import io.intino.sumus.graph.tab.TabLayout;
import io.intino.sumus.graph.temporalholder.TemporalHolderCatalog;
import io.intino.tara.magritte.Concept;
import io.intino.tara.magritte.Graph;
import io.intino.tara.magritte.GraphWrapper;
import io.intino.tara.magritte.Layer;
import io.intino.tara.magritte.Node;
import io.intino.tara.magritte.utils.I18n;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class AbstractGraph
extends GraphWrapper {
    protected Graph graph;
    private List<Record> recordList;
    private List<TemporalRecord> temporalRecordList;
    private List<Entity> entityList;
    private List<Event> eventList;
    private List<Episode> episodeList;
    private List<Report> reportList;
    private ProfileManager profileManager;
    private List<Cube> cubeList;
    private List<Checker> checkerList;
    private List<GeolocatedEntity> geolocatedEntityList;
    private List<DynamicEntity> dynamicEntityList;
    private List<LockEntity> lockEntityList;
    private List<AspectEntity> aspectEntityList;
    private List<KeyStore> keyStoreList;
    private List<Element> elementList;
    private List<ElementOption> elementOptionList;
    private List<Group> groupList;
    private List<Option> optionList;
    private List<Options> optionsList;
    private List<AbstractView> abstractViewList;
    private List<ElementRender> elementRenderList;
    private List<RenderPanel> renderPanelList;
    private List<RenderPanels> renderPanelsList;
    private List<RenderRecord> renderRecordList;
    private List<RenderRecords> renderRecordsList;
    private List<RenderCatalog> renderCatalogList;
    private List<RenderCatalogs> renderCatalogsList;
    private List<RenderMold> renderMoldList;
    private List<RenderOlap> renderOlapList;
    private List<Ticket> ticketList;
    private List<Olap> olapList;
    private List<Filter> filterList;
    private List<OnClickInstant> onClickInstantList;
    private Palette palette;
    private List<Categorization> categorizationList;
    private List<AbstractMetric> abstractMetricList;
    private List<Metric> metricList;
    private List<TemporalMetric> temporalMetricList;
    private List<NameSpace> nameSpaceList;
    private List<Mold> moldList;
    private List<EditableStamp> editableStampList;
    private List<ExpandedBlock> expandedBlockList;
    private Layout layout;
    private List<MenuLayout> menuLayoutList;
    private List<TabLayout> tabLayoutList;
    private List<Catalog> catalogList;
    private List<HolderCatalog> holderCatalogList;
    private List<EntityHolderCatalog> entityHolderCatalogList;
    private List<TemporalHolderCatalog> temporalHolderCatalogList;
    private List<EventHolderCatalog> eventHolderCatalogList;
    private List<ReportHolderCatalog> reportHolderCatalogList;
    private List<OnClickRecord> onClickRecordList;
    private List<Cluster> clusterList;
    private List<Panel> panelList;

    public AbstractGraph(Graph graph) {
        this.graph = graph;
        this.graph.i18n().register("Sumus");
    }

    public AbstractGraph(Graph graph, AbstractGraph wrapper) {
        this.graph = graph;
        this.graph.i18n().register("Sumus");
        this.recordList = new ArrayList<Record>(wrapper.recordList);
        this.temporalRecordList = new ArrayList<TemporalRecord>(wrapper.temporalRecordList);
        this.entityList = new ArrayList<Entity>(wrapper.entityList);
        this.eventList = new ArrayList<Event>(wrapper.eventList);
        this.episodeList = new ArrayList<Episode>(wrapper.episodeList);
        this.reportList = new ArrayList<Report>(wrapper.reportList);
        this.profileManager = wrapper.profileManager;
        this.cubeList = new ArrayList<Cube>(wrapper.cubeList);
        this.checkerList = new ArrayList<Checker>(wrapper.checkerList);
        this.geolocatedEntityList = new ArrayList<GeolocatedEntity>(wrapper.geolocatedEntityList);
        this.dynamicEntityList = new ArrayList<DynamicEntity>(wrapper.dynamicEntityList);
        this.lockEntityList = new ArrayList<LockEntity>(wrapper.lockEntityList);
        this.aspectEntityList = new ArrayList<AspectEntity>(wrapper.aspectEntityList);
        this.keyStoreList = new ArrayList<KeyStore>(wrapper.keyStoreList);
        this.elementList = new ArrayList<Element>(wrapper.elementList);
        this.elementOptionList = new ArrayList<ElementOption>(wrapper.elementOptionList);
        this.groupList = new ArrayList<Group>(wrapper.groupList);
        this.optionList = new ArrayList<Option>(wrapper.optionList);
        this.optionsList = new ArrayList<Options>(wrapper.optionsList);
        this.abstractViewList = new ArrayList<AbstractView>(wrapper.abstractViewList);
        this.elementRenderList = new ArrayList<ElementRender>(wrapper.elementRenderList);
        this.renderPanelList = new ArrayList<RenderPanel>(wrapper.renderPanelList);
        this.renderPanelsList = new ArrayList<RenderPanels>(wrapper.renderPanelsList);
        this.renderRecordList = new ArrayList<RenderRecord>(wrapper.renderRecordList);
        this.renderRecordsList = new ArrayList<RenderRecords>(wrapper.renderRecordsList);
        this.renderCatalogList = new ArrayList<RenderCatalog>(wrapper.renderCatalogList);
        this.renderCatalogsList = new ArrayList<RenderCatalogs>(wrapper.renderCatalogsList);
        this.renderMoldList = new ArrayList<RenderMold>(wrapper.renderMoldList);
        this.renderOlapList = new ArrayList<RenderOlap>(wrapper.renderOlapList);
        this.ticketList = new ArrayList<Ticket>(wrapper.ticketList);
        this.olapList = new ArrayList<Olap>(wrapper.olapList);
        this.filterList = new ArrayList<Filter>(wrapper.filterList);
        this.onClickInstantList = new ArrayList<OnClickInstant>(wrapper.onClickInstantList);
        this.palette = wrapper.palette;
        this.categorizationList = new ArrayList<Categorization>(wrapper.categorizationList);
        this.abstractMetricList = new ArrayList<AbstractMetric>(wrapper.abstractMetricList);
        this.metricList = new ArrayList<Metric>(wrapper.metricList);
        this.temporalMetricList = new ArrayList<TemporalMetric>(wrapper.temporalMetricList);
        this.nameSpaceList = new ArrayList<NameSpace>(wrapper.nameSpaceList);
        this.moldList = new ArrayList<Mold>(wrapper.moldList);
        this.editableStampList = new ArrayList<EditableStamp>(wrapper.editableStampList);
        this.expandedBlockList = new ArrayList<ExpandedBlock>(wrapper.expandedBlockList);
        this.layout = wrapper.layout;
        this.menuLayoutList = new ArrayList<MenuLayout>(wrapper.menuLayoutList);
        this.tabLayoutList = new ArrayList<TabLayout>(wrapper.tabLayoutList);
        this.catalogList = new ArrayList<Catalog>(wrapper.catalogList);
        this.holderCatalogList = new ArrayList<HolderCatalog>(wrapper.holderCatalogList);
        this.entityHolderCatalogList = new ArrayList<EntityHolderCatalog>(wrapper.entityHolderCatalogList);
        this.temporalHolderCatalogList = new ArrayList<TemporalHolderCatalog>(wrapper.temporalHolderCatalogList);
        this.eventHolderCatalogList = new ArrayList<EventHolderCatalog>(wrapper.eventHolderCatalogList);
        this.reportHolderCatalogList = new ArrayList<ReportHolderCatalog>(wrapper.reportHolderCatalogList);
        this.onClickRecordList = new ArrayList<OnClickRecord>(wrapper.onClickRecordList);
        this.clusterList = new ArrayList<Cluster>(wrapper.clusterList);
        this.panelList = new ArrayList<Panel>(wrapper.panelList);
    }

    public void update() {
        this.recordList = this.graph.rootList(Record.class);
        this.temporalRecordList = this.graph.rootList(TemporalRecord.class);
        this.entityList = this.graph.rootList(Entity.class);
        this.eventList = this.graph.rootList(Event.class);
        this.episodeList = this.graph.rootList(Episode.class);
        this.reportList = this.graph.rootList(Report.class);
        this.profileManager = this.graph.rootList(ProfileManager.class).stream().findFirst().orElse(null);
        this.cubeList = this.graph.rootList(Cube.class);
        this.checkerList = this.graph.rootList(Checker.class);
        this.geolocatedEntityList = this.graph.rootList(GeolocatedEntity.class);
        this.dynamicEntityList = this.graph.rootList(DynamicEntity.class);
        this.lockEntityList = this.graph.rootList(LockEntity.class);
        this.aspectEntityList = this.graph.rootList(AspectEntity.class);
        this.keyStoreList = this.graph.rootList(KeyStore.class);
        this.elementList = this.graph.rootList(Element.class);
        this.elementOptionList = this.graph.rootList(ElementOption.class);
        this.groupList = this.graph.rootList(Group.class);
        this.optionList = this.graph.rootList(Option.class);
        this.optionsList = this.graph.rootList(Options.class);
        this.abstractViewList = this.graph.rootList(AbstractView.class);
        this.elementRenderList = this.graph.rootList(ElementRender.class);
        this.renderPanelList = this.graph.rootList(RenderPanel.class);
        this.renderPanelsList = this.graph.rootList(RenderPanels.class);
        this.renderRecordList = this.graph.rootList(RenderRecord.class);
        this.renderRecordsList = this.graph.rootList(RenderRecords.class);
        this.renderCatalogList = this.graph.rootList(RenderCatalog.class);
        this.renderCatalogsList = this.graph.rootList(RenderCatalogs.class);
        this.renderMoldList = this.graph.rootList(RenderMold.class);
        this.renderOlapList = this.graph.rootList(RenderOlap.class);
        this.ticketList = this.graph.rootList(Ticket.class);
        this.olapList = this.graph.rootList(Olap.class);
        this.filterList = this.graph.rootList(Filter.class);
        this.onClickInstantList = this.graph.rootList(OnClickInstant.class);
        this.palette = this.graph.rootList(Palette.class).stream().findFirst().orElse(null);
        this.categorizationList = this.graph.rootList(Categorization.class);
        this.abstractMetricList = this.graph.rootList(AbstractMetric.class);
        this.metricList = this.graph.rootList(Metric.class);
        this.temporalMetricList = this.graph.rootList(TemporalMetric.class);
        this.nameSpaceList = this.graph.rootList(NameSpace.class);
        this.moldList = this.graph.rootList(Mold.class);
        this.editableStampList = this.graph.rootList(EditableStamp.class);
        this.expandedBlockList = this.graph.rootList(ExpandedBlock.class);
        this.layout = this.graph.rootList(Layout.class).stream().findFirst().orElse(null);
        this.menuLayoutList = this.graph.rootList(MenuLayout.class);
        this.tabLayoutList = this.graph.rootList(TabLayout.class);
        this.catalogList = this.graph.rootList(Catalog.class);
        this.holderCatalogList = this.graph.rootList(HolderCatalog.class);
        this.entityHolderCatalogList = this.graph.rootList(EntityHolderCatalog.class);
        this.temporalHolderCatalogList = this.graph.rootList(TemporalHolderCatalog.class);
        this.eventHolderCatalogList = this.graph.rootList(EventHolderCatalog.class);
        this.reportHolderCatalogList = this.graph.rootList(ReportHolderCatalog.class);
        this.onClickRecordList = this.graph.rootList(OnClickRecord.class);
        this.clusterList = this.graph.rootList(Cluster.class);
        this.panelList = this.graph.rootList(Panel.class);
    }

    protected void addNode$(Node node) {
        if (node.is("Record")) {
            this.recordList.add((Record)node.as(Record.class));
        }
        if (node.is("TemporalRecord")) {
            this.temporalRecordList.add((TemporalRecord)node.as(TemporalRecord.class));
        }
        if (node.is("Entity")) {
            this.entityList.add((Entity)node.as(Entity.class));
        }
        if (node.is("Event")) {
            this.eventList.add((Event)node.as(Event.class));
        }
        if (node.is("Episode")) {
            this.episodeList.add((Episode)node.as(Episode.class));
        }
        if (node.is("Report")) {
            this.reportList.add((Report)node.as(Report.class));
        }
        if (node.is("ProfileManager")) {
            this.profileManager = (ProfileManager)node.as(ProfileManager.class);
        }
        if (node.is("Cube")) {
            this.cubeList.add((Cube)node.as(Cube.class));
        }
        if (node.is("Checker")) {
            this.checkerList.add((Checker)node.as(Checker.class));
        }
        if (node.is("Geolocated#Entity")) {
            this.geolocatedEntityList.add((GeolocatedEntity)node.as(GeolocatedEntity.class));
        }
        if (node.is("Dynamic#Entity")) {
            this.dynamicEntityList.add((DynamicEntity)node.as(DynamicEntity.class));
        }
        if (node.is("Lock#Entity")) {
            this.lockEntityList.add((LockEntity)node.as(LockEntity.class));
        }
        if (node.is("Aspect#Entity")) {
            this.aspectEntityList.add((AspectEntity)node.as(AspectEntity.class));
        }
        if (node.is("KeyStore")) {
            this.keyStoreList.add((KeyStore)node.as(KeyStore.class));
        }
        if (node.is("Element")) {
            this.elementList.add((Element)node.as(Element.class));
        }
        if (node.is("ElementOption")) {
            this.elementOptionList.add((ElementOption)node.as(ElementOption.class));
        }
        if (node.is("Group")) {
            this.groupList.add((Group)node.as(Group.class));
        }
        if (node.is("Option")) {
            this.optionList.add((Option)node.as(Option.class));
        }
        if (node.is("Options")) {
            this.optionsList.add((Options)node.as(Options.class));
        }
        if (node.is("AbstractView")) {
            this.abstractViewList.add((AbstractView)node.as(AbstractView.class));
        }
        if (node.is("ElementRender")) {
            this.elementRenderList.add((ElementRender)node.as(ElementRender.class));
        }
        if (node.is("RenderPanel")) {
            this.renderPanelList.add((RenderPanel)node.as(RenderPanel.class));
        }
        if (node.is("RenderPanels")) {
            this.renderPanelsList.add((RenderPanels)node.as(RenderPanels.class));
        }
        if (node.is("RenderRecord")) {
            this.renderRecordList.add((RenderRecord)node.as(RenderRecord.class));
        }
        if (node.is("RenderRecords")) {
            this.renderRecordsList.add((RenderRecords)node.as(RenderRecords.class));
        }
        if (node.is("RenderCatalog")) {
            this.renderCatalogList.add((RenderCatalog)node.as(RenderCatalog.class));
        }
        if (node.is("RenderCatalogs")) {
            this.renderCatalogsList.add((RenderCatalogs)node.as(RenderCatalogs.class));
        }
        if (node.is("RenderMold")) {
            this.renderMoldList.add((RenderMold)node.as(RenderMold.class));
        }
        if (node.is("RenderOlap")) {
            this.renderOlapList.add((RenderOlap)node.as(RenderOlap.class));
        }
        if (node.is("Ticket")) {
            this.ticketList.add((Ticket)node.as(Ticket.class));
        }
        if (node.is("Olap")) {
            this.olapList.add((Olap)node.as(Olap.class));
        }
        if (node.is("Filter")) {
            this.filterList.add((Filter)node.as(Filter.class));
        }
        if (node.is("OnClickInstant")) {
            this.onClickInstantList.add((OnClickInstant)node.as(OnClickInstant.class));
        }
        if (node.is("Palette")) {
            this.palette = (Palette)node.as(Palette.class);
        }
        if (node.is("Categorization")) {
            this.categorizationList.add((Categorization)node.as(Categorization.class));
        }
        if (node.is("AbstractMetric")) {
            this.abstractMetricList.add((AbstractMetric)node.as(AbstractMetric.class));
        }
        if (node.is("Metric")) {
            this.metricList.add((Metric)node.as(Metric.class));
        }
        if (node.is("TemporalMetric")) {
            this.temporalMetricList.add((TemporalMetric)node.as(TemporalMetric.class));
        }
        if (node.is("NameSpace")) {
            this.nameSpaceList.add((NameSpace)node.as(NameSpace.class));
        }
        if (node.is("Mold")) {
            this.moldList.add((Mold)node.as(Mold.class));
        }
        if (node.is("Editable#Mold$Block$Stamp")) {
            this.editableStampList.add((EditableStamp)node.as(EditableStamp.class));
        }
        if (node.is("Expanded#Mold$Block")) {
            this.expandedBlockList.add((ExpandedBlock)node.as(ExpandedBlock.class));
        }
        if (node.is("Layout")) {
            this.layout = (Layout)node.as(Layout.class);
        }
        if (node.is("Menu#Layout")) {
            this.menuLayoutList.add((MenuLayout)node.as(MenuLayout.class));
        }
        if (node.is("Tab#Layout")) {
            this.tabLayoutList.add((TabLayout)node.as(TabLayout.class));
        }
        if (node.is("Catalog")) {
            this.catalogList.add((Catalog)node.as(Catalog.class));
        }
        if (node.is("Holder#Catalog")) {
            this.holderCatalogList.add((HolderCatalog)node.as(HolderCatalog.class));
        }
        if (node.is("EntityHolder#Catalog")) {
            this.entityHolderCatalogList.add((EntityHolderCatalog)node.as(EntityHolderCatalog.class));
        }
        if (node.is("TemporalHolder#Catalog")) {
            this.temporalHolderCatalogList.add((TemporalHolderCatalog)node.as(TemporalHolderCatalog.class));
        }
        if (node.is("EventHolder#Catalog")) {
            this.eventHolderCatalogList.add((EventHolderCatalog)node.as(EventHolderCatalog.class));
        }
        if (node.is("ReportHolder#Catalog")) {
            this.reportHolderCatalogList.add((ReportHolderCatalog)node.as(ReportHolderCatalog.class));
        }
        if (node.is("OnClickRecord")) {
            this.onClickRecordList.add((OnClickRecord)node.as(OnClickRecord.class));
        }
        if (node.is("Cluster")) {
            this.clusterList.add((Cluster)node.as(Cluster.class));
        }
        if (node.is("Panel")) {
            this.panelList.add((Panel)node.as(Panel.class));
        }
    }

    protected void removeNode$(Node node) {
        if (node.is("Record")) {
            this.recordList.remove(node.as(Record.class));
        }
        if (node.is("TemporalRecord")) {
            this.temporalRecordList.remove(node.as(TemporalRecord.class));
        }
        if (node.is("Entity")) {
            this.entityList.remove(node.as(Entity.class));
        }
        if (node.is("Event")) {
            this.eventList.remove(node.as(Event.class));
        }
        if (node.is("Episode")) {
            this.episodeList.remove(node.as(Episode.class));
        }
        if (node.is("Report")) {
            this.reportList.remove(node.as(Report.class));
        }
        if (node.is("ProfileManager")) {
            this.profileManager = null;
        }
        if (node.is("Cube")) {
            this.cubeList.remove(node.as(Cube.class));
        }
        if (node.is("Checker")) {
            this.checkerList.remove(node.as(Checker.class));
        }
        if (node.is("Geolocated#Entity")) {
            this.geolocatedEntityList.remove(node.as(GeolocatedEntity.class));
        }
        if (node.is("Dynamic#Entity")) {
            this.dynamicEntityList.remove(node.as(DynamicEntity.class));
        }
        if (node.is("Lock#Entity")) {
            this.lockEntityList.remove(node.as(LockEntity.class));
        }
        if (node.is("Aspect#Entity")) {
            this.aspectEntityList.remove(node.as(AspectEntity.class));
        }
        if (node.is("KeyStore")) {
            this.keyStoreList.remove(node.as(KeyStore.class));
        }
        if (node.is("Element")) {
            this.elementList.remove(node.as(Element.class));
        }
        if (node.is("ElementOption")) {
            this.elementOptionList.remove(node.as(ElementOption.class));
        }
        if (node.is("Group")) {
            this.groupList.remove(node.as(Group.class));
        }
        if (node.is("Option")) {
            this.optionList.remove(node.as(Option.class));
        }
        if (node.is("Options")) {
            this.optionsList.remove(node.as(Options.class));
        }
        if (node.is("AbstractView")) {
            this.abstractViewList.remove(node.as(AbstractView.class));
        }
        if (node.is("ElementRender")) {
            this.elementRenderList.remove(node.as(ElementRender.class));
        }
        if (node.is("RenderPanel")) {
            this.renderPanelList.remove(node.as(RenderPanel.class));
        }
        if (node.is("RenderPanels")) {
            this.renderPanelsList.remove(node.as(RenderPanels.class));
        }
        if (node.is("RenderRecord")) {
            this.renderRecordList.remove(node.as(RenderRecord.class));
        }
        if (node.is("RenderRecords")) {
            this.renderRecordsList.remove(node.as(RenderRecords.class));
        }
        if (node.is("RenderCatalog")) {
            this.renderCatalogList.remove(node.as(RenderCatalog.class));
        }
        if (node.is("RenderCatalogs")) {
            this.renderCatalogsList.remove(node.as(RenderCatalogs.class));
        }
        if (node.is("RenderMold")) {
            this.renderMoldList.remove(node.as(RenderMold.class));
        }
        if (node.is("RenderOlap")) {
            this.renderOlapList.remove(node.as(RenderOlap.class));
        }
        if (node.is("Ticket")) {
            this.ticketList.remove(node.as(Ticket.class));
        }
        if (node.is("Olap")) {
            this.olapList.remove(node.as(Olap.class));
        }
        if (node.is("Filter")) {
            this.filterList.remove(node.as(Filter.class));
        }
        if (node.is("OnClickInstant")) {
            this.onClickInstantList.remove(node.as(OnClickInstant.class));
        }
        if (node.is("Palette")) {
            this.palette = null;
        }
        if (node.is("Categorization")) {
            this.categorizationList.remove(node.as(Categorization.class));
        }
        if (node.is("AbstractMetric")) {
            this.abstractMetricList.remove(node.as(AbstractMetric.class));
        }
        if (node.is("Metric")) {
            this.metricList.remove(node.as(Metric.class));
        }
        if (node.is("TemporalMetric")) {
            this.temporalMetricList.remove(node.as(TemporalMetric.class));
        }
        if (node.is("NameSpace")) {
            this.nameSpaceList.remove(node.as(NameSpace.class));
        }
        if (node.is("Mold")) {
            this.moldList.remove(node.as(Mold.class));
        }
        if (node.is("Editable#Mold$Block$Stamp")) {
            this.editableStampList.remove(node.as(EditableStamp.class));
        }
        if (node.is("Expanded#Mold$Block")) {
            this.expandedBlockList.remove(node.as(ExpandedBlock.class));
        }
        if (node.is("Layout")) {
            this.layout = null;
        }
        if (node.is("Menu#Layout")) {
            this.menuLayoutList.remove(node.as(MenuLayout.class));
        }
        if (node.is("Tab#Layout")) {
            this.tabLayoutList.remove(node.as(TabLayout.class));
        }
        if (node.is("Catalog")) {
            this.catalogList.remove(node.as(Catalog.class));
        }
        if (node.is("Holder#Catalog")) {
            this.holderCatalogList.remove(node.as(HolderCatalog.class));
        }
        if (node.is("EntityHolder#Catalog")) {
            this.entityHolderCatalogList.remove(node.as(EntityHolderCatalog.class));
        }
        if (node.is("TemporalHolder#Catalog")) {
            this.temporalHolderCatalogList.remove(node.as(TemporalHolderCatalog.class));
        }
        if (node.is("EventHolder#Catalog")) {
            this.eventHolderCatalogList.remove(node.as(EventHolderCatalog.class));
        }
        if (node.is("ReportHolder#Catalog")) {
            this.reportHolderCatalogList.remove(node.as(ReportHolderCatalog.class));
        }
        if (node.is("OnClickRecord")) {
            this.onClickRecordList.remove(node.as(OnClickRecord.class));
        }
        if (node.is("Cluster")) {
            this.clusterList.remove(node.as(Cluster.class));
        }
        if (node.is("Panel")) {
            this.panelList.remove(node.as(Panel.class));
        }
    }

    public URL resourceAsMessage$(String language, String key) {
        return this.graph.loadResource(this.graph.i18n().message(language, key, new Object[0]));
    }

    public List<Record> recordList() {
        return this.recordList;
    }

    public List<TemporalRecord> temporalRecordList() {
        return this.temporalRecordList;
    }

    public List<Entity> entityList() {
        return this.entityList;
    }

    public List<Event> eventList() {
        return this.eventList;
    }

    public List<Episode> episodeList() {
        return this.episodeList;
    }

    public List<Report> reportList() {
        return this.reportList;
    }

    public ProfileManager profileManager() {
        return this.profileManager;
    }

    public List<Cube> cubeList() {
        return this.cubeList;
    }

    public List<Checker> checkerList() {
        return this.checkerList;
    }

    public List<GeolocatedEntity> geolocatedEntityList() {
        return this.geolocatedEntityList;
    }

    public List<DynamicEntity> dynamicEntityList() {
        return this.dynamicEntityList;
    }

    public List<LockEntity> lockEntityList() {
        return this.lockEntityList;
    }

    public List<AspectEntity> aspectEntityList() {
        return this.aspectEntityList;
    }

    public List<KeyStore> keyStoreList() {
        return this.keyStoreList;
    }

    public List<Element> elementList() {
        return this.elementList;
    }

    public List<ElementOption> elementOptionList() {
        return this.elementOptionList;
    }

    public List<Group> groupList() {
        return this.groupList;
    }

    public List<Option> optionList() {
        return this.optionList;
    }

    public List<Options> optionsList() {
        return this.optionsList;
    }

    public List<AbstractView> abstractViewList() {
        return this.abstractViewList;
    }

    public List<ElementRender> elementRenderList() {
        return this.elementRenderList;
    }

    public List<RenderPanel> renderPanelList() {
        return this.renderPanelList;
    }

    public List<RenderPanels> renderPanelsList() {
        return this.renderPanelsList;
    }

    public List<RenderRecord> renderRecordList() {
        return this.renderRecordList;
    }

    public List<RenderRecords> renderRecordsList() {
        return this.renderRecordsList;
    }

    public List<RenderCatalog> renderCatalogList() {
        return this.renderCatalogList;
    }

    public List<RenderCatalogs> renderCatalogsList() {
        return this.renderCatalogsList;
    }

    public List<RenderMold> renderMoldList() {
        return this.renderMoldList;
    }

    public List<RenderOlap> renderOlapList() {
        return this.renderOlapList;
    }

    public List<Ticket> ticketList() {
        return this.ticketList;
    }

    public List<Olap> olapList() {
        return this.olapList;
    }

    public List<Filter> filterList() {
        return this.filterList;
    }

    public List<OnClickInstant> onClickInstantList() {
        return this.onClickInstantList;
    }

    public Palette palette() {
        return this.palette;
    }

    public List<Categorization> categorizationList() {
        return this.categorizationList;
    }

    public List<AbstractMetric> abstractMetricList() {
        return this.abstractMetricList;
    }

    public List<Metric> metricList() {
        return this.metricList;
    }

    public List<TemporalMetric> temporalMetricList() {
        return this.temporalMetricList;
    }

    public List<NameSpace> nameSpaceList() {
        return this.nameSpaceList;
    }

    public List<Mold> moldList() {
        return this.moldList;
    }

    public List<EditableStamp> editableStampList() {
        return this.editableStampList;
    }

    public List<ExpandedBlock> expandedBlockList() {
        return this.expandedBlockList;
    }

    public Layout layout() {
        return this.layout;
    }

    public List<MenuLayout> menuLayoutList() {
        return this.menuLayoutList;
    }

    public List<TabLayout> tabLayoutList() {
        return this.tabLayoutList;
    }

    public List<Catalog> catalogList() {
        return this.catalogList;
    }

    public List<HolderCatalog> holderCatalogList() {
        return this.holderCatalogList;
    }

    public List<EntityHolderCatalog> entityHolderCatalogList() {
        return this.entityHolderCatalogList;
    }

    public List<TemporalHolderCatalog> temporalHolderCatalogList() {
        return this.temporalHolderCatalogList;
    }

    public List<EventHolderCatalog> eventHolderCatalogList() {
        return this.eventHolderCatalogList;
    }

    public List<ReportHolderCatalog> reportHolderCatalogList() {
        return this.reportHolderCatalogList;
    }

    public List<OnClickRecord> onClickRecordList() {
        return this.onClickRecordList;
    }

    public List<Cluster> clusterList() {
        return this.clusterList;
    }

    public List<Panel> panelList() {
        return this.panelList;
    }

    public Stream<Record> recordList(Predicate<Record> filter) {
        return this.recordList.stream().filter(filter);
    }

    public Record record(int index) {
        return this.recordList.get(index);
    }

    public Stream<TemporalRecord> temporalRecordList(Predicate<TemporalRecord> filter) {
        return this.temporalRecordList.stream().filter(filter);
    }

    public TemporalRecord temporalRecord(int index) {
        return this.temporalRecordList.get(index);
    }

    public Stream<Entity> entityList(Predicate<Entity> filter) {
        return this.entityList.stream().filter(filter);
    }

    public Entity entity(int index) {
        return this.entityList.get(index);
    }

    public Stream<Event> eventList(Predicate<Event> filter) {
        return this.eventList.stream().filter(filter);
    }

    public Event event(int index) {
        return this.eventList.get(index);
    }

    public Stream<Episode> episodeList(Predicate<Episode> filter) {
        return this.episodeList.stream().filter(filter);
    }

    public Episode episode(int index) {
        return this.episodeList.get(index);
    }

    public Stream<Report> reportList(Predicate<Report> filter) {
        return this.reportList.stream().filter(filter);
    }

    public Report report(int index) {
        return this.reportList.get(index);
    }

    public Stream<Cube> cubeList(Predicate<Cube> filter) {
        return this.cubeList.stream().filter(filter);
    }

    public Cube cube(int index) {
        return this.cubeList.get(index);
    }

    public Stream<Checker> checkerList(Predicate<Checker> filter) {
        return this.checkerList.stream().filter(filter);
    }

    public Checker checker(int index) {
        return this.checkerList.get(index);
    }

    public Stream<GeolocatedEntity> geolocatedEntityList(Predicate<GeolocatedEntity> filter) {
        return this.geolocatedEntityList.stream().filter(filter);
    }

    public GeolocatedEntity geolocatedEntity(int index) {
        return this.geolocatedEntityList.get(index);
    }

    public Stream<DynamicEntity> dynamicEntityList(Predicate<DynamicEntity> filter) {
        return this.dynamicEntityList.stream().filter(filter);
    }

    public DynamicEntity dynamicEntity(int index) {
        return this.dynamicEntityList.get(index);
    }

    public Stream<LockEntity> lockEntityList(Predicate<LockEntity> filter) {
        return this.lockEntityList.stream().filter(filter);
    }

    public LockEntity lockEntity(int index) {
        return this.lockEntityList.get(index);
    }

    public Stream<AspectEntity> aspectEntityList(Predicate<AspectEntity> filter) {
        return this.aspectEntityList.stream().filter(filter);
    }

    public AspectEntity aspectEntity(int index) {
        return this.aspectEntityList.get(index);
    }

    public Stream<KeyStore> keyStoreList(Predicate<KeyStore> filter) {
        return this.keyStoreList.stream().filter(filter);
    }

    public KeyStore keyStore(int index) {
        return this.keyStoreList.get(index);
    }

    public Stream<Element> elementList(Predicate<Element> filter) {
        return this.elementList.stream().filter(filter);
    }

    public Element element(int index) {
        return this.elementList.get(index);
    }

    public Stream<ElementOption> elementOptionList(Predicate<ElementOption> filter) {
        return this.elementOptionList.stream().filter(filter);
    }

    public ElementOption elementOption(int index) {
        return this.elementOptionList.get(index);
    }

    public Stream<Group> groupList(Predicate<Group> filter) {
        return this.groupList.stream().filter(filter);
    }

    public Group group(int index) {
        return this.groupList.get(index);
    }

    public Stream<Option> optionList(Predicate<Option> filter) {
        return this.optionList.stream().filter(filter);
    }

    public Option option(int index) {
        return this.optionList.get(index);
    }

    public Stream<Options> optionsList(Predicate<Options> filter) {
        return this.optionsList.stream().filter(filter);
    }

    public Options options(int index) {
        return this.optionsList.get(index);
    }

    public Stream<AbstractView> abstractViewList(Predicate<AbstractView> filter) {
        return this.abstractViewList.stream().filter(filter);
    }

    public AbstractView abstractView(int index) {
        return this.abstractViewList.get(index);
    }

    public Stream<ElementRender> elementRenderList(Predicate<ElementRender> filter) {
        return this.elementRenderList.stream().filter(filter);
    }

    public ElementRender elementRender(int index) {
        return this.elementRenderList.get(index);
    }

    public Stream<RenderPanel> renderPanelList(Predicate<RenderPanel> filter) {
        return this.renderPanelList.stream().filter(filter);
    }

    public RenderPanel renderPanel(int index) {
        return this.renderPanelList.get(index);
    }

    public Stream<RenderPanels> renderPanelsList(Predicate<RenderPanels> filter) {
        return this.renderPanelsList.stream().filter(filter);
    }

    public RenderPanels renderPanels(int index) {
        return this.renderPanelsList.get(index);
    }

    public Stream<RenderRecord> renderRecordList(Predicate<RenderRecord> filter) {
        return this.renderRecordList.stream().filter(filter);
    }

    public RenderRecord renderRecord(int index) {
        return this.renderRecordList.get(index);
    }

    public Stream<RenderRecords> renderRecordsList(Predicate<RenderRecords> filter) {
        return this.renderRecordsList.stream().filter(filter);
    }

    public RenderRecords renderRecords(int index) {
        return this.renderRecordsList.get(index);
    }

    public Stream<RenderCatalog> renderCatalogList(Predicate<RenderCatalog> filter) {
        return this.renderCatalogList.stream().filter(filter);
    }

    public RenderCatalog renderCatalog(int index) {
        return this.renderCatalogList.get(index);
    }

    public Stream<RenderCatalogs> renderCatalogsList(Predicate<RenderCatalogs> filter) {
        return this.renderCatalogsList.stream().filter(filter);
    }

    public RenderCatalogs renderCatalogs(int index) {
        return this.renderCatalogsList.get(index);
    }

    public Stream<RenderMold> renderMoldList(Predicate<RenderMold> filter) {
        return this.renderMoldList.stream().filter(filter);
    }

    public RenderMold renderMold(int index) {
        return this.renderMoldList.get(index);
    }

    public Stream<RenderOlap> renderOlapList(Predicate<RenderOlap> filter) {
        return this.renderOlapList.stream().filter(filter);
    }

    public RenderOlap renderOlap(int index) {
        return this.renderOlapList.get(index);
    }

    public Stream<Ticket> ticketList(Predicate<Ticket> filter) {
        return this.ticketList.stream().filter(filter);
    }

    public Ticket ticket(int index) {
        return this.ticketList.get(index);
    }

    public Stream<Olap> olapList(Predicate<Olap> filter) {
        return this.olapList.stream().filter(filter);
    }

    public Olap olap(int index) {
        return this.olapList.get(index);
    }

    public Stream<Filter> filterList(Predicate<Filter> filter) {
        return this.filterList.stream().filter(filter);
    }

    public Filter filter(int index) {
        return this.filterList.get(index);
    }

    public Stream<OnClickInstant> onClickInstantList(Predicate<OnClickInstant> filter) {
        return this.onClickInstantList.stream().filter(filter);
    }

    public OnClickInstant onClickInstant(int index) {
        return this.onClickInstantList.get(index);
    }

    public Stream<Categorization> categorizationList(Predicate<Categorization> filter) {
        return this.categorizationList.stream().filter(filter);
    }

    public Categorization categorization(int index) {
        return this.categorizationList.get(index);
    }

    public Stream<AbstractMetric> abstractMetricList(Predicate<AbstractMetric> filter) {
        return this.abstractMetricList.stream().filter(filter);
    }

    public AbstractMetric abstractMetric(int index) {
        return this.abstractMetricList.get(index);
    }

    public Stream<Metric> metricList(Predicate<Metric> filter) {
        return this.metricList.stream().filter(filter);
    }

    public Metric metric(int index) {
        return this.metricList.get(index);
    }

    public Stream<TemporalMetric> temporalMetricList(Predicate<TemporalMetric> filter) {
        return this.temporalMetricList.stream().filter(filter);
    }

    public TemporalMetric temporalMetric(int index) {
        return this.temporalMetricList.get(index);
    }

    public Stream<NameSpace> nameSpaceList(Predicate<NameSpace> filter) {
        return this.nameSpaceList.stream().filter(filter);
    }

    public NameSpace nameSpace(int index) {
        return this.nameSpaceList.get(index);
    }

    public Stream<Mold> moldList(Predicate<Mold> filter) {
        return this.moldList.stream().filter(filter);
    }

    public Mold mold(int index) {
        return this.moldList.get(index);
    }

    public Stream<EditableStamp> editableStampList(Predicate<EditableStamp> filter) {
        return this.editableStampList.stream().filter(filter);
    }

    public EditableStamp editableStamp(int index) {
        return this.editableStampList.get(index);
    }

    public Stream<ExpandedBlock> expandedBlockList(Predicate<ExpandedBlock> filter) {
        return this.expandedBlockList.stream().filter(filter);
    }

    public ExpandedBlock expandedBlock(int index) {
        return this.expandedBlockList.get(index);
    }

    public Stream<MenuLayout> menuLayoutList(Predicate<MenuLayout> filter) {
        return this.menuLayoutList.stream().filter(filter);
    }

    public MenuLayout menuLayout(int index) {
        return this.menuLayoutList.get(index);
    }

    public Stream<TabLayout> tabLayoutList(Predicate<TabLayout> filter) {
        return this.tabLayoutList.stream().filter(filter);
    }

    public TabLayout tabLayout(int index) {
        return this.tabLayoutList.get(index);
    }

    public Stream<Catalog> catalogList(Predicate<Catalog> filter) {
        return this.catalogList.stream().filter(filter);
    }

    public Catalog catalog(int index) {
        return this.catalogList.get(index);
    }

    public Stream<HolderCatalog> holderCatalogList(Predicate<HolderCatalog> filter) {
        return this.holderCatalogList.stream().filter(filter);
    }

    public HolderCatalog holderCatalog(int index) {
        return this.holderCatalogList.get(index);
    }

    public Stream<EntityHolderCatalog> entityHolderCatalogList(Predicate<EntityHolderCatalog> filter) {
        return this.entityHolderCatalogList.stream().filter(filter);
    }

    public EntityHolderCatalog entityHolderCatalog(int index) {
        return this.entityHolderCatalogList.get(index);
    }

    public Stream<TemporalHolderCatalog> temporalHolderCatalogList(Predicate<TemporalHolderCatalog> filter) {
        return this.temporalHolderCatalogList.stream().filter(filter);
    }

    public TemporalHolderCatalog temporalHolderCatalog(int index) {
        return this.temporalHolderCatalogList.get(index);
    }

    public Stream<EventHolderCatalog> eventHolderCatalogList(Predicate<EventHolderCatalog> filter) {
        return this.eventHolderCatalogList.stream().filter(filter);
    }

    public EventHolderCatalog eventHolderCatalog(int index) {
        return this.eventHolderCatalogList.get(index);
    }

    public Stream<ReportHolderCatalog> reportHolderCatalogList(Predicate<ReportHolderCatalog> filter) {
        return this.reportHolderCatalogList.stream().filter(filter);
    }

    public ReportHolderCatalog reportHolderCatalog(int index) {
        return this.reportHolderCatalogList.get(index);
    }

    public Stream<OnClickRecord> onClickRecordList(Predicate<OnClickRecord> filter) {
        return this.onClickRecordList.stream().filter(filter);
    }

    public OnClickRecord onClickRecord(int index) {
        return this.onClickRecordList.get(index);
    }

    public Stream<Cluster> clusterList(Predicate<Cluster> filter) {
        return this.clusterList.stream().filter(filter);
    }

    public Cluster cluster(int index) {
        return this.clusterList.get(index);
    }

    public Stream<Panel> panelList(Predicate<Panel> filter) {
        return this.panelList.stream().filter(filter);
    }

    public Panel panel(int index) {
        return this.panelList.get(index);
    }

    public Graph core$() {
        return this.graph;
    }

    public I18n i18n$() {
        return this.graph.i18n();
    }

    public Create create() {
        return new Create("Misc", null);
    }

    public Create create(String stash) {
        return new Create(stash, null);
    }

    public Create create(String stash, String name) {
        return new Create(stash, name);
    }

    public Clear clear() {
        return new Clear();
    }

    public class Clear {
        public void cube(Predicate<Cube> filter) {
            new ArrayList<Cube>(AbstractGraph.this.cubeList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void checker(Predicate<Checker> filter) {
            new ArrayList<Checker>(AbstractGraph.this.checkerList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void keyStore(Predicate<KeyStore> filter) {
            new ArrayList<KeyStore>(AbstractGraph.this.keyStoreList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void group(Predicate<Group> filter) {
            new ArrayList<Group>(AbstractGraph.this.groupList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void option(Predicate<Option> filter) {
            new ArrayList<Option>(AbstractGraph.this.optionList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void options(Predicate<Options> filter) {
            new ArrayList<Options>(AbstractGraph.this.optionsList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void abstractView(Predicate<AbstractView> filter) {
            new ArrayList<AbstractView>(AbstractGraph.this.abstractViewList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void renderPanel(Predicate<RenderPanel> filter) {
            new ArrayList<RenderPanel>(AbstractGraph.this.renderPanelList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void renderPanels(Predicate<RenderPanels> filter) {
            new ArrayList<RenderPanels>(AbstractGraph.this.renderPanelsList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void renderRecord(Predicate<RenderRecord> filter) {
            new ArrayList<RenderRecord>(AbstractGraph.this.renderRecordList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void renderRecords(Predicate<RenderRecords> filter) {
            new ArrayList<RenderRecords>(AbstractGraph.this.renderRecordsList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void renderCatalog(Predicate<RenderCatalog> filter) {
            new ArrayList<RenderCatalog>(AbstractGraph.this.renderCatalogList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void renderCatalogs(Predicate<RenderCatalogs> filter) {
            new ArrayList<RenderCatalogs>(AbstractGraph.this.renderCatalogsList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void renderMold(Predicate<RenderMold> filter) {
            new ArrayList<RenderMold>(AbstractGraph.this.renderMoldList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void renderOlap(Predicate<RenderOlap> filter) {
            new ArrayList<RenderOlap>(AbstractGraph.this.renderOlapList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void ticket(Predicate<Ticket> filter) {
            new ArrayList<Ticket>(AbstractGraph.this.ticketList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void olap(Predicate<Olap> filter) {
            new ArrayList<Olap>(AbstractGraph.this.olapList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void filter(Predicate<Filter> filter) {
            new ArrayList<Filter>(AbstractGraph.this.filterList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void onClickInstant(Predicate<OnClickInstant> filter) {
            new ArrayList<OnClickInstant>(AbstractGraph.this.onClickInstantList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void categorization(Predicate<Categorization> filter) {
            new ArrayList<Categorization>(AbstractGraph.this.categorizationList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void metric(Predicate<Metric> filter) {
            new ArrayList<Metric>(AbstractGraph.this.metricList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void temporalMetric(Predicate<TemporalMetric> filter) {
            new ArrayList<TemporalMetric>(AbstractGraph.this.temporalMetricList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void nameSpace(Predicate<NameSpace> filter) {
            new ArrayList<NameSpace>(AbstractGraph.this.nameSpaceList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void mold(Predicate<Mold> filter) {
            new ArrayList<Mold>(AbstractGraph.this.moldList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void editableStamp(Predicate<EditableStamp> filter) {
            new ArrayList<EditableStamp>(AbstractGraph.this.editableStampList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void expandedBlock(Predicate<ExpandedBlock> filter) {
            new ArrayList<ExpandedBlock>(AbstractGraph.this.expandedBlockList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void menuLayout(Predicate<MenuLayout> filter) {
            new ArrayList<MenuLayout>(AbstractGraph.this.menuLayoutList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void tabLayout(Predicate<TabLayout> filter) {
            new ArrayList<TabLayout>(AbstractGraph.this.tabLayoutList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void catalog(Predicate<Catalog> filter) {
            new ArrayList<Catalog>(AbstractGraph.this.catalogList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void entityHolderCatalog(Predicate<EntityHolderCatalog> filter) {
            new ArrayList<EntityHolderCatalog>(AbstractGraph.this.entityHolderCatalogList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void eventHolderCatalog(Predicate<EventHolderCatalog> filter) {
            new ArrayList<EventHolderCatalog>(AbstractGraph.this.eventHolderCatalogList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void reportHolderCatalog(Predicate<ReportHolderCatalog> filter) {
            new ArrayList<ReportHolderCatalog>(AbstractGraph.this.reportHolderCatalogList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void onClickRecord(Predicate<OnClickRecord> filter) {
            new ArrayList<OnClickRecord>(AbstractGraph.this.onClickRecordList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void cluster(Predicate<Cluster> filter) {
            new ArrayList<Cluster>(AbstractGraph.this.clusterList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void panel(Predicate<Panel> filter) {
            new ArrayList<Panel>(AbstractGraph.this.panelList()).stream().filter(filter).forEach(Layer::delete$);
        }
    }

    public class Create {
        private final String stash;
        private final String name;

        public Create(String stash, String name) {
            this.stash = stash;
            this.name = name;
        }

        public ProfileManager profileManager() {
            ProfileManager newElement = (ProfileManager)((ProfileManager)AbstractGraph.this.graph.createRoot(ProfileManager.class, this.stash, this.name)).a$(ProfileManager.class);
            return newElement;
        }

        public Cube cube() {
            Cube newElement = (Cube)((Cube)AbstractGraph.this.graph.createRoot(Cube.class, this.stash, this.name)).a$(Cube.class);
            return newElement;
        }

        public Checker checker(Concept record) {
            Checker newElement = (Checker)((Checker)AbstractGraph.this.graph.createRoot(Checker.class, this.stash, this.name)).a$(Checker.class);
            newElement.core$().set((Layer)newElement, "record", Collections.singletonList(record));
            return newElement;
        }

        public KeyStore keyStore() {
            KeyStore newElement = (KeyStore)((KeyStore)AbstractGraph.this.graph.createRoot(KeyStore.class, this.stash, this.name)).a$(KeyStore.class);
            return newElement;
        }

        public Group group(String label) {
            Group newElement = (Group)((Group)AbstractGraph.this.graph.createRoot(Group.class, this.stash, this.name)).a$(Group.class);
            newElement.core$().set((Layer)newElement, "label", Collections.singletonList(label));
            return newElement;
        }

        public Option option(String label) {
            Option newElement = (Option)((Option)AbstractGraph.this.graph.createRoot(Option.class, this.stash, this.name)).a$(Option.class);
            newElement.core$().set((Layer)newElement, "label", Collections.singletonList(label));
            return newElement;
        }

        public Options options() {
            Options newElement = (Options)((Options)AbstractGraph.this.graph.createRoot(Options.class, this.stash, this.name)).a$(Options.class);
            return newElement;
        }

        public AbstractView abstractView() {
            AbstractView newElement = (AbstractView)((AbstractView)AbstractGraph.this.graph.createRoot(AbstractView.class, this.stash, this.name)).a$(AbstractView.class);
            return newElement;
        }

        public RenderPanel renderPanel(Panel panel) {
            RenderPanel newElement = (RenderPanel)((RenderPanel)AbstractGraph.this.graph.createRoot(RenderPanel.class, this.stash, this.name)).a$(RenderPanel.class);
            newElement.core$().set((Layer)newElement, "panel", Collections.singletonList(panel));
            return newElement;
        }

        public RenderPanels renderPanels(PanelSource source) {
            RenderPanels newElement = (RenderPanels)((RenderPanels)AbstractGraph.this.graph.createRoot(RenderPanels.class, this.stash, this.name)).a$(RenderPanels.class);
            newElement.core$().set((Layer)newElement, "source", Collections.singletonList(source));
            return newElement;
        }

        public RenderRecord renderRecord(Panel container) {
            RenderRecord newElement = (RenderRecord)((RenderRecord)AbstractGraph.this.graph.createRoot(RenderRecord.class, this.stash, this.name)).a$(RenderRecord.class);
            newElement.core$().set((Layer)newElement, "container", Collections.singletonList(container));
            return newElement;
        }

        public RenderRecords renderRecords(RecordSource source, Panel panel) {
            RenderRecords newElement = (RenderRecords)((RenderRecords)AbstractGraph.this.graph.createRoot(RenderRecords.class, this.stash, this.name)).a$(RenderRecords.class);
            newElement.core$().set((Layer)newElement, "source", Collections.singletonList(source));
            newElement.core$().set((Layer)newElement, "panel", Collections.singletonList(panel));
            return newElement;
        }

        public RenderCatalog renderCatalog(Catalog catalog) {
            RenderCatalog newElement = (RenderCatalog)((RenderCatalog)AbstractGraph.this.graph.createRoot(RenderCatalog.class, this.stash, this.name)).a$(RenderCatalog.class);
            newElement.core$().set((Layer)newElement, "catalog", Collections.singletonList(catalog));
            return newElement;
        }

        public RenderCatalogs renderCatalogs() {
            RenderCatalogs newElement = (RenderCatalogs)((RenderCatalogs)AbstractGraph.this.graph.createRoot(RenderCatalogs.class, this.stash, this.name)).a$(RenderCatalogs.class);
            return newElement;
        }

        public RenderMold renderMold(Mold mold) {
            RenderMold newElement = (RenderMold)((RenderMold)AbstractGraph.this.graph.createRoot(RenderMold.class, this.stash, this.name)).a$(RenderMold.class);
            newElement.core$().set((Layer)newElement, "mold", Collections.singletonList(mold));
            return newElement;
        }

        public RenderOlap renderOlap(Olap olap) {
            RenderOlap newElement = (RenderOlap)((RenderOlap)AbstractGraph.this.graph.createRoot(RenderOlap.class, this.stash, this.name)).a$(RenderOlap.class);
            newElement.core$().set((Layer)newElement, "olap", Collections.singletonList(olap));
            return newElement;
        }

        public Ticket ticket(String label, String shortLabel, List<Concept> events) {
            Ticket newElement = (Ticket)((Ticket)AbstractGraph.this.graph.createRoot(Ticket.class, this.stash, this.name)).a$(Ticket.class);
            newElement.core$().set((Layer)newElement, "label", Collections.singletonList(label));
            newElement.core$().set((Layer)newElement, "shortLabel", Collections.singletonList(shortLabel));
            newElement.core$().set((Layer)newElement, "events", events);
            return newElement;
        }

        public Olap olap(String label, NameSpacesLoader nameSpaces, List<Ticket> tickets) {
            Olap newElement = (Olap)((Olap)AbstractGraph.this.graph.createRoot(Olap.class, this.stash, this.name)).a$(Olap.class);
            newElement.core$().set((Layer)newElement, "label", Collections.singletonList(label));
            newElement.core$().set((Layer)newElement, "nameSpaces", Collections.singletonList(nameSpaces));
            newElement.core$().set((Layer)newElement, "tickets", tickets);
            return newElement;
        }

        public Filter filter(String label, String username) {
            Filter newElement = (Filter)((Filter)AbstractGraph.this.graph.createRoot(Filter.class, this.stash, this.name)).a$(Filter.class);
            newElement.core$().set((Layer)newElement, "label", Collections.singletonList(label));
            newElement.core$().set((Layer)newElement, "username", Collections.singletonList(username));
            return newElement;
        }

        public OnClickInstant onClickInstant(List<Catalog> catalogs) {
            OnClickInstant newElement = (OnClickInstant)((OnClickInstant)AbstractGraph.this.graph.createRoot(OnClickInstant.class, this.stash, this.name)).a$(OnClickInstant.class);
            newElement.core$().set((Layer)newElement, "catalogs", catalogs);
            return newElement;
        }

        public Palette palette() {
            Palette newElement = (Palette)((Palette)AbstractGraph.this.graph.createRoot(Palette.class, this.stash, this.name)).a$(Palette.class);
            return newElement;
        }

        public Categorization categorization(String label, Concept record, Attribute attribute) {
            Categorization newElement = (Categorization)((Categorization)AbstractGraph.this.graph.createRoot(Categorization.class, this.stash, this.name)).a$(Categorization.class);
            newElement.core$().set((Layer)newElement, "label", Collections.singletonList(label));
            newElement.core$().set((Layer)newElement, "record", Collections.singletonList(record));
            newElement.core$().set((Layer)newElement, "attribute", Collections.singletonList(attribute));
            return newElement;
        }

        public Metric metric() {
            Metric newElement = (Metric)((Metric)AbstractGraph.this.graph.createRoot(Metric.class, this.stash, this.name)).a$(Metric.class);
            return newElement;
        }

        public TemporalMetric temporalMetric() {
            TemporalMetric newElement = (TemporalMetric)((TemporalMetric)AbstractGraph.this.graph.createRoot(TemporalMetric.class, this.stash, this.name)).a$(TemporalMetric.class);
            return newElement;
        }

        public NameSpace nameSpace(String label) {
            NameSpace newElement = (NameSpace)((NameSpace)AbstractGraph.this.graph.createRoot(NameSpace.class, this.stash, this.name)).a$(NameSpace.class);
            newElement.core$().set((Layer)newElement, "label", Collections.singletonList(label));
            return newElement;
        }

        public Mold mold() {
            Mold newElement = (Mold)((Mold)AbstractGraph.this.graph.createRoot(Mold.class, this.stash, this.name)).a$(Mold.class);
            return newElement;
        }

        public EditableStamp editableStamp(StampSaveEvent onSave) {
            EditableStamp newElement = (EditableStamp)((EditableStamp)AbstractGraph.this.graph.createRoot(EditableStamp.class, this.stash, this.name)).a$(EditableStamp.class);
            newElement.core$().set((Layer)newElement, "onSave", Collections.singletonList(onSave));
            return newElement;
        }

        public ExpandedBlock expandedBlock() {
            ExpandedBlock newElement = (ExpandedBlock)((ExpandedBlock)AbstractGraph.this.graph.createRoot(ExpandedBlock.class, this.stash, this.name)).a$(ExpandedBlock.class);
            return newElement;
        }

        public Layout layout() {
            Layout newElement = (Layout)((Layout)AbstractGraph.this.graph.createRoot(Layout.class, this.stash, this.name)).a$(Layout.class);
            return newElement;
        }

        public MenuLayout menuLayout() {
            MenuLayout newElement = (MenuLayout)((MenuLayout)AbstractGraph.this.graph.createRoot(MenuLayout.class, this.stash, this.name)).a$(MenuLayout.class);
            return newElement;
        }

        public TabLayout tabLayout() {
            TabLayout newElement = (TabLayout)((TabLayout)AbstractGraph.this.graph.createRoot(TabLayout.class, this.stash, this.name)).a$(TabLayout.class);
            return newElement;
        }

        public Catalog catalog(String label) {
            Catalog newElement = (Catalog)((Catalog)AbstractGraph.this.graph.createRoot(Catalog.class, this.stash, this.name)).a$(Catalog.class);
            newElement.core$().set((Layer)newElement, "label", Collections.singletonList(label));
            return newElement;
        }

        public EntityHolderCatalog entityHolderCatalog(Concept entity) {
            EntityHolderCatalog newElement = (EntityHolderCatalog)((EntityHolderCatalog)AbstractGraph.this.graph.createRoot(EntityHolderCatalog.class, this.stash, this.name)).a$(EntityHolderCatalog.class);
            newElement.core$().set((Layer)newElement, "entity", Collections.singletonList(entity));
            return newElement;
        }

        public EventHolderCatalog eventHolderCatalog(List<TimeScale> scales, NameSpacesLoader nameSpaces, Concept event) {
            EventHolderCatalog newElement = (EventHolderCatalog)((EventHolderCatalog)AbstractGraph.this.graph.createRoot(EventHolderCatalog.class, this.stash, this.name)).a$(EventHolderCatalog.class);
            newElement.core$().set((Layer)newElement, "scales", scales);
            newElement.core$().set((Layer)newElement, "nameSpaces", Collections.singletonList(nameSpaces));
            newElement.core$().set((Layer)newElement, "event", Collections.singletonList(event));
            return newElement;
        }

        public ReportHolderCatalog reportHolderCatalog(List<TimeScale> scales, NameSpacesLoader nameSpaces, Concept report) {
            ReportHolderCatalog newElement = (ReportHolderCatalog)((ReportHolderCatalog)AbstractGraph.this.graph.createRoot(ReportHolderCatalog.class, this.stash, this.name)).a$(ReportHolderCatalog.class);
            newElement.core$().set((Layer)newElement, "scales", scales);
            newElement.core$().set((Layer)newElement, "nameSpaces", Collections.singletonList(nameSpaces));
            newElement.core$().set((Layer)newElement, "report", Collections.singletonList(report));
            return newElement;
        }

        public OnClickRecord onClickRecord() {
            OnClickRecord newElement = (OnClickRecord)((OnClickRecord)AbstractGraph.this.graph.createRoot(OnClickRecord.class, this.stash, this.name)).a$(OnClickRecord.class);
            return newElement;
        }

        public Cluster cluster(Catalog catalog, String label, String username) {
            Cluster newElement = (Cluster)((Cluster)AbstractGraph.this.graph.createRoot(Cluster.class, this.stash, this.name)).a$(Cluster.class);
            newElement.core$().set((Layer)newElement, "catalog", Collections.singletonList(catalog));
            newElement.core$().set((Layer)newElement, "label", Collections.singletonList(label));
            newElement.core$().set((Layer)newElement, "username", Collections.singletonList(username));
            return newElement;
        }

        public Panel panel(String label) {
            Panel newElement = (Panel)((Panel)AbstractGraph.this.graph.createRoot(Panel.class, this.stash, this.name)).a$(Panel.class);
            newElement.core$().set((Layer)newElement, "label", Collections.singletonList(label));
            return newElement;
        }
    }
}

