/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.datawarehouse.store;

import io.intino.sumus.SumusStore;
import io.intino.sumus.TimeStamp;
import io.intino.sumus.analytics.TimeRange;
import io.intino.sumus.graph.Cube;
import io.intino.sumus.graph.Event;
import io.intino.sumus.graph.NameSpace;
import io.intino.sumus.graph.rules.TimeScale;
import io.intino.sumus.helpers.UtcDateTime;
import io.intino.tara.magritte.Concept;
import io.intino.tara.magritte.Graph;
import io.intino.tara.magritte.Layer;
import java.time.Clock;
import java.time.Instant;
import java.time.temporal.WeekFields;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class PathBuilder {
    public static final String DigestsSuffix = "-digests";
    public static final String EventsSuffix = "-events";
    public static final String ReportsSuffix = "-reports";
    private static final String PathSeparator = "/";
    private static Map<Class<?>, String> classMap = new HashMap();

    public static String digestPath(NameSpace nameSpace, Cube cube, TimeStamp timeStamp) {
        ScaleBasedPathBuilder builder = ScaleBasedPathBuilder.fileNameBuilders.get((Object)timeStamp.scale());
        return nameSpace.name$() + DigestsSuffix + PathSeparator + cube.name$() + PathSeparator + builder.parentDirectory(timeStamp.instant()) + PathBuilder.formatFileName(builder.code(), builder.formattedInstantForFileName(timeStamp.instant()), builder.toString());
    }

    public static String digestPath(NameSpace nameSpace, Cube cube, TimeScale scale, Instant instant) {
        return PathBuilder.digestPath(nameSpace, cube, new TimeStamp(instant, scale));
    }

    public static String temporalRecordPath(NameSpace nameSpace, Concept temporalRecord, TimeStamp timeStamp) {
        Graph graph = nameSpace.graph().core$();
        ScaleBasedPathBuilder builder = ScaleBasedPathBuilder.fileNameBuilders.get((Object)timeStamp.scale());
        String suffix = temporalRecord.is(graph.concept(Event.class).id()) ? EventsSuffix : ReportsSuffix;
        return nameSpace.name$() + suffix + PathSeparator + PathBuilder.nameOf(temporalRecord).toLowerCase() + PathSeparator + builder.parentDirectory(timeStamp.instant()) + PathBuilder.formatFileName(builder.code(), builder.formattedInstantForFileName(timeStamp.instant()), builder.toString());
    }

    private static String nameOf(Concept temporalRecord) {
        Class layerClass = temporalRecord.layerClass();
        if (!classMap.containsKey(layerClass)) {
            classMap.put(layerClass, layerClass.getSimpleName());
        }
        return classMap.get(layerClass);
    }

    public static String temporalRecordPath(NameSpace nameSpace, Concept temporalRecord, TimeScale scale, Instant instant) {
        return PathBuilder.temporalRecordPath(nameSpace, temporalRecord, new TimeStamp(instant, scale));
    }

    public static String temporalRecordPath(NameSpace nameSpace, Class<? extends Layer> recordClass, TimeStamp timeStamp) {
        return PathBuilder.temporalRecordPath(nameSpace, nameSpace.core$().graph().concept(recordClass), timeStamp);
    }

    public static String temporalRecordPath(NameSpace nameSpace, Class<? extends Layer> recordClass, TimeScale scale, Instant instant) {
        return PathBuilder.temporalRecordPath(nameSpace, recordClass, new TimeStamp(instant, scale));
    }

    public static TimeRange range(List<NameSpace> nameSpaces) {
        if (nameSpaces.size() <= 0) {
            return null;
        }
        SumusStore store = (SumusStore)nameSpaces.get(0).graph().core$().store();
        List names = nameSpaces.stream().map(Layer::name$).collect(Collectors.toList());
        Instant from = names.stream().map(store::minInstantForNameSpace).min(Instant::compareTo).orElse(Instant.MIN);
        Instant to = names.stream().map(store::maxInstantForNameSpace).min(Instant::compareTo).orElse(Instant.now(Clock.systemUTC()));
        to = TimeScale.Day.addTo(to, 1L).minusMillis(1L);
        return new TimeRange(from, to, TimeScale.FifteenMinutes);
    }

    private static String formatFileName(String code, String instant, String scale) {
        return code + "-" + instant + "-" + scale;
    }

    private static String formatWith2Places(int number) {
        return number < 10 ? "0" + number : number + "";
    }

    private static String formatWith3Places(int number) {
        return number > 99 ? number + "" : (number > 9 ? "0" + number : "00" + number);
    }

    public static enum ScaleBasedPathBuilder {
        Year{

            @Override
            public String code() {
                return "A";
            }

            @Override
            String parentDirectory(Instant instant) {
                return "";
            }

            @Override
            String formattedInstantForFileName(Instant instant) {
                Instant normalisedInstant = TimeScale.Year.normalise(instant);
                return PathBuilder.formatWith2Places(UtcDateTime.yearOf(normalisedInstant));
            }
        }
        ,
        QuarterOfYear{

            @Override
            public String code() {
                return "D";
            }

            @Override
            String parentDirectory(Instant instant) {
                return UtcDateTime.yearOf(instant) + PathBuilder.PathSeparator;
            }

            @Override
            String formattedInstantForFileName(Instant instant) {
                Instant normalisedInstant = TimeScale.QuarterOfYear.normalise(instant);
                return PathBuilder.formatWith2Places(UtcDateTime.monthNumberOf(normalisedInstant));
            }
        }
        ,
        Month{

            @Override
            public String code() {
                return "C";
            }

            @Override
            String parentDirectory(Instant instant) {
                return UtcDateTime.yearOf(instant) + PathBuilder.PathSeparator;
            }

            @Override
            String formattedInstantForFileName(Instant instant) {
                Instant normalisedInstant = TimeScale.Month.normalise(instant);
                return PathBuilder.formatWith2Places(UtcDateTime.monthNumberOf(normalisedInstant));
            }
        }
        ,
        Week{

            @Override
            public String code() {
                return "B";
            }

            @Override
            String parentDirectory(Instant instant) {
                Instant normalisedInstant = TimeScale.Week.normalise(instant);
                return UtcDateTime.of(normalisedInstant).year() + PathBuilder.PathSeparator;
            }

            @Override
            String formattedInstantForFileName(Instant instant) {
                UtcDateTime normalisedInstant = UtcDateTime.of(TimeScale.Week.normalise(instant));
                return PathBuilder.formatWith2Places(normalisedInstant.get(WeekFields.ISO.weekOfWeekBasedYear()));
            }
        }
        ,
        Day{

            @Override
            public String code() {
                return "A";
            }

            @Override
            String parentDirectory(Instant instant) {
                return UtcDateTime.yearOf(instant) + PathBuilder.PathSeparator;
            }

            @Override
            String formattedInstantForFileName(Instant instant) {
                Instant normalisedInstant = TimeScale.Day.normalise(instant);
                return PathBuilder.formatWith3Places(UtcDateTime.dayOfYearOf(normalisedInstant));
            }
        }
        ,
        SixHours{

            @Override
            public String code() {
                return "D";
            }

            @Override
            String parentDirectory(Instant instant) {
                UtcDateTime dateTime = UtcDateTime.of(TimeScale.Second.normalise(instant));
                return dateTime.year() + PathBuilder.PathSeparator + PathBuilder.formatWith3Places(dateTime.dayOfYear()) + PathBuilder.PathSeparator;
            }

            @Override
            String formattedInstantForFileName(Instant instant) {
                Instant normalisedInstant = TimeScale.SixHours.normalise(instant);
                return PathBuilder.formatWith2Places(UtcDateTime.hourOf(normalisedInstant));
            }
        }
        ,
        Hour{

            @Override
            public String code() {
                return "C";
            }

            @Override
            String parentDirectory(Instant instant) {
                UtcDateTime dateTime = UtcDateTime.of(instant);
                return dateTime.year() + PathBuilder.PathSeparator + PathBuilder.formatWith3Places(dateTime.dayOfYear()) + PathBuilder.PathSeparator;
            }

            @Override
            String formattedInstantForFileName(Instant instant) {
                Instant normalisedInstant = TimeScale.Hour.normalise(instant);
                return PathBuilder.formatWith2Places(UtcDateTime.hourOf(normalisedInstant));
            }
        }
        ,
        FifteenMinutes{

            @Override
            public String code() {
                return "B";
            }

            @Override
            String parentDirectory(Instant instant) {
                UtcDateTime dateTime = UtcDateTime.of(instant);
                return dateTime.year() + PathBuilder.PathSeparator + PathBuilder.formatWith3Places(dateTime.dayOfYear()) + PathBuilder.PathSeparator;
            }

            @Override
            String formattedInstantForFileName(Instant instant) {
                UtcDateTime dateTime = UtcDateTime.of(TimeScale.FifteenMinutes.normalise(instant));
                return PathBuilder.formatWith2Places(dateTime.hour()) + PathBuilder.formatWith2Places(dateTime.minute());
            }
        }
        ,
        Minute{

            @Override
            public String code() {
                return "A";
            }

            @Override
            String parentDirectory(Instant instant) {
                UtcDateTime dateTime = UtcDateTime.of(instant);
                return dateTime.year() + PathBuilder.PathSeparator + PathBuilder.formatWith3Places(dateTime.dayOfYear()) + PathBuilder.PathSeparator;
            }

            @Override
            String formattedInstantForFileName(Instant instant) {
                UtcDateTime dateTime = UtcDateTime.of(TimeScale.Minute.normalise(instant));
                return PathBuilder.formatWith2Places(dateTime.hour()) + PathBuilder.formatWith2Places(dateTime.minute());
            }
        }
        ,
        Second{

            @Override
            public String code() {
                return "A";
            }

            @Override
            String parentDirectory(Instant instant) {
                UtcDateTime dateTime = UtcDateTime.of(instant);
                return dateTime.year() + PathBuilder.PathSeparator + PathBuilder.formatWith3Places(dateTime.dayOfYear()) + PathBuilder.PathSeparator + PathBuilder.formatWith2Places(dateTime.hour()) + PathBuilder.formatWith2Places(dateTime.minute()) + PathBuilder.PathSeparator;
            }

            @Override
            String formattedInstantForFileName(Instant instant) {
                UtcDateTime dateTime = UtcDateTime.of(TimeScale.Second.normalise(instant));
                return PathBuilder.formatWith2Places(dateTime.second());
            }
        };

        static final Map<TimeScale, ScaleBasedPathBuilder> fileNameBuilders;
        static final Map<String, ScaleBasedPathBuilder> codeBuilders;

        abstract String code();

        abstract String parentDirectory(Instant var1);

        abstract String formattedInstantForFileName(Instant var1);

        static {
            fileNameBuilders = new HashMap<TimeScale, ScaleBasedPathBuilder>();
            codeBuilders = new HashMap<String, ScaleBasedPathBuilder>();
            fileNameBuilders.put(TimeScale.Second, Second);
            fileNameBuilders.put(TimeScale.Minute, Minute);
            fileNameBuilders.put(TimeScale.FifteenMinutes, FifteenMinutes);
            fileNameBuilders.put(TimeScale.Hour, Hour);
            fileNameBuilders.put(TimeScale.SixHours, SixHours);
            fileNameBuilders.put(TimeScale.Day, Day);
            fileNameBuilders.put(TimeScale.Week, Week);
            fileNameBuilders.put(TimeScale.Month, Month);
            fileNameBuilders.put(TimeScale.QuarterOfYear, QuarterOfYear);
            fileNameBuilders.put(TimeScale.Year, Year);
            codeBuilders.put(Second.code(), Second);
            codeBuilders.put(Minute.code(), Minute);
            codeBuilders.put(FifteenMinutes.code(), FifteenMinutes);
            codeBuilders.put(Hour.code(), Hour);
            codeBuilders.put(SixHours.code(), SixHours);
            codeBuilders.put(Day.code(), Day);
            codeBuilders.put(Week.code(), Week);
            codeBuilders.put(Month.code(), Month);
            codeBuilders.put(QuarterOfYear.code(), QuarterOfYear);
            codeBuilders.put(Year.code(), Year);
        }
    }
}

