/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.datawarehouse.store;

import com.tdunning.math.stats.AVLTreeDigest;
import io.intino.sumus.SumusStore;
import io.intino.sumus.TimeStamp;
import io.intino.sumus.datawarehouse.store.Digest;
import io.intino.sumus.datawarehouse.store.PathBuilder;
import io.intino.sumus.datawarehouse.store.TDigest;
import io.intino.sumus.datawarehouse.store.TTable;
import io.intino.sumus.datawarehouse.store.Table;
import io.intino.sumus.graph.Cube;
import io.intino.sumus.graph.NameSpace;
import io.intino.sumus.graph.rules.TimeScale;
import io.intino.tara.magritte.Layer;
import io.intino.tara.magritte.RemounterGraph;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Bucket {
    private static final Map<String, Bucket> BUCKET_MAP = new HashMap<String, Bucket>();
    public static final String REF_SEPARATOR = "@";
    public static final String KEY_SEPARATOR = "|";
    private final Cube cube;
    private final NameSpace nameSpace;
    private TimeStamp timeStamp;
    private Table table;
    private Map<String, TTable> tTables = new HashMap<String, TTable>();
    private List<Digest> digests;
    private Map<String, List<TDigest>> tDigests = new HashMap<String, List<TDigest>>();

    public Bucket(Cube cube, NameSpace nameSpace, TimeStamp timeStamp) {
        this.cube = cube;
        this.nameSpace = nameSpace;
        this.timeStamp = timeStamp;
        if (this.exists()) {
            this.table = new Table(this.streamOf(this.digestFile()));
        }
    }

    public Cube cube() {
        return this.cube;
    }

    public NameSpace nameSpace() {
        return this.nameSpace;
    }

    public TimeStamp timeStamp() {
        return this.timeStamp;
    }

    public TimeScale scale() {
        return this.timeStamp.scale();
    }

    public Instant instant() {
        return this.timeStamp.instant();
    }

    public Bucket create() {
        if (this.table != null) {
            return this;
        }
        this.table = new Table((String[])this.cube.propertyList().stream().map(Cube.Property::label).toArray(String[]::new));
        return this;
    }

    private File digestFile() {
        return Bucket.digestFile(this.cube, this.nameSpace, this.timeStamp);
    }

    private static File digestFile(Cube cube, NameSpace nameSpace, TimeStamp timeStamp) {
        File storeFolder = ((SumusStore)cube.graph().core$().store()).storeFolder();
        return new File(storeFolder, PathBuilder.digestPath(nameSpace, cube, timeStamp.scale(), timeStamp.instant()) + ".digest");
    }

    private File tDigestFile(String property) {
        File storeFolder = ((SumusStore)this.cube.graph().core$().store()).storeFolder();
        return new File(storeFolder, PathBuilder.digestPath(this.nameSpace, this.cube, this.scale(), this.instant()) + "." + property + ".tdigest");
    }

    public boolean exists() {
        return this.digestFile().exists();
    }

    public boolean contains(String key) {
        return this.table.row(key) >= 0;
    }

    public List<TDigest> tDigests(String property) {
        if (this.tDigests.containsKey(property)) {
            return this.tDigests.get(property);
        }
        this.loadTTable(property);
        return this.tDigestsOf(property);
    }

    private void loadTTable(String property) {
        if (this.tTables.containsKey(property)) {
            return;
        }
        File tDigestFile = this.tDigestFile(property);
        if (tDigestFile.exists()) {
            this.tTables.put(property, this.tTableOf(tDigestFile));
        }
    }

    private List<TDigest> tDigestsOf(String property) {
        TTable tTable = this.tTables.get(property);
        if (tTable == null) {
            return Collections.emptyList();
        }
        ArrayList<TDigest> tDigests = new ArrayList<TDigest>();
        for (int i = 0; i < tTable.rows(); ++i) {
            tDigests.add(this.tDigest(tTable, property, i));
        }
        return tDigests;
    }

    private TDigest tDigest(final TTable tTable, final String property, final int index) {
        return new TDigest(){
            private List<String> ids;
            {
                this.ids = Arrays.asList(tTable.row(index).split("\\|"));
            }

            @Override
            public List<String> entityIds() {
                return this.ids;
            }

            @Override
            public void add(double value) {
                tTable.value(index).add(value);
            }

            @Override
            public double rateBelow(double value) {
                return tTable.value(index).cdf(value);
            }

            @Override
            public double quantile(double value) {
                return tTable.value(index).quantile(value);
            }

            @Override
            public AVLTreeDigest avlTreeDigest() {
                return tTable.value(index);
            }

            @Override
            public void save() {
                Bucket.this.save(Bucket.this.tDigestFile(property), tTable.toBytes());
            }
        };
    }

    private TTable tTableOf(File tDigestFile) {
        try {
            return new TTable(new FileInputStream(tDigestFile));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public TDigest tDigest(String property, String ... keys) {
        this.loadTTable(property);
        if (!this.tTables.containsKey(property)) {
            this.tTables.put(property, new TTable());
        }
        return this.tDigestOf(property, this.check(String.join((CharSequence)KEY_SEPARATOR, keys), this.tTables.get(property)));
    }

    private TDigest tDigestOf(String property, String key) {
        return this.tDigest(this.tTables.get(property), property, this.tTables.get(property).row(key));
    }

    public TDigest tDigest(String property, Layer ... layers) {
        return this.tDigest(property, (String[])Arrays.stream(layers).map(l -> l.core$().id()).toArray(String[]::new));
    }

    public List<Digest> digests() {
        if (this.digests != null) {
            return this.digests;
        }
        this.digests = new ArrayList<Digest>();
        for (int i = 0; i < this.table.rows(); ++i) {
            this.digests.add(this.digestOf(i));
        }
        return this.digests;
    }

    public Digest digest(String ... keys) {
        return this.digestOf(this.check(String.join((CharSequence)KEY_SEPARATOR, keys)));
    }

    public Digest digest(Layer ... layers) {
        return this.digest((String[])Arrays.stream(layers).map(l -> l.core$().id()).toArray(String[]::new));
    }

    private Digest digestOf(String row) {
        return this.digestOf(this.table.row(row));
    }

    private Digest digestOf(final int row) {
        return new Digest(){
            private List<String> ids;

            @Override
            public String entityIds() {
                return Bucket.this.table.row(row);
            }

            @Override
            public List<String> entityIdsSplit() {
                return this.ids == null ? (this.ids = Arrays.asList(this.entityIds().split("\\|"))) : this.ids;
            }

            @Override
            public String ref() {
                return Bucket.this.ref() + Bucket.REF_SEPARATOR + this.entityIds();
            }

            @Override
            public int intOf(String col) {
                return Bucket.this.table.cell(row, Bucket.this.table.col(col));
            }

            @Override
            public float floatOf(String col) {
                return Float.intBitsToFloat(this.intOf(col));
            }

            @Override
            public void set(String col, int value) {
                Bucket.this.table.set(row, Bucket.this.table.col(col), value);
            }

            @Override
            public void set(String col, float value) {
                Bucket.this.table.set(row, Bucket.this.table.col(col), Float.floatToIntBits(value));
            }

            @Override
            public void add(String col, int value) {
                this.set(col, this.intOf(col) + value);
            }

            @Override
            public void add(String col, float value) {
                this.set(col, this.floatOf(col) + value);
            }

            @Override
            public Instant ts() {
                return Bucket.this.timeStamp.instant();
            }

            @Override
            public void save() {
                Bucket.this.save();
            }
        };
    }

    private String ref() {
        return this.nameSpace().core$().id() + REF_SEPARATOR + this.instant() + REF_SEPARATOR + (Object)((Object)this.scale());
    }

    private String check(String key) {
        if (!this.contains(key)) {
            this.table.createRowsWith(key);
        }
        return key;
    }

    private String check(String key, TTable tTable) {
        if (tTable.row(key) == -1) {
            tTable.createRowsWith(key);
        }
        return key;
    }

    public void save() {
        if (this.nameSpace.graph().core$().store().allowWriting()) {
            this.save(this.digestFile(), this.table.toBytes());
        }
    }

    public void save(File file, byte[] bytes) {
        try {
            file.getParentFile().mkdirs();
            Files.write(file.toPath(), bytes, new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private InputStream streamOf(File digestFile) {
        try {
            return new FileInputStream(digestFile);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Bucket get(Cube cube, NameSpace nameSpace, TimeStamp timeStamp) {
        if (!(nameSpace.graph().core$() instanceof RemounterGraph)) {
            return new Bucket(cube, nameSpace, timeStamp);
        }
        String path = Bucket.digestFile(cube, nameSpace, timeStamp).getAbsolutePath();
        if (!BUCKET_MAP.containsKey(path)) {
            BUCKET_MAP.put(path, new Bucket(cube, nameSpace, timeStamp));
        }
        return BUCKET_MAP.get(path);
    }

    public static void saveAll() {
        for (Bucket bucket : BUCKET_MAP.values()) {
            bucket.save();
        }
        BUCKET_MAP.clear();
    }
}

