/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box.displays.builders;

import io.intino.sumus.box.schemas.ActivitySchemaAdapters;
import io.intino.sumus.box.schemas.Data;
import io.intino.sumus.box.schemas.Serie;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class SerieBuilder {
    public static Serie build(io.intino.sumus.analytics.viewmodels.Serie serie) {
        Serie result = new Serie().label(serie.label()).metric(serie.metric()).color(serie.color()).style(serie.style()).decimalPlaces(ActivitySchemaAdapters.decimalPlacesFromLayer(serie.decimalPlaces())).dataList(SerieBuilder.dataList(serie.values()));
        if (serie.group() != null) {
            result.group(serie.group());
        }
        if (serie.min() != null) {
            result.min(serie.min().value());
        }
        if (serie.max() != null) {
            result.max(serie.max().value());
        }
        return result;
    }

    public static List<Serie> buildList(List<io.intino.sumus.analytics.viewmodels.Serie> serieList) {
        return serieList.stream().map(SerieBuilder::build).collect(Collectors.toList());
    }

    private static List<Data> dataList(Map<Instant, Double> values) {
        return values.keySet().stream().sorted().map(instant -> SerieBuilder.data(instant, (Double)values.get(instant))).collect(Collectors.toList());
    }

    private static Data data(Instant instant, Double value) {
        return new Data().created(instant.toEpochMilli()).value(!value.isNaN() ? value : 0.0);
    }
}

