/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box.displays.builders;

import com.google.gson.Gson;
import io.intino.konos.server.activity.Asset;
import io.intino.sumus.box.schemas.Property;
import io.intino.sumus.box.schemas.RecordItem;
import io.intino.sumus.box.schemas.RecordItemBlock;
import io.intino.sumus.box.schemas.RecordItemStamp;
import io.intino.sumus.graph.Event;
import io.intino.sumus.graph.Mold;
import io.intino.sumus.graph.Record;
import io.intino.sumus.graph.functions.CatalogStampRecordLinks;
import io.intino.sumus.graph.functions.Tree;
import io.intino.sumus.graph.rules.TimeScale;
import java.net.URL;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;

public class RecordItemBuilder {
    public static RecordItem build(Record record, RecordItemBuilderProvider provider, URL baseAssetUrl) {
        String id = record != null ? record.core$().id() : UUID.randomUUID().toString();
        return new RecordItem().name(new String(Base64.getEncoder().encode(id.getBytes()))).group(RecordItemBuilder.group(record, provider.scale())).label(RecordItemBuilder.label(record, provider)).recordItemBlockList(RecordItemBuilder.recordItemBlockList(record, provider, baseAssetUrl)).recordItemStampList(RecordItemBuilder.recordItemStampList(record, provider, baseAssetUrl));
    }

    public static List<RecordItem> buildList(List<Record> recordList, RecordItemBuilderProvider provider, URL baseAssetUrl) {
        return recordList.stream().map(record -> RecordItemBuilder.build(record, provider, baseAssetUrl)).collect(Collectors.toList());
    }

    private static String label(Record record, RecordItemBuilderProvider provider) {
        String defaultLabel = record != null ? record.name$() : "";
        return provider.stamps().stream().filter(s -> s.i$(Mold.Block.Title.class)).findAny().map(stamp -> (String)stamp.internalValue(record, provider.username())).orElse(defaultLabel);
    }

    private static Instant group(Record record, TimeScale scale) {
        if (record == null || !record.i$(Event.class)) {
            return null;
        }
        return scale.normalise(((Event)record.a$(Event.class)).created());
    }

    private static List<RecordItemBlock> recordItemBlockList(Record record, RecordItemBuilderProvider provider, URL baseAssetUrl) {
        return provider.blocks().stream().map(block -> RecordItemBuilder.recordItemBlock(record, provider, baseAssetUrl, block)).collect(Collectors.toList());
    }

    private static RecordItemBlock recordItemBlock(Record record, RecordItemBuilderProvider provider, URL baseAssetUrl, Mold.Block block) {
        return new RecordItemBlock().name(block.name$()).hidden(block.hidden(record));
    }

    private static List<RecordItemStamp> recordItemStampList(Record record, RecordItemBuilderProvider provider, URL baseAssetUrl) {
        return provider.stamps().stream().map(stamp -> RecordItemBuilder.recordItemStamp(record, provider, baseAssetUrl, stamp)).collect(Collectors.toList());
    }

    private static RecordItemStamp recordItemStamp(Record record, RecordItemBuilderProvider provider, URL baseAssetUrl, Mold.Block.Stamp stamp) {
        return new RecordItemStamp().name(stamp.name$()).values(RecordItemBuilder.valuesOf(stamp, record, provider, baseAssetUrl)).propertyList(RecordItemBuilder.propertiesOf(stamp, record, baseAssetUrl));
    }

    private static List<String> valuesOf(Mold.Block.Stamp stamp, Record record, RecordItemBuilderProvider provider, URL baseAssetUrl) {
        Object value = stamp.internalValue(record, provider.username());
        if (value instanceof List) {
            List<URL> values = (List<URL>)value;
            if (values.isEmpty() && stamp.i$(Mold.Block.Picture.class)) {
                values = Collections.singletonList(((Mold.Block.Picture)stamp.a$(Mold.Block.Picture.class)).defaultPicture());
            }
            return values.stream().map(v -> RecordItemBuilder.valueOf(stamp, v, baseAssetUrl)).collect(Collectors.toList());
        }
        return Collections.singletonList(RecordItemBuilder.valueOf(stamp, value, baseAssetUrl));
    }

    private static String valueOf(Mold.Block.Stamp stamp, Object value, URL baseAssetUrl) {
        if (stamp.i$(Mold.Block.Breadcrumbs.class)) {
            Tree tree = (Tree)value;
            return new Gson().toJson((Object)tree);
        }
        if (stamp.i$(Mold.Block.RecordLinks.class)) {
            CatalogStampRecordLinks.RecordLinks links = (CatalogStampRecordLinks.RecordLinks)value;
            return new Gson().toJson((Object)links);
        }
        if (stamp.i$(Mold.Block.Picture.class)) {
            if (value == null) {
                value = ((Mold.Block.Picture)stamp.a$(Mold.Block.Picture.class)).defaultPicture();
            }
            return value != null ? Asset.toResource((URL)baseAssetUrl, (URL)((URL)value)).toUrl().toString() : "";
        }
        if (stamp.i$(Mold.Block.ResourceIcon.class)) {
            return value != null ? Asset.toResource((URL)baseAssetUrl, (URL)((URL)value)).toUrl().toString() : "";
        }
        return value != null ? String.valueOf(value) : "";
    }

    private static List<Property> propertiesOf(Mold.Block.Stamp stamp, Record record, URL baseAssetUrl) {
        URL icon;
        ArrayList<Property> result = new ArrayList<Property>();
        String style = stamp.style(record);
        if (style != null && !style.isEmpty()) {
            result.add(RecordItemBuilder.propertyOf("style", style));
        }
        if (stamp.i$(Mold.Block.Highlight.class)) {
            result.add(RecordItemBuilder.propertyOf("color", ((Mold.Block.Highlight)stamp.a$(Mold.Block.Highlight.class)).color(record)));
        }
        if (stamp.i$(Mold.Block.RecordLinks.class)) {
            result.add(RecordItemBuilder.propertyOf("title", ((Mold.Block.RecordLinks)stamp.a$(Mold.Block.RecordLinks.class)).title(record)));
        }
        if (stamp.i$(Mold.Block.CatalogLink.class)) {
            result.add(RecordItemBuilder.propertyOf("title", ((Mold.Block.CatalogLink)stamp.a$(Mold.Block.CatalogLink.class)).title(record)));
        }
        if (stamp.i$(Mold.Block.Location.class) && (icon = ((Mold.Block.Location)stamp.a$(Mold.Block.Location.class)).icon(record)) != null) {
            result.add(RecordItemBuilder.propertyOf("icon", Asset.toResource((URL)baseAssetUrl, (URL)icon).toUrl().toString()));
        }
        if (stamp.i$(Mold.Block.Icon.class)) {
            result.add(RecordItemBuilder.propertyOf("title", ((Mold.Block.Icon)stamp.a$(Mold.Block.Icon.class)).title(record)));
        }
        return result;
    }

    private static Property propertyOf(String name, String value) {
        return new Property().name(name).value(value);
    }

    public static interface RecordItemBuilderProvider {
        public List<Mold.Block> blocks();

        public List<Mold.Block.Stamp> stamps();

        public String username();

        public TimeScale scale();
    }
}

