/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box.displays.builders;

import io.intino.sumus.box.schemas.Mold;
import io.intino.sumus.box.schemas.MoldBlock;
import io.intino.sumus.box.schemas.Property;
import io.intino.sumus.box.schemas.Stamp;
import io.intino.sumus.graph.Mold;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class MoldBuilder {
    public static Mold build(io.intino.sumus.graph.Mold mold) {
        return new Mold().moldBlockList(mold.blockList().stream().map(MoldBuilder::buildBlock).collect(Collectors.toList()));
    }

    private static MoldBlock buildBlock(Mold.Block block) {
        return new MoldBlock().name(block.name$()).style(block.style()).expanded(block.isExpanded()).hiddenIfMobile(block.hiddenIfMobile()).layout(block.layout().stream().map(Enum::toString).collect(Collectors.joining(" "))).width(block.width()).height(block.height()).moldBlockList(block.blockList().stream().map(MoldBuilder::buildBlock).collect(Collectors.toList())).stampList(block.stampList().stream().map(MoldBuilder::buildStamp).collect(Collectors.toList()));
    }

    private static Stamp buildStamp(Mold.Block.Stamp stamp) {
        Stamp result = new Stamp().name(stamp.name$()).label(stamp.label()).editable(stamp.isEditable()).shape(MoldBuilder.shapeOf(stamp)).layout(stamp.layout().toString()).height(stamp.height());
        ArrayList<Property> propertyList = new ArrayList<Property>();
        MoldBuilder.addCommonProperties(propertyList, stamp);
        MoldBuilder.addRatingProperties(propertyList, stamp);
        MoldBuilder.addEmbeddedCatalogProperties(propertyList, stamp);
        MoldBuilder.addIconProperties(propertyList, stamp);
        MoldBuilder.addDownloadOperationProperties(propertyList, stamp);
        MoldBuilder.addExportOperationProperties(propertyList, stamp);
        result.propertyList(propertyList);
        return result;
    }

    private static String shapeOf(Mold.Block.Stamp stamp) {
        if (stamp.i$(Mold.Block.Title.class)) {
            return "title";
        }
        if (stamp.i$(Mold.Block.Description.class)) {
            return "description";
        }
        if (stamp.i$(Mold.Block.Icon.class)) {
            return "icon";
        }
        if (stamp.i$(Mold.Block.Rating.class)) {
            return "rating";
        }
        if (stamp.i$(Mold.Block.Highlight.class)) {
            return "highlight";
        }
        if (stamp.i$(Mold.Block.Picture.class)) {
            return "picture";
        }
        if (stamp.i$(Mold.Block.OpenDialogOperation.class)) {
            return "open-dialog-operation";
        }
        if (stamp.i$(Mold.Block.DownloadOperation.class)) {
            return "download-operation";
        }
        if (stamp.i$(Mold.Block.ExportOperation.class)) {
            return "export-operation";
        }
        if (stamp.i$(Mold.Block.TaskOperation.class)) {
            return "task-operation";
        }
        if (stamp.i$(Mold.Block.Page.class)) {
            return "page";
        }
        if (stamp.i$(Mold.Block.Display.class)) {
            return "display";
        }
        if (stamp.i$(Mold.Block.Location.class)) {
            return "location";
        }
        if (stamp.i$(Mold.Block.Breadcrumbs.class)) {
            return "breadcrumbs";
        }
        if (stamp.i$(Mold.Block.RecordLinks.class)) {
            return "record-links";
        }
        if (stamp.i$(Mold.Block.CatalogLink.class)) {
            return "catalog-link";
        }
        if (stamp.i$(Mold.Block.Snippet.class)) {
            return "snippet";
        }
        if (stamp.i$(Mold.Block.EmbeddedCatalog.class)) {
            return "embedded-catalog";
        }
        return "";
    }

    private static void addCommonProperties(List<Property> propertyList, Mold.Block.Stamp stamp) {
        if (!stamp.suffix().isEmpty()) {
            propertyList.add(MoldBuilder.shapeProperty("suffix", stamp.suffix()));
        }
        if (!stamp.defaultStyle().isEmpty()) {
            propertyList.add(MoldBuilder.shapeProperty("defaultStyle", stamp.defaultStyle()));
        }
    }

    private static void addRatingProperties(List<Property> propertyList, Mold.Block.Stamp stamp) {
        if (!stamp.i$(Mold.Block.Rating.class)) {
            return;
        }
        propertyList.add(MoldBuilder.shapeProperty("icon", ((Mold.Block.Rating)stamp.a$(Mold.Block.Rating.class)).ratingIcon()));
    }

    private static void addEmbeddedCatalogProperties(List<Property> propertyList, Mold.Block.Stamp stamp) {
        if (!stamp.i$(Mold.Block.EmbeddedCatalog.class)) {
            return;
        }
        propertyList.add(MoldBuilder.shapeProperty("catalog", ((Mold.Block.EmbeddedCatalog)stamp.a$(Mold.Block.EmbeddedCatalog.class)).catalog().name$()));
    }

    private static void addIconProperties(List<Property> propertyList, Mold.Block.Stamp stamp) {
        if (!stamp.i$(Mold.Block.Icon.class)) {
            return;
        }
        propertyList.add(MoldBuilder.shapeProperty("icon-type", stamp.i$(Mold.Block.SumusIcon.class) ? "sumus" : ""));
    }

    private static void addDownloadOperationProperties(List<Property> propertyList, Mold.Block.Stamp stamp) {
        if (!stamp.i$(Mold.Block.DownloadOperation.class)) {
            return;
        }
        Mold.Block.DownloadOperation downloadStamp = (Mold.Block.DownloadOperation)stamp.a$(Mold.Block.DownloadOperation.class);
        propertyList.add(MoldBuilder.shapeProperty("title", downloadStamp.title()));
        propertyList.add(MoldBuilder.shapeProperty("options", String.join((CharSequence)",", downloadStamp.options())));
    }

    private static void addExportOperationProperties(List<Property> propertyList, Mold.Block.Stamp stamp) {
        if (!stamp.i$(Mold.Block.ExportOperation.class)) {
            return;
        }
        Mold.Block.ExportOperation exportStamp = (Mold.Block.ExportOperation)stamp.a$(Mold.Block.ExportOperation.class);
        propertyList.add(MoldBuilder.shapeProperty("title", exportStamp.title()));
        propertyList.add(MoldBuilder.shapeProperty("options", String.join((CharSequence)",", exportStamp.options())));
        propertyList.add(MoldBuilder.shapeProperty("from", String.valueOf(exportStamp.from().toEpochMilli())));
        propertyList.add(MoldBuilder.shapeProperty("to", String.valueOf(exportStamp.to().toEpochMilli())));
    }

    private static Property shapeProperty(String name, String value) {
        return new Property().name(name).value(value);
    }
}

