/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box.displays.builders;

import io.intino.sumus.analytics.viewmodels.ElementView;
import io.intino.sumus.box.displays.builders.MoldBuilder;
import io.intino.sumus.box.schemas.Center;
import io.intino.sumus.box.schemas.Operation;
import io.intino.sumus.box.schemas.Property;
import io.intino.sumus.box.schemas.Zoom;
import io.intino.sumus.graph.Catalog;
import io.intino.sumus.graph.Toolbar;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class ElementViewBuilder {
    public static io.intino.sumus.box.schemas.ElementView build(ElementView view) {
        io.intino.sumus.box.schemas.ElementView result = new io.intino.sumus.box.schemas.ElementView().name(view.name()).label(view.label());
        if (view.toolbar() != null) {
            result.toolbar(ElementViewBuilder.buildToolbar(view.toolbar()));
        }
        result.embeddedElement(view.embeddedElement());
        result.mold(MoldBuilder.build(view.mold()));
        result.type(view.type());
        result.width(view.width());
        result.canSearch(view.canSearch());
        result.canCreateClusters(view.canCreateClusters());
        result.clusters(view.clusters());
        result.emptyMessage(view.emptyMessage());
        ElementViewBuilder.addMapViewProperties(result, view);
        return result;
    }

    private static io.intino.sumus.box.schemas.Toolbar buildToolbar(Toolbar toolbar) {
        io.intino.sumus.box.schemas.Toolbar result = new io.intino.sumus.box.schemas.Toolbar();
        toolbar.operationList().forEach(op -> result.operationList().add(ElementViewBuilder.buildOperation(op)));
        return result;
    }

    private static Operation buildOperation(Toolbar.Operation operation) {
        Operation result = new Operation().title(operation.title()).name(operation.name$());
        result.type(ElementViewBuilder.type(operation));
        result.icon(operation.sumusIcon());
        result.when(ElementViewBuilder.when(operation));
        result.propertyList(ElementViewBuilder.propertiesOf(operation));
        return result;
    }

    private static String when(Toolbar.Operation operation) {
        if (operation.i$(Toolbar.TaskSelection.class) || operation.i$(Toolbar.ExportSelection.class) || operation.i$(Toolbar.DownloadSelection.class) || operation.i$(Toolbar.GroupingSelection.class)) {
            return "Selection";
        }
        return "Always";
    }

    private static List<Property> propertiesOf(final Toolbar.Operation operation) {
        if (operation.i$(Toolbar.Download.class)) {
            return Collections.singletonList(ElementViewBuilder.propertyOf("options", String.join((CharSequence)",", ((Toolbar.Download)operation.a$(Toolbar.Download.class)).options())));
        }
        if (operation.i$(Toolbar.DownloadSelection.class)) {
            return Collections.singletonList(ElementViewBuilder.propertyOf("options", String.join((CharSequence)",", ((Toolbar.DownloadSelection)operation.a$(Toolbar.DownloadSelection.class)).options())));
        }
        if (operation.i$(Toolbar.Export.class)) {
            return new ArrayList<Property>(){
                {
                    this.add(ElementViewBuilder.propertyOf("from", String.valueOf(((Toolbar.Export)operation.a$(Toolbar.Export.class)).from().toEpochMilli())));
                    this.add(ElementViewBuilder.propertyOf("to", String.valueOf(((Toolbar.Export)operation.a$(Toolbar.Export.class)).to().toEpochMilli())));
                }
            };
        }
        if (operation.i$(Toolbar.ExportSelection.class)) {
            return new ArrayList<Property>(){
                {
                    this.add(ElementViewBuilder.propertyOf("from", String.valueOf(((Toolbar.ExportSelection)operation.a$(Toolbar.ExportSelection.class)).from().toEpochMilli())));
                    this.add(ElementViewBuilder.propertyOf("to", String.valueOf(((Toolbar.ExportSelection)operation.a$(Toolbar.ExportSelection.class)).to().toEpochMilli())));
                }
            };
        }
        return Collections.emptyList();
    }

    private static Property propertyOf(String name, String value) {
        return new Property().name(name).value(value);
    }

    private static String type(Toolbar.Operation operation) {
        if (operation.i$(Toolbar.Download.class) || operation.i$(Toolbar.DownloadSelection.class)) {
            return "download";
        }
        if (operation.i$(Toolbar.Export.class) || operation.i$(Toolbar.ExportSelection.class)) {
            return "export";
        }
        if (operation.i$(Toolbar.OpenDialog.class)) {
            return "open-dialog";
        }
        if (operation.i$(Toolbar.GroupingSelection.class)) {
            return "grouping";
        }
        return "operation";
    }

    public static List<io.intino.sumus.box.schemas.ElementView> buildList(List<ElementView> viewList) {
        return viewList.stream().map(ElementViewBuilder::build).collect(Collectors.toList());
    }

    private static void addMapViewProperties(io.intino.sumus.box.schemas.ElementView result, ElementView view) {
        Object rawView = view.raw();
        if (!rawView.i$(Catalog.MapView.class)) {
            return;
        }
        Catalog.MapView mapView = (Catalog.MapView)rawView.a$(Catalog.MapView.class);
        Catalog.MapView.Zoom zoom = mapView.zoom();
        Catalog.MapView.Center center = mapView.center();
        result.center(new Center().latitude(center.latitude()).longitude(center.longitude()));
        result.zoom(new Zoom().min(zoom.min()).max(zoom.max()).defaultValue(zoom.default$()));
    }
}

