/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box.displays.builders;

import io.intino.sumus.Category;
import io.intino.sumus.box.displays.builders.CatalogSortingBuilder;
import io.intino.sumus.box.schemas.Catalog;
import io.intino.sumus.box.schemas.Group;
import io.intino.sumus.box.schemas.Grouping;
import io.intino.sumus.box.schemas.Sorting;
import io.intino.sumus.graph.Catalog;
import io.intino.sumus.graph.Categorization;
import io.intino.sumus.graph.Cluster;
import io.intino.sumus.queries.CatalogManager;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class CatalogBuilder {
    public static Catalog build(io.intino.sumus.graph.Catalog catalog, CatalogManager manager, String label, boolean embedded) {
        return new Catalog().name(catalog.name$()).label(label).embedded(embedded).hideGroupings(catalog.analysis() == null || catalog.analysis().groupingList().size() <= 0).groupingList(CatalogBuilder.buildGroupingList(catalog, manager)).sortingList(CatalogBuilder.buildSortingList(catalog));
    }

    private static List<Grouping> buildGroupingList(io.intino.sumus.graph.Catalog catalog, CatalogManager manager) {
        if (catalog.analysis() == null) {
            return Collections.emptyList();
        }
        return catalog.analysis().abstractGroupingList().stream().map(g -> CatalogBuilder.buildGrouping(g, manager)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static Grouping buildGrouping(Catalog.Analysis.AbstractGrouping grouping, CatalogManager manager) {
        List<Group> groupList = CatalogBuilder.buildGroupList(grouping, manager);
        int countItems = groupList.stream().mapToInt(Group::count).sum();
        if (countItems <= 0) {
            return null;
        }
        return new Grouping().name(grouping.name$()).label(grouping.label()).histogram(grouping.histogram().toString()).type(CatalogBuilder.typeOf(grouping)).groupList(groupList).countItems(countItems);
    }

    private static List<Sorting> buildSortingList(io.intino.sumus.graph.Catalog catalog) {
        if (catalog.analysis() == null) {
            return Collections.emptyList();
        }
        return CatalogSortingBuilder.buildList(catalog.analysis().sortingList());
    }

    private static String typeOf(Catalog.Analysis.AbstractGrouping grouping) {
        return grouping.i$(Catalog.Analysis.Grouping.class) ? "Grouping" : "ClusterGrouping";
    }

    private static List<Group> buildGroupList(Catalog.Analysis.AbstractGrouping grouping, CatalogManager manager) {
        if (grouping.i$(Catalog.Analysis.Grouping.class)) {
            Categorization categorization = ((Catalog.Analysis.Grouping)grouping.a$(Catalog.Analysis.Grouping.class)).categorization();
            return CatalogBuilder.buildCategorizationGroupList(manager.categories(categorization).toList(), manager.filteredCategories(categorization));
        }
        if (grouping.i$(Catalog.Analysis.ClusterGrouping.class)) {
            return CatalogBuilder.buildClusterGroupList(((Catalog.Analysis.ClusterGrouping)grouping.a$(Catalog.Analysis.ClusterGrouping.class)).cluster().groupList());
        }
        return Collections.emptyList();
    }

    private static List<Group> buildCategorizationGroupList(List<Category> categories, List<String> selected) {
        return categories.stream().map(c -> CatalogBuilder.buildGroup(c, selected.contains(c.label()))).collect(Collectors.toList());
    }

    private static Group buildGroup(Category category, boolean selected) {
        return new Group().name(category.name()).label(category.label()).selected(selected).count(category.recordIds().size());
    }

    private static List<Group> buildClusterGroupList(List<Cluster.Group> groups) {
        return groups.stream().map(CatalogBuilder::buildGroup).collect(Collectors.toList());
    }

    private static Group buildGroup(Cluster.Group group) {
        return new Group().name(group.name$()).label(group.label()).count(group.entities().size());
    }
}

