/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box.displays;

import io.intino.sumus.analytics.TimeRange;
import io.intino.sumus.box.SumusBox;
import io.intino.sumus.box.displays.ChartNavigatorDisplay;
import io.intino.sumus.box.displays.builders.RangeBuilder;
import io.intino.sumus.box.displays.builders.ScaleBuilder;
import io.intino.sumus.box.displays.notifiers.TimeRangeNavigatorDisplayNotifier;
import io.intino.sumus.box.schemas.RequestRange;
import io.intino.sumus.graph.rules.TimeScale;
import io.intino.sumus.helpers.TimeScaleHandler;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

public class TimeRangeNavigatorDisplay
extends ChartNavigatorDisplay<TimeRangeNavigatorDisplayNotifier> {
    private List<Consumer<TimeRange>> moveListeners = new ArrayList<Consumer<TimeRange>>();
    private List<Consumer<TimeRange>> moveNextListeners = new ArrayList<Consumer<TimeRange>>();
    private List<Consumer<TimeRange>> movePreviousListeners = new ArrayList<Consumer<TimeRange>>();
    private List<Consumer<TimeRange>> fromListeners = new ArrayList<Consumer<TimeRange>>();
    private List<Consumer<TimeRange>> scaleListener = new ArrayList<Consumer<TimeRange>>();
    private List<Consumer<TimeRange>> toListeners = new ArrayList<Consumer<TimeRange>>();

    public TimeRangeNavigatorDisplay(SumusBox box) {
        super(box);
    }

    protected void init() {
        super.init();
        TimeRange range = this.timeScaleHandler().range();
        ((TimeRangeNavigatorDisplayNotifier)this.notifier).refreshScales(ScaleBuilder.buildList(this.scales(), this.currentLanguage()));
        ((TimeRangeNavigatorDisplayNotifier)this.notifier).refreshZoomRange(RangeBuilder.build(this.timeScaleHandler().zoomRange()));
        ((TimeRangeNavigatorDisplayNotifier)this.notifier).refreshOlapRange(RangeBuilder.build(this.timeScaleHandler().boundsRange()));
        ((TimeRangeNavigatorDisplayNotifier)this.notifier).refreshRange(RangeBuilder.build(range));
    }

    @Override
    protected void addListeners(TimeScaleHandler timeScaleHandler) {
        timeScaleHandler.onRangeChange(tr -> ((TimeRangeNavigatorDisplayNotifier)this.notifier).refreshRange(RangeBuilder.build(tr)));
        timeScaleHandler.onScaleChange(tr -> ((TimeRangeNavigatorDisplayNotifier)this.notifier).refreshRange(RangeBuilder.build(tr)));
    }

    public void onMove(Consumer<TimeRange> listener) {
        this.moveListeners.add(listener);
    }

    public void onMoveNext(Consumer<TimeRange> listener) {
        this.moveNextListeners.add(listener);
    }

    public void onMovePrevious(Consumer<TimeRange> listener) {
        this.movePreviousListeners.add(listener);
    }

    public void onFromChange(Consumer<TimeRange> listener) {
        this.fromListeners.add(listener);
    }

    public void onToChange(Consumer<TimeRange> listener) {
        this.toListeners.add(listener);
    }

    public void selectScale(String scale) {
        this.timeScaleHandler().updateScale(TimeScale.valueOf(scale));
        ((TimeRangeNavigatorDisplayNotifier)this.notifier).refreshRange(RangeBuilder.build(this.timeScaleHandler().range()));
    }

    public void moveNext() {
        TimeRange timeRange = this.timeScaleHandler().moveRight(1);
        this.moveNextListeners.forEach(l -> l.accept(timeRange));
    }

    public void movePrevious() {
        TimeRange timeRange = this.timeScaleHandler().moveLeft(1);
        this.movePreviousListeners.forEach(l -> l.accept(timeRange));
    }

    public void move(RequestRange range) {
        TimeRange timeRange = this.timeScaleHandler().move(range.from(), range.to());
        this.moveListeners.forEach(l -> l.accept(timeRange));
    }

    public void selectFrom(Instant value) {
        TimeRange timeRange = this.timeScaleHandler().updateRangeFrom(value);
        ((TimeRangeNavigatorDisplayNotifier)this.notifier).refreshRange(RangeBuilder.build(this.timeScaleHandler().range()));
        this.fromListeners.forEach(l -> l.accept(timeRange));
    }

    public void selectTo(Instant value) {
        TimeRange timeRange = this.timeScaleHandler().updateRangeTo(value);
        ((TimeRangeNavigatorDisplayNotifier)this.notifier).refreshRange(RangeBuilder.build(this.timeScaleHandler().range()));
        this.toListeners.forEach(l -> l.accept(timeRange));
    }
}

