/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box.displays;

import io.intino.konos.server.activity.displays.DisplayNotifier;
import io.intino.sumus.box.SumusBox;
import io.intino.sumus.box.displays.ChartDialogDisplay;
import io.intino.sumus.box.displays.TimeNavigatorDisplay;
import io.intino.sumus.graph.Categorization;
import io.intino.sumus.graph.rules.Chart;
import io.intino.sumus.helpers.ChartSpecHandler;
import java.util.Collections;

public abstract class TimeHistogramDialogDisplay<DN extends DisplayNotifier>
extends ChartDialogDisplay<DN, TimeNavigatorDisplay> {
    private final String tag;

    public TimeHistogramDialogDisplay(SumusBox box, Chart type, String tag) {
        super(box, type, new TimeNavigatorDisplay(box));
        this.tag = tag;
    }

    @Override
    protected void init() {
        super.init();
        this.sendCategorizations();
    }

    public void selectCategorization(String value) {
        ChartSpecHandler chartSpecHandler = this.chartSpecHandler();
        chartSpecHandler.clearCategorizationsTag(this.tag);
        chartSpecHandler.selectCategorizations(Collections.singletonMap(this.categorizationOf(value), Collections.singletonList(this.tag)));
        this.sendCategorization();
        chartSpecHandler.update();
    }

    protected abstract void sendCategorizations();

    protected abstract void sendCategorization();

    protected Categorization categorization() {
        return this.specification().categorizationList(this.tag).get(0);
    }
}

