/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box.displays;

import io.intino.konos.server.activity.displays.Display;
import io.intino.konos.server.activity.displays.DisplayNotifier;
import io.intino.sumus.RecordList;
import io.intino.sumus.analytics.TimeRange;
import io.intino.sumus.box.SumusBox;
import io.intino.sumus.box.displays.CatalogDisplay;
import io.intino.sumus.box.displays.CatalogViewDisplay;
import io.intino.sumus.box.displays.CatalogViewListDisplay;
import io.intino.sumus.box.displays.ChartNavigatorDisplay;
import io.intino.sumus.box.displays.StampDisplay;
import io.intino.sumus.box.displays.TemporalStampDisplay;
import io.intino.sumus.box.displays.providers.CatalogViewDisplayProvider;
import io.intino.sumus.box.schemas.GroupingSelection;
import io.intino.sumus.graph.AbstractView;
import io.intino.sumus.graph.Catalog;
import io.intino.sumus.graph.NameSpace;
import io.intino.sumus.graph.Record;
import io.intino.sumus.graph.TemporalRecord;
import io.intino.sumus.graph.rules.Mode;
import io.intino.sumus.graph.rules.TimeScale;
import io.intino.sumus.helpers.Bounds;
import io.intino.sumus.helpers.TimeScaleHandler;
import io.intino.sumus.queries.CatalogManager;
import io.intino.sumus.queries.TemporalRecordQuery;
import io.intino.tara.magritte.Concept;
import java.time.Instant;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

public abstract class TemporalCatalogDisplay<DN extends DisplayNotifier, N extends ChartNavigatorDisplay>
extends CatalogDisplay<DN>
implements CatalogViewDisplayProvider {
    private N navigatorDisplay = null;

    public TemporalCatalogDisplay(SumusBox box, N navigatorDisplay) {
        super(box);
        this.navigatorDisplay = navigatorDisplay;
    }

    public void selectNameSpaceAndRange(NameSpace nameSpace, TimeRange range) {
        this.dirty(true);
        this.nameSpaceHandler().select(nameSpace);
        TimeScale scale = range.scale();
        TimeScale referenceScale = scale.ordinal() > TimeScale.Day.ordinal() ? scale : TimeScale.Day;
        this.timeScaleHandler().updateRange(range.from(), referenceScale.addTo(range.to(), 1L), false);
    }

    @Override
    protected void selectNameSpace(NameSpace nameSpace) {
        this.dirty(true);
        this.resetViews();
        this.refresh();
        this.reloadGroupings();
    }

    private void resetViews() {
        ((CatalogViewListDisplay)this.child(CatalogViewListDisplay.class)).viewList().forEach(CatalogViewDisplay::reset);
    }

    @Override
    public StampDisplay display(String stamp) {
        if (this.box.stampDisplayProvider() == null) {
            return null;
        }
        TemporalStampDisplay display = this.box.stampDisplayProvider().temporalDisplay(stamp);
        display.nameSpace(this.nameSpace());
        display.range(this.timeScaleHandler().range());
        return display;
    }

    @Override
    public void selectGrouping(GroupingSelection value) {
        super.selectGrouping(value);
    }

    @Override
    public void refreshView() {
        super.refreshView();
        this.currentView().ifPresent(catalogView -> {
            AbstractView view = this.views().stream().filter((? super T v) -> v.name$().equals(catalogView.view().name())).findFirst().orElse(null);
            if (view != null && view.i$(Catalog.OlapView.class)) {
                this.hideTimeNavigator();
            } else {
                this.showTimeNavigator();
            }
        });
    }

    @Override
    public TimeScale scale() {
        return this.timeScaleHandler().range().scale();
    }

    @Override
    public void refresh() {
        this.resetGrouping();
        this.createCatalogManager();
        this.refreshView();
    }

    @Override
    public Record rootRecord(List<Record> recordList) {
        return ((Catalog)((Object)this.element())).asTemporalHolder().rootRecord(recordList, this.username(), this.nameSpace(), this.timeScaleHandler().range());
    }

    @Override
    public Record defaultRecord(String id) {
        return ((Catalog)((Object)this.element())).asTemporalHolder().defaultRecord(id, this.username(), this.nameSpace(), this.timeScaleHandler().range());
    }

    @Override
    protected void createCatalogManager() {
        RecordList<TemporalRecord> recordList = this.queryEngine().temporalRecords(this.query(null));
        this.manager = new CatalogManager(recordList.items().stream().map(i -> (Record)i.a$(Record.class)).collect(Collectors.toList()), this.categorizations(), this.keys());
    }

    @Override
    protected <R extends Record> RecordList<R> records(String condition) {
        TemporalRecordQuery query = this.query(condition);
        if (!this.equalsRange()) {
            this.resetGrouping();
        }
        RecordList<TemporalRecord> recordList = this.queryEngine().temporalRecords(query);
        this.applyFilter(recordList);
        if (!this.equalsRange()) {
            this.reloadGroupings();
        }
        this.range(this.timeScaleHandler().range());
        this.filterTimezone(recordList, this.range());
        return recordList;
    }

    @Override
    protected Record loadRecord(String id) {
        return this.queryEngine().temporalRecord(id, this.username());
    }

    @Override
    protected boolean canCreateClusters() {
        return false;
    }

    @Override
    protected void init() {
        TimeScaleHandler timeScaleHandler = this.buildTimeScaleHandler();
        this.buildNavigatorDisplay(timeScaleHandler);
        super.init();
    }

    protected void refresh(Instant instant) {
        this.refresh();
    }

    protected void refresh(TimeRange range) {
        this.refresh();
    }

    private void buildNavigatorDisplay(TimeScaleHandler timeScaleHandler) {
        ((ChartNavigatorDisplay)((Object)this.navigatorDisplay)).timeScaleHandler(timeScaleHandler);
        this.configureNavigatorDisplay(this.navigatorDisplay, timeScaleHandler);
        this.add((Display)this.navigatorDisplay);
        this.navigatorDisplay.personify();
    }

    private TimeScaleHandler buildTimeScaleHandler() {
        TimeRange range = this.queryEngine().temporalRecordRange(this.nameSpaceHandler().nameSpaces(this.username()));
        TimeScaleHandler.Bounds bounds = new TimeScaleHandler.Bounds();
        List<TimeScale> scales = ((Catalog)((Object)this.element())).asTemporalHolder().scales();
        HashMap<TimeScale, Bounds.Zoom> zoomMap = new HashMap<TimeScale, Bounds.Zoom>();
        bounds.range(new TimeRange(range.from(), range.to(), TimeScale.Minute));
        bounds.mode(Mode.ToTheLast);
        scales.forEach(scale -> zoomMap.put((TimeScale)((Object)scale), new Bounds.Zoom().min(1).max(this.maxZoom())));
        bounds.zooms(zoomMap);
        TimeScaleHandler timeScaleHandler = new TimeScaleHandler(bounds, scales, scales.get(0));
        timeScaleHandler.availableScales(this.localizedScales(scales));
        this.configureTimeScaleHandler(timeScaleHandler, range, scales);
        return timeScaleHandler;
    }

    @Override
    public boolean dirty() {
        return super.dirty() || !this.equalsRange();
    }

    protected boolean equalsRange() {
        TimeRange range = this.timeScaleHandler().range();
        return this.range() != null && this.range().from() == range.from() && this.range().scale() == range.scale();
    }

    protected abstract int maxZoom();

    protected abstract void configureTimeScaleHandler(TimeScaleHandler var1, TimeRange var2, List<TimeScale> var3);

    protected abstract void configureNavigatorDisplay(N var1, TimeScaleHandler var2);

    protected abstract Concept recordConcept();

    protected abstract void hideTimeNavigator();

    protected abstract void showTimeNavigator();

    protected abstract void addTime(TemporalRecordQuery.Builder var1);

    protected abstract <R extends Record> void filterTimezone(RecordList<R> var1, TimeRange var2);

    protected abstract TimeScaleHandler timeScaleHandler();

    private TemporalRecordQuery query(String condition) {
        TemporalRecordQuery.Builder builder = new TemporalRecordQuery.Builder();
        builder.condition(condition);
        builder.nameSpace(this.nameSpace());
        this.addTime(builder);
        return builder.build(this.recordConcept(), this.username());
    }

    private void reloadGroupings() {
        this.sendCatalog();
    }
}

