/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box.displays;

import io.intino.konos.server.activity.displays.Display;
import io.intino.konos.server.activity.displays.DisplayNotifier;
import io.intino.konos.server.activity.services.push.ActivityClient;
import io.intino.konos.server.activity.services.push.ActivitySession;
import io.intino.konos.server.activity.services.push.User;
import io.intino.sumus.QueryEngine;
import io.intino.sumus.box.SumusBox;
import io.intino.sumus.graph.Catalog;
import io.intino.sumus.graph.ProfileManager;
import io.intino.sumus.graph.SumusGraph;
import io.intino.sumus.graph.rules.TimeScale;
import io.intino.tara.magritte.Concept;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class SumusDisplay<N extends DisplayNotifier>
extends Display<N> {
    private QueryEngine queryEngine;
    final SumusBox box;

    public SumusDisplay(SumusBox box) {
        this.box = box;
    }

    public Optional<User> user() {
        return Optional.ofNullable(this.session().user());
    }

    public String username() {
        return this.user().isPresent() ? this.user().get().username() : this.session().id();
    }

    SumusGraph platform() {
        return this.box.graph();
    }

    List<String> keys() {
        ProfileManager profileManager = this.platform().profileManager();
        if (profileManager == null) {
            return Collections.emptyList();
        }
        return profileManager.profile(this.username()).keys();
    }

    String currentLanguage() {
        ActivitySession session = this.session();
        if (session == null) {
            return "en";
        }
        ActivityClient client = (ActivityClient)session.currentClient();
        return client != null ? client.language() : this.session().browser().languageFromMetadata();
    }

    List<TimeScale> localizedScales(List<TimeScale> scales) {
        return scales.stream().map(this::scaleWithLabel).collect(Collectors.toList());
    }

    TimeScale scaleWithLabel(TimeScale scale) {
        scale.label(this.box.translatorHelper().translate(scale.toString()).into(this.currentLanguage()));
        return scale;
    }

    URL baseAssetUrl() {
        try {
            return new URL(this.session().browser().baseAssetUrl());
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public QueryEngine queryEngine() {
        if (this.queryEngine == null) {
            this.queryEngine = new QueryEngine(this.box);
        }
        return this.queryEngine;
    }

    int timezoneOffset() {
        return this.session().browser().timezoneOffset();
    }

    void timezoneOffset(int value) {
        this.session().browser().timezoneOffset(value / 60);
    }

    Concept holderConceptOf(Catalog catalog) {
        if (catalog.isEventHolder()) {
            return catalog.asEventHolder().event();
        }
        if (catalog.isEntityHolder()) {
            return catalog.asEntityHolder().entity();
        }
        if (catalog.isReportHolder()) {
            return catalog.asReportHolder().report();
        }
        return null;
    }
}

