/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box.displays;

import io.intino.sumus.RecordList;
import io.intino.sumus.analytics.TimeRange;
import io.intino.sumus.box.SumusBox;
import io.intino.sumus.box.displays.TemporalCatalogDisplay;
import io.intino.sumus.box.displays.TimeNavigatorDisplay;
import io.intino.sumus.box.displays.builders.CatalogBuilder;
import io.intino.sumus.box.displays.notifiers.ReportCatalogDisplayNotifier;
import io.intino.sumus.box.schemas.GroupingSelection;
import io.intino.sumus.graph.Catalog;
import io.intino.sumus.graph.Record;
import io.intino.sumus.graph.rules.TimeScale;
import io.intino.sumus.helpers.TimeScaleHandler;
import io.intino.sumus.queries.TemporalRecordQuery;
import io.intino.tara.magritte.Concept;
import java.util.List;

public class ReportCatalogDisplay
extends TemporalCatalogDisplay<ReportCatalogDisplayNotifier, TimeNavigatorDisplay> {
    public ReportCatalogDisplay(SumusBox box) {
        super(box, new TimeNavigatorDisplay(box));
    }

    @Override
    public void selectGrouping(GroupingSelection value) {
        super.selectGrouping(value);
    }

    @Override
    protected int maxZoom() {
        return 0;
    }

    @Override
    protected void configureTimeScaleHandler(TimeScaleHandler timeScaleHandler, TimeRange range, List<TimeScale> scales) {
        timeScaleHandler.updateInstant(range.to(), scales.get(0));
    }

    @Override
    protected void configureNavigatorDisplay(TimeNavigatorDisplay navigatorDisplay, TimeScaleHandler timeScaleHandler) {
        navigatorDisplay.onMove(this::refresh);
    }

    @Override
    public void clearFilter() {
        super.clearFilter();
    }

    @Override
    protected void refreshBreadcrumbs(String breadcrumbs) {
        ((ReportCatalogDisplayNotifier)this.notifier).refreshBreadcrumbs(breadcrumbs);
    }

    @Override
    protected void createPanel(String item) {
        ((ReportCatalogDisplayNotifier)this.notifier).createPanel(item);
    }

    @Override
    protected void showPanel() {
        ((ReportCatalogDisplayNotifier)this.notifier).showPanel();
    }

    @Override
    protected void hidePanel() {
        ((ReportCatalogDisplayNotifier)this.notifier).hidePanel();
    }

    @Override
    protected void sendCatalog() {
        ((ReportCatalogDisplayNotifier)this.notifier).refreshCatalog(CatalogBuilder.build((Catalog)((Object)this.element()), this.manager, this.label(), this.embedded()));
    }

    @Override
    protected void showDialog() {
        ((ReportCatalogDisplayNotifier)this.notifier).showDialog();
    }

    @Override
    protected void notifyFiltered(boolean value) {
        ((ReportCatalogDisplayNotifier)this.notifier).refreshFiltered(value);
    }

    @Override
    protected Concept recordConcept() {
        return ((Catalog)((Object)this.element())).asReportHolder().report();
    }

    @Override
    protected void showTimeNavigator() {
        ((ReportCatalogDisplayNotifier)this.notifier).showTimeNavigator();
    }

    @Override
    protected void addTime(TemporalRecordQuery.Builder builder) {
        TimeRange range = this.timeScaleHandler().range();
        builder.instant(range.to(), range.scale());
    }

    @Override
    protected <R extends Record> void filterTimezone(RecordList<R> recordList, TimeRange range) {
    }

    @Override
    protected TimeScaleHandler timeScaleHandler() {
        return ((TimeNavigatorDisplay)this.child(TimeNavigatorDisplay.class)).timeScaleHandler();
    }

    @Override
    protected void hideTimeNavigator() {
        ((ReportCatalogDisplayNotifier)this.notifier).hideTimeNavigator();
    }

    public void timezoneOffset(Integer value) {
        super.timezoneOffset(value);
    }

    @Override
    public void navigate(String key) {
        super.navigate(key);
    }
}

