/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box.displays;

import io.intino.konos.server.activity.displays.Display;
import io.intino.konos.server.activity.spark.ActivityFile;
import io.intino.sumus.analytics.TimeRange;
import io.intino.sumus.box.SumusBox;
import io.intino.sumus.box.displays.CatalogDisplay;
import io.intino.sumus.box.displays.ElementDisplay;
import io.intino.sumus.box.displays.ElementViewDisplay;
import io.intino.sumus.box.displays.EntityCatalogDisplay;
import io.intino.sumus.box.displays.EventCatalogDisplay;
import io.intino.sumus.box.displays.PageContainerDisplay;
import io.intino.sumus.box.displays.ReportCatalogDisplay;
import io.intino.sumus.box.displays.StampDisplay;
import io.intino.sumus.box.displays.SumusDisplay;
import io.intino.sumus.box.displays.TemporalCatalogDisplay;
import io.intino.sumus.box.displays.TemporalStampDisplay;
import io.intino.sumus.box.displays.builders.MoldBuilder;
import io.intino.sumus.box.displays.builders.RecordItemBuilder;
import io.intino.sumus.box.displays.notifiers.RecordDisplayNotifier;
import io.intino.sumus.box.displays.providers.RecordDisplayProvider;
import io.intino.sumus.box.schemas.DownloadItemParameters;
import io.intino.sumus.box.schemas.ElementOperationParameters;
import io.intino.sumus.box.schemas.ExecuteItemTaskParameters;
import io.intino.sumus.box.schemas.ExportItemParameters;
import io.intino.sumus.box.schemas.Item;
import io.intino.sumus.box.schemas.OpenItemDialogParameters;
import io.intino.sumus.box.schemas.PageLocation;
import io.intino.sumus.box.schemas.RecordItem;
import io.intino.sumus.box.schemas.RecordRefreshInfo;
import io.intino.sumus.box.schemas.SaveItemParameters;
import io.intino.sumus.graph.Catalog;
import io.intino.sumus.graph.Element;
import io.intino.sumus.graph.Mold;
import io.intino.sumus.graph.NameSpace;
import io.intino.sumus.graph.Panel;
import io.intino.sumus.graph.Record;
import io.intino.sumus.graph.functions.Resource;
import io.intino.sumus.graph.functions.Tree;
import io.intino.sumus.graph.rules.TimeScale;
import io.intino.sumus.helpers.ElementHelper;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class RecordDisplay
extends SumusDisplay<RecordDisplayNotifier> {
    private Mold mold;
    private Element context;
    private Record record;
    private String mode;
    private RecordDisplayProvider provider;
    private List<Consumer<ElementViewDisplay.OpenItemEvent>> openItemListeners = new ArrayList<Consumer<ElementViewDisplay.OpenItemEvent>>();
    private List<Consumer<ElementViewDisplay.OpenItemDialogEvent>> openItemDialogListeners = new ArrayList<Consumer<ElementViewDisplay.OpenItemDialogEvent>>();
    private List<Consumer<ElementViewDisplay.ExecuteItemTaskEvent>> executeItemTaskListeners = new ArrayList<Consumer<ElementViewDisplay.ExecuteItemTaskEvent>>();
    private boolean recordDisplaysCreated = false;
    private String emptyMessage = null;

    public RecordDisplay(SumusBox box) {
        super(box);
    }

    public void mold(Mold mold) {
        this.mold = mold;
    }

    public void context(Element context) {
        this.context = context;
    }

    public void record(Record record) {
        this.record = record;
    }

    public void mode(String mode) {
        this.mode = mode;
    }

    public void provider(RecordDisplayProvider provider) {
        this.provider = provider;
    }

    public void onOpenItem(Consumer<ElementViewDisplay.OpenItemEvent> listener) {
        this.openItemListeners.add(listener);
    }

    public void onOpenItemDialog(Consumer<ElementViewDisplay.OpenItemDialogEvent> parameters) {
        this.openItemDialogListeners.add(parameters);
    }

    public void onExecuteItemTask(Consumer<ElementViewDisplay.ExecuteItemTaskEvent> parameters) {
        this.executeItemTaskListeners.add(parameters);
    }

    protected void init() {
        super.init();
        this.sendEmptyMessage();
        this.sendMode();
    }

    public void refresh() {
        super.refresh();
        this.children(StampDisplay.class).forEach(display -> {
            display.record(this.record);
            if (display instanceof TemporalStampDisplay) {
                TemporalStampDisplay temporalDisplay = (TemporalStampDisplay)((Object)display);
                temporalDisplay.nameSpace(this.provider.nameSpace());
                temporalDisplay.range(this.provider.range());
            }
            display.refresh();
        });
        this.remove(PageContainerDisplay.class);
        this.sendInfo();
    }

    public void refresh(RecordItem item) {
        this.sendInfo(item);
    }

    public void itemStampsReady(String id) {
        if (!this.recordDisplaysCreated) {
            this.displays(this.record).forEach((key, display) -> {
                this.add((Display)display);
                display.record(this.record);
                display.personifyOnce(id + key.name$());
                display.refresh();
            });
        }
        this.pages(this.record).forEach(display -> {
            this.add((Display)display);
            display.personifyOnce(id);
            display.refresh();
        });
        this.embeddedCatalogs().forEach((key, display) -> {
            display.filter(record -> key.filter(this.context, this.record, (Record)((Object)((Object)((Object)record)))));
            display.nameSpaceHandler(this.provider.nameSpaceHandler());
            display.label(key.label());
            display.onOpenItem(params -> this.notifyOpenItem((ElementViewDisplay.OpenItemEvent)params));
            display.embedded(true);
            this.add((Display)display);
            display.personifyOnce(id + key.name$());
        });
        this.recordDisplaysCreated = true;
    }

    public void notifyOpenItem(ElementViewDisplay.OpenItemEvent params) {
        this.openItemListeners.forEach(l -> l.accept(params));
    }

    public void selectElement(Item stampItem) {
        Mold.Block.Stamp stamp = this.provider.stamp(this.mold, stampItem.name());
        if (!stamp.i$(Mold.Block.CatalogLink.class)) {
            return;
        }
        Mold.Block.CatalogLink catalogLinkStamp = (Mold.Block.CatalogLink)stamp.a$(Mold.Block.CatalogLink.class);
        ElementDisplay display = this.provider.openElement(catalogLinkStamp.catalog().label());
        display.filterAndNotify(record -> catalogLinkStamp.filter(this.record, (Record)((Object)((Object)record))));
        if (display instanceof TemporalCatalogDisplay) {
            ((TemporalCatalogDisplay)display).selectNameSpaceAndRange(this.provider.nameSpace(), this.provider.range());
        }
        display.refresh();
    }

    public void openItemDialogOperation(OpenItemDialogParameters params) {
        this.openItemDialogListeners.forEach(l -> l.accept(ElementHelper.openItemDialogEvent(params.item(), this.provider.stamp(this.mold, params.stamp()))));
    }

    public void executeItemTaskOperation(ExecuteItemTaskParameters params) {
        this.executeItemTaskListeners.forEach(l -> l.accept(ElementHelper.executeItemTaskEvent(params.item(), this.provider.stamp(this.mold, params.stamp()))));
    }

    public ActivityFile downloadItemOperation(DownloadItemParameters parameters) {
        Mold.Block.Stamp stamp = this.provider.stamps(this.mold).stream().filter(s -> s.name$().equals(parameters.stamp())).findFirst().orElse(null);
        final Resource resource = ((Mold.Block.DownloadOperation)stamp.a$(Mold.Block.DownloadOperation.class)).execute(this.record, parameters.option());
        return new ActivityFile(){

            public String label() {
                return resource.label();
            }

            public InputStream content() {
                return resource.content();
            }
        };
    }

    public ActivityFile exportItemOperation(ExportItemParameters parameters) {
        Mold.Block.Stamp stamp = this.provider.stamps(this.mold).stream().filter(s -> s.name$().equals(parameters.stamp())).findFirst().orElse(null);
        final Resource resource = ((Mold.Block.ExportOperation)stamp.a$(Mold.Block.ExportOperation.class)).execute(this.record, parameters.from(), parameters.to(), parameters.option(), this.username());
        return new ActivityFile(){

            public String label() {
                return resource.label();
            }

            public InputStream content() {
                return resource.content();
            }
        };
    }

    public void executeOperation(ElementOperationParameters value) {
        this.provider.executeOperation(value, Collections.singletonList(this.record));
    }

    public ActivityFile downloadOperation(ElementOperationParameters value) {
        final Resource resource = this.provider.downloadOperation(value, Collections.singletonList(this.record));
        return new ActivityFile(){

            public String label() {
                return resource.label();
            }

            public InputStream content() {
                return resource.content();
            }
        };
    }

    private void sendInfo(RecordItem item) {
        ((RecordDisplayNotifier)this.notifier).refresh(new RecordRefreshInfo().mold(MoldBuilder.build(this.mold)).recordItem(item));
    }

    private void sendInfo() {
        this.sendInfo(RecordItemBuilder.build(this.record, new RecordItemBuilder.RecordItemBuilderProvider(){

            @Override
            public List<Mold.Block> blocks() {
                return RecordDisplay.this.provider.blocks(RecordDisplay.this.mold);
            }

            @Override
            public List<Mold.Block.Stamp> stamps() {
                return RecordDisplay.this.provider.stamps(RecordDisplay.this.mold);
            }

            @Override
            public String username() {
                return RecordDisplay.this.username();
            }

            @Override
            public TimeScale scale() {
                return RecordDisplay.this.provider.range() != null ? RecordDisplay.this.provider.range().scale() : null;
            }
        }, this.baseAssetUrl()));
    }

    private void sendEmptyMessage() {
        if (this.emptyMessage == null) {
            return;
        }
        ((RecordDisplayNotifier)this.notifier).refreshEmptyMessage(this.emptyMessage);
    }

    private void sendMode() {
        ((RecordDisplayNotifier)this.notifier).refreshMode(this.mode);
    }

    private Map<Mold.Block.Display, StampDisplay> displays(Record record) {
        List stamps = this.provider.stamps(this.mold).stream().filter(s -> s.i$(Mold.Block.Display.class)).collect(Collectors.toList());
        Map mapWithNulls = stamps.stream().collect(HashMap::new, (map, stamp) -> map.put(stamp.a$(Mold.Block.Display.class), this.provider.display(stamp.name$())), HashMap::putAll);
        Map<Mold.Block.Display, StampDisplay> result = mapWithNulls.entrySet().stream().filter(e -> e.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        result.forEach((key, value) -> value.record(record));
        return result;
    }

    private List<Display> pages(Record record) {
        return this.provider.stamps(this.mold).stream().filter(s -> s.i$(Mold.Block.Page.class)).map(stamp -> new PageContainerDisplay(this.box).pageLocation(this.location((Mold.Block.Stamp)((Object)stamp), record))).collect(Collectors.toList());
    }

    private Map<Mold.Block.EmbeddedCatalog, CatalogDisplay> embeddedCatalogs() {
        List stamps = this.provider.stamps(this.mold).stream().filter(s -> s.i$(Mold.Block.EmbeddedCatalog.class)).collect(Collectors.toList());
        return stamps.stream().collect(Collectors.toMap(s -> (Mold.Block.EmbeddedCatalog)s.a$(Mold.Block.EmbeddedCatalog.class), s -> this.displayFor(((Mold.Block.EmbeddedCatalog)s.a$(Mold.Block.EmbeddedCatalog.class)).catalog())));
    }

    private PageLocation location(Mold.Block.Stamp stamp, Record record) {
        PageLocation location = new PageLocation();
        if (stamp.i$(Mold.Block.ExternalPage.class)) {
            return location.value(((Mold.Block.ExternalPage)stamp.a$(Mold.Block.ExternalPage.class)).url(record.name$()).toString()).internal(false);
        }
        return location.value(((Mold.Block.InternalPage)stamp.a$(Mold.Block.InternalPage.class)).path(record.name$())).internal(true);
    }

    private CatalogDisplay displayFor(Catalog catalog) {
        CatalogDisplay result = null;
        if (catalog.isEntityHolder()) {
            result = new EntityCatalogDisplay(this.box);
        } else if (catalog.isReportHolder()) {
            result = new ReportCatalogDisplay(this.box);
        } else if (catalog.isEventHolder()) {
            result = new EventCatalogDisplay(this.box);
        }
        if (result == null) {
            return null;
        }
        result.target(this.record);
        result.catalog(catalog);
        return result;
    }

    public void selectRecord(final Item item) {
        this.openItemListeners.forEach(l -> l.accept(new ElementViewDisplay.OpenItemEvent(){

            @Override
            public String item() {
                return item.name();
            }

            @Override
            public String label() {
                return item.label();
            }

            @Override
            public Record record() {
                return null;
            }

            @Override
            public Panel panel() {
                return (Panel)RecordDisplay.this.context;
            }

            @Override
            public NameSpace nameSpace() {
                return RecordDisplay.this.provider.nameSpace();
            }

            @Override
            public TimeRange range() {
                return RecordDisplay.this.provider.range();
            }

            @Override
            public Tree breadcrumbs() {
                return null;
            }
        }));
    }

    public void saveItem(SaveItemParameters value) {
        this.provider.saveItem(value, this.record);
    }

    public void emptyMessage(String message) {
        this.emptyMessage = message;
    }
}

