/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box.displays;

import io.intino.konos.server.activity.displays.DisplayNotifier;
import io.intino.sumus.analytics.viewmodels.ElementView;
import io.intino.sumus.box.SumusBox;
import io.intino.sumus.box.displays.ElementViewDisplay;
import io.intino.sumus.box.displays.SumusDisplay;
import io.intino.sumus.box.displays.providers.ElementViewDisplayProvider;
import io.intino.sumus.box.schemas.RecordItem;
import io.intino.sumus.graph.Panel;
import io.intino.sumus.graph.Record;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

public class PanelViewDisplay<DN extends DisplayNotifier>
extends SumusDisplay<DN>
implements ElementViewDisplay<ElementViewDisplayProvider> {
    private Panel context;
    private Record target;
    private ElementView<Panel> view;
    private ElementViewDisplayProvider provider;
    private List<Consumer<Boolean>> loadingListeners = new ArrayList<Consumer<Boolean>>();
    private List<Consumer<ElementViewDisplay.OpenItemEvent>> openItemListeners = new ArrayList<Consumer<ElementViewDisplay.OpenItemEvent>>();
    private List<Consumer<ElementViewDisplay.OpenItemDialogEvent>> openItemDialogListeners = new ArrayList<Consumer<ElementViewDisplay.OpenItemDialogEvent>>();
    private List<Consumer<ElementViewDisplay.ExecuteItemTaskEvent>> executeItemTaskListeners = new ArrayList<Consumer<ElementViewDisplay.ExecuteItemTaskEvent>>();

    public PanelViewDisplay(SumusBox box) {
        super(box);
    }

    public Panel context() {
        return this.context;
    }

    public void context(Panel context) {
        this.context = context;
    }

    public Record target() {
        return this.target;
    }

    public void target(Record target) {
        this.target = target;
    }

    @Override
    public ElementView<Panel> view() {
        return this.view;
    }

    @Override
    public void view(ElementView view) {
        this.view = view;
    }

    @Override
    public void refresh(RecordItem ... items) {
        this.refresh();
    }

    public ElementViewDisplayProvider provider() {
        return this.provider;
    }

    @Override
    public void provider(ElementViewDisplayProvider provider) {
        this.provider = provider;
    }

    @Override
    public void onLoading(Consumer<Boolean> listener) {
        this.loadingListeners.add(listener);
    }

    @Override
    public void onOpenItem(Consumer<ElementViewDisplay.OpenItemEvent> listener) {
        this.openItemListeners.add(listener);
    }

    @Override
    public void onOpenItemDialog(Consumer<ElementViewDisplay.OpenItemDialogEvent> listener) {
        this.openItemDialogListeners.add(listener);
    }

    @Override
    public void onExecuteItemTask(Consumer<ElementViewDisplay.ExecuteItemTaskEvent> listener) {
        this.executeItemTaskListeners.add(listener);
    }

    protected void notifyLoading(Boolean value) {
        this.loadingListeners.forEach(l -> l.accept(value));
    }

    protected void notifyOpenItem(ElementViewDisplay.OpenItemEvent params) {
        this.openItemListeners.forEach(l -> l.accept(params));
    }

    protected void notifyOpenItemDialog(ElementViewDisplay.OpenItemDialogEvent params) {
        this.openItemDialogListeners.forEach(l -> l.accept(params));
    }

    protected void notifyExecuteItemTaskOperation(ElementViewDisplay.ExecuteItemTaskEvent params) {
        this.executeItemTaskListeners.forEach(l -> l.accept(params));
    }
}

